/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx_global_policy.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx_global_policy.model;

/**
 * Only support IP address or subnet. Its type can be of IPv4 or IPv6. It will be
 * converted to subnet when netmask is specified(e.g., 192.168.1.3/24 =>
 * 192.168.1.0/24, 2008:12:12:12::2/64 => 2008:12:12:12::/64).
 */
public final class NetworkInfo implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    private java.lang.String dstIp;

    private java.lang.String srcIp;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public NetworkInfo() {
    }

    protected NetworkInfo(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * The destination IP can be an IP address or a subnet. format:
     * address-or-block-or-range
     *
     * @return The current value of the property.
     */
    public java.lang.String getDstIp() {
        return this.dstIp;
    }

    /**
     * The destination IP can be an IP address or a subnet. format:
     * address-or-block-or-range
     *
     * @param dstIp New value for the property.
     */
    public void setDstIp(java.lang.String dstIp) {
        this.dstIp = dstIp;
    }

    /**
     * The source IP can be an IP address or a subnet. format:
     * address-or-block-or-range
     *
     * @return The current value of the property.
     */
    public java.lang.String getSrcIp() {
        return this.srcIp;
    }

    /**
     * The source IP can be an IP address or a subnet. format:
     * address-or-block-or-range
     *
     * @param srcIp New value for the property.
     */
    public void setSrcIp(java.lang.String srcIp) {
        this.srcIp = srcIp;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx_global_policy.model.StructDefinitions.networkInfo;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("dst_ip",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.dstIp, this._getType().getField("dst_ip")));
        structValue.setField("src_ip",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.srcIp, this._getType().getField("src_ip")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx_global_policy.model.StructDefinitions.networkInfo;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx_global_policy.model.StructDefinitions.networkInfo.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static NetworkInfo _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new NetworkInfo(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static NetworkInfo _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new NetworkInfo(structValue);
    }

    /**
     * Builder class for {@link NetworkInfo}.
     */
    public static final class Builder {
        private java.lang.String dstIp;
        private java.lang.String srcIp;

        /**
         * Constructor with parameters for the required properties of
         * {@link NetworkInfo}.
         */
        public Builder() {
        }

        /**
         * The destination IP can be an IP address or a subnet. format:
         * address-or-block-or-range
         *
         * @param dstIp New value for the property.
         */
        public Builder setDstIp(java.lang.String dstIp) {
            this.dstIp = dstIp;
            return this;
        }

        /**
         * The source IP can be an IP address or a subnet. format:
         * address-or-block-or-range
         *
         * @param srcIp New value for the property.
         */
        public Builder setSrcIp(java.lang.String srcIp) {
            this.srcIp = srcIp;
            return this;
        }

        public NetworkInfo build() {
            NetworkInfo result = new NetworkInfo();
            result.setDstIp(this.dstIp);
            result.setSrcIp(this.srcIp);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("dst_ip", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("dst_ip",
                                                                                "dstIp",
                                                                                "getDstIp",
                                                                                "setDstIp");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("src_ip", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("src_ip",
                                                                                "srcIp",
                                                                                "getSrcIp",
                                                                                "setSrcIp");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx_global_policy.model.network_info",
                                                            fields,
                                                            com.vmware.nsx_global_policy.model.NetworkInfo.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

