/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx_global_policy.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx_global_policy.model;

/**
 * Answer of dns nslookup
 */
public final class NsxtDnsAnswer implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    /**
     * Identifier denoting this class, when it is used in polymorphic context. 
     * <p>This
     * value should be assigned to the property which is used to discriminate the
     * actual type used in the polymorphic context.</p>
     */
    public static final java.lang.String _TYPE_IDENTIFIER = "NsxTDnsAnswer";

    private java.util.List<com.vmware.nsx_global_policy.model.NsxtDnsQueryAnswer> authoritativeAnswers;

    private java.lang.String dnsServer;

    private java.lang.String edgeNodeId;

    private java.util.List<com.vmware.nsx_global_policy.model.NsxtDnsQueryAnswer> nonAuthoritativeAnswers;

    private java.lang.String rawAnswer;

    private java.lang.String enforcementPointPath;

    private final java.lang.String resourceType = "NsxTDnsAnswer";

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public NsxtDnsAnswer() {
    }

    protected NsxtDnsAnswer(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * Authoritative answers
     *
     * @return The current value of the property.
     */
    public java.util.List<com.vmware.nsx_global_policy.model.NsxtDnsQueryAnswer> getAuthoritativeAnswers() {
        return this.authoritativeAnswers;
    }

    /**
     * Authoritative answers
     *
     * @param authoritativeAnswers New value for the property.
     */
    public void setAuthoritativeAnswers(java.util.List<com.vmware.nsx_global_policy.model.NsxtDnsQueryAnswer> authoritativeAnswers) {
        this.authoritativeAnswers = authoritativeAnswers;
    }

    /**
     * Dns server ip address and port, format is \"ip address#port\".
     *
     * @return The current value of the property.
     */
    public java.lang.String getDnsServer() {
        return this.dnsServer;
    }

    /**
     * Dns server ip address and port, format is \"ip address#port\".
     *
     * @param dnsServer New value for the property.
     */
    public void setDnsServer(java.lang.String dnsServer) {
        this.dnsServer = dnsServer;
    }

    /**
     * ID of the edge node that performed the query.
     *
     * @return The current value of the property.
     */
    public java.lang.String getEdgeNodeId() {
        return this.edgeNodeId;
    }

    /**
     * ID of the edge node that performed the query.
     *
     * @param edgeNodeId New value for the property.
     */
    public void setEdgeNodeId(java.lang.String edgeNodeId) {
        this.edgeNodeId = edgeNodeId;
    }

    /**
     * Non authoritative answers
     *
     * @return The current value of the property.
     */
    public java.util.List<com.vmware.nsx_global_policy.model.NsxtDnsQueryAnswer> getNonAuthoritativeAnswers() {
        return this.nonAuthoritativeAnswers;
    }

    /**
     * Non authoritative answers
     *
     * @param nonAuthoritativeAnswers New value for the property.
     */
    public void setNonAuthoritativeAnswers(java.util.List<com.vmware.nsx_global_policy.model.NsxtDnsQueryAnswer> nonAuthoritativeAnswers) {
        this.nonAuthoritativeAnswers = nonAuthoritativeAnswers;
    }

    /**
     * It can be NXDOMAIN or error message which is not consisted of
     * authoritative_answer or non_authoritative_answer.
     *
     * @return The current value of the property.
     */
    public java.lang.String getRawAnswer() {
        return this.rawAnswer;
    }

    /**
     * It can be NXDOMAIN or error message which is not consisted of
     * authoritative_answer or non_authoritative_answer.
     *
     * @param rawAnswer New value for the property.
     */
    public void setRawAnswer(java.lang.String rawAnswer) {
        this.rawAnswer = rawAnswer;
    }

    /**
     * Policy path referencing the enforcement point from where the DNS forwarder
     * nslookup answer is fetched.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getEnforcementPointPath() {
        return this.enforcementPointPath;
    }

    /**
     * Policy path referencing the enforcement point from where the DNS forwarder
     * nslookup answer is fetched.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param enforcementPointPath New value for the property.
     */
    public void setEnforcementPointPath(java.lang.String enforcementPointPath) {
        this.enforcementPointPath = enforcementPointPath;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_global_policy.model.PolicyDnsAnswerPerEnforcementPoint#RESOURCE_TYPE_NSXTDNSANSWER}</li>
     * </ul> Resource type of the DNS forwarder nslookup answer.
     * The value of this property is automatically populated to {@code "NsxTDnsAnswer"}.
     *
     * @return The current value of the property.
     */
    public java.lang.String getResourceType() {
        return this.resourceType;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx_global_policy.model.StructDefinitions.nsxtDnsAnswer;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("authoritative_answers",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.authoritativeAnswers, this._getType().getField("authoritative_answers")));
        structValue.setField("dns_server",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.dnsServer, this._getType().getField("dns_server")));
        structValue.setField("edge_node_id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.edgeNodeId, this._getType().getField("edge_node_id")));
        structValue.setField("non_authoritative_answers",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.nonAuthoritativeAnswers, this._getType().getField("non_authoritative_answers")));
        structValue.setField("raw_answer",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.rawAnswer, this._getType().getField("raw_answer")));
        structValue.setField("enforcement_point_path",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.enforcementPointPath, this._getType().getField("enforcement_point_path")));
        structValue.setField("resource_type",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.resourceType, this._getType().getField("resource_type")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx_global_policy.model.StructDefinitions.nsxtDnsAnswer;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx_global_policy.model.StructDefinitions.nsxtDnsAnswer.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static NsxtDnsAnswer _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new NsxtDnsAnswer(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static NsxtDnsAnswer _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new NsxtDnsAnswer(structValue);
    }

    /**
     * Builder class for {@link NsxtDnsAnswer}.
     */
    public static final class Builder {
        private java.util.List<com.vmware.nsx_global_policy.model.NsxtDnsQueryAnswer> authoritativeAnswers;
        private java.lang.String dnsServer;
        private java.lang.String edgeNodeId;
        private java.util.List<com.vmware.nsx_global_policy.model.NsxtDnsQueryAnswer> nonAuthoritativeAnswers;
        private java.lang.String rawAnswer;
        private java.lang.String enforcementPointPath;

        /**
         * Constructor with parameters for the required properties of
         * {@link NsxtDnsAnswer}.
         */
        public Builder() {
        }

        /**
         * Authoritative answers
         *
         * @param authoritativeAnswers New value for the property.
         */
        public Builder setAuthoritativeAnswers(java.util.List<com.vmware.nsx_global_policy.model.NsxtDnsQueryAnswer> authoritativeAnswers) {
            this.authoritativeAnswers = authoritativeAnswers;
            return this;
        }

        /**
         * Dns server ip address and port, format is \"ip address#port\".
         *
         * @param dnsServer New value for the property.
         */
        public Builder setDnsServer(java.lang.String dnsServer) {
            this.dnsServer = dnsServer;
            return this;
        }

        /**
         * ID of the edge node that performed the query.
         *
         * @param edgeNodeId New value for the property.
         */
        public Builder setEdgeNodeId(java.lang.String edgeNodeId) {
            this.edgeNodeId = edgeNodeId;
            return this;
        }

        /**
         * Non authoritative answers
         *
         * @param nonAuthoritativeAnswers New value for the property.
         */
        public Builder setNonAuthoritativeAnswers(java.util.List<com.vmware.nsx_global_policy.model.NsxtDnsQueryAnswer> nonAuthoritativeAnswers) {
            this.nonAuthoritativeAnswers = nonAuthoritativeAnswers;
            return this;
        }

        /**
         * It can be NXDOMAIN or error message which is not consisted of
         * authoritative_answer or non_authoritative_answer.
         *
         * @param rawAnswer New value for the property.
         */
        public Builder setRawAnswer(java.lang.String rawAnswer) {
            this.rawAnswer = rawAnswer;
            return this;
        }

        /**
         * Policy path referencing the enforcement point from where the DNS forwarder
         * nslookup answer is fetched.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param enforcementPointPath New value for the property.
         */
        public Builder setEnforcementPointPath(java.lang.String enforcementPointPath) {
            this.enforcementPointPath = enforcementPointPath;
            return this;
        }

        public NsxtDnsAnswer build() {
            NsxtDnsAnswer result = new NsxtDnsAnswer();
            result.setAuthoritativeAnswers(this.authoritativeAnswers);
            result.setDnsServer(this.dnsServer);
            result.setEdgeNodeId(this.edgeNodeId);
            result.setNonAuthoritativeAnswers(this.nonAuthoritativeAnswers);
            result.setRawAnswer(this.rawAnswer);
            result.setEnforcementPointPath(this.enforcementPointPath);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("authoritative_answers", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_global_policy.model.StructDefinitions.nsxtDnsQueryAnswer; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("authoritative_answers",
                                                                                "authoritativeAnswers",
                                                                                "getAuthoritativeAnswers",
                                                                                "setAuthoritativeAnswers");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("dns_server", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("dns_server",
                                                                                "dnsServer",
                                                                                "getDnsServer",
                                                                                "setDnsServer");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("edge_node_id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("edge_node_id",
                                                                                "edgeNodeId",
                                                                                "getEdgeNodeId",
                                                                                "setEdgeNodeId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("non_authoritative_answers", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_global_policy.model.StructDefinitions.nsxtDnsQueryAnswer; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("non_authoritative_answers",
                                                                                "nonAuthoritativeAnswers",
                                                                                "getNonAuthoritativeAnswers",
                                                                                "setNonAuthoritativeAnswers");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("raw_answer", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("raw_answer",
                                                                                "rawAnswer",
                                                                                "getRawAnswer",
                                                                                "setRawAnswer");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("enforcement_point_path", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("enforcement_point_path",
                                                                                "enforcementPointPath",
                                                                                "getEnforcementPointPath",
                                                                                "setEnforcementPointPath");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("resource_type", new com.vmware.vapi.bindings.type.StringType());
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("resource_type",
                                                                                "resourceType",
                                                                                "getResourceType",
                                                                                null);
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx_global_policy.model.nsxt_dns_answer",
                                                            fields,
                                                            com.vmware.nsx_global_policy.model.NsxtDnsAnswer.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            "resource_type",
                                                            "NsxTDnsAnswer");
    }
}

