/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx_global_policy.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx_global_policy.model;

/**
 * A packet is classified to have an address binding, if its address configuration
 * matches with all user specified properties.
 */
public final class PacketAddressClassifier implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    private java.lang.String ipAddress;

    private java.lang.String macAddress;

    private java.lang.Long vlan;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public PacketAddressClassifier() {
    }

    protected PacketAddressClassifier(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * A single IP address or a subnet, e.g. x.x.x.x or x.x.x.x/y format:
     * address-or-block-or-range
     *
     * @return The current value of the property.
     */
    public java.lang.String getIpAddress() {
        return this.ipAddress;
    }

    /**
     * A single IP address or a subnet, e.g. x.x.x.x or x.x.x.x/y format:
     * address-or-block-or-range
     *
     * @param ipAddress New value for the property.
     */
    public void setIpAddress(java.lang.String ipAddress) {
        this.ipAddress = ipAddress;
    }

    /**
     * A single MAC address format: mac-address
     *
     * @return The current value of the property.
     */
    public java.lang.String getMacAddress() {
        return this.macAddress;
    }

    /**
     * A single MAC address format: mac-address
     *
     * @param macAddress New value for the property.
     */
    public void setMacAddress(java.lang.String macAddress) {
        this.macAddress = macAddress;
    }

    /**
     * Virtual Local Area Network Identifier format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getVlan() {
        return this.vlan;
    }

    /**
     * Virtual Local Area Network Identifier format: int64
     *
     * @param vlan New value for the property.
     */
    public void setVlan(java.lang.Long vlan) {
        this.vlan = vlan;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx_global_policy.model.StructDefinitions.packetAddressClassifier;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("ip_address",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.ipAddress, this._getType().getField("ip_address")));
        structValue.setField("mac_address",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.macAddress, this._getType().getField("mac_address")));
        structValue.setField("vlan",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.vlan, this._getType().getField("vlan")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx_global_policy.model.StructDefinitions.packetAddressClassifier;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx_global_policy.model.StructDefinitions.packetAddressClassifier.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static PacketAddressClassifier _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new PacketAddressClassifier(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static PacketAddressClassifier _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new PacketAddressClassifier(structValue);
    }

    /**
     * Builder class for {@link PacketAddressClassifier}.
     */
    public static final class Builder {
        private java.lang.String ipAddress;
        private java.lang.String macAddress;
        private java.lang.Long vlan;

        /**
         * Constructor with parameters for the required properties of
         * {@link PacketAddressClassifier}.
         */
        public Builder() {
        }

        /**
         * A single IP address or a subnet, e.g. x.x.x.x or x.x.x.x/y format:
         * address-or-block-or-range
         *
         * @param ipAddress New value for the property.
         */
        public Builder setIpAddress(java.lang.String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        /**
         * A single MAC address format: mac-address
         *
         * @param macAddress New value for the property.
         */
        public Builder setMacAddress(java.lang.String macAddress) {
            this.macAddress = macAddress;
            return this;
        }

        /**
         * Virtual Local Area Network Identifier format: int64
         *
         * @param vlan New value for the property.
         */
        public Builder setVlan(java.lang.Long vlan) {
            this.vlan = vlan;
            return this;
        }

        public PacketAddressClassifier build() {
            PacketAddressClassifier result = new PacketAddressClassifier();
            result.setIpAddress(this.ipAddress);
            result.setMacAddress(this.macAddress);
            result.setVlan(this.vlan);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("ip_address", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("ip_address",
                                                                                "ipAddress",
                                                                                "getIpAddress",
                                                                                "setIpAddress");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("mac_address", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("mac_address",
                                                                                "macAddress",
                                                                                "getMacAddress",
                                                                                "setMacAddress");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("vlan", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("vlan",
                                                                                "vlan",
                                                                                "getVlan",
                                                                                "setVlan");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx_global_policy.model.packet_address_classifier",
                                                            fields,
                                                            com.vmware.nsx_global_policy.model.PacketAddressClassifier.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

