/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx_global_policy.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx_global_policy.model;

/**
 * A Route Based L3Vpn is more flexible, more powerful and recommended over policy
 * based. IP Tunnel subnet is created and all traffic routed through tunnel subnet
 * is sent over tunnel. Routes can be learned through BGP. A route based L3Vpn is
 * required when using redundant L3Vpn.
 */
public final class RouteBasedL3VpnSession implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    /**
     * Identifier denoting this class, when it is used in polymorphic context. 
     * <p>This
     * value should be assigned to the property which is used to discriminate the
     * actual type used in the polymorphic context.</p>
     */
    public static final java.lang.String _TYPE_IDENTIFIER = "RouteBasedL3VpnSession";

    private java.lang.Boolean defaultRuleLogging;

    private java.lang.Boolean forceWhitelisting;

    private java.lang.String routingConfigPath;

    private java.util.List<com.vmware.nsx_global_policy.model.TunnelSubnet> tunnelSubnets;

    private final java.lang.String resourceType = "RouteBasedL3VpnSession";

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public RouteBasedL3VpnSession() {
    }

    protected RouteBasedL3VpnSession(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * Indicates if logging should be enabled for the default whitelisting rule for the
     * VTI interface.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getDefaultRuleLogging() {
        return this.defaultRuleLogging;
    }

    /**
     * Indicates if logging should be enabled for the default whitelisting rule for the
     * VTI interface.
     *
     * @param defaultRuleLogging New value for the property.
     */
    public void setDefaultRuleLogging(java.lang.Boolean defaultRuleLogging) {
        this.defaultRuleLogging = defaultRuleLogging;
    }

    /**
     * The default firewall rule Action is set to DROP if true otherwise set to ALLOW.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getForceWhitelisting() {
        return this.forceWhitelisting;
    }

    /**
     * The default firewall rule Action is set to DROP if true otherwise set to ALLOW.
     *
     * @param forceWhitelisting New value for the property.
     */
    public void setForceWhitelisting(java.lang.Boolean forceWhitelisting) {
        this.forceWhitelisting = forceWhitelisting;
    }

    /**
     * This is a deprecated field. Any specified value is not saved and will be
     * ignored.
     *
     * @return The current value of the property.
     */
    @Deprecated
    public java.lang.String getRoutingConfigPath() {
        return this.routingConfigPath;
    }

    /**
     * This is a deprecated field. Any specified value is not saved and will be
     * ignored.
     *
     * @param routingConfigPath New value for the property.
     */
    @Deprecated
    public void setRoutingConfigPath(java.lang.String routingConfigPath) {
        this.routingConfigPath = routingConfigPath;
    }

    /**
     * Virtual tunnel interface (VTI) port IP subnets to be used to configure
     * route-based L3Vpn session. A max of one tunnel subnet is allowed.
     *
     * @return The current value of the property.
     */
    public java.util.List<com.vmware.nsx_global_policy.model.TunnelSubnet> getTunnelSubnets() {
        return this.tunnelSubnets;
    }

    /**
     * Virtual tunnel interface (VTI) port IP subnets to be used to configure
     * route-based L3Vpn session. A max of one tunnel subnet is allowed.
     *
     * @param tunnelSubnets New value for the property.
     */
    public void setTunnelSubnets(java.util.List<com.vmware.nsx_global_policy.model.TunnelSubnet> tunnelSubnets) {
        this.tunnelSubnets = tunnelSubnets;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_global_policy.model.L3VpnSession#RESOURCE_TYPE_POLICYBASEDL3VPNSESSION}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.L3VpnSession#RESOURCE_TYPE_ROUTEBASEDL3VPNSESSION}</li>
     * </ul> - A Policy Based L3Vpn is a configuration in which protect rules to match
     * local and remote subnet needs to be defined. Tunnel is established for each pair
     * of local and remote subnet defined in protect rules. - A Route Based L3Vpn is
     * more flexible, more powerful and recommended over policy based. IP Tunnel subnet
     * is created and all traffic routed through tunnel subnet (commonly known as VTI)
     * is sent over tunnel. Routes can be learned through BGP. A route based L3Vpn is
     * required when using redundant L3Vpn.
     * The value of this property is automatically populated to {@code "RouteBasedL3VpnSession"}.
     *
     * @return The current value of the property.
     */
    public java.lang.String getResourceType() {
        return this.resourceType;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx_global_policy.model.StructDefinitions.routeBasedL3VpnSession;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("default_rule_logging",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.defaultRuleLogging, this._getType().getField("default_rule_logging")));
        structValue.setField("force_whitelisting",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.forceWhitelisting, this._getType().getField("force_whitelisting")));
        structValue.setField("routing_config_path",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.routingConfigPath, this._getType().getField("routing_config_path")));
        structValue.setField("tunnel_subnets",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.tunnelSubnets, this._getType().getField("tunnel_subnets")));
        structValue.setField("resource_type",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.resourceType, this._getType().getField("resource_type")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx_global_policy.model.StructDefinitions.routeBasedL3VpnSession;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx_global_policy.model.StructDefinitions.routeBasedL3VpnSession.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static RouteBasedL3VpnSession _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new RouteBasedL3VpnSession(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static RouteBasedL3VpnSession _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new RouteBasedL3VpnSession(structValue);
    }

    /**
     * Builder class for {@link RouteBasedL3VpnSession}.
     */
    public static final class Builder {
        private java.lang.Boolean defaultRuleLogging;
        private java.lang.Boolean forceWhitelisting;
        private java.lang.String routingConfigPath;
        private java.util.List<com.vmware.nsx_global_policy.model.TunnelSubnet> tunnelSubnets;

        /**
         * Constructor with parameters for the required properties of
         * {@link RouteBasedL3VpnSession}.
         */
        public Builder() {
        }

        /**
         * Indicates if logging should be enabled for the default whitelisting rule for the
         * VTI interface.
         *
         * @param defaultRuleLogging New value for the property.
         */
        public Builder setDefaultRuleLogging(java.lang.Boolean defaultRuleLogging) {
            this.defaultRuleLogging = defaultRuleLogging;
            return this;
        }

        /**
         * The default firewall rule Action is set to DROP if true otherwise set to ALLOW.
         *
         * @param forceWhitelisting New value for the property.
         */
        public Builder setForceWhitelisting(java.lang.Boolean forceWhitelisting) {
            this.forceWhitelisting = forceWhitelisting;
            return this;
        }

        /**
         * This is a deprecated field. Any specified value is not saved and will be
         * ignored.
         *
         * @param routingConfigPath New value for the property.
         */
        public Builder setRoutingConfigPath(java.lang.String routingConfigPath) {
            this.routingConfigPath = routingConfigPath;
            return this;
        }

        /**
         * Virtual tunnel interface (VTI) port IP subnets to be used to configure
         * route-based L3Vpn session. A max of one tunnel subnet is allowed.
         *
         * @param tunnelSubnets New value for the property.
         */
        public Builder setTunnelSubnets(java.util.List<com.vmware.nsx_global_policy.model.TunnelSubnet> tunnelSubnets) {
            this.tunnelSubnets = tunnelSubnets;
            return this;
        }

        public RouteBasedL3VpnSession build() {
            RouteBasedL3VpnSession result = new RouteBasedL3VpnSession();
            result.setDefaultRuleLogging(this.defaultRuleLogging);
            result.setForceWhitelisting(this.forceWhitelisting);
            result.setRoutingConfigPath(this.routingConfigPath);
            result.setTunnelSubnets(this.tunnelSubnets);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("default_rule_logging", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("default_rule_logging",
                                                                                "defaultRuleLogging",
                                                                                "getDefaultRuleLogging",
                                                                                "setDefaultRuleLogging");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("force_whitelisting", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("force_whitelisting",
                                                                                "forceWhitelisting",
                                                                                "getForceWhitelisting",
                                                                                "setForceWhitelisting");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("routing_config_path", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("routing_config_path",
                                                                                "routingConfigPath",
                                                                                "getRoutingConfigPath",
                                                                                "setRoutingConfigPath");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("tunnel_subnets", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_global_policy.model.StructDefinitions.tunnelSubnet; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("tunnel_subnets",
                                                                                "tunnelSubnets",
                                                                                "getTunnelSubnets",
                                                                                "setTunnelSubnets");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("resource_type", new com.vmware.vapi.bindings.type.StringType());
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("resource_type",
                                                                                "resourceType",
                                                                                "getResourceType",
                                                                                null);
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx_global_policy.model.route_based_l3_vpn_session",
                                                            fields,
                                                            com.vmware.nsx_global_policy.model.RouteBasedL3VpnSession.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            "resource_type",
                                                            "RouteBasedL3VpnSession");
    }
}

