/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx_global_policy.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx_global_policy.model;

/**
 * DHCP IPv4 and IPv6 configurations are extended from this abstract class.
 */
public final class SegmentDhcpConfig implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    /**
     * Identifier denoting this class, when it is used in polymorphic context. 
     * <p>This
     * value should be assigned to the property which is used to discriminate the
     * actual type used in the polymorphic context.</p>
     */
    public static final java.lang.String _TYPE_IDENTIFIER = "SegmentDhcpConfig";

    public static final java.lang.String RESOURCE_TYPE_SEGMENTDHCPV4CONFIG = "SegmentDhcpV4Config";

    public static final java.lang.String RESOURCE_TYPE_SEGMENTDHCPV6CONFIG = "SegmentDhcpV6Config";

    private java.util.List<java.lang.String> dnsServers;

    private java.lang.Long leaseTime;

    private final java.lang.String resourceType = "SegmentDhcpConfig";

    private java.lang.String serverAddress;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public SegmentDhcpConfig() {
    }

    protected SegmentDhcpConfig(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * IP address of DNS servers for subnet. DNS server IP address must belong to the
     * same address family as segment gateway_address property. format: ip
     *
     * @return The current value of the property.
     */
    public java.util.List<java.lang.String> getDnsServers() {
        return this.dnsServers;
    }

    /**
     * IP address of DNS servers for subnet. DNS server IP address must belong to the
     * same address family as segment gateway_address property. format: ip
     *
     * @param dnsServers New value for the property.
     */
    public void setDnsServers(java.util.List<java.lang.String> dnsServers) {
        this.dnsServers = dnsServers;
    }

    /**
     * DHCP lease time in seconds. When specified, this property overwrites lease time
     * configured DHCP server config. format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getLeaseTime() {
        return this.leaseTime;
    }

    /**
     * DHCP lease time in seconds. When specified, this property overwrites lease time
     * configured DHCP server config. format: int64
     *
     * @param leaseTime New value for the property.
     */
    public void setLeaseTime(java.lang.Long leaseTime) {
        this.leaseTime = leaseTime;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_global_policy.model.SegmentDhcpConfig#RESOURCE_TYPE_SEGMENTDHCPV4CONFIG}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.SegmentDhcpConfig#RESOURCE_TYPE_SEGMENTDHCPV6CONFIG}</li>
     * </ul>
     * The value of this property is automatically populated to {@code "SegmentDhcpConfig"}.
     *
     * @return The current value of the property.
     */
    public java.lang.String getResourceType() {
        return this.resourceType;
    }

    /**
     * IP address of the DHCP server in CIDR format. The server_address is mandatory in
     * case this segment has provided a dhcp_config_path and it represents a DHCP
     * server config. If this SegmentDhcpConfig is a SegmentDhcpV4Config, the address
     * must be an IPv4 address. If this is a SegmentDhcpV6Config, the address must be
     * an IPv6 address. This address must not overlap the ip-ranges of the subnet, or
     * the gateway address of the subnet, or the DHCP static-binding addresses of this
     * segment. format: ip-cidr-block
     *
     * @return The current value of the property.
     */
    public java.lang.String getServerAddress() {
        return this.serverAddress;
    }

    /**
     * IP address of the DHCP server in CIDR format. The server_address is mandatory in
     * case this segment has provided a dhcp_config_path and it represents a DHCP
     * server config. If this SegmentDhcpConfig is a SegmentDhcpV4Config, the address
     * must be an IPv4 address. If this is a SegmentDhcpV6Config, the address must be
     * an IPv6 address. This address must not overlap the ip-ranges of the subnet, or
     * the gateway address of the subnet, or the DHCP static-binding addresses of this
     * segment. format: ip-cidr-block
     *
     * @param serverAddress New value for the property.
     */
    public void setServerAddress(java.lang.String serverAddress) {
        this.serverAddress = serverAddress;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx_global_policy.model.StructDefinitions.segmentDhcpConfig;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("dns_servers",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.dnsServers, this._getType().getField("dns_servers")));
        structValue.setField("lease_time",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.leaseTime, this._getType().getField("lease_time")));
        structValue.setField("resource_type",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.resourceType, this._getType().getField("resource_type")));
        structValue.setField("server_address",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.serverAddress, this._getType().getField("server_address")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx_global_policy.model.StructDefinitions.segmentDhcpConfig;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx_global_policy.model.StructDefinitions.segmentDhcpConfig.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static SegmentDhcpConfig _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new SegmentDhcpConfig(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static SegmentDhcpConfig _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new SegmentDhcpConfig(structValue);
    }

    /**
     * Builder class for {@link SegmentDhcpConfig}.
     */
    public static final class Builder {
        private java.util.List<java.lang.String> dnsServers;
        private java.lang.Long leaseTime;
        private java.lang.String serverAddress;

        /**
         * Constructor with parameters for the required properties of
         * {@link SegmentDhcpConfig}.
         */
        public Builder() {
        }

        /**
         * IP address of DNS servers for subnet. DNS server IP address must belong to the
         * same address family as segment gateway_address property. format: ip
         *
         * @param dnsServers New value for the property.
         */
        public Builder setDnsServers(java.util.List<java.lang.String> dnsServers) {
            this.dnsServers = dnsServers;
            return this;
        }

        /**
         * DHCP lease time in seconds. When specified, this property overwrites lease time
         * configured DHCP server config. format: int64
         *
         * @param leaseTime New value for the property.
         */
        public Builder setLeaseTime(java.lang.Long leaseTime) {
            this.leaseTime = leaseTime;
            return this;
        }

        /**
         * IP address of the DHCP server in CIDR format. The server_address is mandatory in
         * case this segment has provided a dhcp_config_path and it represents a DHCP
         * server config. If this SegmentDhcpConfig is a SegmentDhcpV4Config, the address
         * must be an IPv4 address. If this is a SegmentDhcpV6Config, the address must be
         * an IPv6 address. This address must not overlap the ip-ranges of the subnet, or
         * the gateway address of the subnet, or the DHCP static-binding addresses of this
         * segment. format: ip-cidr-block
         *
         * @param serverAddress New value for the property.
         */
        public Builder setServerAddress(java.lang.String serverAddress) {
            this.serverAddress = serverAddress;
            return this;
        }

        public SegmentDhcpConfig build() {
            SegmentDhcpConfig result = new SegmentDhcpConfig();
            result.setDnsServers(this.dnsServers);
            result.setLeaseTime(this.leaseTime);
            result.setServerAddress(this.serverAddress);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("dns_servers", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.StringType())));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("dns_servers",
                                                                                "dnsServers",
                                                                                "getDnsServers",
                                                                                "setDnsServers");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("lease_time", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("lease_time",
                                                                                "leaseTime",
                                                                                "getLeaseTime",
                                                                                "setLeaseTime");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("resource_type", new com.vmware.vapi.bindings.type.StringType());
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("resource_type",
                                                                                "resourceType",
                                                                                "getResourceType",
                                                                                null);
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("server_address", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("server_address",
                                                                                "serverAddress",
                                                                                "getServerAddress",
                                                                                "setServerAddress");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx_global_policy.model.segment_dhcp_config",
                                                            fields,
                                                            com.vmware.nsx_global_policy.model.SegmentDhcpConfig.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            "resource_type",
                                                            "SegmentDhcpConfig");
    }
}

