/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx_global_policy.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx_global_policy.model;

/**
 * Service Gateway serves as the default gateway for VPC.
 */
public final class ServiceGateway implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    private java.lang.Boolean autoSnat;

    private java.lang.Boolean disable;

    private com.vmware.nsx_global_policy.model.GatewayQosProfileConfig qosConfig;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public ServiceGateway() {
    }

    protected ServiceGateway(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * Auto plumb snat rule for private subnet, this will make sure private subnets are
     * routable outside of VPC. There will be one snat rule per VPC, translated ip will
     * be taken from external ip block. If enabled, user must also configure external
     * ip block. This property is applicable only when service_gateway is enabled.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getAutoSnat() {
        return this.autoSnat;
    }

    /**
     * Auto plumb snat rule for private subnet, this will make sure private subnets are
     * routable outside of VPC. There will be one snat rule per VPC, translated ip will
     * be taken from external ip block. If enabled, user must also configure external
     * ip block. This property is applicable only when service_gateway is enabled.
     *
     * @param autoSnat New value for the property.
     */
    public void setAutoSnat(java.lang.Boolean autoSnat) {
        this.autoSnat = autoSnat;
    }

    /**
     * Flag to disable service gateway for connected subnets. If false then VPC will
     * support the following services: NAT, gateway security policies, and gateway QoS
     * profile. If true, VPC will support only distributed services i.e., EW security
     * policy. Workload shall be protected using the same. All traffic from subnets
     * will be routed through the distributed router to the connected gateway and
     * eliminates the intermediate hop of the service gateway.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getDisable() {
        return this.disable;
    }

    /**
     * Flag to disable service gateway for connected subnets. If false then VPC will
     * support the following services: NAT, gateway security policies, and gateway QoS
     * profile. If true, VPC will support only distributed services i.e., EW security
     * policy. Workload shall be protected using the same. All traffic from subnets
     * will be routed through the distributed router to the connected gateway and
     * eliminates the intermediate hop of the service gateway.
     *
     * @param disable New value for the property.
     */
    public void setDisable(java.lang.Boolean disable) {
        this.disable = disable;
    }

    /**
     *
     *
     * @return The current value of the property.
     */
    public com.vmware.nsx_global_policy.model.GatewayQosProfileConfig getQosConfig() {
        return this.qosConfig;
    }

    /**
     *
     *
     * @param qosConfig New value for the property.
     */
    public void setQosConfig(com.vmware.nsx_global_policy.model.GatewayQosProfileConfig qosConfig) {
        this.qosConfig = qosConfig;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx_global_policy.model.StructDefinitions.serviceGateway;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("auto_snat",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.autoSnat, this._getType().getField("auto_snat")));
        structValue.setField("disable",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.disable, this._getType().getField("disable")));
        structValue.setField("qos_config",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.qosConfig, this._getType().getField("qos_config")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx_global_policy.model.StructDefinitions.serviceGateway;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx_global_policy.model.StructDefinitions.serviceGateway.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static ServiceGateway _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new ServiceGateway(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static ServiceGateway _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new ServiceGateway(structValue);
    }

    /**
     * Builder class for {@link ServiceGateway}.
     */
    public static final class Builder {
        private java.lang.Boolean autoSnat;
        private java.lang.Boolean disable;
        private com.vmware.nsx_global_policy.model.GatewayQosProfileConfig qosConfig;

        /**
         * Constructor with parameters for the required properties of
         * {@link ServiceGateway}.
         */
        public Builder() {
        }

        /**
         * Auto plumb snat rule for private subnet, this will make sure private subnets are
         * routable outside of VPC. There will be one snat rule per VPC, translated ip will
         * be taken from external ip block. If enabled, user must also configure external
         * ip block. This property is applicable only when service_gateway is enabled.
         *
         * @param autoSnat New value for the property.
         */
        public Builder setAutoSnat(java.lang.Boolean autoSnat) {
            this.autoSnat = autoSnat;
            return this;
        }

        /**
         * Flag to disable service gateway for connected subnets. If false then VPC will
         * support the following services: NAT, gateway security policies, and gateway QoS
         * profile. If true, VPC will support only distributed services i.e., EW security
         * policy. Workload shall be protected using the same. All traffic from subnets
         * will be routed through the distributed router to the connected gateway and
         * eliminates the intermediate hop of the service gateway.
         *
         * @param disable New value for the property.
         */
        public Builder setDisable(java.lang.Boolean disable) {
            this.disable = disable;
            return this;
        }

        /**
         *
         *
         * @param qosConfig New value for the property.
         */
        public Builder setQosConfig(com.vmware.nsx_global_policy.model.GatewayQosProfileConfig qosConfig) {
            this.qosConfig = qosConfig;
            return this;
        }

        public ServiceGateway build() {
            ServiceGateway result = new ServiceGateway();
            result.setAutoSnat(this.autoSnat);
            result.setDisable(this.disable);
            result.setQosConfig(this.qosConfig);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("auto_snat", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("auto_snat",
                                                                                "autoSnat",
                                                                                "getAutoSnat",
                                                                                "setAutoSnat");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("disable", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("disable",
                                                                                "disable",
                                                                                "getDisable",
                                                                                "setDisable");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("qos_config", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_global_policy.model.StructDefinitions.gatewayQosProfileConfig; } }));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("qos_config",
                                                                                "qosConfig",
                                                                                "getQosConfig",
                                                                                "setQosConfig");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx_global_policy.model.service_gateway",
                                                            fields,
                                                            com.vmware.nsx_global_policy.model.ServiceGateway.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

