/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for model: com.vmware.nsx_global_policy.
 */

package com.vmware.nsx_global_policy.util;

import java.util.Map;

import com.vmware.vapi.internal.util.Validate;

import com.vmware.vapi.bindings.type.StructType;

/**
 * Utility for StructType.
 */
public final class StructTypeUtil {

    /**
     * Populates mappings for structures defined in a model (set of VMODL
     * definitions).
     *
     * For each top level structure and each structure defined in a service,
     * adds an entry to the map where the key is the fully qualified canonical
     * name of the structure, and the value is a StructType. It allows to
     * retrieve the StructType from the canonical name of an structure.
     *
     * @param mapping map to fill with mappings for each structure in the bindings;
     *                must not be null.
     */
    public static void populateCanonicalNameToStructTypeMap(Map<String, StructType> mapping) {
        Validate.notNull(mapping);
        add(mapping,
            "com.vmware.nsx_global_policy.model.ALG_type_service_entry",
            com.vmware.nsx_global_policy.model.StructDefinitions.ALGTypeServiceEntry);
        add(mapping,
            "com.vmware.nsx_global_policy.model.abstract_space",
            com.vmware.nsx_global_policy.model.StructDefinitions.abstractSpace);
        add(mapping,
            "com.vmware.nsx_global_policy.model.acceptable_component_version",
            com.vmware.nsx_global_policy.model.StructDefinitions.acceptableComponentVersion);
        add(mapping,
            "com.vmware.nsx_global_policy.model.acceptable_component_version_list",
            com.vmware.nsx_global_policy.model.StructDefinitions.acceptableComponentVersionList);
        add(mapping,
            "com.vmware.nsx_global_policy.model.action",
            com.vmware.nsx_global_policy.model.StructDefinitions.action);
        add(mapping,
            "com.vmware.nsx_global_policy.model.actionable_resource",
            com.vmware.nsx_global_policy.model.StructDefinitions.actionableResource);
        add(mapping,
            "com.vmware.nsx_global_policy.model.actionable_resource_list_result",
            com.vmware.nsx_global_policy.model.StructDefinitions.actionableResourceListResult);
        add(mapping,
            "com.vmware.nsx_global_policy.model.active_directory_identity_source",
            com.vmware.nsx_global_policy.model.StructDefinitions.activeDirectoryIdentitySource);
        add(mapping,
            "com.vmware.nsx_global_policy.model.add_cluster_node_VM_info",
            com.vmware.nsx_global_policy.model.StructDefinitions.addClusterNodeVMInfo);
        add(mapping,
            "com.vmware.nsx_global_policy.model.address_binding_entry",
            com.vmware.nsx_global_policy.model.StructDefinitions.addressBindingEntry);
        add(mapping,
            "com.vmware.nsx_global_policy.model.advance_cluster_restore_input",
            com.vmware.nsx_global_policy.model.StructDefinitions.advanceClusterRestoreInput);
        add(mapping,
            "com.vmware.nsx_global_policy.model.advance_cluster_restore_request",
            com.vmware.nsx_global_policy.model.StructDefinitions.advanceClusterRestoreRequest);
        add(mapping,
            "com.vmware.nsx_global_policy.model.advertised_network_csv_record",
            com.vmware.nsx_global_policy.model.StructDefinitions.advertisedNetworkCsvRecord);
        add(mapping,
            "com.vmware.nsx_global_policy.model.aggregate_DNS_forwarder_statistics",
            com.vmware.nsx_global_policy.model.StructDefinitions.aggregateDNSForwarderStatistics);
        add(mapping,
            "com.vmware.nsx_global_policy.model.aggregate_DNS_forwarder_status",
            com.vmware.nsx_global_policy.model.StructDefinitions.aggregateDNSForwarderStatus);
        add(mapping,
            "com.vmware.nsx_global_policy.model.aggregate_policy_dns_answer",
            com.vmware.nsx_global_policy.model.StructDefinitions.aggregatePolicyDnsAnswer);
        add(mapping,
            "com.vmware.nsx_global_policy.model.aggregate_policy_runtime_info",
            com.vmware.nsx_global_policy.model.StructDefinitions.aggregatePolicyRuntimeInfo);
        add(mapping,
            "com.vmware.nsx_global_policy.model.aggregated_data_counter",
            com.vmware.nsx_global_policy.model.StructDefinitions.aggregatedDataCounter);
        add(mapping,
            "com.vmware.nsx_global_policy.model.aggregated_data_counter_ex",
            com.vmware.nsx_global_policy.model.StructDefinitions.aggregatedDataCounterEx);
        add(mapping,
            "com.vmware.nsx_global_policy.model.aggregated_logical_router_port_counters",
            com.vmware.nsx_global_policy.model.StructDefinitions.aggregatedLogicalRouterPortCounters);
        add(mapping,
            "com.vmware.nsx_global_policy.model.antrea_traceflow_config",
            com.vmware.nsx_global_policy.model.StructDefinitions.antreaTraceflowConfig);
        add(mapping,
            "com.vmware.nsx_global_policy.model.antrea_traceflow_icmp_echo_request_header",
            com.vmware.nsx_global_policy.model.StructDefinitions.antreaTraceflowIcmpEchoRequestHeader);
        add(mapping,
            "com.vmware.nsx_global_policy.model.antrea_traceflow_ip_header",
            com.vmware.nsx_global_policy.model.StructDefinitions.antreaTraceflowIpHeader);
        add(mapping,
            "com.vmware.nsx_global_policy.model.antrea_traceflow_ipv6_header",
            com.vmware.nsx_global_policy.model.StructDefinitions.antreaTraceflowIpv6Header);
        add(mapping,
            "com.vmware.nsx_global_policy.model.antrea_traceflow_packet_data",
            com.vmware.nsx_global_policy.model.StructDefinitions.antreaTraceflowPacketData);
        add(mapping,
            "com.vmware.nsx_global_policy.model.antrea_traceflow_tcp_header",
            com.vmware.nsx_global_policy.model.StructDefinitions.antreaTraceflowTcpHeader);
        add(mapping,
            "com.vmware.nsx_global_policy.model.antrea_traceflow_transport_header",
            com.vmware.nsx_global_policy.model.StructDefinitions.antreaTraceflowTransportHeader);
        add(mapping,
            "com.vmware.nsx_global_policy.model.antrea_traceflow_udp_header",
            com.vmware.nsx_global_policy.model.StructDefinitions.antreaTraceflowUdpHeader);
        add(mapping,
            "com.vmware.nsx_global_policy.model.api_error",
            com.vmware.nsx_global_policy.model.StructDefinitions.apiError);
        add(mapping,
            "com.vmware.nsx_global_policy.model.api_request_body",
            com.vmware.nsx_global_policy.model.StructDefinitions.apiRequestBody);
        add(mapping,
            "com.vmware.nsx_global_policy.model.api_service_config",
            com.vmware.nsx_global_policy.model.StructDefinitions.apiServiceConfig);
        add(mapping,
            "com.vmware.nsx_global_policy.model.application_connectivity_strategy",
            com.vmware.nsx_global_policy.model.StructDefinitions.applicationConnectivityStrategy);
        add(mapping,
            "com.vmware.nsx_global_policy.model.arp_header",
            com.vmware.nsx_global_policy.model.StructDefinitions.arpHeader);
        add(mapping,
            "com.vmware.nsx_global_policy.model.arp_snooping_config",
            com.vmware.nsx_global_policy.model.StructDefinitions.arpSnoopingConfig);
        add(mapping,
            "com.vmware.nsx_global_policy.model.attached_interface_entry",
            com.vmware.nsx_global_policy.model.StructDefinitions.attachedInterfaceEntry);
        add(mapping,
            "com.vmware.nsx_global_policy.model.attribute",
            com.vmware.nsx_global_policy.model.StructDefinitions.attribute);
        add(mapping,
            "com.vmware.nsx_global_policy.model.attribute_val",
            com.vmware.nsx_global_policy.model.StructDefinitions.attributeVal);
        add(mapping,
            "com.vmware.nsx_global_policy.model.auto_rds",
            com.vmware.nsx_global_policy.model.StructDefinitions.autoRds);
        add(mapping,
            "com.vmware.nsx_global_policy.model.avi_connection_info",
            com.vmware.nsx_global_policy.model.StructDefinitions.aviConnectionInfo);
        add(mapping,
            "com.vmware.nsx_global_policy.model.axes",
            com.vmware.nsx_global_policy.model.StructDefinitions.axes);
        add(mapping,
            "com.vmware.nsx_global_policy.model.axis_unit",
            com.vmware.nsx_global_policy.model.StructDefinitions.axisUnit);
        add(mapping,
            "com.vmware.nsx_global_policy.model.backup_configuration",
            com.vmware.nsx_global_policy.model.StructDefinitions.backupConfiguration);
        add(mapping,
            "com.vmware.nsx_global_policy.model.backup_operation_history",
            com.vmware.nsx_global_policy.model.StructDefinitions.backupOperationHistory);
        add(mapping,
            "com.vmware.nsx_global_policy.model.backup_operation_status",
            com.vmware.nsx_global_policy.model.StructDefinitions.backupOperationStatus);
        add(mapping,
            "com.vmware.nsx_global_policy.model.backup_overview",
            com.vmware.nsx_global_policy.model.StructDefinitions.backupOverview);
        add(mapping,
            "com.vmware.nsx_global_policy.model.backup_schedule",
            com.vmware.nsx_global_policy.model.StructDefinitions.backupSchedule);
        add(mapping,
            "com.vmware.nsx_global_policy.model.base_compatibility_check_result",
            com.vmware.nsx_global_policy.model.StructDefinitions.baseCompatibilityCheckResult);
        add(mapping,
            "com.vmware.nsx_global_policy.model.base_consolidated_status_per_enforcement_point",
            com.vmware.nsx_global_policy.model.StructDefinitions.baseConsolidatedStatusPerEnforcementPoint);
        add(mapping,
            "com.vmware.nsx_global_policy.model.base_endpoint",
            com.vmware.nsx_global_policy.model.StructDefinitions.baseEndpoint);
        add(mapping,
            "com.vmware.nsx_global_policy.model.base_interface_group",
            com.vmware.nsx_global_policy.model.StructDefinitions.baseInterfaceGroup);
        add(mapping,
            "com.vmware.nsx_global_policy.model.base_policy_service_instance",
            com.vmware.nsx_global_policy.model.StructDefinitions.basePolicyServiceInstance);
        add(mapping,
            "com.vmware.nsx_global_policy.model.base_rule",
            com.vmware.nsx_global_policy.model.StructDefinitions.baseRule);
        add(mapping,
            "com.vmware.nsx_global_policy.model.base_rule_list_result",
            com.vmware.nsx_global_policy.model.StructDefinitions.baseRuleListResult);
        add(mapping,
            "com.vmware.nsx_global_policy.model.base_tier0_interface",
            com.vmware.nsx_global_policy.model.StructDefinitions.baseTier0Interface);
        add(mapping,
            "com.vmware.nsx_global_policy.model.batch_request",
            com.vmware.nsx_global_policy.model.StructDefinitions.batchRequest);
        add(mapping,
            "com.vmware.nsx_global_policy.model.batch_request_item",
            com.vmware.nsx_global_policy.model.StructDefinitions.batchRequestItem);
        add(mapping,
            "com.vmware.nsx_global_policy.model.batch_response",
            com.vmware.nsx_global_policy.model.StructDefinitions.batchResponse);
        add(mapping,
            "com.vmware.nsx_global_policy.model.batch_response_item",
            com.vmware.nsx_global_policy.model.StructDefinitions.batchResponseItem);
        add(mapping,
            "com.vmware.nsx_global_policy.model.bfd_health_monitoring_config",
            com.vmware.nsx_global_policy.model.StructDefinitions.bfdHealthMonitoringConfig);
        add(mapping,
            "com.vmware.nsx_global_policy.model.bfd_profile",
            com.vmware.nsx_global_policy.model.StructDefinitions.bfdProfile);
        add(mapping,
            "com.vmware.nsx_global_policy.model.bfd_profile_list_result",
            com.vmware.nsx_global_policy.model.StructDefinitions.bfdProfileListResult);
        add(mapping,
            "com.vmware.nsx_global_policy.model.bgp_address_family",
            com.vmware.nsx_global_policy.model.StructDefinitions.bgpAddressFamily);
        add(mapping,
            "com.vmware.nsx_global_policy.model.bgp_bfd_config",
            com.vmware.nsx_global_policy.model.StructDefinitions.bgpBfdConfig);
        add(mapping,
            "com.vmware.nsx_global_policy.model.bgp_graceful_restart_config",
            com.vmware.nsx_global_policy.model.StructDefinitions.bgpGracefulRestartConfig);
        add(mapping,
            "com.vmware.nsx_global_policy.model.bgp_graceful_restart_timer",
            com.vmware.nsx_global_policy.model.StructDefinitions.bgpGracefulRestartTimer);
        add(mapping,
            "com.vmware.nsx_global_policy.model.bgp_neighbor_config",
            com.vmware.nsx_global_policy.model.StructDefinitions.bgpNeighborConfig);
        add(mapping,
            "com.vmware.nsx_global_policy.model.bgp_neighbor_config_list_result",
            com.vmware.nsx_global_policy.model.StructDefinitions.bgpNeighborConfigListResult);
        add(mapping,
            "com.vmware.nsx_global_policy.model.bgp_neighbor_local_as_config",
            com.vmware.nsx_global_policy.model.StructDefinitions.bgpNeighborLocalAsConfig);
        add(mapping,
            "com.vmware.nsx_global_policy.model.bgp_neighbor_route_details_csv_record",
            com.vmware.nsx_global_policy.model.StructDefinitions.bgpNeighborRouteDetailsCsvRecord);
        add(mapping,
            "com.vmware.nsx_global_policy.model.bgp_neighbor_route_details_in_csv_format",
            com.vmware.nsx_global_policy.model.StructDefinitions.bgpNeighborRouteDetailsInCsvFormat);
        add(mapping,
            "com.vmware.nsx_global_policy.model.bgp_neighbor_routes",
            com.vmware.nsx_global_policy.model.StructDefinitions.bgpNeighborRoutes);
        add(mapping,
            "com.vmware.nsx_global_policy.model.bgp_neighbor_routes_list_result",
            com.vmware.nsx_global_policy.model.StructDefinitions.bgpNeighborRoutesListResult);
        add(mapping,
            "com.vmware.nsx_global_policy.model.bgp_route_filtering",
            com.vmware.nsx_global_policy.model.StructDefinitions.bgpRouteFiltering);
        add(mapping,
            "com.vmware.nsx_global_policy.model.bgp_route_leaking",
            com.vmware.nsx_global_policy.model.StructDefinitions.bgpRouteLeaking);
        add(mapping,
            "com.vmware.nsx_global_policy.model.bgp_routing_config",
            com.vmware.nsx_global_policy.model.StructDefinitions.bgpRoutingConfig);
        add(mapping,
            "com.vmware.nsx_global_policy.model.binary_packet_data",
            com.vmware.nsx_global_policy.model.StructDefinitions.binaryPacketData);
        add(mapping,
            "com.vmware.nsx_global_policy.model.bridge_endpoint_statistics",
            com.vmware.nsx_global_policy.model.StructDefinitions.bridgeEndpointStatistics);
        add(mapping,
            "com.vmware.nsx_global_policy.model.bridge_endpoint_status",
            com.vmware.nsx_global_policy.model.StructDefinitions.bridgeEndpointStatus);
        add(mapping,
            "com.vmware.nsx_global_policy.model.bridge_profile_config",
            com.vmware.nsx_global_policy.model.StructDefinitions.bridgeProfileConfig);
        add(mapping,
            "com.vmware.nsx_global_policy.model.byod_policy_service_instance",
            com.vmware.nsx_global_policy.model.StructDefinitions.byodPolicyServiceInstance);
        add(mapping,
            "com.vmware.nsx_global_policy.model.ca_bundle",
            com.vmware.nsx_global_policy.model.StructDefinitions.caBundle);
        add(mapping,
            "com.vmware.nsx_global_policy.model.ca_bundle_list_result",
            com.vmware.nsx_global_policy.model.StructDefinitions.caBundleListResult);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_antrea_traceflow_config",
            com.vmware.nsx_global_policy.model.StructDefinitions.childAntreaTraceflowConfig);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_bfd_profile",
            com.vmware.nsx_global_policy.model.StructDefinitions.childBfdProfile);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_bgp_neighbor_config",
            com.vmware.nsx_global_policy.model.StructDefinitions.childBgpNeighborConfig);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_bgp_routing_config",
            com.vmware.nsx_global_policy.model.StructDefinitions.childBgpRoutingConfig);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_byod_policy_service_instance",
            com.vmware.nsx_global_policy.model.StructDefinitions.childByodPolicyServiceInstance);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_ca_bundle",
            com.vmware.nsx_global_policy.model.StructDefinitions.childCaBundle);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_communication_entry",
            com.vmware.nsx_global_policy.model.StructDefinitions.childCommunicationEntry);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_communication_map",
            com.vmware.nsx_global_policy.model.StructDefinitions.childCommunicationMap);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_community_list",
            com.vmware.nsx_global_policy.model.StructDefinitions.childCommunityList);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_compute_cluster_idfw_configuration",
            com.vmware.nsx_global_policy.model.StructDefinitions.childComputeClusterIdfwConfiguration);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_constraint",
            com.vmware.nsx_global_policy.model.StructDefinitions.childConstraint);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_constraint_global_config",
            com.vmware.nsx_global_policy.model.StructDefinitions.childConstraintGlobalConfig);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_deployment_zone",
            com.vmware.nsx_global_policy.model.StructDefinitions.childDeploymentZone);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_dfw_firewall_configuration",
            com.vmware.nsx_global_policy.model.StructDefinitions.childDfwFirewallConfiguration);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_dhcp_relay_config",
            com.vmware.nsx_global_policy.model.StructDefinitions.childDhcpRelayConfig);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_dhcp_server_config",
            com.vmware.nsx_global_policy.model.StructDefinitions.childDhcpServerConfig);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_dhcp_static_binding_config",
            com.vmware.nsx_global_policy.model.StructDefinitions.childDhcpStaticBindingConfig);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_dns_security_profile",
            com.vmware.nsx_global_policy.model.StructDefinitions.childDnsSecurityProfile);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_dns_security_profile_binding_map",
            com.vmware.nsx_global_policy.model.StructDefinitions.childDnsSecurityProfileBindingMap);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_domain",
            com.vmware.nsx_global_policy.model.StructDefinitions.childDomain);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_domain_deployment_map",
            com.vmware.nsx_global_policy.model.StructDefinitions.childDomainDeploymentMap);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_endpoint_policy",
            com.vmware.nsx_global_policy.model.StructDefinitions.childEndpointPolicy);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_endpoint_rule",
            com.vmware.nsx_global_policy.model.StructDefinitions.childEndpointRule);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_enforcement_point",
            com.vmware.nsx_global_policy.model.StructDefinitions.childEnforcementPoint);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_evpn_config",
            com.vmware.nsx_global_policy.model.StructDefinitions.childEvpnConfig);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_evpn_tunnel_endpoint_config",
            com.vmware.nsx_global_policy.model.StructDefinitions.childEvpnTunnelEndpointConfig);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_flood_protection_profile",
            com.vmware.nsx_global_policy.model.StructDefinitions.childFloodProtectionProfile);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_flood_protection_profile_binding_map",
            com.vmware.nsx_global_policy.model.StructDefinitions.childFloodProtectionProfileBindingMap);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_forwarding_policy",
            com.vmware.nsx_global_policy.model.StructDefinitions.childForwardingPolicy);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_forwarding_rule",
            com.vmware.nsx_global_policy.model.StructDefinitions.childForwardingRule);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_fqdn_analysis_config",
            com.vmware.nsx_global_policy.model.StructDefinitions.childFqdnAnalysisConfig);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_gateway_policy",
            com.vmware.nsx_global_policy.model.StructDefinitions.childGatewayPolicy);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_gateway_qos_profile",
            com.vmware.nsx_global_policy.model.StructDefinitions.childGatewayQosProfile);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_general_security_profile",
            com.vmware.nsx_global_policy.model.StructDefinitions.childGeneralSecurityProfile);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_general_security_profile_binding_map",
            com.vmware.nsx_global_policy.model.StructDefinitions.childGeneralSecurityProfileBindingMap);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_global_config",
            com.vmware.nsx_global_policy.model.StructDefinitions.childGlobalConfig);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_global_dfw_configuration",
            com.vmware.nsx_global_policy.model.StructDefinitions.childGlobalDfwConfiguration);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_global_ids_settings",
            com.vmware.nsx_global_policy.model.StructDefinitions.childGlobalIdsSettings);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_global_ids_signature",
            com.vmware.nsx_global_policy.model.StructDefinitions.childGlobalIdsSignature);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_global_manager",
            com.vmware.nsx_global_policy.model.StructDefinitions.childGlobalManager);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_group",
            com.vmware.nsx_global_policy.model.StructDefinitions.childGroup);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_group_discovery_profile_binding_map",
            com.vmware.nsx_global_policy.model.StructDefinitions.childGroupDiscoveryProfileBindingMap);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_group_monitoring_profile_binding_map",
            com.vmware.nsx_global_policy.model.StructDefinitions.childGroupMonitoringProfileBindingMap);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_IP_discovery_profile",
            com.vmware.nsx_global_policy.model.StructDefinitions.childIPDiscoveryProfile);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_IPFIXDFW_collector_profile",
            com.vmware.nsx_global_policy.model.StructDefinitions.childIPFIXDFWCollectorProfile);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_IPFIXDFW_profile",
            com.vmware.nsx_global_policy.model.StructDefinitions.childIPFIXDFWProfile);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_IPFIX_l2_collector_profile",
            com.vmware.nsx_global_policy.model.StructDefinitions.childIPFIXL2CollectorProfile);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_IPFIX_l2_profile",
            com.vmware.nsx_global_policy.model.StructDefinitions.childIPFIXL2Profile);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_IP_sec_vpn_dpd_profile",
            com.vmware.nsx_global_policy.model.StructDefinitions.childIPSecVpnDpdProfile);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_IP_sec_vpn_ike_profile",
            com.vmware.nsx_global_policy.model.StructDefinitions.childIPSecVpnIkeProfile);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_IP_sec_vpn_local_endpoint",
            com.vmware.nsx_global_policy.model.StructDefinitions.childIPSecVpnLocalEndpoint);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_IP_sec_vpn_service",
            com.vmware.nsx_global_policy.model.StructDefinitions.childIPSecVpnService);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_IP_sec_vpn_session",
            com.vmware.nsx_global_policy.model.StructDefinitions.childIPSecVpnSession);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_IP_sec_vpn_tunnel_profile",
            com.vmware.nsx_global_policy.model.StructDefinitions.childIPSecVpnTunnelProfile);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_identity_firewall_store",
            com.vmware.nsx_global_policy.model.StructDefinitions.childIdentityFirewallStore);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_ids_cluster_config",
            com.vmware.nsx_global_policy.model.StructDefinitions.childIdsClusterConfig);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_ids_gateway_policy",
            com.vmware.nsx_global_policy.model.StructDefinitions.childIdsGatewayPolicy);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_ids_global_event_config",
            com.vmware.nsx_global_policy.model.StructDefinitions.childIdsGlobalEventConfig);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_ids_profile",
            com.vmware.nsx_global_policy.model.StructDefinitions.childIdsProfile);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_ids_rule",
            com.vmware.nsx_global_policy.model.StructDefinitions.childIdsRule);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_ids_security_policy",
            com.vmware.nsx_global_policy.model.StructDefinitions.childIdsSecurityPolicy);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_ids_settings",
            com.vmware.nsx_global_policy.model.StructDefinitions.childIdsSettings);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_ids_signature",
            com.vmware.nsx_global_policy.model.StructDefinitions.childIdsSignature);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_ids_signature_status",
            com.vmware.nsx_global_policy.model.StructDefinitions.childIdsSignatureStatus);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_ids_signature_version",
            com.vmware.nsx_global_policy.model.StructDefinitions.childIdsSignatureVersion);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_ids_standalone_host_config",
            com.vmware.nsx_global_policy.model.StructDefinitions.childIdsStandaloneHostConfig);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_infra",
            com.vmware.nsx_global_policy.model.StructDefinitions.childInfra);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_ip_address_allocation",
            com.vmware.nsx_global_policy.model.StructDefinitions.childIpAddressAllocation);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_ip_address_block",
            com.vmware.nsx_global_policy.model.StructDefinitions.childIpAddressBlock);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_ip_address_pool",
            com.vmware.nsx_global_policy.model.StructDefinitions.childIpAddressPool);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_ip_address_pool_subnet",
            com.vmware.nsx_global_policy.model.StructDefinitions.childIpAddressPoolSubnet);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_ipv6_dad_profile",
            com.vmware.nsx_global_policy.model.StructDefinitions.childIpv6DadProfile);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_ipv6_ndra_profile",
            com.vmware.nsx_global_policy.model.StructDefinitions.childIpv6NdraProfile);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_l2_bridge_endpoint_profile",
            com.vmware.nsx_global_policy.model.StructDefinitions.childL2BridgeEndpointProfile);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_l2_VPN_service",
            com.vmware.nsx_global_policy.model.StructDefinitions.childL2VPNService);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_l2_VPN_session",
            com.vmware.nsx_global_policy.model.StructDefinitions.childL2VPNSession);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_l2_vpn",
            com.vmware.nsx_global_policy.model.StructDefinitions.childL2Vpn);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_l2_vpn_context",
            com.vmware.nsx_global_policy.model.StructDefinitions.childL2VpnContext);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_l3_vpn",
            com.vmware.nsx_global_policy.model.StructDefinitions.childL3Vpn);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_l3_vpn_context",
            com.vmware.nsx_global_policy.model.StructDefinitions.childL3VpnContext);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_l7_access_entry",
            com.vmware.nsx_global_policy.model.StructDefinitions.childL7AccessEntry);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_l7_access_profile",
            com.vmware.nsx_global_policy.model.StructDefinitions.childL7AccessProfile);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_LB_app_profile",
            com.vmware.nsx_global_policy.model.StructDefinitions.childLBAppProfile);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_LB_client_ssl_profile",
            com.vmware.nsx_global_policy.model.StructDefinitions.childLBClientSslProfile);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_LB_monitor_profile",
            com.vmware.nsx_global_policy.model.StructDefinitions.childLBMonitorProfile);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_LB_persistence_profile",
            com.vmware.nsx_global_policy.model.StructDefinitions.childLBPersistenceProfile);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_LB_pool",
            com.vmware.nsx_global_policy.model.StructDefinitions.childLBPool);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_LB_server_ssl_profile",
            com.vmware.nsx_global_policy.model.StructDefinitions.childLBServerSslProfile);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_LB_service",
            com.vmware.nsx_global_policy.model.StructDefinitions.childLBService);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_LB_virtual_server",
            com.vmware.nsx_global_policy.model.StructDefinitions.childLBVirtualServer);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_live_trace_config",
            com.vmware.nsx_global_policy.model.StructDefinitions.childLiveTraceConfig);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_locale_services",
            com.vmware.nsx_global_policy.model.StructDefinitions.childLocaleServices);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_mac_discovery_profile",
            com.vmware.nsx_global_policy.model.StructDefinitions.childMacDiscoveryProfile);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_malware_prevention_profile",
            com.vmware.nsx_global_policy.model.StructDefinitions.childMalwarePreventionProfile);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_malware_prevention_signature",
            com.vmware.nsx_global_policy.model.StructDefinitions.childMalwarePreventionSignature);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_metadata_proxy_config",
            com.vmware.nsx_global_policy.model.StructDefinitions.childMetadataProxyConfig);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_ods_runbook_invocation",
            com.vmware.nsx_global_policy.model.StructDefinitions.childOdsRunbookInvocation);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_ods_runbook_invocation_artifact_batch_request",
            com.vmware.nsx_global_policy.model.StructDefinitions.childOdsRunbookInvocationArtifactBatchRequest);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_ops_global_config",
            com.vmware.nsx_global_policy.model.StructDefinitions.childOpsGlobalConfig);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_org",
            com.vmware.nsx_global_policy.model.StructDefinitions.childOrg);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_org_root",
            com.vmware.nsx_global_policy.model.StructDefinitions.childOrgRoot);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_ospf_area_config",
            com.vmware.nsx_global_policy.model.StructDefinitions.childOspfAreaConfig);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_ospf_routing_config",
            com.vmware.nsx_global_policy.model.StructDefinitions.childOspfRoutingConfig);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_policy_config_resource",
            com.vmware.nsx_global_policy.model.StructDefinitions.childPolicyConfigResource);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_policy_context_profile",
            com.vmware.nsx_global_policy.model.StructDefinitions.childPolicyContextProfile);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_policy_custom_attributes",
            com.vmware.nsx_global_policy.model.StructDefinitions.childPolicyCustomAttributes);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_policy_dns_forwarder",
            com.vmware.nsx_global_policy.model.StructDefinitions.childPolicyDnsForwarder);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_policy_dns_forwarder_zone",
            com.vmware.nsx_global_policy.model.StructDefinitions.childPolicyDnsForwarderZone);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_policy_edge_cluster",
            com.vmware.nsx_global_policy.model.StructDefinitions.childPolicyEdgeCluster);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_policy_edge_node",
            com.vmware.nsx_global_policy.model.StructDefinitions.childPolicyEdgeNode);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_policy_exclude_list",
            com.vmware.nsx_global_policy.model.StructDefinitions.childPolicyExcludeList);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_policy_firewall_CPU_mem_thresholds_profile_binding_map",
            com.vmware.nsx_global_policy.model.StructDefinitions.childPolicyFirewallCPUMemThresholdsProfileBindingMap);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_policy_firewall_cpu_mem_thresholds_profile",
            com.vmware.nsx_global_policy.model.StructDefinitions.childPolicyFirewallCpuMemThresholdsProfile);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_policy_firewall_flood_protection_profile_binding_map",
            com.vmware.nsx_global_policy.model.StructDefinitions.childPolicyFirewallFloodProtectionProfileBindingMap);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_policy_firewall_ip_reputation_config",
            com.vmware.nsx_global_policy.model.StructDefinitions.childPolicyFirewallIpReputationConfig);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_policy_firewall_scheduler",
            com.vmware.nsx_global_policy.model.StructDefinitions.childPolicyFirewallScheduler);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_policy_firewall_session_timer_profile",
            com.vmware.nsx_global_policy.model.StructDefinitions.childPolicyFirewallSessionTimerProfile);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_policy_firewall_session_timer_profile_binding_map",
            com.vmware.nsx_global_policy.model.StructDefinitions.childPolicyFirewallSessionTimerProfileBindingMap);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_policy_igmp_profile",
            com.vmware.nsx_global_policy.model.StructDefinitions.childPolicyIgmpProfile);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_policy_inter_vrf_routing_config",
            com.vmware.nsx_global_policy.model.StructDefinitions.childPolicyInterVrfRoutingConfig);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_policy_label",
            com.vmware.nsx_global_policy.model.StructDefinitions.childPolicyLabel);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_policy_latency_stat_profile",
            com.vmware.nsx_global_policy.model.StructDefinitions.childPolicyLatencyStatProfile);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_policy_multicast_config",
            com.vmware.nsx_global_policy.model.StructDefinitions.childPolicyMulticastConfig);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_policy_nat",
            com.vmware.nsx_global_policy.model.StructDefinitions.childPolicyNat);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_policy_nat_rule",
            com.vmware.nsx_global_policy.model.StructDefinitions.childPolicyNatRule);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_policy_pim_profile",
            com.vmware.nsx_global_policy.model.StructDefinitions.childPolicyPimProfile);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_policy_SI_exclude_list",
            com.vmware.nsx_global_policy.model.StructDefinitions.childPolicySIExcludeList);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_policy_service_chain",
            com.vmware.nsx_global_policy.model.StructDefinitions.childPolicyServiceChain);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_policy_service_instance",
            com.vmware.nsx_global_policy.model.StructDefinitions.childPolicyServiceInstance);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_policy_service_profile",
            com.vmware.nsx_global_policy.model.StructDefinitions.childPolicyServiceProfile);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_policy_tier1_multicast_config",
            com.vmware.nsx_global_policy.model.StructDefinitions.childPolicyTier1MulticastConfig);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_policy_transport_zone",
            com.vmware.nsx_global_policy.model.StructDefinitions.childPolicyTransportZone);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_policy_transport_zone_profile",
            com.vmware.nsx_global_policy.model.StructDefinitions.childPolicyTransportZoneProfile);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_policy_url_categorization_config",
            com.vmware.nsx_global_policy.model.StructDefinitions.childPolicyUrlCategorizationConfig);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_policy_vpc_nat_rule",
            com.vmware.nsx_global_policy.model.StructDefinitions.childPolicyVpcNatRule);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_port_discovery_profile_binding_map",
            com.vmware.nsx_global_policy.model.StructDefinitions.childPortDiscoveryProfileBindingMap);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_port_mirroring_profile",
            com.vmware.nsx_global_policy.model.StructDefinitions.childPortMirroringProfile);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_port_monitoring_profile_binding_map",
            com.vmware.nsx_global_policy.model.StructDefinitions.childPortMonitoringProfileBindingMap);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_port_qos_profile_binding_map",
            com.vmware.nsx_global_policy.model.StructDefinitions.childPortQosProfileBindingMap);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_port_security_profile_binding_map",
            com.vmware.nsx_global_policy.model.StructDefinitions.childPortSecurityProfileBindingMap);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_prefix_list",
            com.vmware.nsx_global_policy.model.StructDefinitions.childPrefixList);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_project",
            com.vmware.nsx_global_policy.model.StructDefinitions.childProject);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_project_route_filter",
            com.vmware.nsx_global_policy.model.StructDefinitions.childProjectRouteFilter);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_qos_profile",
            com.vmware.nsx_global_policy.model.StructDefinitions.childQosProfile);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_reaction",
            com.vmware.nsx_global_policy.model.StructDefinitions.childReaction);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_redirection_policy",
            com.vmware.nsx_global_policy.model.StructDefinitions.childRedirectionPolicy);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_redirection_rule",
            com.vmware.nsx_global_policy.model.StructDefinitions.childRedirectionRule);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_resource_reference",
            com.vmware.nsx_global_policy.model.StructDefinitions.childResourceReference);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_rule",
            com.vmware.nsx_global_policy.model.StructDefinitions.childRule);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_SI_status_configuration",
            com.vmware.nsx_global_policy.model.StructDefinitions.childSIStatusConfiguration);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_security_features",
            com.vmware.nsx_global_policy.model.StructDefinitions.childSecurityFeatures);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_security_policy",
            com.vmware.nsx_global_policy.model.StructDefinitions.childSecurityPolicy);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_segment",
            com.vmware.nsx_global_policy.model.StructDefinitions.childSegment);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_segment_discovery_profile_binding_map",
            com.vmware.nsx_global_policy.model.StructDefinitions.childSegmentDiscoveryProfileBindingMap);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_segment_monitoring_profile_binding_map",
            com.vmware.nsx_global_policy.model.StructDefinitions.childSegmentMonitoringProfileBindingMap);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_segment_port",
            com.vmware.nsx_global_policy.model.StructDefinitions.childSegmentPort);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_segment_qos_profile_binding_map",
            com.vmware.nsx_global_policy.model.StructDefinitions.childSegmentQosProfileBindingMap);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_segment_security_profile",
            com.vmware.nsx_global_policy.model.StructDefinitions.childSegmentSecurityProfile);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_segment_security_profile_binding_map",
            com.vmware.nsx_global_policy.model.StructDefinitions.childSegmentSecurityProfileBindingMap);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_service",
            com.vmware.nsx_global_policy.model.StructDefinitions.childService);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_service_entry",
            com.vmware.nsx_global_policy.model.StructDefinitions.childServiceEntry);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_service_instance_endpoint",
            com.vmware.nsx_global_policy.model.StructDefinitions.childServiceInstanceEndpoint);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_service_interface",
            com.vmware.nsx_global_policy.model.StructDefinitions.childServiceInterface);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_service_reference",
            com.vmware.nsx_global_policy.model.StructDefinitions.childServiceReference);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_service_segment",
            com.vmware.nsx_global_policy.model.StructDefinitions.childServiceSegment);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_session_timer_profile_binding_map",
            com.vmware.nsx_global_policy.model.StructDefinitions.childSessionTimerProfileBindingMap);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_sha_dynamic_plugin",
            com.vmware.nsx_global_policy.model.StructDefinitions.childShaDynamicPlugin);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_sha_plugin_profile",
            com.vmware.nsx_global_policy.model.StructDefinitions.childShaPluginProfile);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_sha_predefined_plugin",
            com.vmware.nsx_global_policy.model.StructDefinitions.childShaPredefinedPlugin);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_share",
            com.vmware.nsx_global_policy.model.StructDefinitions.childShare);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_shared_resource",
            com.vmware.nsx_global_policy.model.StructDefinitions.childSharedResource);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_site",
            com.vmware.nsx_global_policy.model.StructDefinitions.childSite);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_spoof_guard_profile",
            com.vmware.nsx_global_policy.model.StructDefinitions.childSpoofGuardProfile);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_standalone_host_idfw_configuration",
            com.vmware.nsx_global_policy.model.StructDefinitions.childStandaloneHostIdfwConfiguration);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_static_ARP_config",
            com.vmware.nsx_global_policy.model.StructDefinitions.childStaticARPConfig);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_static_mime_content",
            com.vmware.nsx_global_policy.model.StructDefinitions.childStaticMimeContent);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_static_route_bfd_peer",
            com.vmware.nsx_global_policy.model.StructDefinitions.childStaticRouteBfdPeer);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_static_routes",
            com.vmware.nsx_global_policy.model.StructDefinitions.childStaticRoutes);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_tag_bulk_operation",
            com.vmware.nsx_global_policy.model.StructDefinitions.childTagBulkOperation);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_tier0",
            com.vmware.nsx_global_policy.model.StructDefinitions.childTier0);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_tier0_deployment_map",
            com.vmware.nsx_global_policy.model.StructDefinitions.childTier0DeploymentMap);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_tier0_interface",
            com.vmware.nsx_global_policy.model.StructDefinitions.childTier0Interface);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_tier0_interface_group",
            com.vmware.nsx_global_policy.model.StructDefinitions.childTier0InterfaceGroup);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_tier0_route_map",
            com.vmware.nsx_global_policy.model.StructDefinitions.childTier0RouteMap);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_tier0_security_features",
            com.vmware.nsx_global_policy.model.StructDefinitions.childTier0SecurityFeatures);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_tier1",
            com.vmware.nsx_global_policy.model.StructDefinitions.childTier1);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_tier1_deployment_map",
            com.vmware.nsx_global_policy.model.StructDefinitions.childTier1DeploymentMap);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_tier1_interface",
            com.vmware.nsx_global_policy.model.StructDefinitions.childTier1Interface);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_tier1_interface_group",
            com.vmware.nsx_global_policy.model.StructDefinitions.childTier1InterfaceGroup);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_tls_certificate",
            com.vmware.nsx_global_policy.model.StructDefinitions.childTlsCertificate);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_tls_crl",
            com.vmware.nsx_global_policy.model.StructDefinitions.childTlsCrl);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_tls_policy",
            com.vmware.nsx_global_policy.model.StructDefinitions.childTlsPolicy);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_tls_profile",
            com.vmware.nsx_global_policy.model.StructDefinitions.childTlsProfile);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_tls_rule",
            com.vmware.nsx_global_policy.model.StructDefinitions.childTlsRule);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_tls_trust_data",
            com.vmware.nsx_global_policy.model.StructDefinitions.childTlsTrustData);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_traceflow_config",
            com.vmware.nsx_global_policy.model.StructDefinitions.childTraceflowConfig);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_VM_tag_replication_policy",
            com.vmware.nsx_global_policy.model.StructDefinitions.childVMTagReplicationPolicy);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_virtual_endpoint",
            com.vmware.nsx_global_policy.model.StructDefinitions.childVirtualEndpoint);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_vni_pool_config",
            com.vmware.nsx_global_policy.model.StructDefinitions.childVniPoolConfig);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_vpc",
            com.vmware.nsx_global_policy.model.StructDefinitions.childVpc);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_vpc_ip_address_allocation",
            com.vmware.nsx_global_policy.model.StructDefinitions.childVpcIpAddressAllocation);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_vpc_subnet",
            com.vmware.nsx_global_policy.model.StructDefinitions.childVpcSubnet);
        add(mapping,
            "com.vmware.nsx_global_policy.model.child_vpc_subnet_port",
            com.vmware.nsx_global_policy.model.StructDefinitions.childVpcSubnetPort);
        add(mapping,
            "com.vmware.nsx_global_policy.model.cidr_array_constraint_value",
            com.vmware.nsx_global_policy.model.StructDefinitions.cidrArrayConstraintValue);
        add(mapping,
            "com.vmware.nsx_global_policy.model.cipher_suite",
            com.vmware.nsx_global_policy.model.StructDefinitions.cipherSuite);
        add(mapping,
            "com.vmware.nsx_global_policy.model.classless_static_route",
            com.vmware.nsx_global_policy.model.StructDefinitions.classlessStaticRoute);
        add(mapping,
            "com.vmware.nsx_global_policy.model.cluster_backup_info",
            com.vmware.nsx_global_policy.model.StructDefinitions.clusterBackupInfo);
        add(mapping,
            "com.vmware.nsx_global_policy.model.cluster_backup_info_list_result",
            com.vmware.nsx_global_policy.model.StructDefinitions.clusterBackupInfoListResult);
        add(mapping,
            "com.vmware.nsx_global_policy.model.cluster_member_details",
            com.vmware.nsx_global_policy.model.StructDefinitions.clusterMemberDetails);
        add(mapping,
            "com.vmware.nsx_global_policy.model.cluster_node_VM_deployment_config",
            com.vmware.nsx_global_policy.model.StructDefinitions.clusterNodeVMDeploymentConfig);
        add(mapping,
            "com.vmware.nsx_global_policy.model.cluster_node_VM_deployment_request",
            com.vmware.nsx_global_policy.model.StructDefinitions.clusterNodeVMDeploymentRequest);
        add(mapping,
            "com.vmware.nsx_global_policy.model.cluster_node_VM_deployment_request_list",
            com.vmware.nsx_global_policy.model.StructDefinitions.clusterNodeVMDeploymentRequestList);
        add(mapping,
            "com.vmware.nsx_global_policy.model.cluster_node_VM_deployment_status_report",
            com.vmware.nsx_global_policy.model.StructDefinitions.clusterNodeVMDeploymentStatusReport);
        add(mapping,
            "com.vmware.nsx_global_policy.model.cluster_restore_status",
            com.vmware.nsx_global_policy.model.StructDefinitions.clusterRestoreStatus);
        add(mapping,
            "com.vmware.nsx_global_policy.model.clustering_config",
            com.vmware.nsx_global_policy.model.StructDefinitions.clusteringConfig);
        add(mapping,
            "com.vmware.nsx_global_policy.model.column_item",
            com.vmware.nsx_global_policy.model.StructDefinitions.columnItem);
        add(mapping,
            "com.vmware.nsx_global_policy.model.communication_entry",
            com.vmware.nsx_global_policy.model.StructDefinitions.communicationEntry);
        add(mapping,
            "com.vmware.nsx_global_policy.model.communication_map",
            com.vmware.nsx_global_policy.model.StructDefinitions.communicationMap);
        add(mapping,
            "com.vmware.nsx_global_policy.model.community_list",
            com.vmware.nsx_global_policy.model.StructDefinitions.communityList);
        add(mapping,
            "com.vmware.nsx_global_policy.model.community_list_list_result",
            com.vmware.nsx_global_policy.model.StructDefinitions.communityListListResult);
        add(mapping,
            "com.vmware.nsx_global_policy.model.community_match_criteria",
            com.vmware.nsx_global_policy.model.StructDefinitions.communityMatchCriteria);
        add(mapping,
            "com.vmware.nsx_global_policy.model.compatibility_check_result",
            com.vmware.nsx_global_policy.model.StructDefinitions.compatibilityCheckResult);
        add(mapping,
            "com.vmware.nsx_global_policy.model.compatibility_detail",
            com.vmware.nsx_global_policy.model.StructDefinitions.compatibilityDetail);
        add(mapping,
            "com.vmware.nsx_global_policy.model.compute_cluster_idfw_configuration",
            com.vmware.nsx_global_policy.model.StructDefinitions.computeClusterIdfwConfiguration);
        add(mapping,
            "com.vmware.nsx_global_policy.model.condition",
            com.vmware.nsx_global_policy.model.StructDefinitions.condition);
        add(mapping,
            "com.vmware.nsx_global_policy.model.conditional_value_constraint_expression",
            com.vmware.nsx_global_policy.model.StructDefinitions.conditionalValueConstraintExpression);
        add(mapping,
            "com.vmware.nsx_global_policy.model.config_onboarding_conflict_request",
            com.vmware.nsx_global_policy.model.StructDefinitions.configOnboardingConflictRequest);
        add(mapping,
            "com.vmware.nsx_global_policy.model.config_onboarding_conflict_status",
            com.vmware.nsx_global_policy.model.StructDefinitions.configOnboardingConflictStatus);
        add(mapping,
            "com.vmware.nsx_global_policy.model.config_onboarding_error",
            com.vmware.nsx_global_policy.model.StructDefinitions.configOnboardingError);
        add(mapping,
            "com.vmware.nsx_global_policy.model.config_onboarding_in_progress_status",
            com.vmware.nsx_global_policy.model.StructDefinitions.configOnboardingInProgressStatus);
        add(mapping,
            "com.vmware.nsx_global_policy.model.config_onboarding_request",
            com.vmware.nsx_global_policy.model.StructDefinitions.configOnboardingRequest);
        add(mapping,
            "com.vmware.nsx_global_policy.model.config_onboarding_status",
            com.vmware.nsx_global_policy.model.StructDefinitions.configOnboardingStatus);
        add(mapping,
            "com.vmware.nsx_global_policy.model.config_onboarding_status_details",
            com.vmware.nsx_global_policy.model.StructDefinitions.configOnboardingStatusDetails);
        add(mapping,
            "com.vmware.nsx_global_policy.model.configuration_state",
            com.vmware.nsx_global_policy.model.StructDefinitions.configurationState);
        add(mapping,
            "com.vmware.nsx_global_policy.model.configuration_state_element",
            com.vmware.nsx_global_policy.model.StructDefinitions.configurationStateElement);
        add(mapping,
            "com.vmware.nsx_global_policy.model.conflicting_entity_list_response",
            com.vmware.nsx_global_policy.model.StructDefinitions.conflictingEntityListResponse);
        add(mapping,
            "com.vmware.nsx_global_policy.model.conjunction_operator",
            com.vmware.nsx_global_policy.model.StructDefinitions.conjunctionOperator);
        add(mapping,
            "com.vmware.nsx_global_policy.model.connectivity_advanced_config",
            com.vmware.nsx_global_policy.model.StructDefinitions.connectivityAdvancedConfig);
        add(mapping,
            "com.vmware.nsx_global_policy.model.consolidated_effective_IP_address_member_list_result",
            com.vmware.nsx_global_policy.model.StructDefinitions.consolidatedEffectiveIPAddressMemberListResult);
        add(mapping,
            "com.vmware.nsx_global_policy.model.consolidated_realized_status",
            com.vmware.nsx_global_policy.model.StructDefinitions.consolidatedRealizedStatus);
        add(mapping,
            "com.vmware.nsx_global_policy.model.consolidated_status",
            com.vmware.nsx_global_policy.model.StructDefinitions.consolidatedStatus);
        add(mapping,
            "com.vmware.nsx_global_policy.model.consolidated_status_nsxt",
            com.vmware.nsx_global_policy.model.StructDefinitions.consolidatedStatusNsxt);
        add(mapping,
            "com.vmware.nsx_global_policy.model.consolidated_status_per_enforcement_point",
            com.vmware.nsx_global_policy.model.StructDefinitions.consolidatedStatusPerEnforcementPoint);
        add(mapping,
            "com.vmware.nsx_global_policy.model.constant_field_value",
            com.vmware.nsx_global_policy.model.StructDefinitions.constantFieldValue);
        add(mapping,
            "com.vmware.nsx_global_policy.model.constraint",
            com.vmware.nsx_global_policy.model.StructDefinitions.constraint);
        add(mapping,
            "com.vmware.nsx_global_policy.model.constraint_expression",
            com.vmware.nsx_global_policy.model.StructDefinitions.constraintExpression);
        add(mapping,
            "com.vmware.nsx_global_policy.model.constraint_global_config",
            com.vmware.nsx_global_policy.model.StructDefinitions.constraintGlobalConfig);
        add(mapping,
            "com.vmware.nsx_global_policy.model.constraint_list_result",
            com.vmware.nsx_global_policy.model.StructDefinitions.constraintListResult);
        add(mapping,
            "com.vmware.nsx_global_policy.model.constraint_target",
            com.vmware.nsx_global_policy.model.StructDefinitions.constraintTarget);
        add(mapping,
            "com.vmware.nsx_global_policy.model.constraint_value",
            com.vmware.nsx_global_policy.model.StructDefinitions.constraintValue);
        add(mapping,
            "com.vmware.nsx_global_policy.model.container_configuration",
            com.vmware.nsx_global_policy.model.StructDefinitions.containerConfiguration);
        add(mapping,
            "com.vmware.nsx_global_policy.model.context_profile_attributes_metadata",
            com.vmware.nsx_global_policy.model.StructDefinitions.contextProfileAttributesMetadata);
        add(mapping,
            "com.vmware.nsx_global_policy.model.criterion",
            com.vmware.nsx_global_policy.model.StructDefinitions.criterion);
        add(mapping,
            "com.vmware.nsx_global_policy.model.cross_site_flow_info",
            com.vmware.nsx_global_policy.model.StructDefinitions.crossSiteFlowInfo);
        add(mapping,
            "com.vmware.nsx_global_policy.model.csv_list_result",
            com.vmware.nsx_global_policy.model.StructDefinitions.csvListResult);
        add(mapping,
            "com.vmware.nsx_global_policy.model.csv_record",
            com.vmware.nsx_global_policy.model.StructDefinitions.csvRecord);
        add(mapping,
            "com.vmware.nsx_global_policy.model.current_backup_operation_status",
            com.vmware.nsx_global_policy.model.StructDefinitions.currentBackupOperationStatus);
        add(mapping,
            "com.vmware.nsx_global_policy.model.custom_filter_widget_configuration",
            com.vmware.nsx_global_policy.model.StructDefinitions.customFilterWidgetConfiguration);
        add(mapping,
            "com.vmware.nsx_global_policy.model.custom_widget_configuration",
            com.vmware.nsx_global_policy.model.StructDefinitions.customWidgetConfiguration);
        add(mapping,
            "com.vmware.nsx_global_policy.model.cvx_connection_info",
            com.vmware.nsx_global_policy.model.StructDefinitions.cvxConnectionInfo);
        add(mapping,
            "com.vmware.nsx_global_policy.model.DNS_forwarder_statistics_per_enforcement_point",
            com.vmware.nsx_global_policy.model.StructDefinitions.DNSForwarderStatisticsPerEnforcementPoint);
        add(mapping,
            "com.vmware.nsx_global_policy.model.DNS_forwarder_status_per_enforcement_point",
            com.vmware.nsx_global_policy.model.StructDefinitions.DNSForwarderStatusPerEnforcementPoint);
        add(mapping,
            "com.vmware.nsx_global_policy.model.data_counter",
            com.vmware.nsx_global_policy.model.StructDefinitions.dataCounter);
        add(mapping,
            "com.vmware.nsx_global_policy.model.data_source_parameters",
            com.vmware.nsx_global_policy.model.StructDefinitions.dataSourceParameters);
        add(mapping,
            "com.vmware.nsx_global_policy.model.datasource",
            com.vmware.nsx_global_policy.model.StructDefinitions.datasource);
        add(mapping,
            "com.vmware.nsx_global_policy.model.default_filter_value",
            com.vmware.nsx_global_policy.model.StructDefinitions.defaultFilterValue);
        add(mapping,
            "com.vmware.nsx_global_policy.model.delete_request_parameters",
            com.vmware.nsx_global_policy.model.StructDefinitions.deleteRequestParameters);
        add(mapping,
            "com.vmware.nsx_global_policy.model.dependent_services",
            com.vmware.nsx_global_policy.model.StructDefinitions.dependentServices);
        add(mapping,
            "com.vmware.nsx_global_policy.model.deployment_zone",
            com.vmware.nsx_global_policy.model.StructDefinitions.deploymentZone);
        add(mapping,
            "com.vmware.nsx_global_policy.model.dfw_firewall_configuration",
            com.vmware.nsx_global_policy.model.StructDefinitions.dfwFirewallConfiguration);
        add(mapping,
            "com.vmware.nsx_global_policy.model.dhcp_config",
            com.vmware.nsx_global_policy.model.StructDefinitions.dhcpConfig);
        add(mapping,
            "com.vmware.nsx_global_policy.model.dhcp_delete_lease_request_parameters",
            com.vmware.nsx_global_policy.model.StructDefinitions.dhcpDeleteLeaseRequestParameters);
        add(mapping,
            "com.vmware.nsx_global_policy.model.dhcp_delete_leases",
            com.vmware.nsx_global_policy.model.StructDefinitions.dhcpDeleteLeases);
        add(mapping,
            "com.vmware.nsx_global_policy.model.dhcp_header",
            com.vmware.nsx_global_policy.model.StructDefinitions.dhcpHeader);
        add(mapping,
            "com.vmware.nsx_global_policy.model.dhcp_ip_pool_usage",
            com.vmware.nsx_global_policy.model.StructDefinitions.dhcpIpPoolUsage);
        add(mapping,
            "com.vmware.nsx_global_policy.model.dhcp_lease_per_IP",
            com.vmware.nsx_global_policy.model.StructDefinitions.dhcpLeasePerIP);
        add(mapping,
            "com.vmware.nsx_global_policy.model.dhcp_leases",
            com.vmware.nsx_global_policy.model.StructDefinitions.dhcpLeases);
        add(mapping,
            "com.vmware.nsx_global_policy.model.dhcp_leases_result",
            com.vmware.nsx_global_policy.model.StructDefinitions.dhcpLeasesResult);
        add(mapping,
            "com.vmware.nsx_global_policy.model.dhcp_option121",
            com.vmware.nsx_global_policy.model.StructDefinitions.dhcpOption121);
        add(mapping,
            "com.vmware.nsx_global_policy.model.dhcp_relay_config",
            com.vmware.nsx_global_policy.model.StructDefinitions.dhcpRelayConfig);
        add(mapping,
            "com.vmware.nsx_global_policy.model.dhcp_relay_config_list_result",
            com.vmware.nsx_global_policy.model.StructDefinitions.dhcpRelayConfigListResult);
        add(mapping,
            "com.vmware.nsx_global_policy.model.dhcp_server_config",
            com.vmware.nsx_global_policy.model.StructDefinitions.dhcpServerConfig);
        add(mapping,
            "com.vmware.nsx_global_policy.model.dhcp_server_config_list_result",
            com.vmware.nsx_global_policy.model.StructDefinitions.dhcpServerConfigListResult);
        add(mapping,
            "com.vmware.nsx_global_policy.model.dhcp_server_state",
            com.vmware.nsx_global_policy.model.StructDefinitions.dhcpServerState);
        add(mapping,
            "com.vmware.nsx_global_policy.model.dhcp_server_statistics",
            com.vmware.nsx_global_policy.model.StructDefinitions.dhcpServerStatistics);
        add(mapping,
            "com.vmware.nsx_global_policy.model.dhcp_server_status",
            com.vmware.nsx_global_policy.model.StructDefinitions.dhcpServerStatus);
        add(mapping,
            "com.vmware.nsx_global_policy.model.dhcp_static_binding_config",
            com.vmware.nsx_global_policy.model.StructDefinitions.dhcpStaticBindingConfig);
        add(mapping,
            "com.vmware.nsx_global_policy.model.dhcp_static_binding_config_list_result",
            com.vmware.nsx_global_policy.model.StructDefinitions.dhcpStaticBindingConfigListResult);
        add(mapping,
            "com.vmware.nsx_global_policy.model.dhcp_static_binding_state",
            com.vmware.nsx_global_policy.model.StructDefinitions.dhcpStaticBindingState);
        add(mapping,
            "com.vmware.nsx_global_policy.model.dhcp_statistics",
            com.vmware.nsx_global_policy.model.StructDefinitions.dhcpStatistics);
        add(mapping,
            "com.vmware.nsx_global_policy.model.dhcp_v4_options",
            com.vmware.nsx_global_policy.model.StructDefinitions.dhcpV4Options);
        add(mapping,
            "com.vmware.nsx_global_policy.model.dhcp_v4_static_binding_config",
            com.vmware.nsx_global_policy.model.StructDefinitions.dhcpV4StaticBindingConfig);
        add(mapping,
            "com.vmware.nsx_global_policy.model.dhcp_v6_static_binding_config",
            com.vmware.nsx_global_policy.model.StructDefinitions.dhcpV6StaticBindingConfig);
        add(mapping,
            "com.vmware.nsx_global_policy.model.dhcpv6_header",
            com.vmware.nsx_global_policy.model.StructDefinitions.dhcpv6Header);
        add(mapping,
            "com.vmware.nsx_global_policy.model.directory_domain_sync_settings",
            com.vmware.nsx_global_policy.model.StructDefinitions.directoryDomainSyncSettings);
        add(mapping,
            "com.vmware.nsx_global_policy.model.directory_event_log_server_status",
            com.vmware.nsx_global_policy.model.StructDefinitions.directoryEventLogServerStatus);
        add(mapping,
            "com.vmware.nsx_global_policy.model.discovered_resource",
            com.vmware.nsx_global_policy.model.StructDefinitions.discoveredResource);
        add(mapping,
            "com.vmware.nsx_global_policy.model.discovered_resource_scope",
            com.vmware.nsx_global_policy.model.StructDefinitions.discoveredResourceScope);
        add(mapping,
            "com.vmware.nsx_global_policy.model.discovery_profile_binding_map",
            com.vmware.nsx_global_policy.model.StructDefinitions.discoveryProfileBindingMap);
        add(mapping,
            "com.vmware.nsx_global_policy.model.distributed_flood_protection_profile",
            com.vmware.nsx_global_policy.model.StructDefinitions.distributedFloodProtectionProfile);
        add(mapping,
            "com.vmware.nsx_global_policy.model.dns_client_config",
            com.vmware.nsx_global_policy.model.StructDefinitions.dnsClientConfig);
        add(mapping,
            "com.vmware.nsx_global_policy.model.dns_header",
            com.vmware.nsx_global_policy.model.StructDefinitions.dnsHeader);
        add(mapping,
            "com.vmware.nsx_global_policy.model.dns_security_profile",
            com.vmware.nsx_global_policy.model.StructDefinitions.dnsSecurityProfile);
        add(mapping,
            "com.vmware.nsx_global_policy.model.dns_security_profile_binding_map",
            com.vmware.nsx_global_policy.model.StructDefinitions.dnsSecurityProfileBindingMap);
        add(mapping,
            "com.vmware.nsx_global_policy.model.dns_security_profile_binding_map_list_result",
            com.vmware.nsx_global_policy.model.StructDefinitions.dnsSecurityProfileBindingMapListResult);
        add(mapping,
            "com.vmware.nsx_global_policy.model.dns_security_profile_list_result",
            com.vmware.nsx_global_policy.model.StructDefinitions.dnsSecurityProfileListResult);
        add(mapping,
            "com.vmware.nsx_global_policy.model.domain",
            com.vmware.nsx_global_policy.model.StructDefinitions.domain);
        add(mapping,
            "com.vmware.nsx_global_policy.model.domain_deployment_map",
            com.vmware.nsx_global_policy.model.StructDefinitions.domainDeploymentMap);
        add(mapping,
            "com.vmware.nsx_global_policy.model.domain_deployment_map_list_result",
            com.vmware.nsx_global_policy.model.StructDefinitions.domainDeploymentMapListResult);
        add(mapping,
            "com.vmware.nsx_global_policy.model.domain_list_result",
            com.vmware.nsx_global_policy.model.StructDefinitions.domainListResult);
        add(mapping,
            "com.vmware.nsx_global_policy.model.donut_configuration",
            com.vmware.nsx_global_policy.model.StructDefinitions.donutConfiguration);
        add(mapping,
            "com.vmware.nsx_global_policy.model.donut_part",
            com.vmware.nsx_global_policy.model.StructDefinitions.donutPart);
        add(mapping,
            "com.vmware.nsx_global_policy.model.donut_section",
            com.vmware.nsx_global_policy.model.StructDefinitions.donutSection);
        add(mapping,
            "com.vmware.nsx_global_policy.model.dropdown_filter_plot_configuration",
            com.vmware.nsx_global_policy.model.StructDefinitions.dropdownFilterPlotConfiguration);
        add(mapping,
            "com.vmware.nsx_global_policy.model.dropdown_filter_widget_configuration",
            com.vmware.nsx_global_policy.model.StructDefinitions.dropdownFilterWidgetConfiguration);
        add(mapping,
            "com.vmware.nsx_global_policy.model.dropdown_item",
            com.vmware.nsx_global_policy.model.StructDefinitions.dropdownItem);
        add(mapping,
            "com.vmware.nsx_global_policy.model.dscp_bit",
            com.vmware.nsx_global_policy.model.StructDefinitions.dscpBit);
        add(mapping,
            "com.vmware.nsx_global_policy.model.dscp_indicator",
            com.vmware.nsx_global_policy.model.StructDefinitions.dscpIndicator);
        add(mapping,
            "com.vmware.nsx_global_policy.model.dscp_value",
            com.vmware.nsx_global_policy.model.StructDefinitions.dscpValue);
        add(mapping,
            "com.vmware.nsx_global_policy.model.duplicate_address_binding_entry",
            com.vmware.nsx_global_policy.model.StructDefinitions.duplicateAddressBindingEntry);
        add(mapping,
            "com.vmware.nsx_global_policy.model.duplicate_IP_detection_options",
            com.vmware.nsx_global_policy.model.StructDefinitions.duplicateIPDetectionOptions);
        add(mapping,
            "com.vmware.nsx_global_policy.model.EULA_acceptance",
            com.vmware.nsx_global_policy.model.StructDefinitions.EULAAcceptance);
        add(mapping,
            "com.vmware.nsx_global_policy.model.EULA_content",
            com.vmware.nsx_global_policy.model.StructDefinitions.EULAContent);
        add(mapping,
            "com.vmware.nsx_global_policy.model.edge_configuration_state",
            com.vmware.nsx_global_policy.model.StructDefinitions.edgeConfigurationState);
        add(mapping,
            "com.vmware.nsx_global_policy.model.effective_IP_info",
            com.vmware.nsx_global_policy.model.StructDefinitions.effectiveIPInfo);
        add(mapping,
            "com.vmware.nsx_global_policy.model.effective_profiles_response",
            com.vmware.nsx_global_policy.model.StructDefinitions.effectiveProfilesResponse);
        add(mapping,
            "com.vmware.nsx_global_policy.model.egress_rate_limiter",
            com.vmware.nsx_global_policy.model.StructDefinitions.egressRateLimiter);
        add(mapping,
            "com.vmware.nsx_global_policy.model.endpoint_policy",
            com.vmware.nsx_global_policy.model.StructDefinitions.endpointPolicy);
        add(mapping,
            "com.vmware.nsx_global_policy.model.endpoint_rule",
            com.vmware.nsx_global_policy.model.StructDefinitions.endpointRule);
        add(mapping,
            "com.vmware.nsx_global_policy.model.enforced_status_details_nsxt",
            com.vmware.nsx_global_policy.model.StructDefinitions.enforcedStatusDetailsNsxt);
        add(mapping,
            "com.vmware.nsx_global_policy.model.enforced_status_info_nsxt",
            com.vmware.nsx_global_policy.model.StructDefinitions.enforcedStatusInfoNsxt);
        add(mapping,
            "com.vmware.nsx_global_policy.model.enforced_status_nsxt",
            com.vmware.nsx_global_policy.model.StructDefinitions.enforcedStatusNsxt);
        add(mapping,
            "com.vmware.nsx_global_policy.model.enforced_status_per_scope_nsxt",
            com.vmware.nsx_global_policy.model.StructDefinitions.enforcedStatusPerScopeNsxt);
        add(mapping,
            "com.vmware.nsx_global_policy.model.enforced_status_per_transport_node",
            com.vmware.nsx_global_policy.model.StructDefinitions.enforcedStatusPerTransportNode);
        add(mapping,
            "com.vmware.nsx_global_policy.model.enforcement_point",
            com.vmware.nsx_global_policy.model.StructDefinitions.enforcementPoint);
        add(mapping,
            "com.vmware.nsx_global_policy.model.enforcement_point_connection_info",
            com.vmware.nsx_global_policy.model.StructDefinitions.enforcementPointConnectionInfo);
        add(mapping,
            "com.vmware.nsx_global_policy.model.enforcement_point_list_result",
            com.vmware.nsx_global_policy.model.StructDefinitions.enforcementPointListResult);
        add(mapping,
            "com.vmware.nsx_global_policy.model.entity_instance_count_constraint_expression",
            com.vmware.nsx_global_policy.model.StructDefinitions.entityInstanceCountConstraintExpression);
        add(mapping,
            "com.vmware.nsx_global_policy.model.error_resolver_info",
            com.vmware.nsx_global_policy.model.StructDefinitions.errorResolverInfo);
        add(mapping,
            "com.vmware.nsx_global_policy.model.error_resolver_info_list",
            com.vmware.nsx_global_policy.model.StructDefinitions.errorResolverInfoList);
        add(mapping,
            "com.vmware.nsx_global_policy.model.error_resolver_metadata",
            com.vmware.nsx_global_policy.model.StructDefinitions.errorResolverMetadata);
        add(mapping,
            "com.vmware.nsx_global_policy.model.error_resolver_metadata_list",
            com.vmware.nsx_global_policy.model.StructDefinitions.errorResolverMetadataList);
        add(mapping,
            "com.vmware.nsx_global_policy.model.error_resolver_system_metadata",
            com.vmware.nsx_global_policy.model.StructDefinitions.errorResolverSystemMetadata);
        add(mapping,
            "com.vmware.nsx_global_policy.model.error_resolver_user_input_data",
            com.vmware.nsx_global_policy.model.StructDefinitions.errorResolverUserInputData);
        add(mapping,
            "com.vmware.nsx_global_policy.model.error_resolver_user_metadata",
            com.vmware.nsx_global_policy.model.StructDefinitions.errorResolverUserMetadata);
        add(mapping,
            "com.vmware.nsx_global_policy.model.ether_type_service_entry",
            com.vmware.nsx_global_policy.model.StructDefinitions.etherTypeServiceEntry);
        add(mapping,
            "com.vmware.nsx_global_policy.model.ethernet_header",
            com.vmware.nsx_global_policy.model.StructDefinitions.ethernetHeader);
        add(mapping,
            "com.vmware.nsx_global_policy.model.evaluation",
            com.vmware.nsx_global_policy.model.StructDefinitions.evaluation);
        add(mapping,
            "com.vmware.nsx_global_policy.model.event",
            com.vmware.nsx_global_policy.model.StructDefinitions.event);
        add(mapping,
            "com.vmware.nsx_global_policy.model.evpn_config",
            com.vmware.nsx_global_policy.model.StructDefinitions.evpnConfig);
        add(mapping,
            "com.vmware.nsx_global_policy.model.evpn_config_advanced_config",
            com.vmware.nsx_global_policy.model.StructDefinitions.evpnConfigAdvancedConfig);
        add(mapping,
            "com.vmware.nsx_global_policy.model.evpn_encap_config",
            com.vmware.nsx_global_policy.model.StructDefinitions.evpnEncapConfig);
        add(mapping,
            "com.vmware.nsx_global_policy.model.evpn_tenant_config",
            com.vmware.nsx_global_policy.model.StructDefinitions.evpnTenantConfig);
        add(mapping,
            "com.vmware.nsx_global_policy.model.evpn_tunnel_endpoint_config",
            com.vmware.nsx_global_policy.model.StructDefinitions.evpnTunnelEndpointConfig);
        add(mapping,
            "com.vmware.nsx_global_policy.model.excluded_members_list",
            com.vmware.nsx_global_policy.model.StructDefinitions.excludedMembersList);
        add(mapping,
            "com.vmware.nsx_global_policy.model.export_request_parameter",
            com.vmware.nsx_global_policy.model.StructDefinitions.exportRequestParameter);
        add(mapping,
            "com.vmware.nsx_global_policy.model.export_task",
            com.vmware.nsx_global_policy.model.StructDefinitions.exportTask);
        add(mapping,
            "com.vmware.nsx_global_policy.model.expression",
            com.vmware.nsx_global_policy.model.StructDefinitions.expression);
        add(mapping,
            "com.vmware.nsx_global_policy.model.external_gateway_bfd_config",
            com.vmware.nsx_global_policy.model.StructDefinitions.externalGatewayBfdConfig);
        add(mapping,
            "com.vmware.nsx_global_policy.model.external_ID_expression",
            com.vmware.nsx_global_policy.model.StructDefinitions.externalIDExpression);
        add(mapping,
            "com.vmware.nsx_global_policy.model.FIPS_global_config",
            com.vmware.nsx_global_policy.model.StructDefinitions.FIPSGlobalConfig);
        add(mapping,
            "com.vmware.nsx_global_policy.model.feature_compatibility_info",
            com.vmware.nsx_global_policy.model.StructDefinitions.featureCompatibilityInfo);
        add(mapping,
            "com.vmware.nsx_global_policy.model.feature_conflict_info",
            com.vmware.nsx_global_policy.model.StructDefinitions.featureConflictInfo);
        add(mapping,
            "com.vmware.nsx_global_policy.model.feature_permission",
            com.vmware.nsx_global_policy.model.StructDefinitions.featurePermission);
        add(mapping,
            "com.vmware.nsx_global_policy.model.feature_permission_array",
            com.vmware.nsx_global_policy.model.StructDefinitions.featurePermissionArray);
        add(mapping,
            "com.vmware.nsx_global_policy.model.feature_permission_list_result",
            com.vmware.nsx_global_policy.model.StructDefinitions.featurePermissionListResult);
        add(mapping,
            "com.vmware.nsx_global_policy.model.feature_set",
            com.vmware.nsx_global_policy.model.StructDefinitions.featureSet);
        add(mapping,
            "com.vmware.nsx_global_policy.model.feature_summary",
            com.vmware.nsx_global_policy.model.StructDefinitions.featureSummary);
        add(mapping,
            "com.vmware.nsx_global_policy.model.federation_component_upgrade_status",
            com.vmware.nsx_global_policy.model.StructDefinitions.federationComponentUpgradeStatus);
        add(mapping,
            "com.vmware.nsx_global_policy.model.federation_config",
            com.vmware.nsx_global_policy.model.StructDefinitions.federationConfig);
        add(mapping,
            "com.vmware.nsx_global_policy.model.federation_connectivity_config",
            com.vmware.nsx_global_policy.model.StructDefinitions.federationConnectivityConfig);
        add(mapping,
            "com.vmware.nsx_global_policy.model.federation_gateway_config",
            com.vmware.nsx_global_policy.model.StructDefinitions.federationGatewayConfig);
        add(mapping,
            "com.vmware.nsx_global_policy.model.federation_invalid_configuration_details_response",
            com.vmware.nsx_global_policy.model.StructDefinitions.federationInvalidConfigurationDetailsResponse);
        add(mapping,
            "com.vmware.nsx_global_policy.model.federation_node_summary",
            com.vmware.nsx_global_policy.model.StructDefinitions.federationNodeSummary);
        add(mapping,
            "com.vmware.nsx_global_policy.model.federation_queue_info",
            com.vmware.nsx_global_policy.model.StructDefinitions.federationQueueInfo);
        add(mapping,
            "com.vmware.nsx_global_policy.model.federation_upgrade_summary",
            com.vmware.nsx_global_policy.model.StructDefinitions.federationUpgradeSummary);
        add(mapping,
            "com.vmware.nsx_global_policy.model.federation_upgrade_summary_list_result",
            com.vmware.nsx_global_policy.model.StructDefinitions.federationUpgradeSummaryListResult);
        add(mapping,
            "com.vmware.nsx_global_policy.model.field_sanity_constraint_expression",
            com.vmware.nsx_global_policy.model.StructDefinitions.fieldSanityConstraintExpression);
        add(mapping,
            "com.vmware.nsx_global_policy.model.field_setting",
            com.vmware.nsx_global_policy.model.StructDefinitions.fieldSetting);
        add(mapping,
            "com.vmware.nsx_global_policy.model.field_setting_value",
            com.vmware.nsx_global_policy.model.StructDefinitions.fieldSettingValue);
        add(mapping,
            "com.vmware.nsx_global_policy.model.fields_filter_data",
            com.vmware.nsx_global_policy.model.StructDefinitions.fieldsFilterData);
        add(mapping,
            "com.vmware.nsx_global_policy.model.fields_packet_data",
            com.vmware.nsx_global_policy.model.StructDefinitions.fieldsPacketData);
        add(mapping,
            "com.vmware.nsx_global_policy.model.file_transfer_authentication_scheme",
            com.vmware.nsx_global_policy.model.StructDefinitions.fileTransferAuthenticationScheme);
        add(mapping,
            "com.vmware.nsx_global_policy.model.file_transfer_protocol",
            com.vmware.nsx_global_policy.model.StructDefinitions.fileTransferProtocol);
        add(mapping,
            "com.vmware.nsx_global_policy.model.filter_widget_configuration",
            com.vmware.nsx_global_policy.model.StructDefinitions.filterWidgetConfiguration);
        add(mapping,
            "com.vmware.nsx_global_policy.model.firewall_configuration",
            com.vmware.nsx_global_policy.model.StructDefinitions.firewallConfiguration);
        add(mapping,
            "com.vmware.nsx_global_policy.model.flood_protection_profile",
            com.vmware.nsx_global_policy.model.StructDefinitions.floodProtectionProfile);
        add(mapping,
            "com.vmware.nsx_global_policy.model.flood_protection_profile_binding_list_result",
            com.vmware.nsx_global_policy.model.StructDefinitions.floodProtectionProfileBindingListResult);
        add(mapping,
            "com.vmware.nsx_global_policy.model.flood_protection_profile_binding_map",
            com.vmware.nsx_global_policy.model.StructDefinitions.floodProtectionProfileBindingMap);
        add(mapping,
            "com.vmware.nsx_global_policy.model.flood_protection_profile_list_result",
            com.vmware.nsx_global_policy.model.StructDefinitions.floodProtectionProfileListResult);
        add(mapping,
            "com.vmware.nsx_global_policy.model.flow_info",
            com.vmware.nsx_global_policy.model.StructDefinitions.flowInfo);
        add(mapping,
            "com.vmware.nsx_global_policy.model.footer",
            com.vmware.nsx_global_policy.model.StructDefinitions.footer);
        add(mapping,
            "com.vmware.nsx_global_policy.model.footer_action",
            com.vmware.nsx_global_policy.model.StructDefinitions.footerAction);
        add(mapping,
            "com.vmware.nsx_global_policy.model.forwarding_policy",
            com.vmware.nsx_global_policy.model.StructDefinitions.forwardingPolicy);
        add(mapping,
            "com.vmware.nsx_global_policy.model.forwarding_policy_list_result",
            com.vmware.nsx_global_policy.model.StructDefinitions.forwardingPolicyListResult);
        add(mapping,
            "com.vmware.nsx_global_policy.model.forwarding_rule",
            com.vmware.nsx_global_policy.model.StructDefinitions.forwardingRule);
        add(mapping,
            "com.vmware.nsx_global_policy.model.forwarding_rule_list_result",
            com.vmware.nsx_global_policy.model.StructDefinitions.forwardingRuleListResult);
        add(mapping,
            "com.vmware.nsx_global_policy.model.fqdn_analysis_config",
            com.vmware.nsx_global_policy.model.StructDefinitions.fqdnAnalysisConfig);
        add(mapping,
            "com.vmware.nsx_global_policy.model.full_sync_info",
            com.vmware.nsx_global_policy.model.StructDefinitions.fullSyncInfo);
        add(mapping,
            "com.vmware.nsx_global_policy.model.full_sync_state",
            com.vmware.nsx_global_policy.model.StructDefinitions.fullSyncState);
        add(mapping,
            "com.vmware.nsx_global_policy.model.full_sync_state_list_result",
            com.vmware.nsx_global_policy.model.StructDefinitions.fullSyncStateListResult);
        add(mapping,
            "com.vmware.nsx_global_policy.model.gateway_flood_protection_profile",
            com.vmware.nsx_global_policy.model.StructDefinitions.gatewayFloodProtectionProfile);
        add(mapping,
            "com.vmware.nsx_global_policy.model.gateway_general_security_profile",
            com.vmware.nsx_global_policy.model.StructDefinitions.gatewayGeneralSecurityProfile);
        add(mapping,
            "com.vmware.nsx_global_policy.model.gateway_interface_reference",
            com.vmware.nsx_global_policy.model.StructDefinitions.gatewayInterfaceReference);
        add(mapping,
            "com.vmware.nsx_global_policy.model.gateway_policy",
            com.vmware.nsx_global_policy.model.StructDefinitions.gatewayPolicy);
        add(mapping,
            "com.vmware.nsx_global_policy.model.gateway_policy_list_result",
            com.vmware.nsx_global_policy.model.StructDefinitions.gatewayPolicyListResult);
        add(mapping,
            "com.vmware.nsx_global_policy.model.gateway_qos_profile",
            com.vmware.nsx_global_policy.model.StructDefinitions.gatewayQosProfile);
        add(mapping,
            "com.vmware.nsx_global_policy.model.gateway_qos_profile_config",
            com.vmware.nsx_global_policy.model.StructDefinitions.gatewayQosProfileConfig);
        add(mapping,
            "com.vmware.nsx_global_policy.model.gateway_qos_profile_list_result",
            com.vmware.nsx_global_policy.model.StructDefinitions.gatewayQosProfileListResult);
        add(mapping,
            "com.vmware.nsx_global_policy.model.gateway_recovery_site_config",
            com.vmware.nsx_global_policy.model.StructDefinitions.gatewayRecoverySiteConfig);
        add(mapping,
            "com.vmware.nsx_global_policy.model.gateway_route_csv_record",
            com.vmware.nsx_global_policy.model.StructDefinitions.gatewayRouteCsvRecord);
        add(mapping,
            "com.vmware.nsx_global_policy.model.gateway_route_table_in_csv_format",
            com.vmware.nsx_global_policy.model.StructDefinitions.gatewayRouteTableInCsvFormat);
        add(mapping,
            "com.vmware.nsx_global_policy.model.gateway_site_failover_action_config",
            com.vmware.nsx_global_policy.model.StructDefinitions.gatewaySiteFailoverActionConfig);
        add(mapping,
            "com.vmware.nsx_global_policy.model.general_security_profile",
            com.vmware.nsx_global_policy.model.StructDefinitions.generalSecurityProfile);
        add(mapping,
            "com.vmware.nsx_global_policy.model.general_security_profile_binding_map",
            com.vmware.nsx_global_policy.model.StructDefinitions.generalSecurityProfileBindingMap);
        add(mapping,
            "com.vmware.nsx_global_policy.model.generic_dhcp_option",
            com.vmware.nsx_global_policy.model.StructDefinitions.genericDhcpOption);
        add(mapping,
            "com.vmware.nsx_global_policy.model.generic_policy_realized_resource",
            com.vmware.nsx_global_policy.model.StructDefinitions.genericPolicyRealizedResource);
        add(mapping,
            "com.vmware.nsx_global_policy.model.generic_policy_realized_resource_list_result",
            com.vmware.nsx_global_policy.model.StructDefinitions.genericPolicyRealizedResourceListResult);
        add(mapping,
            "com.vmware.nsx_global_policy.model.global_collector_config",
            com.vmware.nsx_global_policy.model.StructDefinitions.globalCollectorConfig);
        add(mapping,
            "com.vmware.nsx_global_policy.model.global_config",
            com.vmware.nsx_global_policy.model.StructDefinitions.globalConfig);
        add(mapping,
            "com.vmware.nsx_global_policy.model.global_dfw_configuration",
            com.vmware.nsx_global_policy.model.StructDefinitions.globalDfwConfiguration);
        add(mapping,
            "com.vmware.nsx_global_policy.model.global_dfw_configuration_list_result",
            com.vmware.nsx_global_policy.model.StructDefinitions.globalDfwConfigurationListResult);
        add(mapping,
            "com.vmware.nsx_global_policy.model.global_ids_settings",
            com.vmware.nsx_global_policy.model.StructDefinitions.globalIdsSettings);
        add(mapping,
            "com.vmware.nsx_global_policy.model.global_ids_signature",
            com.vmware.nsx_global_policy.model.StructDefinitions.globalIdsSignature);
        add(mapping,
            "com.vmware.nsx_global_policy.model.global_manager",
            com.vmware.nsx_global_policy.model.StructDefinitions.globalManager);
        add(mapping,
            "com.vmware.nsx_global_policy.model.global_manager_config",
            com.vmware.nsx_global_policy.model.StructDefinitions.globalManagerConfig);
        add(mapping,
            "com.vmware.nsx_global_policy.model.global_manager_list_result",
            com.vmware.nsx_global_policy.model.StructDefinitions.globalManagerListResult);
        add(mapping,
            "com.vmware.nsx_global_policy.model.global_restore_status",
            com.vmware.nsx_global_policy.model.StructDefinitions.globalRestoreStatus);
        add(mapping,
            "com.vmware.nsx_global_policy.model.gm_config_onboarding_conflict_entity_info",
            com.vmware.nsx_global_policy.model.StructDefinitions.gmConfigOnboardingConflictEntityInfo);
        add(mapping,
            "com.vmware.nsx_global_policy.model.gm_federation_site_config",
            com.vmware.nsx_global_policy.model.StructDefinitions.gmFederationSiteConfig);
        add(mapping,
            "com.vmware.nsx_global_policy.model.gm_node_status",
            com.vmware.nsx_global_policy.model.StructDefinitions.gmNodeStatus);
        add(mapping,
            "com.vmware.nsx_global_policy.model.gm_operational_state",
            com.vmware.nsx_global_policy.model.StructDefinitions.gmOperationalState);
        add(mapping,
            "com.vmware.nsx_global_policy.model.gm_rtep_config",
            com.vmware.nsx_global_policy.model.StructDefinitions.gmRtepConfig);
        add(mapping,
            "com.vmware.nsx_global_policy.model.graph_configuration",
            com.vmware.nsx_global_policy.model.StructDefinitions.graphConfiguration);
        add(mapping,
            "com.vmware.nsx_global_policy.model.graph_definition",
            com.vmware.nsx_global_policy.model.StructDefinitions.graphDefinition);
        add(mapping,
            "com.vmware.nsx_global_policy.model.grid_configuration",
            com.vmware.nsx_global_policy.model.StructDefinitions.gridConfiguration);
        add(mapping,
            "com.vmware.nsx_global_policy.model.group",
            com.vmware.nsx_global_policy.model.StructDefinitions.group);
        add(mapping,
            "com.vmware.nsx_global_policy.model.group_discovery_profile_binding_map",
            com.vmware.nsx_global_policy.model.StructDefinitions.groupDiscoveryProfileBindingMap);
        add(mapping,
            "com.vmware.nsx_global_policy.model.group_discovery_profile_binding_map_list_result",
            com.vmware.nsx_global_policy.model.StructDefinitions.groupDiscoveryProfileBindingMapListResult);
        add(mapping,
            "com.vmware.nsx_global_policy.model.group_list_result",
            com.vmware.nsx_global_policy.model.StructDefinitions.groupListResult);
        add(mapping,
            "com.vmware.nsx_global_policy.model.group_member_list",
            com.vmware.nsx_global_policy.model.StructDefinitions.groupMemberList);
        add(mapping,
            "com.vmware.nsx_global_policy.model.group_member_tags_list",
            com.vmware.nsx_global_policy.model.StructDefinitions.groupMemberTagsList);
        add(mapping,
            "com.vmware.nsx_global_policy.model.group_member_type_list_result",
            com.vmware.nsx_global_policy.model.StructDefinitions.groupMemberTypeListResult);
        add(mapping,
            "com.vmware.nsx_global_policy.model.group_monitoring_profile_binding_map",
            com.vmware.nsx_global_policy.model.StructDefinitions.groupMonitoringProfileBindingMap);
        add(mapping,
            "com.vmware.nsx_global_policy.model.group_scope_expression",
            com.vmware.nsx_global_policy.model.StructDefinitions.groupScopeExpression);
        add(mapping,
            "com.vmware.nsx_global_policy.model.group_tags_list",
            com.vmware.nsx_global_policy.model.StructDefinitions.groupTagsList);
        add(mapping,
            "com.vmware.nsx_global_policy.model.header",
            com.vmware.nsx_global_policy.model.StructDefinitions.header);
        add(mapping,
            "com.vmware.nsx_global_policy.model.ICMP_type_service_entry",
            com.vmware.nsx_global_policy.model.StructDefinitions.ICMPTypeServiceEntry);
        add(mapping,
            "com.vmware.nsx_global_policy.model.IGMP_type_service_entry",
            com.vmware.nsx_global_policy.model.StructDefinitions.IGMPTypeServiceEntry);
        add(mapping,
            "com.vmware.nsx_global_policy.model.IP_address_expression",
            com.vmware.nsx_global_policy.model.StructDefinitions.IPAddressExpression);
        add(mapping,
            "com.vmware.nsx_global_policy.model.IP_address_list",
            com.vmware.nsx_global_policy.model.StructDefinitions.IPAddressList);
        add(mapping,
            "com.vmware.nsx_global_policy.model.IP_addresses",
            com.vmware.nsx_global_policy.model.StructDefinitions.IPAddresses);
        add(mapping,
            "com.vmware.nsx_global_policy.model.IP_discovery_profile",
            com.vmware.nsx_global_policy.model.StructDefinitions.IPDiscoveryProfile);
        add(mapping,
            "com.vmware.nsx_global_policy.model.IP_discovery_profile_list_result",
            com.vmware.nsx_global_policy.model.StructDefinitions.IPDiscoveryProfileListResult);
        add(mapping,
            "com.vmware.nsx_global_policy.model.IPFIXDFW_collector",
            com.vmware.nsx_global_policy.model.StructDefinitions.IPFIXDFWCollector);
        add(mapping,
            "com.vmware.nsx_global_policy.model.IPFIXDFW_collector_profile",
            com.vmware.nsx_global_policy.model.StructDefinitions.IPFIXDFWCollectorProfile);
        add(mapping,
            "com.vmware.nsx_global_policy.model.IPFIXDFW_profile",
            com.vmware.nsx_global_policy.model.StructDefinitions.IPFIXDFWProfile);
        add(mapping,
            "com.vmware.nsx_global_policy.model.IPFIX_l2_collector",
            com.vmware.nsx_global_policy.model.StructDefinitions.IPFIXL2Collector);
        add(mapping,
            "com.vmware.nsx_global_policy.model.IPFIX_l2_collector_profile",
            com.vmware.nsx_global_policy.model.StructDefinitions.IPFIXL2CollectorProfile);
        add(mapping,
            "com.vmware.nsx_global_policy.model.IPFIX_l2_profile",
            com.vmware.nsx_global_policy.model.StructDefinitions.IPFIXL2Profile);
        add(mapping,
            "com.vmware.nsx_global_policy.model.IP_info",
            com.vmware.nsx_global_policy.model.StructDefinitions.IPInfo);
        add(mapping,
            "com.vmware.nsx_global_policy.model.IP_protocol_service_entry",
            com.vmware.nsx_global_policy.model.StructDefinitions.IPProtocolServiceEntry);
        add(mapping,
            "com.vmware.nsx_global_policy.model.IP_sec_vpn_dpd_profile",
            com.vmware.nsx_global_policy.model.StructDefinitions.IPSecVpnDpdProfile);
        add(mapping,
            "com.vmware.nsx_global_policy.model.IP_sec_vpn_ike_profile",
            com.vmware.nsx_global_policy.model.StructDefinitions.IPSecVpnIkeProfile);
        add(mapping,
            "com.vmware.nsx_global_policy.model.IP_sec_vpn_local_endpoint",
            com.vmware.nsx_global_policy.model.StructDefinitions.IPSecVpnLocalEndpoint);
        add(mapping,
            "com.vmware.nsx_global_policy.model.IP_sec_vpn_rule",
            com.vmware.nsx_global_policy.model.StructDefinitions.IPSecVpnRule);
        add(mapping,
            "com.vmware.nsx_global_policy.model.IP_sec_vpn_service",
            com.vmware.nsx_global_policy.model.StructDefinitions.IPSecVpnService);
        add(mapping,
            "com.vmware.nsx_global_policy.model.IP_sec_vpn_session",
            com.vmware.nsx_global_policy.model.StructDefinitions.IPSecVpnSession);
        add(mapping,
            "com.vmware.nsx_global_policy.model.IP_sec_vpn_subnet",
            com.vmware.nsx_global_policy.model.StructDefinitions.IPSecVpnSubnet);
        add(mapping,
            "com.vmware.nsx_global_policy.model.IP_sec_vpn_tunnel_interface",
            com.vmware.nsx_global_policy.model.StructDefinitions.IPSecVpnTunnelInterface);
        add(mapping,
            "com.vmware.nsx_global_policy.model.IP_sec_vpn_tunnel_profile",
            com.vmware.nsx_global_policy.model.StructDefinitions.IPSecVpnTunnelProfile);
        add(mapping,
            "com.vmware.nsx_global_policy.model.IP_subnet",
            com.vmware.nsx_global_policy.model.StructDefinitions.IPSubnet);
        add(mapping,
            "com.vmware.nsx_global_policy.model.I_pv4_discovery_options",
            com.vmware.nsx_global_policy.model.StructDefinitions.IPv4DiscoveryOptions);
        add(mapping,
            "com.vmware.nsx_global_policy.model.I_pv6_DAD_status",
            com.vmware.nsx_global_policy.model.StructDefinitions.IPv6DADStatus);
        add(mapping,
            "com.vmware.nsx_global_policy.model.I_pv6_discovery_options",
            com.vmware.nsx_global_policy.model.StructDefinitions.IPv6DiscoveryOptions);
        add(mapping,
            "com.vmware.nsx_global_policy.model.I_pv6_status",
            com.vmware.nsx_global_policy.model.StructDefinitions.IPv6Status);
        add(mapping,
            "com.vmware.nsx_global_policy.model.icmp_echo_request_header",
            com.vmware.nsx_global_policy.model.StructDefinitions.icmpEchoRequestHeader);
        add(mapping,
            "com.vmware.nsx_global_policy.model.icon",
            com.vmware.nsx_global_policy.model.StructDefinitions.icon);
        add(mapping,
            "com.vmware.nsx_global_policy.model.identity_firewall_ad_store",
            com.vmware.nsx_global_policy.model.StructDefinitions.identityFirewallAdStore);
        add(mapping,
            "com.vmware.nsx_global_policy.model.identity_firewall_store",
            com.vmware.nsx_global_policy.model.StructDefinitions.identityFirewallStore);
        add(mapping,
            "com.vmware.nsx_global_policy.model.identity_firewall_store_event_log_server",
            com.vmware.nsx_global_policy.model.StructDefinitions.identityFirewallStoreEventLogServer);
        add(mapping,
            "com.vmware.nsx_global_policy.model.identity_firewall_store_ldap_server",
            com.vmware.nsx_global_policy.model.StructDefinitions.identityFirewallStoreLdapServer);
        add(mapping,
            "com.vmware.nsx_global_policy.model.identity_group_expression",
            com.vmware.nsx_global_policy.model.StructDefinitions.identityGroupExpression);
        add(mapping,
            "com.vmware.nsx_global_policy.model.identity_group_info",
            com.vmware.nsx_global_policy.model.StructDefinitions.identityGroupInfo);
        add(mapping,
            "com.vmware.nsx_global_policy.model.identity_source_ldap_server",
            com.vmware.nsx_global_policy.model.StructDefinitions.identitySourceLdapServer);
        add(mapping,
            "com.vmware.nsx_global_policy.model.identity_source_ldap_server_endpoint",
            com.vmware.nsx_global_policy.model.StructDefinitions.identitySourceLdapServerEndpoint);
        add(mapping,
            "com.vmware.nsx_global_policy.model.identity_source_ldap_server_probe_result",
            com.vmware.nsx_global_policy.model.StructDefinitions.identitySourceLdapServerProbeResult);
        add(mapping,
            "com.vmware.nsx_global_policy.model.ids_cluster_config",
            com.vmware.nsx_global_policy.model.StructDefinitions.idsClusterConfig);
        add(mapping,
            "com.vmware.nsx_global_policy.model.ids_gateway_policy",
            com.vmware.nsx_global_policy.model.StructDefinitions.idsGatewayPolicy);
        add(mapping,
            "com.vmware.nsx_global_policy.model.ids_global_event_config",
            com.vmware.nsx_global_policy.model.StructDefinitions.idsGlobalEventConfig);
        add(mapping,
            "com.vmware.nsx_global_policy.model.ids_policy",
            com.vmware.nsx_global_policy.model.StructDefinitions.idsPolicy);
        add(mapping,
            "com.vmware.nsx_global_policy.model.ids_profile",
            com.vmware.nsx_global_policy.model.StructDefinitions.idsProfile);
        add(mapping,
            "com.vmware.nsx_global_policy.model.ids_profile_conjunction_operator",
            com.vmware.nsx_global_policy.model.StructDefinitions.idsProfileConjunctionOperator);
        add(mapping,
            "com.vmware.nsx_global_policy.model.ids_profile_criteria",
            com.vmware.nsx_global_policy.model.StructDefinitions.idsProfileCriteria);
        add(mapping,
            "com.vmware.nsx_global_policy.model.ids_profile_filter_criteria",
            com.vmware.nsx_global_policy.model.StructDefinitions.idsProfileFilterCriteria);
        add(mapping,
            "com.vmware.nsx_global_policy.model.ids_profile_local_signature",
            com.vmware.nsx_global_policy.model.StructDefinitions.idsProfileLocalSignature);
        add(mapping,
            "com.vmware.nsx_global_policy.model.ids_profile_severity",
            com.vmware.nsx_global_policy.model.StructDefinitions.idsProfileSeverity);
        add(mapping,
            "com.vmware.nsx_global_policy.model.ids_rule",
            com.vmware.nsx_global_policy.model.StructDefinitions.idsRule);
        add(mapping,
            "com.vmware.nsx_global_policy.model.ids_security_policy",
            com.vmware.nsx_global_policy.model.StructDefinitions.idsSecurityPolicy);
        add(mapping,
            "com.vmware.nsx_global_policy.model.ids_settings",
            com.vmware.nsx_global_policy.model.StructDefinitions.idsSettings);
        add(mapping,
            "com.vmware.nsx_global_policy.model.ids_signature",
            com.vmware.nsx_global_policy.model.StructDefinitions.idsSignature);
        add(mapping,
            "com.vmware.nsx_global_policy.model.ids_signature_status",
            com.vmware.nsx_global_policy.model.StructDefinitions.idsSignatureStatus);
        add(mapping,
            "com.vmware.nsx_global_policy.model.ids_signature_version",
            com.vmware.nsx_global_policy.model.StructDefinitions.idsSignatureVersion);
        add(mapping,
            "com.vmware.nsx_global_policy.model.ids_standalone_host_config",
            com.vmware.nsx_global_policy.model.StructDefinitions.idsStandaloneHostConfig);
        add(mapping,
            "com.vmware.nsx_global_policy.model.import_task",
            com.vmware.nsx_global_policy.model.StructDefinitions.importTask);
        add(mapping,
            "com.vmware.nsx_global_policy.model.included_fields_parameters",
            com.vmware.nsx_global_policy.model.StructDefinitions.includedFieldsParameters);
        add(mapping,
            "com.vmware.nsx_global_policy.model.infra",
            com.vmware.nsx_global_policy.model.StructDefinitions.infra);
        add(mapping,
            "com.vmware.nsx_global_policy.model.infra_security_config",
            com.vmware.nsx_global_policy.model.StructDefinitions.infraSecurityConfig);
        add(mapping,
            "com.vmware.nsx_global_policy.model.ingress_broadcast_rate_limiter",
            com.vmware.nsx_global_policy.model.StructDefinitions.ingressBroadcastRateLimiter);
        add(mapping,
            "com.vmware.nsx_global_policy.model.ingress_rate_limiter",
            com.vmware.nsx_global_policy.model.StructDefinitions.ingressRateLimiter);
        add(mapping,
            "com.vmware.nsx_global_policy.model.initiate_cluster_restore_request",
            com.vmware.nsx_global_policy.model.StructDefinitions.initiateClusterRestoreRequest);
        add(mapping,
            "com.vmware.nsx_global_policy.model.injection",
            com.vmware.nsx_global_policy.model.StructDefinitions.injection);
        add(mapping,
            "com.vmware.nsx_global_policy.model.injection_value",
            com.vmware.nsx_global_policy.model.StructDefinitions.injectionValue);
        add(mapping,
            "com.vmware.nsx_global_policy.model.instruction_info",
            com.vmware.nsx_global_policy.model.StructDefinitions.instructionInfo);
        add(mapping,
            "com.vmware.nsx_global_policy.model.integer_array_constraint_value",
            com.vmware.nsx_global_policy.model.StructDefinitions.integerArrayConstraintValue);
        add(mapping,
            "com.vmware.nsx_global_policy.model.intent_runtime_request_parameters",
            com.vmware.nsx_global_policy.model.StructDefinitions.intentRuntimeRequestParameters);
        add(mapping,
            "com.vmware.nsx_global_policy.model.inter_site_port_counters",
            com.vmware.nsx_global_policy.model.StructDefinitions.interSitePortCounters);
        add(mapping,
            "com.vmware.nsx_global_policy.model.interface_arp_csv_record",
            com.vmware.nsx_global_policy.model.StructDefinitions.interfaceArpCsvRecord);
        add(mapping,
            "com.vmware.nsx_global_policy.model.interface_arp_entry",
            com.vmware.nsx_global_policy.model.StructDefinitions.interfaceArpEntry);
        add(mapping,
            "com.vmware.nsx_global_policy.model.interface_arp_proxy",
            com.vmware.nsx_global_policy.model.StructDefinitions.interfaceArpProxy);
        add(mapping,
            "com.vmware.nsx_global_policy.model.interface_arp_proxy_csv_entry",
            com.vmware.nsx_global_policy.model.StructDefinitions.interfaceArpProxyCsvEntry);
        add(mapping,
            "com.vmware.nsx_global_policy.model.interface_arp_table",
            com.vmware.nsx_global_policy.model.StructDefinitions.interfaceArpTable);
        add(mapping,
            "com.vmware.nsx_global_policy.model.interface_arp_table_in_csv_format",
            com.vmware.nsx_global_policy.model.StructDefinitions.interfaceArpTableInCsvFormat);
        add(mapping,
            "com.vmware.nsx_global_policy.model.interface_DAD_state",
            com.vmware.nsx_global_policy.model.StructDefinitions.interfaceDADState);
        add(mapping,
            "com.vmware.nsx_global_policy.model.interfacei_pv6_DAD_status",
            com.vmware.nsx_global_policy.model.StructDefinitions.interfaceiPv6DADStatus);
        add(mapping,
            "com.vmware.nsx_global_policy.model.interface_subnet",
            com.vmware.nsx_global_policy.model.StructDefinitions.interfaceSubnet);
        add(mapping,
            "com.vmware.nsx_global_policy.model.intersite_gateway_config",
            com.vmware.nsx_global_policy.model.StructDefinitions.intersiteGatewayConfig);
        add(mapping,
            "com.vmware.nsx_global_policy.model.interval_backup_schedule",
            com.vmware.nsx_global_policy.model.StructDefinitions.intervalBackupSchedule);
        add(mapping,
            "com.vmware.nsx_global_policy.model.invalid_config_summary",
            com.vmware.nsx_global_policy.model.StructDefinitions.invalidConfigSummary);
        add(mapping,
            "com.vmware.nsx_global_policy.model.ip_address_allocation",
            com.vmware.nsx_global_policy.model.StructDefinitions.ipAddressAllocation);
        add(mapping,
            "com.vmware.nsx_global_policy.model.ip_address_block",
            com.vmware.nsx_global_policy.model.StructDefinitions.ipAddressBlock);
        add(mapping,
            "com.vmware.nsx_global_policy.model.ip_address_info",
            com.vmware.nsx_global_policy.model.StructDefinitions.ipAddressInfo);
        add(mapping,
            "com.vmware.nsx_global_policy.model.ip_address_pool",
            com.vmware.nsx_global_policy.model.StructDefinitions.ipAddressPool);
        add(mapping,
            "com.vmware.nsx_global_policy.model.ip_address_pool_block_subnet",
            com.vmware.nsx_global_policy.model.StructDefinitions.ipAddressPoolBlockSubnet);
        add(mapping,
            "com.vmware.nsx_global_policy.model.ip_address_pool_static_subnet",
            com.vmware.nsx_global_policy.model.StructDefinitions.ipAddressPoolStaticSubnet);
        add(mapping,
            "com.vmware.nsx_global_policy.model.ip_address_pool_subnet",
            com.vmware.nsx_global_policy.model.StructDefinitions.ipAddressPoolSubnet);
        add(mapping,
            "com.vmware.nsx_global_policy.model.ip_info",
            com.vmware.nsx_global_policy.model.StructDefinitions.ipInfo);
        add(mapping,
            "com.vmware.nsx_global_policy.model.ip_pool_range",
            com.vmware.nsx_global_policy.model.StructDefinitions.ipPoolRange);
        add(mapping,
            "com.vmware.nsx_global_policy.model.ipv4_header",
            com.vmware.nsx_global_policy.model.StructDefinitions.ipv4Header);
        add(mapping,
            "com.vmware.nsx_global_policy.model.ipv6_dad_profile",
            com.vmware.nsx_global_policy.model.StructDefinitions.ipv6DadProfile);
        add(mapping,
            "com.vmware.nsx_global_policy.model.ipv6_dad_profile_list_result",
            com.vmware.nsx_global_policy.model.StructDefinitions.ipv6DadProfileListResult);
        add(mapping,
            "com.vmware.nsx_global_policy.model.ipv6_header",
            com.vmware.nsx_global_policy.model.StructDefinitions.ipv6Header);
        add(mapping,
            "com.vmware.nsx_global_policy.model.ipv6_ndra_profile",
            com.vmware.nsx_global_policy.model.StructDefinitions.ipv6NdraProfile);
        add(mapping,
            "com.vmware.nsx_global_policy.model.ipv6_ndra_profile_list_result",
            com.vmware.nsx_global_policy.model.StructDefinitions.ipv6NdraProfileListResult);
        add(mapping,
            "com.vmware.nsx_global_policy.model.issuer_serial_number",
            com.vmware.nsx_global_policy.model.StructDefinitions.issuerSerialNumber);
        add(mapping,
            "com.vmware.nsx_global_policy.model.key_store_info",
            com.vmware.nsx_global_policy.model.StructDefinitions.keyStoreInfo);
        add(mapping,
            "com.vmware.nsx_global_policy.model.key_value",
            com.vmware.nsx_global_policy.model.StructDefinitions.keyValue);
        add(mapping,
            "com.vmware.nsx_global_policy.model.l2_auto_RD",
            com.vmware.nsx_global_policy.model.StructDefinitions.l2AutoRD);
        add(mapping,
            "com.vmware.nsx_global_policy.model.l2_bridge_endpoint_profile",
            com.vmware.nsx_global_policy.model.StructDefinitions.l2BridgeEndpointProfile);
        add(mapping,
            "com.vmware.nsx_global_policy.model.l2_bridge_endpoint_profile_list_result",
            com.vmware.nsx_global_policy.model.StructDefinitions.l2BridgeEndpointProfileListResult);
        add(mapping,
            "com.vmware.nsx_global_policy.model.l2_extension",
            com.vmware.nsx_global_policy.model.StructDefinitions.l2Extension);
        add(mapping,
            "com.vmware.nsx_global_policy.model.l2_forwarder_remote_macs_per_site",
            com.vmware.nsx_global_policy.model.StructDefinitions.l2ForwarderRemoteMacsPerSite);
        add(mapping,
            "com.vmware.nsx_global_policy.model.l2_forwarder_status_per_node",
            com.vmware.nsx_global_policy.model.StructDefinitions.l2ForwarderStatusPerNode);
        add(mapping,
            "com.vmware.nsx_global_policy.model.l2_tcp_max_segment_size_clamping",
            com.vmware.nsx_global_policy.model.StructDefinitions.l2TcpMaxSegmentSizeClamping);
        add(mapping,
            "com.vmware.nsx_global_policy.model.l2_VPN_service",
            com.vmware.nsx_global_policy.model.StructDefinitions.l2VPNService);
        add(mapping,
            "com.vmware.nsx_global_policy.model.l2_VPN_session",
            com.vmware.nsx_global_policy.model.StructDefinitions.l2VPNSession);
        add(mapping,
            "com.vmware.nsx_global_policy.model.l2_VPN_tunnel_encapsulation",
            com.vmware.nsx_global_policy.model.StructDefinitions.l2VPNTunnelEncapsulation);
        add(mapping,
            "com.vmware.nsx_global_policy.model.l2_vpn",
            com.vmware.nsx_global_policy.model.StructDefinitions.l2Vpn);
        add(mapping,
            "com.vmware.nsx_global_policy.model.l2_vpn_context",
            com.vmware.nsx_global_policy.model.StructDefinitions.l2VpnContext);
        add(mapping,
            "com.vmware.nsx_global_policy.model.l3_vpn",
            com.vmware.nsx_global_policy.model.StructDefinitions.l3Vpn);
        add(mapping,
            "com.vmware.nsx_global_policy.model.l3_vpn_context",
            com.vmware.nsx_global_policy.model.StructDefinitions.l3VpnContext);
        add(mapping,
            "com.vmware.nsx_global_policy.model.l3_vpn_rule",
            com.vmware.nsx_global_policy.model.StructDefinitions.l3VpnRule);
        add(mapping,
            "com.vmware.nsx_global_policy.model.l3_vpn_session",
            com.vmware.nsx_global_policy.model.StructDefinitions.l3VpnSession);
        add(mapping,
            "com.vmware.nsx_global_policy.model.l3_vpn_subnet",
            com.vmware.nsx_global_policy.model.StructDefinitions.l3VpnSubnet);
        add(mapping,
            "com.vmware.nsx_global_policy.model.l4_port_set_service_entry",
            com.vmware.nsx_global_policy.model.StructDefinitions.l4PortSetServiceEntry);
        add(mapping,
            "com.vmware.nsx_global_policy.model.l7_access_attributes",
            com.vmware.nsx_global_policy.model.StructDefinitions.l7AccessAttributes);
        add(mapping,
            "com.vmware.nsx_global_policy.model.l7_access_entry",
            com.vmware.nsx_global_policy.model.StructDefinitions.l7AccessEntry);
        add(mapping,
            "com.vmware.nsx_global_policy.model.l7_access_profile",
            com.vmware.nsx_global_policy.model.StructDefinitions.l7AccessProfile);
        add(mapping,
            "com.vmware.nsx_global_policy.model.LB_access_list_control",
            com.vmware.nsx_global_policy.model.StructDefinitions.LBAccessListControl);
        add(mapping,
            "com.vmware.nsx_global_policy.model.LB_active_monitor",
            com.vmware.nsx_global_policy.model.StructDefinitions.LBActiveMonitor);
        add(mapping,
            "com.vmware.nsx_global_policy.model.LB_app_profile",
            com.vmware.nsx_global_policy.model.StructDefinitions.LBAppProfile);
        add(mapping,
            "com.vmware.nsx_global_policy.model.LB_client_certificate_issuer_dn_condition",
            com.vmware.nsx_global_policy.model.StructDefinitions.LBClientCertificateIssuerDnCondition);
        add(mapping,
            "com.vmware.nsx_global_policy.model.LB_client_certificate_subject_dn_condition",
            com.vmware.nsx_global_policy.model.StructDefinitions.LBClientCertificateSubjectDnCondition);
        add(mapping,
            "com.vmware.nsx_global_policy.model.LB_client_ssl_profile",
            com.vmware.nsx_global_policy.model.StructDefinitions.LBClientSslProfile);
        add(mapping,
            "com.vmware.nsx_global_policy.model.LB_client_ssl_profile_binding",
            com.vmware.nsx_global_policy.model.StructDefinitions.LBClientSslProfileBinding);
        add(mapping,
            "com.vmware.nsx_global_policy.model.LB_connection_drop_action",
            com.vmware.nsx_global_policy.model.StructDefinitions.LBConnectionDropAction);
        add(mapping,
            "com.vmware.nsx_global_policy.model.LB_cookie_persistence_profile",
            com.vmware.nsx_global_policy.model.StructDefinitions.LBCookiePersistenceProfile);
        add(mapping,
            "com.vmware.nsx_global_policy.model.LB_cookie_time",
            com.vmware.nsx_global_policy.model.StructDefinitions.LBCookieTime);
        add(mapping,
            "com.vmware.nsx_global_policy.model.LB_fast_tcp_profile",
            com.vmware.nsx_global_policy.model.StructDefinitions.LBFastTcpProfile);
        add(mapping,
            "com.vmware.nsx_global_policy.model.LB_fast_udp_profile",
            com.vmware.nsx_global_policy.model.StructDefinitions.LBFastUdpProfile);
        add(mapping,
            "com.vmware.nsx_global_policy.model.LB_generic_persistence_profile",
            com.vmware.nsx_global_policy.model.StructDefinitions.LBGenericPersistenceProfile);
        add(mapping,
            "com.vmware.nsx_global_policy.model.LB_http_monitor_profile",
            com.vmware.nsx_global_policy.model.StructDefinitions.LBHttpMonitorProfile);
        add(mapping,
            "com.vmware.nsx_global_policy.model.LB_http_profile",
            com.vmware.nsx_global_policy.model.StructDefinitions.LBHttpProfile);
        add(mapping,
            "com.vmware.nsx_global_policy.model.LB_http_redirect_action",
            com.vmware.nsx_global_policy.model.StructDefinitions.LBHttpRedirectAction);
        add(mapping,
            "com.vmware.nsx_global_policy.model.LB_http_reject_action",
            com.vmware.nsx_global_policy.model.StructDefinitions.LBHttpRejectAction);
        add(mapping,
            "com.vmware.nsx_global_policy.model.LB_http_request_body_condition",
            com.vmware.nsx_global_policy.model.StructDefinitions.LBHttpRequestBodyCondition);
        add(mapping,
            "com.vmware.nsx_global_policy.model.LB_http_request_cookie_condition",
            com.vmware.nsx_global_policy.model.StructDefinitions.LBHttpRequestCookieCondition);
        add(mapping,
            "com.vmware.nsx_global_policy.model.LB_http_request_header_condition",
            com.vmware.nsx_global_policy.model.StructDefinitions.LBHttpRequestHeaderCondition);
        add(mapping,
            "com.vmware.nsx_global_policy.model.LB_http_request_header_delete_action",
            com.vmware.nsx_global_policy.model.StructDefinitions.LBHttpRequestHeaderDeleteAction);
        add(mapping,
            "com.vmware.nsx_global_policy.model.LB_http_request_header_rewrite_action",
            com.vmware.nsx_global_policy.model.StructDefinitions.LBHttpRequestHeaderRewriteAction);
        add(mapping,
            "com.vmware.nsx_global_policy.model.LB_http_request_method_condition",
            com.vmware.nsx_global_policy.model.StructDefinitions.LBHttpRequestMethodCondition);
        add(mapping,
            "com.vmware.nsx_global_policy.model.LB_http_request_uri_arguments_condition",
            com.vmware.nsx_global_policy.model.StructDefinitions.LBHttpRequestUriArgumentsCondition);
        add(mapping,
            "com.vmware.nsx_global_policy.model.LB_http_request_uri_condition",
            com.vmware.nsx_global_policy.model.StructDefinitions.LBHttpRequestUriCondition);
        add(mapping,
            "com.vmware.nsx_global_policy.model.LB_http_request_uri_rewrite_action",
            com.vmware.nsx_global_policy.model.StructDefinitions.LBHttpRequestUriRewriteAction);
        add(mapping,
            "com.vmware.nsx_global_policy.model.LB_http_request_version_condition",
            com.vmware.nsx_global_policy.model.StructDefinitions.LBHttpRequestVersionCondition);
        add(mapping,
            "com.vmware.nsx_global_policy.model.LB_http_response_header_condition",
            com.vmware.nsx_global_policy.model.StructDefinitions.LBHttpResponseHeaderCondition);
        add(mapping,
            "com.vmware.nsx_global_policy.model.LB_http_response_header_delete_action",
            com.vmware.nsx_global_policy.model.StructDefinitions.LBHttpResponseHeaderDeleteAction);
        add(mapping,
            "com.vmware.nsx_global_policy.model.LB_http_response_header_rewrite_action",
            com.vmware.nsx_global_policy.model.StructDefinitions.LBHttpResponseHeaderRewriteAction);
        add(mapping,
            "com.vmware.nsx_global_policy.model.LB_http_ssl_condition",
            com.vmware.nsx_global_policy.model.StructDefinitions.LBHttpSslCondition);
        add(mapping,
            "com.vmware.nsx_global_policy.model.LB_https_monitor_profile",
            com.vmware.nsx_global_policy.model.StructDefinitions.LBHttpsMonitorProfile);
        add(mapping,
            "com.vmware.nsx_global_policy.model.LB_icmp_monitor_profile",
            com.vmware.nsx_global_policy.model.StructDefinitions.LBIcmpMonitorProfile);
        add(mapping,
            "com.vmware.nsx_global_policy.model.LB_ip_header_condition",
            com.vmware.nsx_global_policy.model.StructDefinitions.LBIpHeaderCondition);
        add(mapping,
            "com.vmware.nsx_global_policy.model.LB_jwt_auth_action",
            com.vmware.nsx_global_policy.model.StructDefinitions.LBJwtAuthAction);
        add(mapping,
            "com.vmware.nsx_global_policy.model.LB_jwt_certificate_key",
            com.vmware.nsx_global_policy.model.StructDefinitions.LBJwtCertificateKey);
        add(mapping,
            "com.vmware.nsx_global_policy.model.LB_jwt_key",
            com.vmware.nsx_global_policy.model.StructDefinitions.LBJwtKey);
        add(mapping,
            "com.vmware.nsx_global_policy.model.LB_jwt_public_key",
            com.vmware.nsx_global_policy.model.StructDefinitions.LBJwtPublicKey);
        add(mapping,
            "com.vmware.nsx_global_policy.model.LB_jwt_symmetric_key",
            com.vmware.nsx_global_policy.model.StructDefinitions.LBJwtSymmetricKey);
        add(mapping,
            "com.vmware.nsx_global_policy.model.LB_monitor_profile",
            com.vmware.nsx_global_policy.model.StructDefinitions.LBMonitorProfile);
        add(mapping,
            "com.vmware.nsx_global_policy.model.LB_passive_monitor_profile",
            com.vmware.nsx_global_policy.model.StructDefinitions.LBPassiveMonitorProfile);
        add(mapping,
            "com.vmware.nsx_global_policy.model.LB_persistence_cookie_time",
            com.vmware.nsx_global_policy.model.StructDefinitions.LBPersistenceCookieTime);
        add(mapping,
            "com.vmware.nsx_global_policy.model.LB_persistence_profile",
            com.vmware.nsx_global_policy.model.StructDefinitions.LBPersistenceProfile);
        add(mapping,
            "com.vmware.nsx_global_policy.model.LB_pool",
            com.vmware.nsx_global_policy.model.StructDefinitions.LBPool);
        add(mapping,
            "com.vmware.nsx_global_policy.model.LB_pool_member",
            com.vmware.nsx_global_policy.model.StructDefinitions.LBPoolMember);
        add(mapping,
            "com.vmware.nsx_global_policy.model.LB_pool_member_group",
            com.vmware.nsx_global_policy.model.StructDefinitions.LBPoolMemberGroup);
        add(mapping,
            "com.vmware.nsx_global_policy.model.LB_rule",
            com.vmware.nsx_global_policy.model.StructDefinitions.LBRule);
        add(mapping,
            "com.vmware.nsx_global_policy.model.LB_rule_action",
            com.vmware.nsx_global_policy.model.StructDefinitions.LBRuleAction);
        add(mapping,
            "com.vmware.nsx_global_policy.model.LB_rule_condition",
            com.vmware.nsx_global_policy.model.StructDefinitions.LBRuleCondition);
        add(mapping,
            "com.vmware.nsx_global_policy.model.LB_select_pool_action",
            com.vmware.nsx_global_policy.model.StructDefinitions.LBSelectPoolAction);
        add(mapping,
            "com.vmware.nsx_global_policy.model.LB_server_ssl_profile",
            com.vmware.nsx_global_policy.model.StructDefinitions.LBServerSslProfile);
        add(mapping,
            "com.vmware.nsx_global_policy.model.LB_server_ssl_profile_binding",
            com.vmware.nsx_global_policy.model.StructDefinitions.LBServerSslProfileBinding);
        add(mapping,
            "com.vmware.nsx_global_policy.model.LB_service",
            com.vmware.nsx_global_policy.model.StructDefinitions.LBService);
        add(mapping,
            "com.vmware.nsx_global_policy.model.LB_session_cookie_time",
            com.vmware.nsx_global_policy.model.StructDefinitions.LBSessionCookieTime);
        add(mapping,
            "com.vmware.nsx_global_policy.model.LB_snat_auto_map",
            com.vmware.nsx_global_policy.model.StructDefinitions.LBSnatAutoMap);
        add(mapping,
            "com.vmware.nsx_global_policy.model.LB_snat_disabled",
            com.vmware.nsx_global_policy.model.StructDefinitions.LBSnatDisabled);
        add(mapping,
            "com.vmware.nsx_global_policy.model.LB_snat_ip_element",
            com.vmware.nsx_global_policy.model.StructDefinitions.LBSnatIpElement);
        add(mapping,
            "com.vmware.nsx_global_policy.model.LB_snat_ip_pool",
            com.vmware.nsx_global_policy.model.StructDefinitions.LBSnatIpPool);
        add(mapping,
            "com.vmware.nsx_global_policy.model.LB_snat_translation",
            com.vmware.nsx_global_policy.model.StructDefinitions.LBSnatTranslation);
        add(mapping,
            "com.vmware.nsx_global_policy.model.LB_source_ip_persistence_profile",
            com.vmware.nsx_global_policy.model.StructDefinitions.LBSourceIpPersistenceProfile);
        add(mapping,
            "com.vmware.nsx_global_policy.model.LB_ssl_mode_selection_action",
            com.vmware.nsx_global_policy.model.StructDefinitions.LBSslModeSelectionAction);
        add(mapping,
            "com.vmware.nsx_global_policy.model.LB_ssl_profile",
            com.vmware.nsx_global_policy.model.StructDefinitions.LBSslProfile);
        add(mapping,
            "com.vmware.nsx_global_policy.model.LB_ssl_sni_condition",
            com.vmware.nsx_global_policy.model.StructDefinitions.LBSslSniCondition);
        add(mapping,
            "com.vmware.nsx_global_policy.model.LB_tcp_header_condition",
            com.vmware.nsx_global_policy.model.StructDefinitions.LBTcpHeaderCondition);
        add(mapping,
            "com.vmware.nsx_global_policy.model.LB_tcp_monitor_profile",
            com.vmware.nsx_global_policy.model.StructDefinitions.LBTcpMonitorProfile);
        add(mapping,
            "com.vmware.nsx_global_policy.model.LB_udp_monitor_profile",
            com.vmware.nsx_global_policy.model.StructDefinitions.LBUdpMonitorProfile);
        add(mapping,
            "com.vmware.nsx_global_policy.model.LB_variable_assignment_action",
            com.vmware.nsx_global_policy.model.StructDefinitions.LBVariableAssignmentAction);
        add(mapping,
            "com.vmware.nsx_global_policy.model.LB_variable_condition",
            com.vmware.nsx_global_policy.model.StructDefinitions.LBVariableCondition);
        add(mapping,
            "com.vmware.nsx_global_policy.model.LB_variable_persistence_learn_action",
            com.vmware.nsx_global_policy.model.StructDefinitions.LBVariablePersistenceLearnAction);
        add(mapping,
            "com.vmware.nsx_global_policy.model.LB_variable_persistence_on_action",
            com.vmware.nsx_global_policy.model.StructDefinitions.LBVariablePersistenceOnAction);
        add(mapping,
            "com.vmware.nsx_global_policy.model.LB_virtual_server",
            com.vmware.nsx_global_policy.model.StructDefinitions.LBVirtualServer);
        add(mapping,
            "com.vmware.nsx_global_policy.model.label",
            com.vmware.nsx_global_policy.model.StructDefinitions.label);
        add(mapping,
            "com.vmware.nsx_global_policy.model.label_value_configuration",
            com.vmware.nsx_global_policy.model.StructDefinitions.labelValueConfiguration);
        add(mapping,
            "com.vmware.nsx_global_policy.model.layout",
            com.vmware.nsx_global_policy.model.StructDefinitions.layout);
        add(mapping,
            "com.vmware.nsx_global_policy.model.layout_properties",
            com.vmware.nsx_global_policy.model.StructDefinitions.layoutProperties);
        add(mapping,
            "com.vmware.nsx_global_policy.model.lb_http_request_header",
            com.vmware.nsx_global_policy.model.StructDefinitions.lbHttpRequestHeader);
        add(mapping,
            "com.vmware.nsx_global_policy.model.ldap_identity_source",
            com.vmware.nsx_global_policy.model.StructDefinitions.ldapIdentitySource);
        add(mapping,
            "com.vmware.nsx_global_policy.model.ldap_identity_source_list_result",
            com.vmware.nsx_global_policy.model.StructDefinitions.ldapIdentitySourceListResult);
        add(mapping,
            "com.vmware.nsx_global_policy.model.ldap_identity_source_probe_results",
            com.vmware.nsx_global_policy.model.StructDefinitions.ldapIdentitySourceProbeResults);
        add(mapping,
            "com.vmware.nsx_global_policy.model.ldap_identity_source_search_result_item",
            com.vmware.nsx_global_policy.model.StructDefinitions.ldapIdentitySourceSearchResultItem);
        add(mapping,
            "com.vmware.nsx_global_policy.model.ldap_identity_source_search_result_list",
            com.vmware.nsx_global_policy.model.StructDefinitions.ldapIdentitySourceSearchResultList);
        add(mapping,
            "com.vmware.nsx_global_policy.model.ldap_probe_error",
            com.vmware.nsx_global_policy.model.StructDefinitions.ldapProbeError);
        add(mapping,
            "com.vmware.nsx_global_policy.model.legend",
            com.vmware.nsx_global_policy.model.StructDefinitions.legend);
        add(mapping,
            "com.vmware.nsx_global_policy.model.legend_widget_configuration",
            com.vmware.nsx_global_policy.model.StructDefinitions.legendWidgetConfiguration);
        add(mapping,
            "com.vmware.nsx_global_policy.model.line_chart_plot_configuration",
            com.vmware.nsx_global_policy.model.StructDefinitions.lineChartPlotConfiguration);
        add(mapping,
            "com.vmware.nsx_global_policy.model.list_result",
            com.vmware.nsx_global_policy.model.StructDefinitions.listResult);
        add(mapping,
            "com.vmware.nsx_global_policy.model.live_trace_config",
            com.vmware.nsx_global_policy.model.StructDefinitions.liveTraceConfig);
        add(mapping,
            "com.vmware.nsx_global_policy.model.live_trace_filter_data",
            com.vmware.nsx_global_policy.model.StructDefinitions.liveTraceFilterData);
        add(mapping,
            "com.vmware.nsx_global_policy.model.live_trace_packet_granular_action_config",
            com.vmware.nsx_global_policy.model.StructDefinitions.liveTracePacketGranularActionConfig);
        add(mapping,
            "com.vmware.nsx_global_policy.model.live_trace_sampling_config",
            com.vmware.nsx_global_policy.model.StructDefinitions.liveTraceSamplingConfig);
        add(mapping,
            "com.vmware.nsx_global_policy.model.load_balancer_VPC_endpoint",
            com.vmware.nsx_global_policy.model.StructDefinitions.loadBalancerVPCEndpoint);
        add(mapping,
            "com.vmware.nsx_global_policy.model.local_egress",
            com.vmware.nsx_global_policy.model.StructDefinitions.localEgress);
        add(mapping,
            "com.vmware.nsx_global_policy.model.local_egress_routing_entry",
            com.vmware.nsx_global_policy.model.StructDefinitions.localEgressRoutingEntry);
        add(mapping,
            "com.vmware.nsx_global_policy.model.locale_services",
            com.vmware.nsx_global_policy.model.StructDefinitions.localeServices);
        add(mapping,
            "com.vmware.nsx_global_policy.model.locale_services_list_result",
            com.vmware.nsx_global_policy.model.StructDefinitions.localeServicesListResult);
        add(mapping,
            "com.vmware.nsx_global_policy.model.logical_port_operational_status",
            com.vmware.nsx_global_policy.model.StructDefinitions.logicalPortOperationalStatus);
        add(mapping,
            "com.vmware.nsx_global_policy.model.logical_port_statistics",
            com.vmware.nsx_global_policy.model.StructDefinitions.logicalPortStatistics);
        add(mapping,
            "com.vmware.nsx_global_policy.model.logical_router_port_counters",
            com.vmware.nsx_global_policy.model.StructDefinitions.logicalRouterPortCounters);
        add(mapping,
            "com.vmware.nsx_global_policy.model.logical_router_port_statistics",
            com.vmware.nsx_global_policy.model.StructDefinitions.logicalRouterPortStatistics);
        add(mapping,
            "com.vmware.nsx_global_policy.model.logical_router_port_statistics_per_node",
            com.vmware.nsx_global_policy.model.StructDefinitions.logicalRouterPortStatisticsPerNode);
        add(mapping,
            "com.vmware.nsx_global_policy.model.logical_router_port_statistics_summary",
            com.vmware.nsx_global_policy.model.StructDefinitions.logicalRouterPortStatisticsSummary);
        add(mapping,
            "com.vmware.nsx_global_policy.model.logical_router_state",
            com.vmware.nsx_global_policy.model.StructDefinitions.logicalRouterState);
        add(mapping,
            "com.vmware.nsx_global_policy.model.logical_router_status",
            com.vmware.nsx_global_policy.model.StructDefinitions.logicalRouterStatus);
        add(mapping,
            "com.vmware.nsx_global_policy.model.logical_router_status_per_node",
            com.vmware.nsx_global_policy.model.StructDefinitions.logicalRouterStatusPerNode);
        add(mapping,
            "com.vmware.nsx_global_policy.model.logical_switch_statistics",
            com.vmware.nsx_global_policy.model.StructDefinitions.logicalSwitchStatistics);
        add(mapping,
            "com.vmware.nsx_global_policy.model.MAC_address_expression",
            com.vmware.nsx_global_policy.model.StructDefinitions.MACAddressExpression);
        add(mapping,
            "com.vmware.nsx_global_policy.model.MAC_address_list",
            com.vmware.nsx_global_policy.model.StructDefinitions.MACAddressList);
        add(mapping,
            "com.vmware.nsx_global_policy.model.mac_address_csv_list_result",
            com.vmware.nsx_global_policy.model.StructDefinitions.macAddressCsvListResult);
        add(mapping,
            "com.vmware.nsx_global_policy.model.mac_discovery_profile",
            com.vmware.nsx_global_policy.model.StructDefinitions.macDiscoveryProfile);
        add(mapping,
            "com.vmware.nsx_global_policy.model.mac_discovery_profile_list_result",
            com.vmware.nsx_global_policy.model.StructDefinitions.macDiscoveryProfileListResult);
        add(mapping,
            "com.vmware.nsx_global_policy.model.mac_learning_counters",
            com.vmware.nsx_global_policy.model.StructDefinitions.macLearningCounters);
        add(mapping,
            "com.vmware.nsx_global_policy.model.mac_table_csv_record",
            com.vmware.nsx_global_policy.model.StructDefinitions.macTableCsvRecord);
        add(mapping,
            "com.vmware.nsx_global_policy.model.mac_table_entry",
            com.vmware.nsx_global_policy.model.StructDefinitions.macTableEntry);
        add(mapping,
            "com.vmware.nsx_global_policy.model.malware_prevention_profile",
            com.vmware.nsx_global_policy.model.StructDefinitions.malwarePreventionProfile);
        add(mapping,
            "com.vmware.nsx_global_policy.model.malware_prevention_signature",
            com.vmware.nsx_global_policy.model.StructDefinitions.malwarePreventionSignature);
        add(mapping,
            "com.vmware.nsx_global_policy.model.managed_resource",
            com.vmware.nsx_global_policy.model.StructDefinitions.managedResource);
        add(mapping,
            "com.vmware.nsx_global_policy.model.management_config",
            com.vmware.nsx_global_policy.model.StructDefinitions.managementConfig);
        add(mapping,
            "com.vmware.nsx_global_policy.model.metadata_proxy_config",
            com.vmware.nsx_global_policy.model.StructDefinitions.metadataProxyConfig);
        add(mapping,
            "com.vmware.nsx_global_policy.model.metadata_proxy_statistics_per_segment",
            com.vmware.nsx_global_policy.model.StructDefinitions.metadataProxyStatisticsPerSegment);
        add(mapping,
            "com.vmware.nsx_global_policy.model.mitre_attack",
            com.vmware.nsx_global_policy.model.StructDefinitions.mitreAttack);
        add(mapping,
            "com.vmware.nsx_global_policy.model.monitoring_error",
            com.vmware.nsx_global_policy.model.StructDefinitions.monitoringError);
        add(mapping,
            "com.vmware.nsx_global_policy.model.monitoring_info",
            com.vmware.nsx_global_policy.model.StructDefinitions.monitoringInfo);
        add(mapping,
            "com.vmware.nsx_global_policy.model.monitoring_profile_binding_map",
            com.vmware.nsx_global_policy.model.StructDefinitions.monitoringProfileBindingMap);
        add(mapping,
            "com.vmware.nsx_global_policy.model.multi_widget_configuration",
            com.vmware.nsx_global_policy.model.StructDefinitions.multiWidgetConfiguration);
        add(mapping,
            "com.vmware.nsx_global_policy.model.NDRA_advertised_route",
            com.vmware.nsx_global_policy.model.StructDefinitions.NDRAAdvertisedRoute);
        add(mapping,
            "com.vmware.nsx_global_policy.model.NSX_manager_deployment_info",
            com.vmware.nsx_global_policy.model.StructDefinitions.NSXManagerDeploymentInfo);
        add(mapping,
            "com.vmware.nsx_global_policy.model.NSXT_connection_info",
            com.vmware.nsx_global_policy.model.StructDefinitions.NSXTConnectionInfo);
        add(mapping,
            "com.vmware.nsx_global_policy.model.NSXV_connection_info",
            com.vmware.nsx_global_policy.model.StructDefinitions.NSXVConnectionInfo);
        add(mapping,
            "com.vmware.nsx_global_policy.model.namespace_member_details",
            com.vmware.nsx_global_policy.model.StructDefinitions.namespaceMemberDetails);
        add(mapping,
            "com.vmware.nsx_global_policy.model.nd_snooping_config",
            com.vmware.nsx_global_policy.model.StructDefinitions.ndSnoopingConfig);
        add(mapping,
            "com.vmware.nsx_global_policy.model.ndp_header",
            com.vmware.nsx_global_policy.model.StructDefinitions.ndpHeader);
        add(mapping,
            "com.vmware.nsx_global_policy.model.nested_expression",
            com.vmware.nsx_global_policy.model.StructDefinitions.nestedExpression);
        add(mapping,
            "com.vmware.nsx_global_policy.model.nested_service_service_entry",
            com.vmware.nsx_global_policy.model.StructDefinitions.nestedServiceServiceEntry);
        add(mapping,
            "com.vmware.nsx_global_policy.model.network_info",
            com.vmware.nsx_global_policy.model.StructDefinitions.networkInfo);
        add(mapping,
            "com.vmware.nsx_global_policy.model.new_role",
            com.vmware.nsx_global_policy.model.StructDefinitions.newRole);
        add(mapping,
            "com.vmware.nsx_global_policy.model.node_user_settings",
            com.vmware.nsx_global_policy.model.StructDefinitions.nodeUserSettings);
        add(mapping,
            "com.vmware.nsx_global_policy.model.nsx_role",
            com.vmware.nsx_global_policy.model.StructDefinitions.nsxRole);
        add(mapping,
            "com.vmware.nsx_global_policy.model.nsx_TDNS_forwarder_statistics",
            com.vmware.nsx_global_policy.model.StructDefinitions.nsxTDNSForwarderStatistics);
        add(mapping,
            "com.vmware.nsx_global_policy.model.nsx_TDNS_forwarder_status",
            com.vmware.nsx_global_policy.model.StructDefinitions.nsxTDNSForwarderStatus);
        add(mapping,
            "com.vmware.nsx_global_policy.model.nsx_TDNS_forwarder_zone_statistics",
            com.vmware.nsx_global_policy.model.StructDefinitions.nsxTDNSForwarderZoneStatistics);
        add(mapping,
            "com.vmware.nsx_global_policy.model.nsxt_dns_answer",
            com.vmware.nsx_global_policy.model.StructDefinitions.nsxtDnsAnswer);
        add(mapping,
            "com.vmware.nsx_global_policy.model.nsxt_dns_query_answer",
            com.vmware.nsx_global_policy.model.StructDefinitions.nsxtDnsQueryAnswer);
        add(mapping,
            "com.vmware.nsx_global_policy.model.nsxt_per_node_used_cache_statistics",
            com.vmware.nsx_global_policy.model.StructDefinitions.nsxtPerNodeUsedCacheStatistics);
        add(mapping,
            "com.vmware.nsx_global_policy.model.nsxt_upstream_server_statistics",
            com.vmware.nsx_global_policy.model.StructDefinitions.nsxtUpstreamServerStatistics);
        add(mapping,
            "com.vmware.nsx_global_policy.model.ods_runbook_invocation",
            com.vmware.nsx_global_policy.model.StructDefinitions.odsRunbookInvocation);
        add(mapping,
            "com.vmware.nsx_global_policy.model.ods_runbook_invocation_artifact_batch_request",
            com.vmware.nsx_global_policy.model.StructDefinitions.odsRunbookInvocationArtifactBatchRequest);
        add(mapping,
            "com.vmware.nsx_global_policy.model.onboarding_attribute",
            com.vmware.nsx_global_policy.model.StructDefinitions.onboardingAttribute);
        add(mapping,
            "com.vmware.nsx_global_policy.model.onboarding_feature_info",
            com.vmware.nsx_global_policy.model.StructDefinitions.onboardingFeatureInfo);
        add(mapping,
            "com.vmware.nsx_global_policy.model.open_ldap_identity_source",
            com.vmware.nsx_global_policy.model.StructDefinitions.openLdapIdentitySource);
        add(mapping,
            "com.vmware.nsx_global_policy.model.operation_vertical_config",
            com.vmware.nsx_global_policy.model.StructDefinitions.operationVerticalConfig);
        add(mapping,
            "com.vmware.nsx_global_policy.model.ops_global_config",
            com.vmware.nsx_global_policy.model.StructDefinitions.opsGlobalConfig);
        add(mapping,
            "com.vmware.nsx_global_policy.model.org",
            com.vmware.nsx_global_policy.model.StructDefinitions.org);
        add(mapping,
            "com.vmware.nsx_global_policy.model.org_root",
            com.vmware.nsx_global_policy.model.StructDefinitions.orgRoot);
        add(mapping,
            "com.vmware.nsx_global_policy.model.ospf_area_config",
            com.vmware.nsx_global_policy.model.StructDefinitions.ospfAreaConfig);
        add(mapping,
            "com.vmware.nsx_global_policy.model.ospf_authentication_config",
            com.vmware.nsx_global_policy.model.StructDefinitions.ospfAuthenticationConfig);
        add(mapping,
            "com.vmware.nsx_global_policy.model.ospf_routing_config",
            com.vmware.nsx_global_policy.model.StructDefinitions.ospfRoutingConfig);
        add(mapping,
            "com.vmware.nsx_global_policy.model.ospf_summary_address_config",
            com.vmware.nsx_global_policy.model.StructDefinitions.ospfSummaryAddressConfig);
        add(mapping,
            "com.vmware.nsx_global_policy.model.overridden_resource",
            com.vmware.nsx_global_policy.model.StructDefinitions.overriddenResource);
        add(mapping,
            "com.vmware.nsx_global_policy.model.overridden_resource_list_result",
            com.vmware.nsx_global_policy.model.StructDefinitions.overriddenResourceListResult);
        add(mapping,
            "com.vmware.nsx_global_policy.model.packet_address_classifier",
            com.vmware.nsx_global_policy.model.StructDefinitions.packetAddressClassifier);
        add(mapping,
            "com.vmware.nsx_global_policy.model.packet_data",
            com.vmware.nsx_global_policy.model.StructDefinitions.packetData);
        add(mapping,
            "com.vmware.nsx_global_policy.model.packet_type_and_counter",
            com.vmware.nsx_global_policy.model.StructDefinitions.packetTypeAndCounter);
        add(mapping,
            "com.vmware.nsx_global_policy.model.packets_dropped_by_security",
            com.vmware.nsx_global_policy.model.StructDefinitions.packetsDroppedBySecurity);
        add(mapping,
            "com.vmware.nsx_global_policy.model.partial_patch_config",
            com.vmware.nsx_global_policy.model.StructDefinitions.partialPatchConfig);
        add(mapping,
            "com.vmware.nsx_global_policy.model.patch_resources",
            com.vmware.nsx_global_policy.model.StructDefinitions.patchResources);
        add(mapping,
            "com.vmware.nsx_global_policy.model.path_expression",
            com.vmware.nsx_global_policy.model.StructDefinitions.pathExpression);
        add(mapping,
            "com.vmware.nsx_global_policy.model.peer_certificate_chain",
            com.vmware.nsx_global_policy.model.StructDefinitions.peerCertificateChain);
        add(mapping,
            "com.vmware.nsx_global_policy.model.pending_changes_info_nsxt",
            com.vmware.nsx_global_policy.model.StructDefinitions.pendingChangesInfoNsxt);
        add(mapping,
            "com.vmware.nsx_global_policy.model.per_step_restore_status",
            com.vmware.nsx_global_policy.model.StructDefinitions.perStepRestoreStatus);
        add(mapping,
            "com.vmware.nsx_global_policy.model.plain_filter_data",
            com.vmware.nsx_global_policy.model.StructDefinitions.plainFilterData);
        add(mapping,
            "com.vmware.nsx_global_policy.model.point_definition",
            com.vmware.nsx_global_policy.model.StructDefinitions.pointDefinition);
        add(mapping,
            "com.vmware.nsx_global_policy.model.policy",
            com.vmware.nsx_global_policy.model.StructDefinitions.policy);
        add(mapping,
            "com.vmware.nsx_global_policy.model.policy_advertised_network",
            com.vmware.nsx_global_policy.model.StructDefinitions.policyAdvertisedNetwork);
        add(mapping,
            "com.vmware.nsx_global_policy.model.policy_advertised_network_in_csv_format",
            com.vmware.nsx_global_policy.model.StructDefinitions.policyAdvertisedNetworkInCsvFormat);
        add(mapping,
            "com.vmware.nsx_global_policy.model.policy_advertised_networks_list_result",
            com.vmware.nsx_global_policy.model.StructDefinitions.policyAdvertisedNetworksListResult);
        add(mapping,
            "com.vmware.nsx_global_policy.model.policy_alarm_resource",
            com.vmware.nsx_global_policy.model.StructDefinitions.policyAlarmResource);
        add(mapping,
            "com.vmware.nsx_global_policy.model.policy_alarm_resource_list_result",
            com.vmware.nsx_global_policy.model.StructDefinitions.policyAlarmResourceListResult);
        add(mapping,
            "com.vmware.nsx_global_policy.model.policy_api_error",
            com.vmware.nsx_global_policy.model.StructDefinitions.policyApiError);
        add(mapping,
            "com.vmware.nsx_global_policy.model.policy_arp_proxy_entry",
            com.vmware.nsx_global_policy.model.StructDefinitions.policyArpProxyEntry);
        add(mapping,
            "com.vmware.nsx_global_policy.model.policy_arp_proxy_table_csv_list_result",
            com.vmware.nsx_global_policy.model.StructDefinitions.policyArpProxyTableCsvListResult);
        add(mapping,
            "com.vmware.nsx_global_policy.model.policy_arp_proxy_table_list_result",
            com.vmware.nsx_global_policy.model.StructDefinitions.policyArpProxyTableListResult);
        add(mapping,
            "com.vmware.nsx_global_policy.model.policy_attributes",
            com.vmware.nsx_global_policy.model.StructDefinitions.policyAttributes);
        add(mapping,
            "com.vmware.nsx_global_policy.model.policy_based_IP_sec_vpn_session",
            com.vmware.nsx_global_policy.model.StructDefinitions.policyBasedIPSecVpnSession);
        add(mapping,
            "com.vmware.nsx_global_policy.model.policy_based_l3_vpn_session",
            com.vmware.nsx_global_policy.model.StructDefinitions.policyBasedL3VpnSession);
        add(mapping,
            "com.vmware.nsx_global_policy.model.policy_bgp_neighbor_status",
            com.vmware.nsx_global_policy.model.StructDefinitions.policyBgpNeighborStatus);
        add(mapping,
            "com.vmware.nsx_global_policy.model.policy_bgp_neighbors_status_list_result",
            com.vmware.nsx_global_policy.model.StructDefinitions.policyBgpNeighborsStatusListResult);
        add(mapping,
            "com.vmware.nsx_global_policy.model.policy_compliance_status",
            com.vmware.nsx_global_policy.model.StructDefinitions.policyComplianceStatus);
        add(mapping,
            "com.vmware.nsx_global_policy.model.policy_config_resource",
            com.vmware.nsx_global_policy.model.StructDefinitions.policyConfigResource);
        add(mapping,
            "com.vmware.nsx_global_policy.model.policy_container_group_member_details",
            com.vmware.nsx_global_policy.model.StructDefinitions.policyContainerGroupMemberDetails);
        add(mapping,
            "com.vmware.nsx_global_policy.model.policy_container_group_members_list_result",
            com.vmware.nsx_global_policy.model.StructDefinitions.policyContainerGroupMembersListResult);
        add(mapping,
            "com.vmware.nsx_global_policy.model.policy_context_profile",
            com.vmware.nsx_global_policy.model.StructDefinitions.policyContextProfile);
        add(mapping,
            "com.vmware.nsx_global_policy.model.policy_context_profile_list_result",
            com.vmware.nsx_global_policy.model.StructDefinitions.policyContextProfileListResult);
        add(mapping,
            "com.vmware.nsx_global_policy.model.policy_custom_attributes",
            com.vmware.nsx_global_policy.model.StructDefinitions.policyCustomAttributes);
        add(mapping,
            "com.vmware.nsx_global_policy.model.policy_dns_answer_per_enforcement_point",
            com.vmware.nsx_global_policy.model.StructDefinitions.policyDnsAnswerPerEnforcementPoint);
        add(mapping,
            "com.vmware.nsx_global_policy.model.policy_dns_forwarder",
            com.vmware.nsx_global_policy.model.StructDefinitions.policyDnsForwarder);
        add(mapping,
            "com.vmware.nsx_global_policy.model.policy_dns_forwarder_zone",
            com.vmware.nsx_global_policy.model.StructDefinitions.policyDnsForwarderZone);
        add(mapping,
            "com.vmware.nsx_global_policy.model.policy_dns_forwarder_zone_list_result",
            com.vmware.nsx_global_policy.model.StructDefinitions.policyDnsForwarderZoneListResult);
        add(mapping,
            "com.vmware.nsx_global_policy.model.policy_draft",
            com.vmware.nsx_global_policy.model.StructDefinitions.policyDraft);
        add(mapping,
            "com.vmware.nsx_global_policy.model.policy_draft_list_result",
            com.vmware.nsx_global_policy.model.StructDefinitions.policyDraftListResult);
        add(mapping,
            "com.vmware.nsx_global_policy.model.policy_draft_paginated_aggregated_configuration_result",
            com.vmware.nsx_global_policy.model.StructDefinitions.policyDraftPaginatedAggregatedConfigurationResult);
        add(mapping,
            "com.vmware.nsx_global_policy.model.policy_edge_cluster",
            com.vmware.nsx_global_policy.model.StructDefinitions.policyEdgeCluster);
        add(mapping,
            "com.vmware.nsx_global_policy.model.policy_edge_cluster_inter_site_bgp_summary",
            com.vmware.nsx_global_policy.model.StructDefinitions.policyEdgeClusterInterSiteBgpSummary);
        add(mapping,
            "com.vmware.nsx_global_policy.model.policy_edge_cluster_inter_site_status",
            com.vmware.nsx_global_policy.model.StructDefinitions.policyEdgeClusterInterSiteStatus);
        add(mapping,
            "com.vmware.nsx_global_policy.model.policy_edge_cluster_list_result",
            com.vmware.nsx_global_policy.model.StructDefinitions.policyEdgeClusterListResult);
        add(mapping,
            "com.vmware.nsx_global_policy.model.policy_edge_cluster_member_inter_site_status",
            com.vmware.nsx_global_policy.model.StructDefinitions.policyEdgeClusterMemberInterSiteStatus);
        add(mapping,
            "com.vmware.nsx_global_policy.model.policy_edge_node",
            com.vmware.nsx_global_policy.model.StructDefinitions.policyEdgeNode);
        add(mapping,
            "com.vmware.nsx_global_policy.model.policy_edge_node_inter_site_bgp_summary",
            com.vmware.nsx_global_policy.model.StructDefinitions.policyEdgeNodeInterSiteBgpSummary);
        add(mapping,
            "com.vmware.nsx_global_policy.model.policy_edge_node_list_result",
            com.vmware.nsx_global_policy.model.StructDefinitions.policyEdgeNodeListResult);
        add(mapping,
            "com.vmware.nsx_global_policy.model.policy_exclude_list",
            com.vmware.nsx_global_policy.model.StructDefinitions.policyExcludeList);
        add(mapping,
            "com.vmware.nsx_global_policy.model.policy_fine_tuning_resource_info",
            com.vmware.nsx_global_policy.model.StructDefinitions.policyFineTuningResourceInfo);
        add(mapping,
            "com.vmware.nsx_global_policy.model.policy_fine_tuning_resource_info_detail",
            com.vmware.nsx_global_policy.model.StructDefinitions.policyFineTuningResourceInfoDetail);
        add(mapping,
            "com.vmware.nsx_global_policy.model.policy_firewall_CPU_mem_thresholds_profile_binding_map",
            com.vmware.nsx_global_policy.model.StructDefinitions.policyFirewallCPUMemThresholdsProfileBindingMap);
        add(mapping,
            "com.vmware.nsx_global_policy.model.policy_firewall_CPU_mem_thresholds_profile_binding_map_list_result",
            com.vmware.nsx_global_policy.model.StructDefinitions.policyFirewallCPUMemThresholdsProfileBindingMapListResult);
        add(mapping,
            "com.vmware.nsx_global_policy.model.policy_firewall_cpu_mem_thresholds_profile",
            com.vmware.nsx_global_policy.model.StructDefinitions.policyFirewallCpuMemThresholdsProfile);
        add(mapping,
            "com.vmware.nsx_global_policy.model.policy_firewall_cpu_mem_thresholds_profile_list_result",
            com.vmware.nsx_global_policy.model.StructDefinitions.policyFirewallCpuMemThresholdsProfileListResult);
        add(mapping,
            "com.vmware.nsx_global_policy.model.policy_firewall_flood_protection_profile_binding_map",
            com.vmware.nsx_global_policy.model.StructDefinitions.policyFirewallFloodProtectionProfileBindingMap);
        add(mapping,
            "com.vmware.nsx_global_policy.model.policy_firewall_flood_protection_profile_binding_map_list_result",
            com.vmware.nsx_global_policy.model.StructDefinitions.policyFirewallFloodProtectionProfileBindingMapListResult);
        add(mapping,
            "com.vmware.nsx_global_policy.model.policy_firewall_ip_reputation_config",
            com.vmware.nsx_global_policy.model.StructDefinitions.policyFirewallIpReputationConfig);
        add(mapping,
            "com.vmware.nsx_global_policy.model.policy_firewall_scheduler",
            com.vmware.nsx_global_policy.model.StructDefinitions.policyFirewallScheduler);
        add(mapping,
            "com.vmware.nsx_global_policy.model.policy_firewall_scheduler_list_result",
            com.vmware.nsx_global_policy.model.StructDefinitions.policyFirewallSchedulerListResult);
        add(mapping,
            "com.vmware.nsx_global_policy.model.policy_firewall_session_timer_profile",
            com.vmware.nsx_global_policy.model.StructDefinitions.policyFirewallSessionTimerProfile);
        add(mapping,
            "com.vmware.nsx_global_policy.model.policy_firewall_session_timer_profile_binding_map",
            com.vmware.nsx_global_policy.model.StructDefinitions.policyFirewallSessionTimerProfileBindingMap);
        add(mapping,
            "com.vmware.nsx_global_policy.model.policy_firewall_session_timer_profile_binding_map_list_result",
            com.vmware.nsx_global_policy.model.StructDefinitions.policyFirewallSessionTimerProfileBindingMapListResult);
        add(mapping,
            "com.vmware.nsx_global_policy.model.policy_firewall_session_timer_profile_list_result",
            com.vmware.nsx_global_policy.model.StructDefinitions.policyFirewallSessionTimerProfileListResult);
        add(mapping,
            "com.vmware.nsx_global_policy.model.policy_group_IP_members_list_result",
            com.vmware.nsx_global_policy.model.StructDefinitions.policyGroupIPMembersListResult);
        add(mapping,
            "com.vmware.nsx_global_policy.model.policy_group_member_details",
            com.vmware.nsx_global_policy.model.StructDefinitions.policyGroupMemberDetails);
        add(mapping,
            "com.vmware.nsx_global_policy.model.policy_group_members_list_result",
            com.vmware.nsx_global_policy.model.StructDefinitions.policyGroupMembersListResult);
        add(mapping,
            "com.vmware.nsx_global_policy.model.policy_IP_address_info",
            com.vmware.nsx_global_policy.model.StructDefinitions.policyIPAddressInfo);
        add(mapping,
            "com.vmware.nsx_global_policy.model.policy_igmp_profile",
            com.vmware.nsx_global_policy.model.StructDefinitions.policyIgmpProfile);
        add(mapping,
            "com.vmware.nsx_global_policy.model.policy_insert_parameters",
            com.vmware.nsx_global_policy.model.StructDefinitions.policyInsertParameters);
        add(mapping,
            "com.vmware.nsx_global_policy.model.policy_inter_vrf_routing_config",
            com.vmware.nsx_global_policy.model.StructDefinitions.policyInterVrfRoutingConfig);
        add(mapping,
            "com.vmware.nsx_global_policy.model.policy_interface_group_statistics",
            com.vmware.nsx_global_policy.model.StructDefinitions.policyInterfaceGroupStatistics);
        add(mapping,
            "com.vmware.nsx_global_policy.model.policy_interface_ospf_config",
            com.vmware.nsx_global_policy.model.StructDefinitions.policyInterfaceOspfConfig);
        add(mapping,
            "com.vmware.nsx_global_policy.model.policy_interface_statistics",
            com.vmware.nsx_global_policy.model.StructDefinitions.policyInterfaceStatistics);
        add(mapping,
            "com.vmware.nsx_global_policy.model.policy_interface_statistics_summary",
            com.vmware.nsx_global_policy.model.StructDefinitions.policyInterfaceStatisticsSummary);
        add(mapping,
            "com.vmware.nsx_global_policy.model.policy_l2_tables_parameters",
            com.vmware.nsx_global_policy.model.StructDefinitions.policyL2TablesParameters);
        add(mapping,
            "com.vmware.nsx_global_policy.model.policy_label",
            com.vmware.nsx_global_policy.model.StructDefinitions.policyLabel);
        add(mapping,
            "com.vmware.nsx_global_policy.model.policy_label_list_result",
            com.vmware.nsx_global_policy.model.StructDefinitions.policyLabelListResult);
        add(mapping,
            "com.vmware.nsx_global_policy.model.policy_latency_stat_profile",
            com.vmware.nsx_global_policy.model.StructDefinitions.policyLatencyStatProfile);
        add(mapping,
            "com.vmware.nsx_global_policy.model.policy_latency_stat_profile_list_result",
            com.vmware.nsx_global_policy.model.StructDefinitions.policyLatencyStatProfileListResult);
        add(mapping,
            "com.vmware.nsx_global_policy.model.policy_list_result",
            com.vmware.nsx_global_policy.model.StructDefinitions.policyListResult);
        add(mapping,
            "com.vmware.nsx_global_policy.model.policy_live_trace_action_config",
            com.vmware.nsx_global_policy.model.StructDefinitions.policyLiveTraceActionConfig);
        add(mapping,
            "com.vmware.nsx_global_policy.model.policy_live_trace_ipsec_vpn_config",
            com.vmware.nsx_global_policy.model.StructDefinitions.policyLiveTraceIpsecVpnConfig);
        add(mapping,
            "com.vmware.nsx_global_policy.model.policy_metadata_proxy_statistics",
            com.vmware.nsx_global_policy.model.StructDefinitions.policyMetadataProxyStatistics);
        add(mapping,
            "com.vmware.nsx_global_policy.model.policy_metadata_proxy_status",
            com.vmware.nsx_global_policy.model.StructDefinitions.policyMetadataProxyStatus);
        add(mapping,
            "com.vmware.nsx_global_policy.model.policy_monitoring_config",
            com.vmware.nsx_global_policy.model.StructDefinitions.policyMonitoringConfig);
        add(mapping,
            "com.vmware.nsx_global_policy.model.policy_multicast_config",
            com.vmware.nsx_global_policy.model.StructDefinitions.policyMulticastConfig);
        add(mapping,
            "com.vmware.nsx_global_policy.model.policy_NAT_rule_counters",
            com.vmware.nsx_global_policy.model.StructDefinitions.policyNATRuleCounters);
        add(mapping,
            "com.vmware.nsx_global_policy.model.policy_nat",
            com.vmware.nsx_global_policy.model.StructDefinitions.policyNat);
        add(mapping,
            "com.vmware.nsx_global_policy.model.policy_nat_list_result",
            com.vmware.nsx_global_policy.model.StructDefinitions.policyNatListResult);
        add(mapping,
            "com.vmware.nsx_global_policy.model.policy_nat_rule",
            com.vmware.nsx_global_policy.model.StructDefinitions.policyNatRule);
        add(mapping,
            "com.vmware.nsx_global_policy.model.policy_nat_rule_list_result",
            com.vmware.nsx_global_policy.model.StructDefinitions.policyNatRuleListResult);
        add(mapping,
            "com.vmware.nsx_global_policy.model.policy_nat_rule_statistics",
            com.vmware.nsx_global_policy.model.StructDefinitions.policyNatRuleStatistics);
        add(mapping,
            "com.vmware.nsx_global_policy.model.policy_nat_rule_statistics_list_result",
            com.vmware.nsx_global_policy.model.StructDefinitions.policyNatRuleStatisticsListResult);
        add(mapping,
            "com.vmware.nsx_global_policy.model.policy_nat_rule_statistics_per_enforcement_point",
            com.vmware.nsx_global_policy.model.StructDefinitions.policyNatRuleStatisticsPerEnforcementPoint);
        add(mapping,
            "com.vmware.nsx_global_policy.model.policy_nat_rule_statistics_per_logical_router",
            com.vmware.nsx_global_policy.model.StructDefinitions.policyNatRuleStatisticsPerLogicalRouter);
        add(mapping,
            "com.vmware.nsx_global_policy.model.policy_nat_rule_statistics_per_logical_router_list_result",
            com.vmware.nsx_global_policy.model.StructDefinitions.policyNatRuleStatisticsPerLogicalRouterListResult);
        add(mapping,
            "com.vmware.nsx_global_policy.model.policy_nat_rule_statistics_per_transport_node",
            com.vmware.nsx_global_policy.model.StructDefinitions.policyNatRuleStatisticsPerTransportNode);
        add(mapping,
            "com.vmware.nsx_global_policy.model.policy_non_compliant_config",
            com.vmware.nsx_global_policy.model.StructDefinitions.policyNonCompliantConfig);
        add(mapping,
            "com.vmware.nsx_global_policy.model.policy_pim_profile",
            com.vmware.nsx_global_policy.model.StructDefinitions.policyPimProfile);
        add(mapping,
            "com.vmware.nsx_global_policy.model.policy_pool_usage",
            com.vmware.nsx_global_policy.model.StructDefinitions.policyPoolUsage);
        add(mapping,
            "com.vmware.nsx_global_policy.model.policy_realized_resource",
            com.vmware.nsx_global_policy.model.StructDefinitions.policyRealizedResource);
        add(mapping,
            "com.vmware.nsx_global_policy.model.policy_related_api_error",
            com.vmware.nsx_global_policy.model.StructDefinitions.policyRelatedApiError);
        add(mapping,
            "com.vmware.nsx_global_policy.model.policy_request_parameter",
            com.vmware.nsx_global_policy.model.StructDefinitions.policyRequestParameter);
        add(mapping,
            "com.vmware.nsx_global_policy.model.policy_resource",
            com.vmware.nsx_global_policy.model.StructDefinitions.policyResource);
        add(mapping,
            "com.vmware.nsx_global_policy.model.policy_resource_reference",
            com.vmware.nsx_global_policy.model.StructDefinitions.policyResourceReference);
        add(mapping,
            "com.vmware.nsx_global_policy.model.policy_resource_reference_for_EP",
            com.vmware.nsx_global_policy.model.StructDefinitions.policyResourceReferenceForEP);
        add(mapping,
            "com.vmware.nsx_global_policy.model.policy_resource_reference_for_EP_list_result",
            com.vmware.nsx_global_policy.model.StructDefinitions.policyResourceReferenceForEPListResult);
        add(mapping,
            "com.vmware.nsx_global_policy.model.policy_resource_reference_list_result",
            com.vmware.nsx_global_policy.model.StructDefinitions.policyResourceReferenceListResult);
        add(mapping,
            "com.vmware.nsx_global_policy.model.policy_route_advertisement_rule",
            com.vmware.nsx_global_policy.model.StructDefinitions.policyRouteAdvertisementRule);
        add(mapping,
            "com.vmware.nsx_global_policy.model.policy_runtime_alarm",
            com.vmware.nsx_global_policy.model.StructDefinitions.policyRuntimeAlarm);
        add(mapping,
            "com.vmware.nsx_global_policy.model.policy_runtime_info_per_EP",
            com.vmware.nsx_global_policy.model.StructDefinitions.policyRuntimeInfoPerEP);
        add(mapping,
            "com.vmware.nsx_global_policy.model.policy_SI_exclude_list",
            com.vmware.nsx_global_policy.model.StructDefinitions.policySIExcludeList);
        add(mapping,
            "com.vmware.nsx_global_policy.model.policy_SI_status_configuration",
            com.vmware.nsx_global_policy.model.StructDefinitions.policySIStatusConfiguration);
        add(mapping,
            "com.vmware.nsx_global_policy.model.policy_service_chain",
            com.vmware.nsx_global_policy.model.StructDefinitions.policyServiceChain);
        add(mapping,
            "com.vmware.nsx_global_policy.model.policy_service_instance",
            com.vmware.nsx_global_policy.model.StructDefinitions.policyServiceInstance);
        add(mapping,
            "com.vmware.nsx_global_policy.model.policy_service_profile",
            com.vmware.nsx_global_policy.model.StructDefinitions.policyServiceProfile);
        add(mapping,
            "com.vmware.nsx_global_policy.model.policy_static_route_advertisement",
            com.vmware.nsx_global_policy.model.StructDefinitions.policyStaticRouteAdvertisement);
        add(mapping,
            "com.vmware.nsx_global_policy.model.policy_sub_attributes",
            com.vmware.nsx_global_policy.model.StructDefinitions.policySubAttributes);
        add(mapping,
            "com.vmware.nsx_global_policy.model.policy_task",
            com.vmware.nsx_global_policy.model.StructDefinitions.policyTask);
        add(mapping,
            "com.vmware.nsx_global_policy.model.policy_tep_csv_list_result",
            com.vmware.nsx_global_policy.model.StructDefinitions.policyTepCsvListResult);
        add(mapping,
            "com.vmware.nsx_global_policy.model.policy_tep_list_result",
            com.vmware.nsx_global_policy.model.StructDefinitions.policyTepListResult);
        add(mapping,
            "com.vmware.nsx_global_policy.model.policy_tep_table_csv_record",
            com.vmware.nsx_global_policy.model.StructDefinitions.policyTepTableCsvRecord);
        add(mapping,
            "com.vmware.nsx_global_policy.model.policy_tep_table_entry",
            com.vmware.nsx_global_policy.model.StructDefinitions.policyTepTableEntry);
        add(mapping,
            "com.vmware.nsx_global_policy.model.policy_tier1_multicast_config",
            com.vmware.nsx_global_policy.model.StructDefinitions.policyTier1MulticastConfig);
        add(mapping,
            "com.vmware.nsx_global_policy.model.policy_time_interval_value",
            com.vmware.nsx_global_policy.model.StructDefinitions.policyTimeIntervalValue);
        add(mapping,
            "com.vmware.nsx_global_policy.model.policy_traceflow_observation_delivered",
            com.vmware.nsx_global_policy.model.StructDefinitions.policyTraceflowObservationDelivered);
        add(mapping,
            "com.vmware.nsx_global_policy.model.policy_traceflow_observation_dropped",
            com.vmware.nsx_global_policy.model.StructDefinitions.policyTraceflowObservationDropped);
        add(mapping,
            "com.vmware.nsx_global_policy.model.policy_traceflow_observation_dropped_logical",
            com.vmware.nsx_global_policy.model.StructDefinitions.policyTraceflowObservationDroppedLogical);
        add(mapping,
            "com.vmware.nsx_global_policy.model.policy_traceflow_observation_forwarded_logical",
            com.vmware.nsx_global_policy.model.StructDefinitions.policyTraceflowObservationForwardedLogical);
        add(mapping,
            "com.vmware.nsx_global_policy.model.policy_traceflow_observation_ipsec_vpn",
            com.vmware.nsx_global_policy.model.StructDefinitions.policyTraceflowObservationIpsecVpn);
        add(mapping,
            "com.vmware.nsx_global_policy.model.policy_traceflow_observation_received_logical",
            com.vmware.nsx_global_policy.model.StructDefinitions.policyTraceflowObservationReceivedLogical);
        add(mapping,
            "com.vmware.nsx_global_policy.model.policy_traceflow_observation_relayed_logical",
            com.vmware.nsx_global_policy.model.StructDefinitions.policyTraceflowObservationRelayedLogical);
        add(mapping,
            "com.vmware.nsx_global_policy.model.policy_transport_zone",
            com.vmware.nsx_global_policy.model.StructDefinitions.policyTransportZone);
        add(mapping,
            "com.vmware.nsx_global_policy.model.policy_transport_zone_list_result",
            com.vmware.nsx_global_policy.model.StructDefinitions.policyTransportZoneListResult);
        add(mapping,
            "com.vmware.nsx_global_policy.model.policy_transport_zone_profile",
            com.vmware.nsx_global_policy.model.StructDefinitions.policyTransportZoneProfile);
        add(mapping,
            "com.vmware.nsx_global_policy.model.policy_transport_zone_profile_list_result",
            com.vmware.nsx_global_policy.model.StructDefinitions.policyTransportZoneProfileListResult);
        add(mapping,
            "com.vmware.nsx_global_policy.model.policy_url_categorization_config",
            com.vmware.nsx_global_policy.model.StructDefinitions.policyUrlCategorizationConfig);
        add(mapping,
            "com.vmware.nsx_global_policy.model.policy_vpc_nat_rule",
            com.vmware.nsx_global_policy.model.StructDefinitions.policyVpcNatRule);
        add(mapping,
            "com.vmware.nsx_global_policy.model.pool_member_setting",
            com.vmware.nsx_global_policy.model.StructDefinitions.poolMemberSetting);
        add(mapping,
            "com.vmware.nsx_global_policy.model.port_address_binding_entry",
            com.vmware.nsx_global_policy.model.StructDefinitions.portAddressBindingEntry);
        add(mapping,
            "com.vmware.nsx_global_policy.model.port_attacher",
            com.vmware.nsx_global_policy.model.StructDefinitions.portAttacher);
        add(mapping,
            "com.vmware.nsx_global_policy.model.port_attachment",
            com.vmware.nsx_global_policy.model.StructDefinitions.portAttachment);
        add(mapping,
            "com.vmware.nsx_global_policy.model.port_discovery_profile_binding_map",
            com.vmware.nsx_global_policy.model.StructDefinitions.portDiscoveryProfileBindingMap);
        add(mapping,
            "com.vmware.nsx_global_policy.model.port_discovery_profile_binding_map_list_result",
            com.vmware.nsx_global_policy.model.StructDefinitions.portDiscoveryProfileBindingMapListResult);
        add(mapping,
            "com.vmware.nsx_global_policy.model.port_mirror_filter",
            com.vmware.nsx_global_policy.model.StructDefinitions.portMirrorFilter);
        add(mapping,
            "com.vmware.nsx_global_policy.model.port_mirroring_profile",
            com.vmware.nsx_global_policy.model.StructDefinitions.portMirroringProfile);
        add(mapping,
            "com.vmware.nsx_global_policy.model.port_monitoring_profile_binding_map",
            com.vmware.nsx_global_policy.model.StructDefinitions.portMonitoringProfileBindingMap);
        add(mapping,
            "com.vmware.nsx_global_policy.model.port_qos_profile_binding_map",
            com.vmware.nsx_global_policy.model.StructDefinitions.portQosProfileBindingMap);
        add(mapping,
            "com.vmware.nsx_global_policy.model.port_qos_profile_binding_map_list_result",
            com.vmware.nsx_global_policy.model.StructDefinitions.portQosProfileBindingMapListResult);
        add(mapping,
            "com.vmware.nsx_global_policy.model.port_security_profile_binding_map",
            com.vmware.nsx_global_policy.model.StructDefinitions.portSecurityProfileBindingMap);
        add(mapping,
            "com.vmware.nsx_global_policy.model.port_security_profile_binding_map_list_result",
            com.vmware.nsx_global_policy.model.StructDefinitions.portSecurityProfileBindingMapListResult);
        add(mapping,
            "com.vmware.nsx_global_policy.model.prefix_entry",
            com.vmware.nsx_global_policy.model.StructDefinitions.prefixEntry);
        add(mapping,
            "com.vmware.nsx_global_policy.model.prefix_list",
            com.vmware.nsx_global_policy.model.StructDefinitions.prefixList);
        add(mapping,
            "com.vmware.nsx_global_policy.model.prefix_list_result",
            com.vmware.nsx_global_policy.model.StructDefinitions.prefixListResult);
        add(mapping,
            "com.vmware.nsx_global_policy.model.principal",
            com.vmware.nsx_global_policy.model.StructDefinitions.principal);
        add(mapping,
            "com.vmware.nsx_global_policy.model.profile_binding_map",
            com.vmware.nsx_global_policy.model.StructDefinitions.profileBindingMap);
        add(mapping,
            "com.vmware.nsx_global_policy.model.project",
            com.vmware.nsx_global_policy.model.StructDefinitions.project);
        add(mapping,
            "com.vmware.nsx_global_policy.model.project_route_filter",
            com.vmware.nsx_global_policy.model.StructDefinitions.projectRouteFilter);
        add(mapping,
            "com.vmware.nsx_global_policy.model.property_item",
            com.vmware.nsx_global_policy.model.StructDefinitions.propertyItem);
        add(mapping,
            "com.vmware.nsx_global_policy.model.protocol_version",
            com.vmware.nsx_global_policy.model.StructDefinitions.protocolVersion);
        add(mapping,
            "com.vmware.nsx_global_policy.model.qos_base_rate_limiter",
            com.vmware.nsx_global_policy.model.StructDefinitions.qosBaseRateLimiter);
        add(mapping,
            "com.vmware.nsx_global_policy.model.qos_dscp",
            com.vmware.nsx_global_policy.model.StructDefinitions.qosDscp);
        add(mapping,
            "com.vmware.nsx_global_policy.model.qos_profile",
            com.vmware.nsx_global_policy.model.StructDefinitions.qosProfile);
        add(mapping,
            "com.vmware.nsx_global_policy.model.qos_profile_binding_map",
            com.vmware.nsx_global_policy.model.StructDefinitions.qosProfileBindingMap);
        add(mapping,
            "com.vmware.nsx_global_policy.model.qos_profile_list_result",
            com.vmware.nsx_global_policy.model.StructDefinitions.qosProfileListResult);
        add(mapping,
            "com.vmware.nsx_global_policy.model.RA_config",
            com.vmware.nsx_global_policy.model.StructDefinitions.RAConfig);
        add(mapping,
            "com.vmware.nsx_global_policy.model.ra_DNS_config",
            com.vmware.nsx_global_policy.model.StructDefinitions.raDNSConfig);
        add(mapping,
            "com.vmware.nsx_global_policy.model.reaction",
            com.vmware.nsx_global_policy.model.StructDefinitions.reaction);
        add(mapping,
            "com.vmware.nsx_global_policy.model.realized_virtual_machine",
            com.vmware.nsx_global_policy.model.StructDefinitions.realizedVirtualMachine);
        add(mapping,
            "com.vmware.nsx_global_policy.model.realized_virtual_machine_list_result",
            com.vmware.nsx_global_policy.model.StructDefinitions.realizedVirtualMachineListResult);
        add(mapping,
            "com.vmware.nsx_global_policy.model.recommended_feature_permission",
            com.vmware.nsx_global_policy.model.StructDefinitions.recommendedFeaturePermission);
        add(mapping,
            "com.vmware.nsx_global_policy.model.recommended_feature_permission_list_result",
            com.vmware.nsx_global_policy.model.StructDefinitions.recommendedFeaturePermissionListResult);
        add(mapping,
            "com.vmware.nsx_global_policy.model.redirection_policy",
            com.vmware.nsx_global_policy.model.StructDefinitions.redirectionPolicy);
        add(mapping,
            "com.vmware.nsx_global_policy.model.redirection_rule",
            com.vmware.nsx_global_policy.model.StructDefinitions.redirectionRule);
        add(mapping,
            "com.vmware.nsx_global_policy.model.reg_token_query",
            com.vmware.nsx_global_policy.model.StructDefinitions.regTokenQuery);
        add(mapping,
            "com.vmware.nsx_global_policy.model.registration_token",
            com.vmware.nsx_global_policy.model.StructDefinitions.registrationToken);
        add(mapping,
            "com.vmware.nsx_global_policy.model.related_api_error",
            com.vmware.nsx_global_policy.model.StructDefinitions.relatedApiError);
        add(mapping,
            "com.vmware.nsx_global_policy.model.related_attribute",
            com.vmware.nsx_global_policy.model.StructDefinitions.relatedAttribute);
        add(mapping,
            "com.vmware.nsx_global_policy.model.related_attribute_conditional_expression",
            com.vmware.nsx_global_policy.model.StructDefinitions.relatedAttributeConditionalExpression);
        add(mapping,
            "com.vmware.nsx_global_policy.model.remote_file_server",
            com.vmware.nsx_global_policy.model.StructDefinitions.remoteFileServer);
        add(mapping,
            "com.vmware.nsx_global_policy.model.remote_server_fingerprint",
            com.vmware.nsx_global_policy.model.StructDefinitions.remoteServerFingerprint);
        add(mapping,
            "com.vmware.nsx_global_policy.model.remote_server_fingerprint_request",
            com.vmware.nsx_global_policy.model.StructDefinitions.remoteServerFingerprintRequest);
        add(mapping,
            "com.vmware.nsx_global_policy.model.render_configuration",
            com.vmware.nsx_global_policy.model.StructDefinitions.renderConfiguration);
        add(mapping,
            "com.vmware.nsx_global_policy.model.repo_sync_status_report",
            com.vmware.nsx_global_policy.model.StructDefinitions.repoSyncStatusReport);
        add(mapping,
            "com.vmware.nsx_global_policy.model.resource",
            com.vmware.nsx_global_policy.model.StructDefinitions.resource);
        add(mapping,
            "com.vmware.nsx_global_policy.model.resource_field_pointer",
            com.vmware.nsx_global_policy.model.StructDefinitions.resourceFieldPointer);
        add(mapping,
            "com.vmware.nsx_global_policy.model.resource_info",
            com.vmware.nsx_global_policy.model.StructDefinitions.resourceInfo);
        add(mapping,
            "com.vmware.nsx_global_policy.model.resource_info_list_result",
            com.vmware.nsx_global_policy.model.StructDefinitions.resourceInfoListResult);
        add(mapping,
            "com.vmware.nsx_global_policy.model.resource_link",
            com.vmware.nsx_global_policy.model.StructDefinitions.resourceLink);
        add(mapping,
            "com.vmware.nsx_global_policy.model.resource_object",
            com.vmware.nsx_global_policy.model.StructDefinitions.resourceObject);
        add(mapping,
            "com.vmware.nsx_global_policy.model.resource_operation",
            com.vmware.nsx_global_policy.model.StructDefinitions.resourceOperation);
        add(mapping,
            "com.vmware.nsx_global_policy.model.resource_reference",
            com.vmware.nsx_global_policy.model.StructDefinitions.resourceReference);
        add(mapping,
            "com.vmware.nsx_global_policy.model.resource_summary_detail",
            com.vmware.nsx_global_policy.model.StructDefinitions.resourceSummaryDetail);
        add(mapping,
            "com.vmware.nsx_global_policy.model.resource_tag_status",
            com.vmware.nsx_global_policy.model.StructDefinitions.resourceTagStatus);
        add(mapping,
            "com.vmware.nsx_global_policy.model.resource_type_tag_status",
            com.vmware.nsx_global_policy.model.StructDefinitions.resourceTypeTagStatus);
        add(mapping,
            "com.vmware.nsx_global_policy.model.restore_step",
            com.vmware.nsx_global_policy.model.StructDefinitions.restoreStep);
        add(mapping,
            "com.vmware.nsx_global_policy.model.revisioned_resource",
            com.vmware.nsx_global_policy.model.StructDefinitions.revisionedResource);
        add(mapping,
            "com.vmware.nsx_global_policy.model.role",
            com.vmware.nsx_global_policy.model.StructDefinitions.role);
        add(mapping,
            "com.vmware.nsx_global_policy.model.role_assignment_permission_config",
            com.vmware.nsx_global_policy.model.StructDefinitions.roleAssignmentPermissionConfig);
        add(mapping,
            "com.vmware.nsx_global_policy.model.role_binding",
            com.vmware.nsx_global_policy.model.StructDefinitions.roleBinding);
        add(mapping,
            "com.vmware.nsx_global_policy.model.role_binding_list_result",
            com.vmware.nsx_global_policy.model.StructDefinitions.roleBindingListResult);
        add(mapping,
            "com.vmware.nsx_global_policy.model.role_list_result",
            com.vmware.nsx_global_policy.model.StructDefinitions.roleListResult);
        add(mapping,
            "com.vmware.nsx_global_policy.model.role_with_features",
            com.vmware.nsx_global_policy.model.StructDefinitions.roleWithFeatures);
        add(mapping,
            "com.vmware.nsx_global_policy.model.role_with_features_list_result",
            com.vmware.nsx_global_policy.model.StructDefinitions.roleWithFeaturesListResult);
        add(mapping,
            "com.vmware.nsx_global_policy.model.roles_for_path",
            com.vmware.nsx_global_policy.model.StructDefinitions.rolesForPath);
        add(mapping,
            "com.vmware.nsx_global_policy.model.route_advertisement_rule",
            com.vmware.nsx_global_policy.model.StructDefinitions.routeAdvertisementRule);
        add(mapping,
            "com.vmware.nsx_global_policy.model.route_aggregation_entry",
            com.vmware.nsx_global_policy.model.StructDefinitions.routeAggregationEntry);
        add(mapping,
            "com.vmware.nsx_global_policy.model.route_based_IP_sec_vpn_session",
            com.vmware.nsx_global_policy.model.StructDefinitions.routeBasedIPSecVpnSession);
        add(mapping,
            "com.vmware.nsx_global_policy.model.route_based_l3_vpn_session",
            com.vmware.nsx_global_policy.model.StructDefinitions.routeBasedL3VpnSession);
        add(mapping,
            "com.vmware.nsx_global_policy.model.route_details",
            com.vmware.nsx_global_policy.model.StructDefinitions.routeDetails);
        add(mapping,
            "com.vmware.nsx_global_policy.model.route_map_entry",
            com.vmware.nsx_global_policy.model.StructDefinitions.routeMapEntry);
        add(mapping,
            "com.vmware.nsx_global_policy.model.route_map_entry_set",
            com.vmware.nsx_global_policy.model.StructDefinitions.routeMapEntrySet);
        add(mapping,
            "com.vmware.nsx_global_policy.model.router_nexthop",
            com.vmware.nsx_global_policy.model.StructDefinitions.routerNexthop);
        add(mapping,
            "com.vmware.nsx_global_policy.model.routes_per_transport_node",
            com.vmware.nsx_global_policy.model.StructDefinitions.routesPerTransportNode);
        add(mapping,
            "com.vmware.nsx_global_policy.model.routing_entry",
            com.vmware.nsx_global_policy.model.StructDefinitions.routingEntry);
        add(mapping,
            "com.vmware.nsx_global_policy.model.routing_table",
            com.vmware.nsx_global_policy.model.StructDefinitions.routingTable);
        add(mapping,
            "com.vmware.nsx_global_policy.model.routing_table_list_result",
            com.vmware.nsx_global_policy.model.StructDefinitions.routingTableListResult);
        add(mapping,
            "com.vmware.nsx_global_policy.model.row_list_field",
            com.vmware.nsx_global_policy.model.StructDefinitions.rowListField);
        add(mapping,
            "com.vmware.nsx_global_policy.model.rp_address_multicast_ranges",
            com.vmware.nsx_global_policy.model.StructDefinitions.rpAddressMulticastRanges);
        add(mapping,
            "com.vmware.nsx_global_policy.model.rule",
            com.vmware.nsx_global_policy.model.StructDefinitions.rule);
        add(mapping,
            "com.vmware.nsx_global_policy.model.rule_list_result",
            com.vmware.nsx_global_policy.model.StructDefinitions.ruleListResult);
        add(mapping,
            "com.vmware.nsx_global_policy.model.rule_statistics",
            com.vmware.nsx_global_policy.model.StructDefinitions.ruleStatistics);
        add(mapping,
            "com.vmware.nsx_global_policy.model.rule_statistics_for_enforcement_point",
            com.vmware.nsx_global_policy.model.StructDefinitions.ruleStatisticsForEnforcementPoint);
        add(mapping,
            "com.vmware.nsx_global_policy.model.rule_statistics_list_result",
            com.vmware.nsx_global_policy.model.StructDefinitions.ruleStatisticsListResult);
        add(mapping,
            "com.vmware.nsx_global_policy.model.search_response",
            com.vmware.nsx_global_policy.model.StructDefinitions.searchResponse);
        add(mapping,
            "com.vmware.nsx_global_policy.model.security_feature",
            com.vmware.nsx_global_policy.model.StructDefinitions.securityFeature);
        add(mapping,
            "com.vmware.nsx_global_policy.model.security_feature_base",
            com.vmware.nsx_global_policy.model.StructDefinitions.securityFeatureBase);
        add(mapping,
            "com.vmware.nsx_global_policy.model.security_features",
            com.vmware.nsx_global_policy.model.StructDefinitions.securityFeatures);
        add(mapping,
            "com.vmware.nsx_global_policy.model.security_policy",
            com.vmware.nsx_global_policy.model.StructDefinitions.securityPolicy);
        add(mapping,
            "com.vmware.nsx_global_policy.model.security_policy_list_result",
            com.vmware.nsx_global_policy.model.StructDefinitions.securityPolicyListResult);
        add(mapping,
            "com.vmware.nsx_global_policy.model.security_policy_statistics",
            com.vmware.nsx_global_policy.model.StructDefinitions.securityPolicyStatistics);
        add(mapping,
            "com.vmware.nsx_global_policy.model.security_policy_statistics_for_enforcement_point",
            com.vmware.nsx_global_policy.model.StructDefinitions.securityPolicyStatisticsForEnforcementPoint);
        add(mapping,
            "com.vmware.nsx_global_policy.model.security_policy_statistics_list_result",
            com.vmware.nsx_global_policy.model.StructDefinitions.securityPolicyStatisticsListResult);
        add(mapping,
            "com.vmware.nsx_global_policy.model.security_profile_binding_map",
            com.vmware.nsx_global_policy.model.StructDefinitions.securityProfileBindingMap);
        add(mapping,
            "com.vmware.nsx_global_policy.model.segment",
            com.vmware.nsx_global_policy.model.StructDefinitions.segment);
        add(mapping,
            "com.vmware.nsx_global_policy.model.segment_advanced_config",
            com.vmware.nsx_global_policy.model.StructDefinitions.segmentAdvancedConfig);
        add(mapping,
            "com.vmware.nsx_global_policy.model.segment_configuration_state",
            com.vmware.nsx_global_policy.model.StructDefinitions.segmentConfigurationState);
        add(mapping,
            "com.vmware.nsx_global_policy.model.segment_configuration_state_list_result",
            com.vmware.nsx_global_policy.model.StructDefinitions.segmentConfigurationStateListResult);
        add(mapping,
            "com.vmware.nsx_global_policy.model.segment_cross_site_traffic_stats",
            com.vmware.nsx_global_policy.model.StructDefinitions.segmentCrossSiteTrafficStats);
        add(mapping,
            "com.vmware.nsx_global_policy.model.segment_dhcp_config",
            com.vmware.nsx_global_policy.model.StructDefinitions.segmentDhcpConfig);
        add(mapping,
            "com.vmware.nsx_global_policy.model.segment_dhcp_v4_config",
            com.vmware.nsx_global_policy.model.StructDefinitions.segmentDhcpV4Config);
        add(mapping,
            "com.vmware.nsx_global_policy.model.segment_dhcp_v6_config",
            com.vmware.nsx_global_policy.model.StructDefinitions.segmentDhcpV6Config);
        add(mapping,
            "com.vmware.nsx_global_policy.model.segment_discovery_profile_binding_map",
            com.vmware.nsx_global_policy.model.StructDefinitions.segmentDiscoveryProfileBindingMap);
        add(mapping,
            "com.vmware.nsx_global_policy.model.segment_discovery_profile_binding_map_list_result",
            com.vmware.nsx_global_policy.model.StructDefinitions.segmentDiscoveryProfileBindingMapListResult);
        add(mapping,
            "com.vmware.nsx_global_policy.model.segment_extra_config",
            com.vmware.nsx_global_policy.model.StructDefinitions.segmentExtraConfig);
        add(mapping,
            "com.vmware.nsx_global_policy.model.segment_l2_forwarder_site_span_info",
            com.vmware.nsx_global_policy.model.StructDefinitions.segmentL2ForwarderSiteSpanInfo);
        add(mapping,
            "com.vmware.nsx_global_policy.model.segment_list_result",
            com.vmware.nsx_global_policy.model.StructDefinitions.segmentListResult);
        add(mapping,
            "com.vmware.nsx_global_policy.model.segment_mac_address_list_result",
            com.vmware.nsx_global_policy.model.StructDefinitions.segmentMacAddressListResult);
        add(mapping,
            "com.vmware.nsx_global_policy.model.segment_monitoring_profile_binding_map",
            com.vmware.nsx_global_policy.model.StructDefinitions.segmentMonitoringProfileBindingMap);
        add(mapping,
            "com.vmware.nsx_global_policy.model.segment_port",
            com.vmware.nsx_global_policy.model.StructDefinitions.segmentPort);
        add(mapping,
            "com.vmware.nsx_global_policy.model.segment_port_attachment_state",
            com.vmware.nsx_global_policy.model.StructDefinitions.segmentPortAttachmentState);
        add(mapping,
            "com.vmware.nsx_global_policy.model.segment_port_list_result",
            com.vmware.nsx_global_policy.model.StructDefinitions.segmentPortListResult);
        add(mapping,
            "com.vmware.nsx_global_policy.model.segment_port_mac_address_csv_list_result",
            com.vmware.nsx_global_policy.model.StructDefinitions.segmentPortMacAddressCsvListResult);
        add(mapping,
            "com.vmware.nsx_global_policy.model.segment_port_mac_address_list_result",
            com.vmware.nsx_global_policy.model.StructDefinitions.segmentPortMacAddressListResult);
        add(mapping,
            "com.vmware.nsx_global_policy.model.segment_port_mac_table_csv_entry",
            com.vmware.nsx_global_policy.model.StructDefinitions.segmentPortMacTableCsvEntry);
        add(mapping,
            "com.vmware.nsx_global_policy.model.segment_port_mac_table_entry",
            com.vmware.nsx_global_policy.model.StructDefinitions.segmentPortMacTableEntry);
        add(mapping,
            "com.vmware.nsx_global_policy.model.segment_port_state",
            com.vmware.nsx_global_policy.model.StructDefinitions.segmentPortState);
        add(mapping,
            "com.vmware.nsx_global_policy.model.segment_port_statistics",
            com.vmware.nsx_global_policy.model.StructDefinitions.segmentPortStatistics);
        add(mapping,
            "com.vmware.nsx_global_policy.model.segment_port_status",
            com.vmware.nsx_global_policy.model.StructDefinitions.segmentPortStatus);
        add(mapping,
            "com.vmware.nsx_global_policy.model.segment_qos_profile_binding_map",
            com.vmware.nsx_global_policy.model.StructDefinitions.segmentQosProfileBindingMap);
        add(mapping,
            "com.vmware.nsx_global_policy.model.segment_qos_profile_binding_map_list_result",
            com.vmware.nsx_global_policy.model.StructDefinitions.segmentQosProfileBindingMapListResult);
        add(mapping,
            "com.vmware.nsx_global_policy.model.segment_request_parameter",
            com.vmware.nsx_global_policy.model.StructDefinitions.segmentRequestParameter);
        add(mapping,
            "com.vmware.nsx_global_policy.model.segment_security_profile",
            com.vmware.nsx_global_policy.model.StructDefinitions.segmentSecurityProfile);
        add(mapping,
            "com.vmware.nsx_global_policy.model.segment_security_profile_binding_map",
            com.vmware.nsx_global_policy.model.StructDefinitions.segmentSecurityProfileBindingMap);
        add(mapping,
            "com.vmware.nsx_global_policy.model.segment_security_profile_binding_map_list_result",
            com.vmware.nsx_global_policy.model.StructDefinitions.segmentSecurityProfileBindingMapListResult);
        add(mapping,
            "com.vmware.nsx_global_policy.model.segment_security_profile_list_result",
            com.vmware.nsx_global_policy.model.StructDefinitions.segmentSecurityProfileListResult);
        add(mapping,
            "com.vmware.nsx_global_policy.model.segment_statistics",
            com.vmware.nsx_global_policy.model.StructDefinitions.segmentStatistics);
        add(mapping,
            "com.vmware.nsx_global_policy.model.segment_subnet",
            com.vmware.nsx_global_policy.model.StructDefinitions.segmentSubnet);
        add(mapping,
            "com.vmware.nsx_global_policy.model.selectable_resource_reference",
            com.vmware.nsx_global_policy.model.StructDefinitions.selectableResourceReference);
        add(mapping,
            "com.vmware.nsx_global_policy.model.selective_sync_settings",
            com.vmware.nsx_global_policy.model.StructDefinitions.selectiveSyncSettings);
        add(mapping,
            "com.vmware.nsx_global_policy.model.self_resource_link",
            com.vmware.nsx_global_policy.model.StructDefinitions.selfResourceLink);
        add(mapping,
            "com.vmware.nsx_global_policy.model.service",
            com.vmware.nsx_global_policy.model.StructDefinitions.service);
        add(mapping,
            "com.vmware.nsx_global_policy.model.service_entry",
            com.vmware.nsx_global_policy.model.StructDefinitions.serviceEntry);
        add(mapping,
            "com.vmware.nsx_global_policy.model.service_entry_list_result",
            com.vmware.nsx_global_policy.model.StructDefinitions.serviceEntryListResult);
        add(mapping,
            "com.vmware.nsx_global_policy.model.service_gateway",
            com.vmware.nsx_global_policy.model.StructDefinitions.serviceGateway);
        add(mapping,
            "com.vmware.nsx_global_policy.model.service_instance_endpoint",
            com.vmware.nsx_global_policy.model.StructDefinitions.serviceInstanceEndpoint);
        add(mapping,
            "com.vmware.nsx_global_policy.model.service_interface",
            com.vmware.nsx_global_policy.model.StructDefinitions.serviceInterface);
        add(mapping,
            "com.vmware.nsx_global_policy.model.service_interface_list_result",
            com.vmware.nsx_global_policy.model.StructDefinitions.serviceInterfaceListResult);
        add(mapping,
            "com.vmware.nsx_global_policy.model.service_list_result",
            com.vmware.nsx_global_policy.model.StructDefinitions.serviceListResult);
        add(mapping,
            "com.vmware.nsx_global_policy.model.service_reference",
            com.vmware.nsx_global_policy.model.StructDefinitions.serviceReference);
        add(mapping,
            "com.vmware.nsx_global_policy.model.service_segment",
            com.vmware.nsx_global_policy.model.StructDefinitions.serviceSegment);
        add(mapping,
            "com.vmware.nsx_global_policy.model.session_timer_profile_binding_list_result",
            com.vmware.nsx_global_policy.model.StructDefinitions.sessionTimerProfileBindingListResult);
        add(mapping,
            "com.vmware.nsx_global_policy.model.session_timer_profile_binding_map",
            com.vmware.nsx_global_policy.model.StructDefinitions.sessionTimerProfileBindingMap);
        add(mapping,
            "com.vmware.nsx_global_policy.model.set_fields",
            com.vmware.nsx_global_policy.model.StructDefinitions.setFields);
        add(mapping,
            "com.vmware.nsx_global_policy.model.sha_dynamic_plugin",
            com.vmware.nsx_global_policy.model.StructDefinitions.shaDynamicPlugin);
        add(mapping,
            "com.vmware.nsx_global_policy.model.sha_dynamic_plugin_profile",
            com.vmware.nsx_global_policy.model.StructDefinitions.shaDynamicPluginProfile);
        add(mapping,
            "com.vmware.nsx_global_policy.model.sha_plugin_profile",
            com.vmware.nsx_global_policy.model.StructDefinitions.shaPluginProfile);
        add(mapping,
            "com.vmware.nsx_global_policy.model.sha_predefined_plugin",
            com.vmware.nsx_global_policy.model.StructDefinitions.shaPredefinedPlugin);
        add(mapping,
            "com.vmware.nsx_global_policy.model.sha_predefined_plugin_profile",
            com.vmware.nsx_global_policy.model.StructDefinitions.shaPredefinedPluginProfile);
        add(mapping,
            "com.vmware.nsx_global_policy.model.sha_predefined_plugin_profile_data",
            com.vmware.nsx_global_policy.model.StructDefinitions.shaPredefinedPluginProfileData);
        add(mapping,
            "com.vmware.nsx_global_policy.model.share",
            com.vmware.nsx_global_policy.model.StructDefinitions.share);
        add(mapping,
            "com.vmware.nsx_global_policy.model.shared_resource",
            com.vmware.nsx_global_policy.model.StructDefinitions.sharedResource);
        add(mapping,
            "com.vmware.nsx_global_policy.model.site",
            com.vmware.nsx_global_policy.model.StructDefinitions.site);
        add(mapping,
            "com.vmware.nsx_global_policy.model.site_allocation_index_for_edge",
            com.vmware.nsx_global_policy.model.StructDefinitions.siteAllocationIndexForEdge);
        add(mapping,
            "com.vmware.nsx_global_policy.model.site_cleanup_pending",
            com.vmware.nsx_global_policy.model.StructDefinitions.siteCleanupPending);
        add(mapping,
            "com.vmware.nsx_global_policy.model.site_cleanup_pending_list_result",
            com.vmware.nsx_global_policy.model.StructDefinitions.siteCleanupPendingListResult);
        add(mapping,
            "com.vmware.nsx_global_policy.model.site_federation_config",
            com.vmware.nsx_global_policy.model.StructDefinitions.siteFederationConfig);
        add(mapping,
            "com.vmware.nsx_global_policy.model.site_info",
            com.vmware.nsx_global_policy.model.StructDefinitions.siteInfo);
        add(mapping,
            "com.vmware.nsx_global_policy.model.site_list_result",
            com.vmware.nsx_global_policy.model.StructDefinitions.siteListResult);
        add(mapping,
            "com.vmware.nsx_global_policy.model.site_node_connection_info",
            com.vmware.nsx_global_policy.model.StructDefinitions.siteNodeConnectionInfo);
        add(mapping,
            "com.vmware.nsx_global_policy.model.site_onboarding_preference",
            com.vmware.nsx_global_policy.model.StructDefinitions.siteOnboardingPreference);
        add(mapping,
            "com.vmware.nsx_global_policy.model.site_override",
            com.vmware.nsx_global_policy.model.StructDefinitions.siteOverride);
        add(mapping,
            "com.vmware.nsx_global_policy.model.source",
            com.vmware.nsx_global_policy.model.StructDefinitions.source);
        add(mapping,
            "com.vmware.nsx_global_policy.model.source_field_evaluation",
            com.vmware.nsx_global_policy.model.StructDefinitions.sourceFieldEvaluation);
        add(mapping,
            "com.vmware.nsx_global_policy.model.spacer_widget_configuration",
            com.vmware.nsx_global_policy.model.StructDefinitions.spacerWidgetConfiguration);
        add(mapping,
            "com.vmware.nsx_global_policy.model.span",
            com.vmware.nsx_global_policy.model.StructDefinitions.span);
        add(mapping,
            "com.vmware.nsx_global_policy.model.span_site_info",
            com.vmware.nsx_global_policy.model.StructDefinitions.spanSiteInfo);
        add(mapping,
            "com.vmware.nsx_global_policy.model.spoof_guard_profile",
            com.vmware.nsx_global_policy.model.StructDefinitions.spoofGuardProfile);
        add(mapping,
            "com.vmware.nsx_global_policy.model.spoof_guard_profile_list_result",
            com.vmware.nsx_global_policy.model.StructDefinitions.spoofGuardProfileListResult);
        add(mapping,
            "com.vmware.nsx_global_policy.model.standalone_host_idfw_configuration",
            com.vmware.nsx_global_policy.model.StructDefinitions.standaloneHostIdfwConfiguration);
        add(mapping,
            "com.vmware.nsx_global_policy.model.stat_item",
            com.vmware.nsx_global_policy.model.StructDefinitions.statItem);
        add(mapping,
            "com.vmware.nsx_global_policy.model.static_ARP_config",
            com.vmware.nsx_global_policy.model.StructDefinitions.staticARPConfig);
        add(mapping,
            "com.vmware.nsx_global_policy.model.static_filter",
            com.vmware.nsx_global_policy.model.StructDefinitions.staticFilter);
        add(mapping,
            "com.vmware.nsx_global_policy.model.static_mime_content",
            com.vmware.nsx_global_policy.model.StructDefinitions.staticMimeContent);
        add(mapping,
            "com.vmware.nsx_global_policy.model.static_pool_config",
            com.vmware.nsx_global_policy.model.StructDefinitions.staticPoolConfig);
        add(mapping,
            "com.vmware.nsx_global_policy.model.static_route_bfd_peer",
            com.vmware.nsx_global_policy.model.StructDefinitions.staticRouteBfdPeer);
        add(mapping,
            "com.vmware.nsx_global_policy.model.static_route_bfd_peer_list_result",
            com.vmware.nsx_global_policy.model.StructDefinitions.staticRouteBfdPeerListResult);
        add(mapping,
            "com.vmware.nsx_global_policy.model.static_routes",
            com.vmware.nsx_global_policy.model.StructDefinitions.staticRoutes);
        add(mapping,
            "com.vmware.nsx_global_policy.model.static_routes_list_result",
            com.vmware.nsx_global_policy.model.StructDefinitions.staticRoutesListResult);
        add(mapping,
            "com.vmware.nsx_global_policy.model.stats_configuration",
            com.vmware.nsx_global_policy.model.StructDefinitions.statsConfiguration);
        add(mapping,
            "com.vmware.nsx_global_policy.model.string_array_constraint_value",
            com.vmware.nsx_global_policy.model.StructDefinitions.stringArrayConstraintValue);
        add(mapping,
            "com.vmware.nsx_global_policy.model.subject_public_key_hash",
            com.vmware.nsx_global_policy.model.StructDefinitions.subjectPublicKeyHash);
        add(mapping,
            "com.vmware.nsx_global_policy.model.subnet_profiles",
            com.vmware.nsx_global_policy.model.StructDefinitions.subnetProfiles);
        add(mapping,
            "com.vmware.nsx_global_policy.model.switching_profile_type_id_entry",
            com.vmware.nsx_global_policy.model.StructDefinitions.switchingProfileTypeIdEntry);
        add(mapping,
            "com.vmware.nsx_global_policy.model.swsec_counters",
            com.vmware.nsx_global_policy.model.StructDefinitions.swsecCounters);
        add(mapping,
            "com.vmware.nsx_global_policy.model.tag",
            com.vmware.nsx_global_policy.model.StructDefinitions.tag);
        add(mapping,
            "com.vmware.nsx_global_policy.model.tag_bulk_operation",
            com.vmware.nsx_global_policy.model.StructDefinitions.tagBulkOperation);
        add(mapping,
            "com.vmware.nsx_global_policy.model.tag_bulk_operation_status",
            com.vmware.nsx_global_policy.model.StructDefinitions.tagBulkOperationStatus);
        add(mapping,
            "com.vmware.nsx_global_policy.model.tag_info",
            com.vmware.nsx_global_policy.model.StructDefinitions.tagInfo);
        add(mapping,
            "com.vmware.nsx_global_policy.model.tag_info_list_result",
            com.vmware.nsx_global_policy.model.StructDefinitions.tagInfoListResult);
        add(mapping,
            "com.vmware.nsx_global_policy.model.task_properties",
            com.vmware.nsx_global_policy.model.StructDefinitions.taskProperties);
        add(mapping,
            "com.vmware.nsx_global_policy.model.tcp_header",
            com.vmware.nsx_global_policy.model.StructDefinitions.tcpHeader);
        add(mapping,
            "com.vmware.nsx_global_policy.model.tcp_maximum_segment_size_clamping",
            com.vmware.nsx_global_policy.model.StructDefinitions.tcpMaximumSegmentSizeClamping);
        add(mapping,
            "com.vmware.nsx_global_policy.model.tier0",
            com.vmware.nsx_global_policy.model.StructDefinitions.tier0);
        add(mapping,
            "com.vmware.nsx_global_policy.model.tier0_advanced_config",
            com.vmware.nsx_global_policy.model.StructDefinitions.tier0AdvancedConfig);
        add(mapping,
            "com.vmware.nsx_global_policy.model.tier0_deployment_map",
            com.vmware.nsx_global_policy.model.StructDefinitions.tier0DeploymentMap);
        add(mapping,
            "com.vmware.nsx_global_policy.model.tier0_deployment_map_list_result",
            com.vmware.nsx_global_policy.model.StructDefinitions.tier0DeploymentMapListResult);
        add(mapping,
            "com.vmware.nsx_global_policy.model.tier0_gateway_state",
            com.vmware.nsx_global_policy.model.StructDefinitions.tier0GatewayState);
        add(mapping,
            "com.vmware.nsx_global_policy.model.tier0_ha_vip_config",
            com.vmware.nsx_global_policy.model.StructDefinitions.tier0HaVipConfig);
        add(mapping,
            "com.vmware.nsx_global_policy.model.tier0_interface",
            com.vmware.nsx_global_policy.model.StructDefinitions.tier0Interface);
        add(mapping,
            "com.vmware.nsx_global_policy.model.tier0_interface_group",
            com.vmware.nsx_global_policy.model.StructDefinitions.tier0InterfaceGroup);
        add(mapping,
            "com.vmware.nsx_global_policy.model.tier0_interface_group_list_result",
            com.vmware.nsx_global_policy.model.StructDefinitions.tier0InterfaceGroupListResult);
        add(mapping,
            "com.vmware.nsx_global_policy.model.tier0_interface_list_result",
            com.vmware.nsx_global_policy.model.StructDefinitions.tier0InterfaceListResult);
        add(mapping,
            "com.vmware.nsx_global_policy.model.tier0_interface_pim_config",
            com.vmware.nsx_global_policy.model.StructDefinitions.tier0InterfacePimConfig);
        add(mapping,
            "com.vmware.nsx_global_policy.model.tier0_list_result",
            com.vmware.nsx_global_policy.model.StructDefinitions.tier0ListResult);
        add(mapping,
            "com.vmware.nsx_global_policy.model.tier0_number_of_routes_result",
            com.vmware.nsx_global_policy.model.StructDefinitions.tier0NumberOfRoutesResult);
        add(mapping,
            "com.vmware.nsx_global_policy.model.tier0_route_map",
            com.vmware.nsx_global_policy.model.StructDefinitions.tier0RouteMap);
        add(mapping,
            "com.vmware.nsx_global_policy.model.tier0_route_map_list_result",
            com.vmware.nsx_global_policy.model.StructDefinitions.tier0RouteMapListResult);
        add(mapping,
            "com.vmware.nsx_global_policy.model.tier0_route_redistribution_config",
            com.vmware.nsx_global_policy.model.StructDefinitions.tier0RouteRedistributionConfig);
        add(mapping,
            "com.vmware.nsx_global_policy.model.tier0_route_redistribution_rule",
            com.vmware.nsx_global_policy.model.StructDefinitions.tier0RouteRedistributionRule);
        add(mapping,
            "com.vmware.nsx_global_policy.model.tier0_security_feature",
            com.vmware.nsx_global_policy.model.StructDefinitions.tier0SecurityFeature);
        add(mapping,
            "com.vmware.nsx_global_policy.model.tier0_security_features",
            com.vmware.nsx_global_policy.model.StructDefinitions.tier0SecurityFeatures);
        add(mapping,
            "com.vmware.nsx_global_policy.model.tier0_stateful_services_config",
            com.vmware.nsx_global_policy.model.StructDefinitions.tier0StatefulServicesConfig);
        add(mapping,
            "com.vmware.nsx_global_policy.model.tier0_vrf_config",
            com.vmware.nsx_global_policy.model.StructDefinitions.tier0VrfConfig);
        add(mapping,
            "com.vmware.nsx_global_policy.model.tier1",
            com.vmware.nsx_global_policy.model.StructDefinitions.tier1);
        add(mapping,
            "com.vmware.nsx_global_policy.model.tier1_deployment_map",
            com.vmware.nsx_global_policy.model.StructDefinitions.tier1DeploymentMap);
        add(mapping,
            "com.vmware.nsx_global_policy.model.tier1_gateway_state",
            com.vmware.nsx_global_policy.model.StructDefinitions.tier1GatewayState);
        add(mapping,
            "com.vmware.nsx_global_policy.model.tier1_interface",
            com.vmware.nsx_global_policy.model.StructDefinitions.tier1Interface);
        add(mapping,
            "com.vmware.nsx_global_policy.model.tier1_interface_group",
            com.vmware.nsx_global_policy.model.StructDefinitions.tier1InterfaceGroup);
        add(mapping,
            "com.vmware.nsx_global_policy.model.tier1_interface_group_list_result",
            com.vmware.nsx_global_policy.model.StructDefinitions.tier1InterfaceGroupListResult);
        add(mapping,
            "com.vmware.nsx_global_policy.model.tier1_interface_list_result",
            com.vmware.nsx_global_policy.model.StructDefinitions.tier1InterfaceListResult);
        add(mapping,
            "com.vmware.nsx_global_policy.model.tier1_list_result",
            com.vmware.nsx_global_policy.model.StructDefinitions.tier1ListResult);
        add(mapping,
            "com.vmware.nsx_global_policy.model.time_range_dropdown_filter_widget_configuration",
            com.vmware.nsx_global_policy.model.StructDefinitions.timeRangeDropdownFilterWidgetConfiguration);
        add(mapping,
            "com.vmware.nsx_global_policy.model.time_range_filter_info",
            com.vmware.nsx_global_policy.model.StructDefinitions.timeRangeFilterInfo);
        add(mapping,
            "com.vmware.nsx_global_policy.model.tls_certificate",
            com.vmware.nsx_global_policy.model.StructDefinitions.tlsCertificate);
        add(mapping,
            "com.vmware.nsx_global_policy.model.tls_certificate_list",
            com.vmware.nsx_global_policy.model.StructDefinitions.tlsCertificateList);
        add(mapping,
            "com.vmware.nsx_global_policy.model.tls_crl",
            com.vmware.nsx_global_policy.model.StructDefinitions.tlsCrl);
        add(mapping,
            "com.vmware.nsx_global_policy.model.tls_crl_list_result",
            com.vmware.nsx_global_policy.model.StructDefinitions.tlsCrlListResult);
        add(mapping,
            "com.vmware.nsx_global_policy.model.tls_csr",
            com.vmware.nsx_global_policy.model.StructDefinitions.tlsCsr);
        add(mapping,
            "com.vmware.nsx_global_policy.model.tls_csr_list_result",
            com.vmware.nsx_global_policy.model.StructDefinitions.tlsCsrListResult);
        add(mapping,
            "com.vmware.nsx_global_policy.model.tls_csr_with_days_valid",
            com.vmware.nsx_global_policy.model.StructDefinitions.tlsCsrWithDaysValid);
        add(mapping,
            "com.vmware.nsx_global_policy.model.tls_inspection_external_profile",
            com.vmware.nsx_global_policy.model.StructDefinitions.tlsInspectionExternalProfile);
        add(mapping,
            "com.vmware.nsx_global_policy.model.tls_inspection_internal_profile",
            com.vmware.nsx_global_policy.model.StructDefinitions.tlsInspectionInternalProfile);
        add(mapping,
            "com.vmware.nsx_global_policy.model.tls_listener_certificate",
            com.vmware.nsx_global_policy.model.StructDefinitions.tlsListenerCertificate);
        add(mapping,
            "com.vmware.nsx_global_policy.model.tls_policy",
            com.vmware.nsx_global_policy.model.StructDefinitions.tlsPolicy);
        add(mapping,
            "com.vmware.nsx_global_policy.model.tls_profile",
            com.vmware.nsx_global_policy.model.StructDefinitions.tlsProfile);
        add(mapping,
            "com.vmware.nsx_global_policy.model.tls_rule",
            com.vmware.nsx_global_policy.model.StructDefinitions.tlsRule);
        add(mapping,
            "com.vmware.nsx_global_policy.model.tls_trust_data",
            com.vmware.nsx_global_policy.model.StructDefinitions.tlsTrustData);
        add(mapping,
            "com.vmware.nsx_global_policy.model.tooltip",
            com.vmware.nsx_global_policy.model.StructDefinitions.tooltip);
        add(mapping,
            "com.vmware.nsx_global_policy.model.traceflow",
            com.vmware.nsx_global_policy.model.StructDefinitions.traceflow);
        add(mapping,
            "com.vmware.nsx_global_policy.model.traceflow_config",
            com.vmware.nsx_global_policy.model.StructDefinitions.traceflowConfig);
        add(mapping,
            "com.vmware.nsx_global_policy.model.traceflow_config_list_result",
            com.vmware.nsx_global_policy.model.StructDefinitions.traceflowConfigListResult);
        add(mapping,
            "com.vmware.nsx_global_policy.model.traceflow_observation",
            com.vmware.nsx_global_policy.model.StructDefinitions.traceflowObservation);
        add(mapping,
            "com.vmware.nsx_global_policy.model.traceflow_observation_counters",
            com.vmware.nsx_global_policy.model.StructDefinitions.traceflowObservationCounters);
        add(mapping,
            "com.vmware.nsx_global_policy.model.traceflow_observation_delivered",
            com.vmware.nsx_global_policy.model.StructDefinitions.traceflowObservationDelivered);
        add(mapping,
            "com.vmware.nsx_global_policy.model.traceflow_observation_dropped",
            com.vmware.nsx_global_policy.model.StructDefinitions.traceflowObservationDropped);
        add(mapping,
            "com.vmware.nsx_global_policy.model.traceflow_observation_dropped_logical",
            com.vmware.nsx_global_policy.model.StructDefinitions.traceflowObservationDroppedLogical);
        add(mapping,
            "com.vmware.nsx_global_policy.model.traceflow_observation_forwarded",
            com.vmware.nsx_global_policy.model.StructDefinitions.traceflowObservationForwarded);
        add(mapping,
            "com.vmware.nsx_global_policy.model.traceflow_observation_forwarded_logical",
            com.vmware.nsx_global_policy.model.StructDefinitions.traceflowObservationForwardedLogical);
        add(mapping,
            "com.vmware.nsx_global_policy.model.traceflow_observation_ipsec_vpn",
            com.vmware.nsx_global_policy.model.StructDefinitions.traceflowObservationIpsecVpn);
        add(mapping,
            "com.vmware.nsx_global_policy.model.traceflow_observation_list_result",
            com.vmware.nsx_global_policy.model.StructDefinitions.traceflowObservationListResult);
        add(mapping,
            "com.vmware.nsx_global_policy.model.traceflow_observation_protected",
            com.vmware.nsx_global_policy.model.StructDefinitions.traceflowObservationProtected);
        add(mapping,
            "com.vmware.nsx_global_policy.model.traceflow_observation_received",
            com.vmware.nsx_global_policy.model.StructDefinitions.traceflowObservationReceived);
        add(mapping,
            "com.vmware.nsx_global_policy.model.traceflow_observation_received_logical",
            com.vmware.nsx_global_policy.model.StructDefinitions.traceflowObservationReceivedLogical);
        add(mapping,
            "com.vmware.nsx_global_policy.model.traceflow_observation_relayed_logical",
            com.vmware.nsx_global_policy.model.StructDefinitions.traceflowObservationRelayedLogical);
        add(mapping,
            "com.vmware.nsx_global_policy.model.traceflow_observation_replication_logical",
            com.vmware.nsx_global_policy.model.StructDefinitions.traceflowObservationReplicationLogical);
        add(mapping,
            "com.vmware.nsx_global_policy.model.traceflow_request_parameter",
            com.vmware.nsx_global_policy.model.StructDefinitions.traceflowRequestParameter);
        add(mapping,
            "com.vmware.nsx_global_policy.model.traffic_rate_limits",
            com.vmware.nsx_global_policy.model.StructDefinitions.trafficRateLimits);
        add(mapping,
            "com.vmware.nsx_global_policy.model.transport_info",
            com.vmware.nsx_global_policy.model.StructDefinitions.transportInfo);
        add(mapping,
            "com.vmware.nsx_global_policy.model.transport_node_id_parameters",
            com.vmware.nsx_global_policy.model.StructDefinitions.transportNodeIdParameters);
        add(mapping,
            "com.vmware.nsx_global_policy.model.transport_node_span_enforced_status",
            com.vmware.nsx_global_policy.model.StructDefinitions.transportNodeSpanEnforcedStatus);
        add(mapping,
            "com.vmware.nsx_global_policy.model.transport_protocol_header",
            com.vmware.nsx_global_policy.model.StructDefinitions.transportProtocolHeader);
        add(mapping,
            "com.vmware.nsx_global_policy.model.tunnel_interface_IP_subnet",
            com.vmware.nsx_global_policy.model.StructDefinitions.tunnelInterfaceIPSubnet);
        add(mapping,
            "com.vmware.nsx_global_policy.model.tunnel_subnet",
            com.vmware.nsx_global_policy.model.StructDefinitions.tunnelSubnet);
        add(mapping,
            "com.vmware.nsx_global_policy.model.udp_header",
            com.vmware.nsx_global_policy.model.StructDefinitions.udpHeader);
        add(mapping,
            "com.vmware.nsx_global_policy.model.unary_operation",
            com.vmware.nsx_global_policy.model.StructDefinitions.unaryOperation);
        add(mapping,
            "com.vmware.nsx_global_policy.model.unary_operation_based_injection_value",
            com.vmware.nsx_global_policy.model.StructDefinitions.unaryOperationBasedInjectionValue);
        add(mapping,
            "com.vmware.nsx_global_policy.model.unbounded_key_value_pair",
            com.vmware.nsx_global_policy.model.StructDefinitions.unboundedKeyValuePair);
        add(mapping,
            "com.vmware.nsx_global_policy.model.url_alias",
            com.vmware.nsx_global_policy.model.StructDefinitions.urlAlias);
        add(mapping,
            "com.vmware.nsx_global_policy.model.user_info",
            com.vmware.nsx_global_policy.model.StructDefinitions.userInfo);
        add(mapping,
            "com.vmware.nsx_global_policy.model.VM_deployment_progress_state",
            com.vmware.nsx_global_policy.model.StructDefinitions.VMDeploymentProgressState);
        add(mapping,
            "com.vmware.nsx_global_policy.model.VM_tag_replication_policy",
            com.vmware.nsx_global_policy.model.StructDefinitions.VMTagReplicationPolicy);
        add(mapping,
            "com.vmware.nsx_global_policy.model.VM_tag_replication_policy_list_result",
            com.vmware.nsx_global_policy.model.StructDefinitions.VMTagReplicationPolicyListResult);
        add(mapping,
            "com.vmware.nsx_global_policy.model.value_constraint_expression",
            com.vmware.nsx_global_policy.model.StructDefinitions.valueConstraintExpression);
        add(mapping,
            "com.vmware.nsx_global_policy.model.vdl2_counters",
            com.vmware.nsx_global_policy.model.StructDefinitions.vdl2Counters);
        add(mapping,
            "com.vmware.nsx_global_policy.model.vdrb_counters",
            com.vmware.nsx_global_policy.model.StructDefinitions.vdrbCounters);
        add(mapping,
            "com.vmware.nsx_global_policy.model.version_list",
            com.vmware.nsx_global_policy.model.StructDefinitions.versionList);
        add(mapping,
            "com.vmware.nsx_global_policy.model.vidm_info",
            com.vmware.nsx_global_policy.model.StructDefinitions.vidmInfo);
        add(mapping,
            "com.vmware.nsx_global_policy.model.vidm_info_list_result",
            com.vmware.nsx_global_policy.model.StructDefinitions.vidmInfoListResult);
        add(mapping,
            "com.vmware.nsx_global_policy.model.view",
            com.vmware.nsx_global_policy.model.StructDefinitions.view);
        add(mapping,
            "com.vmware.nsx_global_policy.model.view_list",
            com.vmware.nsx_global_policy.model.StructDefinitions.viewList);
        add(mapping,
            "com.vmware.nsx_global_policy.model.virtual_endpoint",
            com.vmware.nsx_global_policy.model.StructDefinitions.virtualEndpoint);
        add(mapping,
            "com.vmware.nsx_global_policy.model.virtual_network_interface",
            com.vmware.nsx_global_policy.model.StructDefinitions.virtualNetworkInterface);
        add(mapping,
            "com.vmware.nsx_global_policy.model.virtual_network_interface_list_result",
            com.vmware.nsx_global_policy.model.StructDefinitions.virtualNetworkInterfaceListResult);
        add(mapping,
            "com.vmware.nsx_global_policy.model.vlan_vni_range_pair",
            com.vmware.nsx_global_policy.model.StructDefinitions.vlanVniRangePair);
        add(mapping,
            "com.vmware.nsx_global_policy.model.vni_pool_config",
            com.vmware.nsx_global_policy.model.StructDefinitions.vniPoolConfig);
        add(mapping,
            "com.vmware.nsx_global_policy.model.vpc",
            com.vmware.nsx_global_policy.model.StructDefinitions.vpc);
        add(mapping,
            "com.vmware.nsx_global_policy.model.vpc_ip_address_allocation",
            com.vmware.nsx_global_policy.model.StructDefinitions.vpcIpAddressAllocation);
        add(mapping,
            "com.vmware.nsx_global_policy.model.vpc_subnet",
            com.vmware.nsx_global_policy.model.StructDefinitions.vpcSubnet);
        add(mapping,
            "com.vmware.nsx_global_policy.model.vpc_subnet_dhcp_config",
            com.vmware.nsx_global_policy.model.StructDefinitions.vpcSubnetDhcpConfig);
        add(mapping,
            "com.vmware.nsx_global_policy.model.vpc_subnet_port",
            com.vmware.nsx_global_policy.model.StructDefinitions.vpcSubnetPort);
        add(mapping,
            "com.vmware.nsx_global_policy.model.vrf_evpn_l2_vni_config",
            com.vmware.nsx_global_policy.model.StructDefinitions.vrfEvpnL2VniConfig);
        add(mapping,
            "com.vmware.nsx_global_policy.model.vrf_l2_vni_config",
            com.vmware.nsx_global_policy.model.StructDefinitions.vrfL2VniConfig);
        add(mapping,
            "com.vmware.nsx_global_policy.model.vrf_route_targets",
            com.vmware.nsx_global_policy.model.StructDefinitions.vrfRouteTargets);
        add(mapping,
            "com.vmware.nsx_global_policy.model.vrni_global_collector",
            com.vmware.nsx_global_policy.model.StructDefinitions.vrniGlobalCollector);
        add(mapping,
            "com.vmware.nsx_global_policy.model.vsphere_cluster_node_VM_deployment_config",
            com.vmware.nsx_global_policy.model.StructDefinitions.vsphereClusterNodeVMDeploymentConfig);
        add(mapping,
            "com.vmware.nsx_global_policy.model.wave_front_global_collector",
            com.vmware.nsx_global_policy.model.StructDefinitions.waveFrontGlobalCollector);
        add(mapping,
            "com.vmware.nsx_global_policy.model.weekly_backup_schedule",
            com.vmware.nsx_global_policy.model.StructDefinitions.weeklyBackupSchedule);
        add(mapping,
            "com.vmware.nsx_global_policy.model.widget_configuration",
            com.vmware.nsx_global_policy.model.StructDefinitions.widgetConfiguration);
        add(mapping,
            "com.vmware.nsx_global_policy.model.widget_configuration_list",
            com.vmware.nsx_global_policy.model.StructDefinitions.widgetConfigurationList);
        add(mapping,
            "com.vmware.nsx_global_policy.model.widget_item",
            com.vmware.nsx_global_policy.model.StructDefinitions.widgetItem);
        add(mapping,
            "com.vmware.nsx_global_policy.model.widget_plot_configuration",
            com.vmware.nsx_global_policy.model.StructDefinitions.widgetPlotConfiguration);
        add(mapping,
            "com.vmware.nsx_global_policy.model.x509_certificate",
            com.vmware.nsx_global_policy.model.StructDefinitions.x509Certificate);
        add(mapping,
            "com.vmware.nsx_global_policy.model.x509_crl",
            com.vmware.nsx_global_policy.model.StructDefinitions.x509Crl);
        add(mapping,
            "com.vmware.nsx_global_policy.model.x509_crl_entry",
            com.vmware.nsx_global_policy.model.StructDefinitions.x509CrlEntry);
    }

    private static void add(Map<String, StructType> mapping, String key, StructType structType) {
        if (mapping.containsKey(key)) {
            throw new IllegalArgumentException("Two structures with the same canonical name detected: " + key +
                                               ". Unable to populate the map.");
        }
        mapping.put(key, structType);
    }
}
