/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx.
 * Used by client-side stubs.
 */

package com.vmware.nsx;

public interface LogicalPorts extends com.vmware.vapi.bindings.Service, com.vmware.nsx.LogicalPortsTypes {

    /**
     * Creates a new logical switch port. The required parameters are the associated
     * logical_switch_id and admin_state (UP or DOWN). Optional parameters are the
     * attachment and switching_profile_ids. If you don't specify
     * switching_profile_ids, default switching profiles are assigned to the port. If
     * you don't specify an attachment, the switch port remains empty. To configure an
     * attachment, you must specify an id, and optionally you can specify an
     * attachment_type (VIF or LOGICALROUTER). The attachment_type is VIF by default.
     * <br/> This api is now deprecated. Please use new api PUT
     * /infra/segments/<segment-id>/ports/<port-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param logicalPort (required)
     * @return com.vmware.nsx.model.LogicalPort
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.LogicalPort create(com.vmware.nsx.model.LogicalPort logicalPort);

    /**
     * Creates a new logical switch port. The required parameters are the associated
     * logical_switch_id and admin_state (UP or DOWN). Optional parameters are the
     * attachment and switching_profile_ids. If you don't specify
     * switching_profile_ids, default switching profiles are assigned to the port. If
     * you don't specify an attachment, the switch port remains empty. To configure an
     * attachment, you must specify an id, and optionally you can specify an
     * attachment_type (VIF or LOGICALROUTER). The attachment_type is VIF by default.
     * <br/> This api is now deprecated. Please use new api PUT
     * /infra/segments/<segment-id>/ports/<port-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param logicalPort (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.LogicalPort
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.LogicalPort create(com.vmware.nsx.model.LogicalPort logicalPort, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Creates a new logical switch port. The required parameters are the associated
     * logical_switch_id and admin_state (UP or DOWN). Optional parameters are the
     * attachment and switching_profile_ids. If you don't specify
     * switching_profile_ids, default switching profiles are assigned to the port. If
     * you don't specify an attachment, the switch port remains empty. To configure an
     * attachment, you must specify an id, and optionally you can specify an
     * attachment_type (VIF or LOGICALROUTER). The attachment_type is VIF by default.
     * <br/> This api is now deprecated. Please use new api PUT
     * /infra/segments/<segment-id>/ports/<port-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.LogicalPort
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param logicalPort (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void create(com.vmware.nsx.model.LogicalPort logicalPort, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.LogicalPort> asyncCallback);

    /**
     * Creates a new logical switch port. The required parameters are the associated
     * logical_switch_id and admin_state (UP or DOWN). Optional parameters are the
     * attachment and switching_profile_ids. If you don't specify
     * switching_profile_ids, default switching profiles are assigned to the port. If
     * you don't specify an attachment, the switch port remains empty. To configure an
     * attachment, you must specify an id, and optionally you can specify an
     * attachment_type (VIF or LOGICALROUTER). The attachment_type is VIF by default.
     * <br/> This api is now deprecated. Please use new api PUT
     * /infra/segments/<segment-id>/ports/<port-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.LogicalPort
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param logicalPort (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void create(com.vmware.nsx.model.LogicalPort logicalPort, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.LogicalPort> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Deletes the specified logical switch port. By default, if logical port has
     * attachments, or it is added to any NSGroup, the deletion will be failed. Option
     * detach could be used for deleting logical port forcibly. <br/> This api is now
     * deprecated. Please use new api - DELETE
     * /infra/segments/<segment-id>/ports/<port-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param lportId (required)
     * @param detach force delete even if attached or referenced by a group (optional, default to
     * false)
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public void delete(java.lang.String lportId, java.lang.Boolean detach);

    /**
     * Deletes the specified logical switch port. By default, if logical port has
     * attachments, or it is added to any NSGroup, the deletion will be failed. Option
     * detach could be used for deleting logical port forcibly. <br/> This api is now
     * deprecated. Please use new api - DELETE
     * /infra/segments/<segment-id>/ports/<port-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param lportId (required)
     * @param detach force delete even if attached or referenced by a group (optional, default to
     * false)
     * @param invocationConfig Configuration for the method invocation.
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public void delete(java.lang.String lportId, java.lang.Boolean detach, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Deletes the specified logical switch port. By default, if logical port has
     * attachments, or it is added to any NSGroup, the deletion will be failed. Option
     * detach could be used for deleting logical port forcibly. <br/> This api is now
     * deprecated. Please use new api - DELETE
     * /infra/segments/<segment-id>/ports/<port-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param lportId (required)
     * @param detach force delete even if attached or referenced by a group (optional, default to
     * false)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void delete(java.lang.String lportId, java.lang.Boolean detach, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback);

    /**
     * Deletes the specified logical switch port. By default, if logical port has
     * attachments, or it is added to any NSGroup, the deletion will be failed. Option
     * detach could be used for deleting logical port forcibly. <br/> This api is now
     * deprecated. Please use new api - DELETE
     * /infra/segments/<segment-id>/ports/<port-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param lportId (required)
     * @param detach force delete even if attached or referenced by a group (optional, default to
     * false)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void delete(java.lang.String lportId, java.lang.Boolean detach, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Returns information about a specified logical port. <br/> Please use
     * corresponding policy API /infra/segments/<segment-id>/ports/<lport-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param lportId (required)
     * @return com.vmware.nsx.model.LogicalPort
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.LogicalPort get(java.lang.String lportId);

    /**
     * Returns information about a specified logical port. <br/> Please use
     * corresponding policy API /infra/segments/<segment-id>/ports/<lport-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param lportId (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.LogicalPort
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.LogicalPort get(java.lang.String lportId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Returns information about a specified logical port. <br/> Please use
     * corresponding policy API /infra/segments/<segment-id>/ports/<lport-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.LogicalPort
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param lportId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void get(java.lang.String lportId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.LogicalPort> asyncCallback);

    /**
     * Returns information about a specified logical port. <br/> Please use
     * corresponding policy API /infra/segments/<segment-id>/ports/<lport-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.LogicalPort
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param lportId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void get(java.lang.String lportId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.LogicalPort> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Returns information about all configured logical switch ports. Logical switch
     * ports connect to VM virtual network interface cards (NICs). Each logical port is
     * associated with one logical switch. <br/> This api is now deprecated. Please use
     * new api - /infra/segments/<segment-id>/ports
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param attachmentId Logical Port attachment Id (optional)
     * @param attachmentType Type of attachment for logical port; for query only. (optional)
     * @param bridgeClusterId Bridge Cluster identifier (optional)
     * @param containerPortsOnly Only container VIF logical ports will be returned if true (optional, default to
     * false)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param diagnostic Flag to enable showing of transit logical port. (optional, default to false)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param logicalSwitchId Logical Switch identifier (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param parentVifId ID of the VIF of type PARENT (optional)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param switchingProfileId Network Profile identifier (optional)
     * @param transportNodeId Transport node identifier (optional)
     * @param transportZoneId Transport zone identifier (optional)
     * @return com.vmware.nsx.model.LogicalPortListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.LogicalPortListResult list(java.lang.String attachmentId, java.lang.String attachmentType, java.lang.String bridgeClusterId, java.lang.Boolean containerPortsOnly, java.lang.String cursor, java.lang.Boolean diagnostic, java.lang.String includedFields, java.lang.String logicalSwitchId, java.lang.Long pageSize, java.lang.String parentVifId, java.lang.Boolean sortAscending, java.lang.String sortBy, java.lang.String switchingProfileId, java.lang.String transportNodeId, java.lang.String transportZoneId);

    /**
     * Returns information about all configured logical switch ports. Logical switch
     * ports connect to VM virtual network interface cards (NICs). Each logical port is
     * associated with one logical switch. <br/> This api is now deprecated. Please use
     * new api - /infra/segments/<segment-id>/ports
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param attachmentId Logical Port attachment Id (optional)
     * @param attachmentType Type of attachment for logical port; for query only. (optional)
     * @param bridgeClusterId Bridge Cluster identifier (optional)
     * @param containerPortsOnly Only container VIF logical ports will be returned if true (optional, default to
     * false)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param diagnostic Flag to enable showing of transit logical port. (optional, default to false)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param logicalSwitchId Logical Switch identifier (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param parentVifId ID of the VIF of type PARENT (optional)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param switchingProfileId Network Profile identifier (optional)
     * @param transportNodeId Transport node identifier (optional)
     * @param transportZoneId Transport zone identifier (optional)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.LogicalPortListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.LogicalPortListResult list(java.lang.String attachmentId, java.lang.String attachmentType, java.lang.String bridgeClusterId, java.lang.Boolean containerPortsOnly, java.lang.String cursor, java.lang.Boolean diagnostic, java.lang.String includedFields, java.lang.String logicalSwitchId, java.lang.Long pageSize, java.lang.String parentVifId, java.lang.Boolean sortAscending, java.lang.String sortBy, java.lang.String switchingProfileId, java.lang.String transportNodeId, java.lang.String transportZoneId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Returns information about all configured logical switch ports. Logical switch
     * ports connect to VM virtual network interface cards (NICs). Each logical port is
     * associated with one logical switch. <br/> This api is now deprecated. Please use
     * new api - /infra/segments/<segment-id>/ports
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.LogicalPortListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param attachmentId Logical Port attachment Id (optional)
     * @param attachmentType Type of attachment for logical port; for query only. (optional)
     * @param bridgeClusterId Bridge Cluster identifier (optional)
     * @param containerPortsOnly Only container VIF logical ports will be returned if true (optional, default to
     * false)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param diagnostic Flag to enable showing of transit logical port. (optional, default to false)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param logicalSwitchId Logical Switch identifier (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param parentVifId ID of the VIF of type PARENT (optional)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param switchingProfileId Network Profile identifier (optional)
     * @param transportNodeId Transport node identifier (optional)
     * @param transportZoneId Transport zone identifier (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void list(java.lang.String attachmentId, java.lang.String attachmentType, java.lang.String bridgeClusterId, java.lang.Boolean containerPortsOnly, java.lang.String cursor, java.lang.Boolean diagnostic, java.lang.String includedFields, java.lang.String logicalSwitchId, java.lang.Long pageSize, java.lang.String parentVifId, java.lang.Boolean sortAscending, java.lang.String sortBy, java.lang.String switchingProfileId, java.lang.String transportNodeId, java.lang.String transportZoneId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.LogicalPortListResult> asyncCallback);

    /**
     * Returns information about all configured logical switch ports. Logical switch
     * ports connect to VM virtual network interface cards (NICs). Each logical port is
     * associated with one logical switch. <br/> This api is now deprecated. Please use
     * new api - /infra/segments/<segment-id>/ports
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.LogicalPortListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param attachmentId Logical Port attachment Id (optional)
     * @param attachmentType Type of attachment for logical port; for query only. (optional)
     * @param bridgeClusterId Bridge Cluster identifier (optional)
     * @param containerPortsOnly Only container VIF logical ports will be returned if true (optional, default to
     * false)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param diagnostic Flag to enable showing of transit logical port. (optional, default to false)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param logicalSwitchId Logical Switch identifier (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param parentVifId ID of the VIF of type PARENT (optional)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param switchingProfileId Network Profile identifier (optional)
     * @param transportNodeId Transport node identifier (optional)
     * @param transportZoneId Transport zone identifier (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void list(java.lang.String attachmentId, java.lang.String attachmentType, java.lang.String bridgeClusterId, java.lang.Boolean containerPortsOnly, java.lang.String cursor, java.lang.Boolean diagnostic, java.lang.String includedFields, java.lang.String logicalSwitchId, java.lang.Long pageSize, java.lang.String parentVifId, java.lang.Boolean sortAscending, java.lang.String sortBy, java.lang.String switchingProfileId, java.lang.String transportNodeId, java.lang.String transportZoneId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.LogicalPortListResult> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Modifies an existing logical switch port. Parameters that can be modified
     * include attachment_type (LOGICALROUTER, VIF), admin_state (UP or DOWN),
     * attachment id and switching_profile_ids. You cannot modify the
     * logical_switch_id. In other words, you cannot move an existing port from one
     * switch to another switch. <br/> This api is now deprecated. Please use new api -
     * /infra/segments/<segment-id>/ports/<port-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param lportId (required)
     * @param logicalPort (required)
     * @return com.vmware.nsx.model.LogicalPort
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.LogicalPort update(java.lang.String lportId, com.vmware.nsx.model.LogicalPort logicalPort);

    /**
     * Modifies an existing logical switch port. Parameters that can be modified
     * include attachment_type (LOGICALROUTER, VIF), admin_state (UP or DOWN),
     * attachment id and switching_profile_ids. You cannot modify the
     * logical_switch_id. In other words, you cannot move an existing port from one
     * switch to another switch. <br/> This api is now deprecated. Please use new api -
     * /infra/segments/<segment-id>/ports/<port-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param lportId (required)
     * @param logicalPort (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.LogicalPort
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.LogicalPort update(java.lang.String lportId, com.vmware.nsx.model.LogicalPort logicalPort, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Modifies an existing logical switch port. Parameters that can be modified
     * include attachment_type (LOGICALROUTER, VIF), admin_state (UP or DOWN),
     * attachment id and switching_profile_ids. You cannot modify the
     * logical_switch_id. In other words, you cannot move an existing port from one
     * switch to another switch. <br/> This api is now deprecated. Please use new api -
     * /infra/segments/<segment-id>/ports/<port-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.LogicalPort
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param lportId (required)
     * @param logicalPort (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void update(java.lang.String lportId, com.vmware.nsx.model.LogicalPort logicalPort, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.LogicalPort> asyncCallback);

    /**
     * Modifies an existing logical switch port. Parameters that can be modified
     * include attachment_type (LOGICALROUTER, VIF), admin_state (UP or DOWN),
     * attachment id and switching_profile_ids. You cannot modify the
     * logical_switch_id. In other words, you cannot move an existing port from one
     * switch to another switch. <br/> This api is now deprecated. Please use new api -
     * /infra/segments/<segment-id>/ports/<port-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.LogicalPort
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param lportId (required)
     * @param logicalPort (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void update(java.lang.String lportId, com.vmware.nsx.model.LogicalPort logicalPort, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.LogicalPort> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
