
/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 */


package com.vmware.nsx.dhcp.servers;

/**
 * {@link ServersFactory} is responsible for creating instances of services
 * contained inside the com.vmware.nsx.dhcp.servers package and also has the subpackages reference
 * to access respective subpackage services.
 * <p>
*/
public class ServersFactory {

    private com.vmware.vapi.bindings.StubFactory stubFactory;
    private com.vmware.vapi.bindings.StubConfiguration stubConfig;

    // restricting developers to create instance of this class directly
    private ServersFactory() {

    }

    /**
     * Creates the new instance of this class with provided configuration
     * @param stubFactory {@link StubFactory} instance is responsible for creating stubs
     * @param stubConfig {@link StubConfiguration} instance is required to authenticate the request
     * @return {@link ServersFactory} factory instance
     */
    public static ServersFactory getFactory(com.vmware.vapi.bindings.StubFactory stubFactory, com.vmware.vapi.bindings.StubConfiguration stubConfig) {
        ServersFactory instance = new ServersFactory();
        instance.stubFactory = stubFactory;
        instance.stubConfig = stubConfig;
        return instance;
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.dhcp.servers.IpPools}
     */
    public com.vmware.nsx.dhcp.servers.IpPools ipPoolsService() {
        return this.stubFactory.createStub(IpPools.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.dhcp.servers.Ipv6IpPools}
     */
    public com.vmware.nsx.dhcp.servers.Ipv6IpPools ipv6IpPoolsService() {
        return this.stubFactory.createStub(Ipv6IpPools.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.dhcp.servers.Ipv6StaticBindings}
     */
    public com.vmware.nsx.dhcp.servers.Ipv6StaticBindings ipv6StaticBindingsService() {
        return this.stubFactory.createStub(Ipv6StaticBindings.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.dhcp.servers.Leases}
     */
    public com.vmware.nsx.dhcp.servers.Leases leasesService() {
        return this.stubFactory.createStub(Leases.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.dhcp.servers.State}
     */
    public com.vmware.nsx.dhcp.servers.State stateService() {
        return this.stubFactory.createStub(State.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.dhcp.servers.StaticBindings}
     */
    public com.vmware.nsx.dhcp.servers.StaticBindings staticBindingsService() {
        return this.stubFactory.createStub(StaticBindings.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.dhcp.servers.Statistics}
     */
    public com.vmware.nsx.dhcp.servers.Statistics statisticsService() {
        return this.stubFactory.createStub(Statistics.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.dhcp.servers.Status}
     */
    public com.vmware.nsx.dhcp.servers.Status statusService() {
        return this.stubFactory.createStub(Status.class, this.stubConfig);
    }

    public com.vmware.nsx.dhcp.servers.ip_pools.IpPoolsFactory ipPools() {
        return com.vmware.nsx.dhcp.servers.ip_pools.IpPoolsFactory.getFactory(this.stubFactory, this.stubConfig);
    }

    public com.vmware.nsx.dhcp.servers.static_bindings.StaticBindingsFactory staticBindings() {
        return com.vmware.nsx.dhcp.servers.static_bindings.StaticBindingsFactory.getFactory(this.stubFactory, this.stubConfig);
    }

    public void updateStubConfiguration(com.vmware.vapi.bindings.StubFactory stubFactory, com.vmware.vapi.bindings.StubConfiguration stubConfig) {
        if (this.stubFactory == stubFactory && this.stubConfig == stubConfig)
            return;

        this.stubFactory = stubFactory;
        this.stubConfig = stubConfig;
    }

}
