/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx.directory.domains.
 * Used by client-side stubs.
 */

package com.vmware.nsx.directory.domains;

public interface LdapServers extends com.vmware.vapi.bindings.Service, com.vmware.nsx.directory.domains.LdapServersTypes {

    /**
     * More than one LDAP server can be created and only one LDAP server is used to
     * synchronize directory objects. If more than one LDAP server is configured, NSX
     * will try all the servers until it is able to successfully connect to one. <br/>
     * <br/> Use the following Policy API - <br/> POST
     * /policy/api/v1/infra/firewall-identity-stores/<firewall-identity-store-id>/ldap-servers/<ldap-server-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param domainId Directory domain identifier (required)
     * @param directoryLdapServer (required)
     * @return com.vmware.nsx.model.DirectoryLdapServer
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.DirectoryLdapServer create(java.lang.String domainId, com.vmware.nsx.model.DirectoryLdapServer directoryLdapServer);

    /**
     * More than one LDAP server can be created and only one LDAP server is used to
     * synchronize directory objects. If more than one LDAP server is configured, NSX
     * will try all the servers until it is able to successfully connect to one. <br/>
     * <br/> Use the following Policy API - <br/> POST
     * /policy/api/v1/infra/firewall-identity-stores/<firewall-identity-store-id>/ldap-servers/<ldap-server-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param domainId Directory domain identifier (required)
     * @param directoryLdapServer (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.DirectoryLdapServer
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.DirectoryLdapServer create(java.lang.String domainId, com.vmware.nsx.model.DirectoryLdapServer directoryLdapServer, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * More than one LDAP server can be created and only one LDAP server is used to
     * synchronize directory objects. If more than one LDAP server is configured, NSX
     * will try all the servers until it is able to successfully connect to one. <br/>
     * <br/> Use the following Policy API - <br/> POST
     * /policy/api/v1/infra/firewall-identity-stores/<firewall-identity-store-id>/ldap-servers/<ldap-server-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.DirectoryLdapServer
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param domainId Directory domain identifier (required)
     * @param directoryLdapServer (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void create(java.lang.String domainId, com.vmware.nsx.model.DirectoryLdapServer directoryLdapServer, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.DirectoryLdapServer> asyncCallback);

    /**
     * More than one LDAP server can be created and only one LDAP server is used to
     * synchronize directory objects. If more than one LDAP server is configured, NSX
     * will try all the servers until it is able to successfully connect to one. <br/>
     * <br/> Use the following Policy API - <br/> POST
     * /policy/api/v1/infra/firewall-identity-stores/<firewall-identity-store-id>/ldap-servers/<ldap-server-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.DirectoryLdapServer
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param domainId Directory domain identifier (required)
     * @param directoryLdapServer (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void create(java.lang.String domainId, com.vmware.nsx.model.DirectoryLdapServer directoryLdapServer, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.DirectoryLdapServer> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * The API tests a LDAP server connection for an already configured domain. If the
     * connection is successful, the response will be HTTP status 200. Otherwise the
     * response will be HTTP status 500 and corresponding error message will be
     * returned. <br/> <br/> Use the following Policy API - <br/> POST
     * /policy/api/v1/infra/firewall-identity-stores/<firewall-identity-store-id>/ldap-servers/<ldap-server-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param domainId Directory domain identifier (required)
     * @param serverId LDAP server identifier (required)
     * @param action LDAP server test requested (required)
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public void create0(java.lang.String domainId, java.lang.String serverId, java.lang.String action);

    /**
     * The API tests a LDAP server connection for an already configured domain. If the
     * connection is successful, the response will be HTTP status 200. Otherwise the
     * response will be HTTP status 500 and corresponding error message will be
     * returned. <br/> <br/> Use the following Policy API - <br/> POST
     * /policy/api/v1/infra/firewall-identity-stores/<firewall-identity-store-id>/ldap-servers/<ldap-server-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param domainId Directory domain identifier (required)
     * @param serverId LDAP server identifier (required)
     * @param action LDAP server test requested (required)
     * @param invocationConfig Configuration for the method invocation.
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public void create0(java.lang.String domainId, java.lang.String serverId, java.lang.String action, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * The API tests a LDAP server connection for an already configured domain. If the
     * connection is successful, the response will be HTTP status 200. Otherwise the
     * response will be HTTP status 500 and corresponding error message will be
     * returned. <br/> <br/> Use the following Policy API - <br/> POST
     * /policy/api/v1/infra/firewall-identity-stores/<firewall-identity-store-id>/ldap-servers/<ldap-server-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param domainId Directory domain identifier (required)
     * @param serverId LDAP server identifier (required)
     * @param action LDAP server test requested (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void create0(java.lang.String domainId, java.lang.String serverId, java.lang.String action, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback);

    /**
     * The API tests a LDAP server connection for an already configured domain. If the
     * connection is successful, the response will be HTTP status 200. Otherwise the
     * response will be HTTP status 500 and corresponding error message will be
     * returned. <br/> <br/> Use the following Policy API - <br/> POST
     * /policy/api/v1/infra/firewall-identity-stores/<firewall-identity-store-id>/ldap-servers/<ldap-server-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param domainId Directory domain identifier (required)
     * @param serverId LDAP server identifier (required)
     * @param action LDAP server test requested (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void create0(java.lang.String domainId, java.lang.String serverId, java.lang.String action, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Delete a LDAP server for directory domain <br/> <br/> Use the following Policy
     * API - <br/> DELETE
     * /policy/api/v1/infra/firewall-identity-stores/<firewall-identity-store-id>/ldap-servers/<ldap-server-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param domainId Directory domain identifier (required)
     * @param serverId LDAP server identifier (required)
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public void delete(java.lang.String domainId, java.lang.String serverId);

    /**
     * Delete a LDAP server for directory domain <br/> <br/> Use the following Policy
     * API - <br/> DELETE
     * /policy/api/v1/infra/firewall-identity-stores/<firewall-identity-store-id>/ldap-servers/<ldap-server-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param domainId Directory domain identifier (required)
     * @param serverId LDAP server identifier (required)
     * @param invocationConfig Configuration for the method invocation.
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public void delete(java.lang.String domainId, java.lang.String serverId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Delete a LDAP server for directory domain <br/> <br/> Use the following Policy
     * API - <br/> DELETE
     * /policy/api/v1/infra/firewall-identity-stores/<firewall-identity-store-id>/ldap-servers/<ldap-server-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param domainId Directory domain identifier (required)
     * @param serverId LDAP server identifier (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void delete(java.lang.String domainId, java.lang.String serverId, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback);

    /**
     * Delete a LDAP server for directory domain <br/> <br/> Use the following Policy
     * API - <br/> DELETE
     * /policy/api/v1/infra/firewall-identity-stores/<firewall-identity-store-id>/ldap-servers/<ldap-server-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param domainId Directory domain identifier (required)
     * @param serverId LDAP server identifier (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void delete(java.lang.String domainId, java.lang.String serverId, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Get a specific LDAP server for a given directory domain <br/> <br/> Use the
     * following Policy API - <br/> GET
     * /policy/api/v1/infra/firewall-identity-stores/<firewall-identity-store-id>/ldap-servers/<ldap-server-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param domainId Directory domain identifier (required)
     * @param serverId LDAP server identifier (required)
     * @return com.vmware.nsx.model.DirectoryLdapServer
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.DirectoryLdapServer get(java.lang.String domainId, java.lang.String serverId);

    /**
     * Get a specific LDAP server for a given directory domain <br/> <br/> Use the
     * following Policy API - <br/> GET
     * /policy/api/v1/infra/firewall-identity-stores/<firewall-identity-store-id>/ldap-servers/<ldap-server-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param domainId Directory domain identifier (required)
     * @param serverId LDAP server identifier (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.DirectoryLdapServer
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.DirectoryLdapServer get(java.lang.String domainId, java.lang.String serverId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Get a specific LDAP server for a given directory domain <br/> <br/> Use the
     * following Policy API - <br/> GET
     * /policy/api/v1/infra/firewall-identity-stores/<firewall-identity-store-id>/ldap-servers/<ldap-server-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.DirectoryLdapServer
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param domainId Directory domain identifier (required)
     * @param serverId LDAP server identifier (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void get(java.lang.String domainId, java.lang.String serverId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.DirectoryLdapServer> asyncCallback);

    /**
     * Get a specific LDAP server for a given directory domain <br/> <br/> Use the
     * following Policy API - <br/> GET
     * /policy/api/v1/infra/firewall-identity-stores/<firewall-identity-store-id>/ldap-servers/<ldap-server-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.DirectoryLdapServer
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param domainId Directory domain identifier (required)
     * @param serverId LDAP server identifier (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void get(java.lang.String domainId, java.lang.String serverId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.DirectoryLdapServer> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * List all configured domain LDAP servers <br/> <br/> Use the following Policy API
     * - <br/> GET
     * /policy/api/v1/infra/firewall-identity-stores/<firewall-identity-store-id>/ldap-servers
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param domainId Directory domain identifier (required)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @return com.vmware.nsx.model.DirectoryLdapServerListResults
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.DirectoryLdapServerListResults list(java.lang.String domainId, java.lang.String cursor, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy);

    /**
     * List all configured domain LDAP servers <br/> <br/> Use the following Policy API
     * - <br/> GET
     * /policy/api/v1/infra/firewall-identity-stores/<firewall-identity-store-id>/ldap-servers
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param domainId Directory domain identifier (required)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.DirectoryLdapServerListResults
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.DirectoryLdapServerListResults list(java.lang.String domainId, java.lang.String cursor, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * List all configured domain LDAP servers <br/> <br/> Use the following Policy API
     * - <br/> GET
     * /policy/api/v1/infra/firewall-identity-stores/<firewall-identity-store-id>/ldap-servers
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.DirectoryLdapServerListResults
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param domainId Directory domain identifier (required)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void list(java.lang.String domainId, java.lang.String cursor, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.DirectoryLdapServerListResults> asyncCallback);

    /**
     * List all configured domain LDAP servers <br/> <br/> Use the following Policy API
     * - <br/> GET
     * /policy/api/v1/infra/firewall-identity-stores/<firewall-identity-store-id>/ldap-servers
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.DirectoryLdapServerListResults
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param domainId Directory domain identifier (required)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void list(java.lang.String domainId, java.lang.String cursor, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.DirectoryLdapServerListResults> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Update a LDAP server for directory domain <br/> <br/> Use the following Policy
     * API - <br/> PUT
     * /policy/api/v1/infra/firewall-identity-stores/<firewall-identity-store-id>/ldap-servers/<ldap-server-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param domainId Directory domain identifier (required)
     * @param serverId LDAP server identifier (required)
     * @param directoryLdapServer (required)
     * @return com.vmware.nsx.model.DirectoryLdapServer
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.DirectoryLdapServer update(java.lang.String domainId, java.lang.String serverId, com.vmware.nsx.model.DirectoryLdapServer directoryLdapServer);

    /**
     * Update a LDAP server for directory domain <br/> <br/> Use the following Policy
     * API - <br/> PUT
     * /policy/api/v1/infra/firewall-identity-stores/<firewall-identity-store-id>/ldap-servers/<ldap-server-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param domainId Directory domain identifier (required)
     * @param serverId LDAP server identifier (required)
     * @param directoryLdapServer (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.DirectoryLdapServer
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.DirectoryLdapServer update(java.lang.String domainId, java.lang.String serverId, com.vmware.nsx.model.DirectoryLdapServer directoryLdapServer, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Update a LDAP server for directory domain <br/> <br/> Use the following Policy
     * API - <br/> PUT
     * /policy/api/v1/infra/firewall-identity-stores/<firewall-identity-store-id>/ldap-servers/<ldap-server-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.DirectoryLdapServer
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param domainId Directory domain identifier (required)
     * @param serverId LDAP server identifier (required)
     * @param directoryLdapServer (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void update(java.lang.String domainId, java.lang.String serverId, com.vmware.nsx.model.DirectoryLdapServer directoryLdapServer, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.DirectoryLdapServer> asyncCallback);

    /**
     * Update a LDAP server for directory domain <br/> <br/> Use the following Policy
     * API - <br/> PUT
     * /policy/api/v1/infra/firewall-identity-stores/<firewall-identity-store-id>/ldap-servers/<ldap-server-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.DirectoryLdapServer
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param domainId Directory domain identifier (required)
     * @param serverId LDAP server identifier (required)
     * @param directoryLdapServer (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void update(java.lang.String domainId, java.lang.String serverId, com.vmware.nsx.model.DirectoryLdapServer directoryLdapServer, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.DirectoryLdapServer> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
