/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx.fabric.
 * Used by client-side stubs.
 */

package com.vmware.nsx.fabric;

public interface DiscoveredNodes extends com.vmware.vapi.bindings.Service, com.vmware.nsx.fabric.DiscoveredNodesTypes {

    /**
     * NSX components are installaed on host and transport node is created with given
     * configurations.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param nodeExtId (required)
     * @param transportNode (required)
     * @param overrideNsxOwnership Override NSX Ownership (optional, default to false)
     * @return com.vmware.nsx.model.TransportNode
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx.model.TransportNode createtransportnode(java.lang.String nodeExtId, com.vmware.nsx.model.TransportNode transportNode, java.lang.Boolean overrideNsxOwnership);

    /**
     * NSX components are installaed on host and transport node is created with given
     * configurations.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param nodeExtId (required)
     * @param transportNode (required)
     * @param overrideNsxOwnership Override NSX Ownership (optional, default to false)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.TransportNode
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx.model.TransportNode createtransportnode(java.lang.String nodeExtId, com.vmware.nsx.model.TransportNode transportNode, java.lang.Boolean overrideNsxOwnership, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * NSX components are installaed on host and transport node is created with given
     * configurations.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.TransportNode
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param nodeExtId (required)
     * @param transportNode (required)
     * @param overrideNsxOwnership Override NSX Ownership (optional, default to false)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void createtransportnode(java.lang.String nodeExtId, com.vmware.nsx.model.TransportNode transportNode, java.lang.Boolean overrideNsxOwnership, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.TransportNode> asyncCallback);

    /**
     * NSX components are installaed on host and transport node is created with given
     * configurations.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.TransportNode
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param nodeExtId (required)
     * @param transportNode (required)
     * @param overrideNsxOwnership Override NSX Ownership (optional, default to false)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void createtransportnode(java.lang.String nodeExtId, com.vmware.nsx.model.TransportNode transportNode, java.lang.Boolean overrideNsxOwnership, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.TransportNode> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Returns information about a specific discovered node.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param nodeExtId (required)
     * @return com.vmware.nsx.model.DiscoveredNode
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx.model.DiscoveredNode get(java.lang.String nodeExtId);

    /**
     * Returns information about a specific discovered node.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param nodeExtId (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.DiscoveredNode
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx.model.DiscoveredNode get(java.lang.String nodeExtId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Returns information about a specific discovered node.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.DiscoveredNode
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param nodeExtId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void get(java.lang.String nodeExtId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.DiscoveredNode> asyncCallback);

    /**
     * Returns information about a specific discovered node.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.DiscoveredNode
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param nodeExtId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void get(java.lang.String nodeExtId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.DiscoveredNode> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Returns information about all discovered nodes.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param cmLocalId Local Id of the discovered node in the Compute Manager (optional)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param displayName Display name of discovered node (optional)
     * @param externalId External id of the discovered node, ex. a mo-ref from VC (optional)
     * @param hasParent Discovered node has a parent compute collection or is a standalone host
     * (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param ipAddress IP address of the discovered node (optional)
     * @param nodeId Id of the fabric node created from the discovered node (optional)
     * @param nodeType Discovered Node type like HostNode (optional)
     * @param originId Id of the compute manager from where this node was discovered (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param parentComputeCollection External id of the compute collection to which this node belongs (optional)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @return com.vmware.nsx.model.DiscoveredNodeListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx.model.DiscoveredNodeListResult list(java.lang.String cmLocalId, java.lang.String cursor, java.lang.String displayName, java.lang.String externalId, java.lang.String hasParent, java.lang.String includedFields, java.lang.String ipAddress, java.lang.String nodeId, java.lang.String nodeType, java.lang.String originId, java.lang.Long pageSize, java.lang.String parentComputeCollection, java.lang.Boolean sortAscending, java.lang.String sortBy);

    /**
     * Returns information about all discovered nodes.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param cmLocalId Local Id of the discovered node in the Compute Manager (optional)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param displayName Display name of discovered node (optional)
     * @param externalId External id of the discovered node, ex. a mo-ref from VC (optional)
     * @param hasParent Discovered node has a parent compute collection or is a standalone host
     * (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param ipAddress IP address of the discovered node (optional)
     * @param nodeId Id of the fabric node created from the discovered node (optional)
     * @param nodeType Discovered Node type like HostNode (optional)
     * @param originId Id of the compute manager from where this node was discovered (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param parentComputeCollection External id of the compute collection to which this node belongs (optional)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.DiscoveredNodeListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx.model.DiscoveredNodeListResult list(java.lang.String cmLocalId, java.lang.String cursor, java.lang.String displayName, java.lang.String externalId, java.lang.String hasParent, java.lang.String includedFields, java.lang.String ipAddress, java.lang.String nodeId, java.lang.String nodeType, java.lang.String originId, java.lang.Long pageSize, java.lang.String parentComputeCollection, java.lang.Boolean sortAscending, java.lang.String sortBy, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Returns information about all discovered nodes.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.DiscoveredNodeListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param cmLocalId Local Id of the discovered node in the Compute Manager (optional)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param displayName Display name of discovered node (optional)
     * @param externalId External id of the discovered node, ex. a mo-ref from VC (optional)
     * @param hasParent Discovered node has a parent compute collection or is a standalone host
     * (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param ipAddress IP address of the discovered node (optional)
     * @param nodeId Id of the fabric node created from the discovered node (optional)
     * @param nodeType Discovered Node type like HostNode (optional)
     * @param originId Id of the compute manager from where this node was discovered (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param parentComputeCollection External id of the compute collection to which this node belongs (optional)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void list(java.lang.String cmLocalId, java.lang.String cursor, java.lang.String displayName, java.lang.String externalId, java.lang.String hasParent, java.lang.String includedFields, java.lang.String ipAddress, java.lang.String nodeId, java.lang.String nodeType, java.lang.String originId, java.lang.Long pageSize, java.lang.String parentComputeCollection, java.lang.Boolean sortAscending, java.lang.String sortBy, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.DiscoveredNodeListResult> asyncCallback);

    /**
     * Returns information about all discovered nodes.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.DiscoveredNodeListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param cmLocalId Local Id of the discovered node in the Compute Manager (optional)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param displayName Display name of discovered node (optional)
     * @param externalId External id of the discovered node, ex. a mo-ref from VC (optional)
     * @param hasParent Discovered node has a parent compute collection or is a standalone host
     * (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param ipAddress IP address of the discovered node (optional)
     * @param nodeId Id of the fabric node created from the discovered node (optional)
     * @param nodeType Discovered Node type like HostNode (optional)
     * @param originId Id of the compute manager from where this node was discovered (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param parentComputeCollection External id of the compute collection to which this node belongs (optional)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void list(java.lang.String cmLocalId, java.lang.String cursor, java.lang.String displayName, java.lang.String externalId, java.lang.String hasParent, java.lang.String includedFields, java.lang.String ipAddress, java.lang.String nodeId, java.lang.String nodeType, java.lang.String originId, java.lang.Long pageSize, java.lang.String parentComputeCollection, java.lang.Boolean sortAscending, java.lang.String sortBy, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.DiscoveredNodeListResult> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * When transport node profile (TNP) is applied to a cluster, if any validation
     * fails (e.g. VMs running on host) then transport node (TN) is not created. In
     * that case after the required action is taken (e.g. VMs powered off), you can
     * call this API to try to create TN for that discovered node. Do not call this API
     * if Transport Node already exists for the discovered node. In that case use API
     * on transport node.
     * /transport-nodes/<transport-node-id>?action=restore_cluster_config
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param nodeExtId (required)
     * @param overrideNsxOwnership Override NSX Ownership (optional, default to false)
     * @return com.vmware.nsx.model.TransportNode
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx.model.TransportNode reapplyclusterconfig(java.lang.String nodeExtId, java.lang.Boolean overrideNsxOwnership);

    /**
     * When transport node profile (TNP) is applied to a cluster, if any validation
     * fails (e.g. VMs running on host) then transport node (TN) is not created. In
     * that case after the required action is taken (e.g. VMs powered off), you can
     * call this API to try to create TN for that discovered node. Do not call this API
     * if Transport Node already exists for the discovered node. In that case use API
     * on transport node.
     * /transport-nodes/<transport-node-id>?action=restore_cluster_config
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param nodeExtId (required)
     * @param overrideNsxOwnership Override NSX Ownership (optional, default to false)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.TransportNode
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx.model.TransportNode reapplyclusterconfig(java.lang.String nodeExtId, java.lang.Boolean overrideNsxOwnership, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * When transport node profile (TNP) is applied to a cluster, if any validation
     * fails (e.g. VMs running on host) then transport node (TN) is not created. In
     * that case after the required action is taken (e.g. VMs powered off), you can
     * call this API to try to create TN for that discovered node. Do not call this API
     * if Transport Node already exists for the discovered node. In that case use API
     * on transport node.
     * /transport-nodes/<transport-node-id>?action=restore_cluster_config
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.TransportNode
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param nodeExtId (required)
     * @param overrideNsxOwnership Override NSX Ownership (optional, default to false)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void reapplyclusterconfig(java.lang.String nodeExtId, java.lang.Boolean overrideNsxOwnership, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.TransportNode> asyncCallback);

    /**
     * When transport node profile (TNP) is applied to a cluster, if any validation
     * fails (e.g. VMs running on host) then transport node (TN) is not created. In
     * that case after the required action is taken (e.g. VMs powered off), you can
     * call this API to try to create TN for that discovered node. Do not call this API
     * if Transport Node already exists for the discovered node. In that case use API
     * on transport node.
     * /transport-nodes/<transport-node-id>?action=restore_cluster_config
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.TransportNode
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param nodeExtId (required)
     * @param overrideNsxOwnership Override NSX Ownership (optional, default to false)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void reapplyclusterconfig(java.lang.String nodeExtId, java.lang.Boolean overrideNsxOwnership, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.TransportNode> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
