/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx.firewall.
 * Used by client-side stubs.
 */

package com.vmware.nsx.firewall;

public interface Profiles extends com.vmware.vapi.bindings.Service, com.vmware.nsx.firewall.ProfilesTypes {

    /**
     * Create a firewall profile with values provided. It creates profile based
     * resource_type in the payload. <br/> <br/> Use one of the following Policy APIs
     * depending upon the profile type - <br/> PUT|PATCH
     * /policy/api/v1/infra/settings/firewall/cpu-mem-thresholds-profiles/<profile-id>
     * <br/> PUT|PATCH /policy/api/v1/infra/dns-security-profiles/<profile-id> <br/>
     * PATCH
     * /policy/api/v1/infra/flood-protection-profiles/<flood-protection-profile-id>
     * <br/> PUT|PATCH
     * /policy/api/v1/infra/firewall-session-timer-profiles/<firewall-session-timer-profile-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param baseFirewallProfile (required)
     * The parameter must contain all the properties defined in {@link
     * com.vmware.nsx.model.BaseFirewallProfile}.
     * @return com.vmware.nsx.model.BaseFirewallProfile
     * The return value will contain all the properties defined in {@link
     * com.vmware.nsx.model.BaseFirewallProfile}.
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.vapi.bindings.Structure create(com.vmware.vapi.bindings.Structure baseFirewallProfile);

    /**
     * Create a firewall profile with values provided. It creates profile based
     * resource_type in the payload. <br/> <br/> Use one of the following Policy APIs
     * depending upon the profile type - <br/> PUT|PATCH
     * /policy/api/v1/infra/settings/firewall/cpu-mem-thresholds-profiles/<profile-id>
     * <br/> PUT|PATCH /policy/api/v1/infra/dns-security-profiles/<profile-id> <br/>
     * PATCH
     * /policy/api/v1/infra/flood-protection-profiles/<flood-protection-profile-id>
     * <br/> PUT|PATCH
     * /policy/api/v1/infra/firewall-session-timer-profiles/<firewall-session-timer-profile-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param baseFirewallProfile (required)
     * The parameter must contain all the properties defined in {@link
     * com.vmware.nsx.model.BaseFirewallProfile}.
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.BaseFirewallProfile
     * The return value will contain all the properties defined in {@link
     * com.vmware.nsx.model.BaseFirewallProfile}.
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.vapi.bindings.Structure create(com.vmware.vapi.bindings.Structure baseFirewallProfile, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Create a firewall profile with values provided. It creates profile based
     * resource_type in the payload. <br/> <br/> Use one of the following Policy APIs
     * depending upon the profile type - <br/> PUT|PATCH
     * /policy/api/v1/infra/settings/firewall/cpu-mem-thresholds-profiles/<profile-id>
     * <br/> PUT|PATCH /policy/api/v1/infra/dns-security-profiles/<profile-id> <br/>
     * PATCH
     * /policy/api/v1/infra/flood-protection-profiles/<flood-protection-profile-id>
     * <br/> PUT|PATCH
     * /policy/api/v1/infra/firewall-session-timer-profiles/<firewall-session-timer-profile-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.BaseFirewallProfile
     * The return value will contain all the properties defined in {@link
     * com.vmware.nsx.model.BaseFirewallProfile}.
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param baseFirewallProfile (required)
     * The parameter must contain all the properties defined in {@link
     * com.vmware.nsx.model.BaseFirewallProfile}.
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void create(com.vmware.vapi.bindings.Structure baseFirewallProfile, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.vapi.bindings.Structure> asyncCallback);

    /**
     * Create a firewall profile with values provided. It creates profile based
     * resource_type in the payload. <br/> <br/> Use one of the following Policy APIs
     * depending upon the profile type - <br/> PUT|PATCH
     * /policy/api/v1/infra/settings/firewall/cpu-mem-thresholds-profiles/<profile-id>
     * <br/> PUT|PATCH /policy/api/v1/infra/dns-security-profiles/<profile-id> <br/>
     * PATCH
     * /policy/api/v1/infra/flood-protection-profiles/<flood-protection-profile-id>
     * <br/> PUT|PATCH
     * /policy/api/v1/infra/firewall-session-timer-profiles/<firewall-session-timer-profile-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.BaseFirewallProfile
     * The return value will contain all the properties defined in {@link
     * com.vmware.nsx.model.BaseFirewallProfile}.
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param baseFirewallProfile (required)
     * The parameter must contain all the properties defined in {@link
     * com.vmware.nsx.model.BaseFirewallProfile}.
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void create(com.vmware.vapi.bindings.Structure baseFirewallProfile, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.vapi.bindings.Structure> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Deletes a firewall profile. <br/> <br/> Use one of the following Policy APIs
     * depending upon the profile type - <br/> DELETE
     * /policy/api/v1/infra/settings/firewall/cpu-mem-thresholds-profiles/<profile-id>
     * <br/> DELETE /policy/api/v1/infra/dns-security-profiles/<profile-id> <br/>
     * DELETE
     * /policy/api/v1/infra/flood-protection-profiles/<flood-protection-profile-id>
     * <br/> DELETE
     * /policy/api/v1/infra/firewall-session-timer-profiles/<firewall-session-timer-profile-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param profileId (required)
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public void delete(java.lang.String profileId);

    /**
     * Deletes a firewall profile. <br/> <br/> Use one of the following Policy APIs
     * depending upon the profile type - <br/> DELETE
     * /policy/api/v1/infra/settings/firewall/cpu-mem-thresholds-profiles/<profile-id>
     * <br/> DELETE /policy/api/v1/infra/dns-security-profiles/<profile-id> <br/>
     * DELETE
     * /policy/api/v1/infra/flood-protection-profiles/<flood-protection-profile-id>
     * <br/> DELETE
     * /policy/api/v1/infra/firewall-session-timer-profiles/<firewall-session-timer-profile-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param profileId (required)
     * @param invocationConfig Configuration for the method invocation.
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public void delete(java.lang.String profileId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Deletes a firewall profile. <br/> <br/> Use one of the following Policy APIs
     * depending upon the profile type - <br/> DELETE
     * /policy/api/v1/infra/settings/firewall/cpu-mem-thresholds-profiles/<profile-id>
     * <br/> DELETE /policy/api/v1/infra/dns-security-profiles/<profile-id> <br/>
     * DELETE
     * /policy/api/v1/infra/flood-protection-profiles/<flood-protection-profile-id>
     * <br/> DELETE
     * /policy/api/v1/infra/firewall-session-timer-profiles/<firewall-session-timer-profile-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param profileId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void delete(java.lang.String profileId, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback);

    /**
     * Deletes a firewall profile. <br/> <br/> Use one of the following Policy APIs
     * depending upon the profile type - <br/> DELETE
     * /policy/api/v1/infra/settings/firewall/cpu-mem-thresholds-profiles/<profile-id>
     * <br/> DELETE /policy/api/v1/infra/dns-security-profiles/<profile-id> <br/>
     * DELETE
     * /policy/api/v1/infra/flood-protection-profiles/<flood-protection-profile-id>
     * <br/> DELETE
     * /policy/api/v1/infra/firewall-session-timer-profiles/<firewall-session-timer-profile-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param profileId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void delete(java.lang.String profileId, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Return firewall session timer profile. <br/> <br/> Use one of the following
     * Policy APIs depending upon the profile type - <br/> GET
     * /policy/api/v1/infra/settings/firewall/cpu-mem-thresholds-profiles/<profile-id>
     * <br/> GET /policy/api/v1/infra/dns-security-profiles/<profile-id> <br/> GET
     * /policy/api/v1/infra/flood-protection-profiles/<flood-protection-profile-id>
     * <br/> GET
     * /policy/api/v1/infra/firewall-session-timer-profiles/<firewall-session-timer-profile-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param profileId (required)
     * @return com.vmware.nsx.model.BaseFirewallProfile
     * The return value will contain all the properties defined in {@link
     * com.vmware.nsx.model.BaseFirewallProfile}.
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.vapi.bindings.Structure get(java.lang.String profileId);

    /**
     * Return firewall session timer profile. <br/> <br/> Use one of the following
     * Policy APIs depending upon the profile type - <br/> GET
     * /policy/api/v1/infra/settings/firewall/cpu-mem-thresholds-profiles/<profile-id>
     * <br/> GET /policy/api/v1/infra/dns-security-profiles/<profile-id> <br/> GET
     * /policy/api/v1/infra/flood-protection-profiles/<flood-protection-profile-id>
     * <br/> GET
     * /policy/api/v1/infra/firewall-session-timer-profiles/<firewall-session-timer-profile-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param profileId (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.BaseFirewallProfile
     * The return value will contain all the properties defined in {@link
     * com.vmware.nsx.model.BaseFirewallProfile}.
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.vapi.bindings.Structure get(java.lang.String profileId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Return firewall session timer profile. <br/> <br/> Use one of the following
     * Policy APIs depending upon the profile type - <br/> GET
     * /policy/api/v1/infra/settings/firewall/cpu-mem-thresholds-profiles/<profile-id>
     * <br/> GET /policy/api/v1/infra/dns-security-profiles/<profile-id> <br/> GET
     * /policy/api/v1/infra/flood-protection-profiles/<flood-protection-profile-id>
     * <br/> GET
     * /policy/api/v1/infra/firewall-session-timer-profiles/<firewall-session-timer-profile-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.BaseFirewallProfile
     * The return value will contain all the properties defined in {@link
     * com.vmware.nsx.model.BaseFirewallProfile}.
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param profileId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void get(java.lang.String profileId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.vapi.bindings.Structure> asyncCallback);

    /**
     * Return firewall session timer profile. <br/> <br/> Use one of the following
     * Policy APIs depending upon the profile type - <br/> GET
     * /policy/api/v1/infra/settings/firewall/cpu-mem-thresholds-profiles/<profile-id>
     * <br/> GET /policy/api/v1/infra/dns-security-profiles/<profile-id> <br/> GET
     * /policy/api/v1/infra/flood-protection-profiles/<flood-protection-profile-id>
     * <br/> GET
     * /policy/api/v1/infra/firewall-session-timer-profiles/<firewall-session-timer-profile-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.BaseFirewallProfile
     * The return value will contain all the properties defined in {@link
     * com.vmware.nsx.model.BaseFirewallProfile}.
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param profileId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void get(java.lang.String profileId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.vapi.bindings.Structure> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * List all the firewall profiles available by requested resource_type. <br/> <br/>
     * Use one of the following Policy APIs depending upon the profile type - <br/> GET
     * /policy/api/v1/global-infra/settings/firewall/cpu-mem-thresholds-profiles <br/>
     * GET /policy/api/v1/infra/dns-security-profiles <br/> GET
     * /policy/api/v1/infra/flood-protection-profiles <br/> GET
     * /policy/api/v1/infra/firewall-session-timer-profiles
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param resourceType Profile resource type (required)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @return com.vmware.nsx.model.FirewallProfileListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.FirewallProfileListResult list(java.lang.String resourceType, java.lang.String cursor, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy);

    /**
     * List all the firewall profiles available by requested resource_type. <br/> <br/>
     * Use one of the following Policy APIs depending upon the profile type - <br/> GET
     * /policy/api/v1/global-infra/settings/firewall/cpu-mem-thresholds-profiles <br/>
     * GET /policy/api/v1/infra/dns-security-profiles <br/> GET
     * /policy/api/v1/infra/flood-protection-profiles <br/> GET
     * /policy/api/v1/infra/firewall-session-timer-profiles
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param resourceType Profile resource type (required)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.FirewallProfileListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.FirewallProfileListResult list(java.lang.String resourceType, java.lang.String cursor, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * List all the firewall profiles available by requested resource_type. <br/> <br/>
     * Use one of the following Policy APIs depending upon the profile type - <br/> GET
     * /policy/api/v1/global-infra/settings/firewall/cpu-mem-thresholds-profiles <br/>
     * GET /policy/api/v1/infra/dns-security-profiles <br/> GET
     * /policy/api/v1/infra/flood-protection-profiles <br/> GET
     * /policy/api/v1/infra/firewall-session-timer-profiles
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.FirewallProfileListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param resourceType Profile resource type (required)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void list(java.lang.String resourceType, java.lang.String cursor, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.FirewallProfileListResult> asyncCallback);

    /**
     * List all the firewall profiles available by requested resource_type. <br/> <br/>
     * Use one of the following Policy APIs depending upon the profile type - <br/> GET
     * /policy/api/v1/global-infra/settings/firewall/cpu-mem-thresholds-profiles <br/>
     * GET /policy/api/v1/infra/dns-security-profiles <br/> GET
     * /policy/api/v1/infra/flood-protection-profiles <br/> GET
     * /policy/api/v1/infra/firewall-session-timer-profiles
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.FirewallProfileListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param resourceType Profile resource type (required)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void list(java.lang.String resourceType, java.lang.String cursor, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.FirewallProfileListResult> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Update user configurable properties of firewall profile. <br/> <br/> Use one of
     * the following Policy APIs depending upon the profile type - <br/> PUT|PATCH
     * /policy/api/v1/infra/settings/firewall/cpu-mem-thresholds-profiles/<profile-id>
     * <br/> PUT|PATCH /policy/api/v1/infra/dns-security-profiles/<profile-id> <br/>
     * PUT|PATCH
     * /policy/api/v1/infra/flood-protection-profiles/<flood-protection-profile-id>
     * <br/> PUT|PATCH
     * /policy/api/v1/infra/firewall-session-timer-profiles/<firewall-session-timer-profile-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param profileId (required)
     * @param baseFirewallProfile (required)
     * The parameter must contain all the properties defined in {@link
     * com.vmware.nsx.model.BaseFirewallProfile}.
     * @return com.vmware.nsx.model.BaseFirewallProfile
     * The return value will contain all the properties defined in {@link
     * com.vmware.nsx.model.BaseFirewallProfile}.
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.vapi.bindings.Structure update(java.lang.String profileId, com.vmware.vapi.bindings.Structure baseFirewallProfile);

    /**
     * Update user configurable properties of firewall profile. <br/> <br/> Use one of
     * the following Policy APIs depending upon the profile type - <br/> PUT|PATCH
     * /policy/api/v1/infra/settings/firewall/cpu-mem-thresholds-profiles/<profile-id>
     * <br/> PUT|PATCH /policy/api/v1/infra/dns-security-profiles/<profile-id> <br/>
     * PUT|PATCH
     * /policy/api/v1/infra/flood-protection-profiles/<flood-protection-profile-id>
     * <br/> PUT|PATCH
     * /policy/api/v1/infra/firewall-session-timer-profiles/<firewall-session-timer-profile-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param profileId (required)
     * @param baseFirewallProfile (required)
     * The parameter must contain all the properties defined in {@link
     * com.vmware.nsx.model.BaseFirewallProfile}.
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.BaseFirewallProfile
     * The return value will contain all the properties defined in {@link
     * com.vmware.nsx.model.BaseFirewallProfile}.
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.vapi.bindings.Structure update(java.lang.String profileId, com.vmware.vapi.bindings.Structure baseFirewallProfile, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Update user configurable properties of firewall profile. <br/> <br/> Use one of
     * the following Policy APIs depending upon the profile type - <br/> PUT|PATCH
     * /policy/api/v1/infra/settings/firewall/cpu-mem-thresholds-profiles/<profile-id>
     * <br/> PUT|PATCH /policy/api/v1/infra/dns-security-profiles/<profile-id> <br/>
     * PUT|PATCH
     * /policy/api/v1/infra/flood-protection-profiles/<flood-protection-profile-id>
     * <br/> PUT|PATCH
     * /policy/api/v1/infra/firewall-session-timer-profiles/<firewall-session-timer-profile-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.BaseFirewallProfile
     * The return value will contain all the properties defined in {@link
     * com.vmware.nsx.model.BaseFirewallProfile}.
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param profileId (required)
     * @param baseFirewallProfile (required)
     * The parameter must contain all the properties defined in {@link
     * com.vmware.nsx.model.BaseFirewallProfile}.
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void update(java.lang.String profileId, com.vmware.vapi.bindings.Structure baseFirewallProfile, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.vapi.bindings.Structure> asyncCallback);

    /**
     * Update user configurable properties of firewall profile. <br/> <br/> Use one of
     * the following Policy APIs depending upon the profile type - <br/> PUT|PATCH
     * /policy/api/v1/infra/settings/firewall/cpu-mem-thresholds-profiles/<profile-id>
     * <br/> PUT|PATCH /policy/api/v1/infra/dns-security-profiles/<profile-id> <br/>
     * PUT|PATCH
     * /policy/api/v1/infra/flood-protection-profiles/<flood-protection-profile-id>
     * <br/> PUT|PATCH
     * /policy/api/v1/infra/firewall-session-timer-profiles/<firewall-session-timer-profile-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.BaseFirewallProfile
     * The return value will contain all the properties defined in {@link
     * com.vmware.nsx.model.BaseFirewallProfile}.
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param profileId (required)
     * @param baseFirewallProfile (required)
     * The parameter must contain all the properties defined in {@link
     * com.vmware.nsx.model.BaseFirewallProfile}.
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void update(java.lang.String profileId, com.vmware.vapi.bindings.Structure baseFirewallProfile, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.vapi.bindings.Structure> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
