/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx.loadbalancer.services.virtual_servers.
 * Used by client-side stubs.
 */

package com.vmware.nsx.loadbalancer.services.virtual_servers;

public interface Statistics extends com.vmware.vapi.bindings.Service, com.vmware.nsx.loadbalancer.services.virtual_servers.StatisticsTypes {

    /**
     * Returns the statistics of the load balancer virtual server by given load
     * balancer serives id and load balancer virtual server id.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param serviceId (required)
     * @param virtualServerId (required)
     * @param source Data source type. (optional)
     * @return com.vmware.nsx.model.LbVirtualServerStatistics
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.LbVirtualServerStatistics get(java.lang.String serviceId, java.lang.String virtualServerId, java.lang.String source);

    /**
     * Returns the statistics of the load balancer virtual server by given load
     * balancer serives id and load balancer virtual server id.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param serviceId (required)
     * @param virtualServerId (required)
     * @param source Data source type. (optional)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.LbVirtualServerStatistics
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.LbVirtualServerStatistics get(java.lang.String serviceId, java.lang.String virtualServerId, java.lang.String source, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Returns the statistics of the load balancer virtual server by given load
     * balancer serives id and load balancer virtual server id.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.LbVirtualServerStatistics
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param serviceId (required)
     * @param virtualServerId (required)
     * @param source Data source type. (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void get(java.lang.String serviceId, java.lang.String virtualServerId, java.lang.String source, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.LbVirtualServerStatistics> asyncCallback);

    /**
     * Returns the statistics of the load balancer virtual server by given load
     * balancer serives id and load balancer virtual server id.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.LbVirtualServerStatistics
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param serviceId (required)
     * @param virtualServerId (required)
     * @param source Data source type. (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void get(java.lang.String serviceId, java.lang.String virtualServerId, java.lang.String source, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.LbVirtualServerStatistics> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Returns the statistics list of virtual servers in given load balancer service.
     * Currently, only realtime mode is supported.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param serviceId (required)
     * @param source Data source type. (optional)
     * @return com.vmware.nsx.model.LbVirtualServerStatisticsListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.LbVirtualServerStatisticsListResult list(java.lang.String serviceId, java.lang.String source);

    /**
     * Returns the statistics list of virtual servers in given load balancer service.
     * Currently, only realtime mode is supported.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param serviceId (required)
     * @param source Data source type. (optional)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.LbVirtualServerStatisticsListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.LbVirtualServerStatisticsListResult list(java.lang.String serviceId, java.lang.String source, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Returns the statistics list of virtual servers in given load balancer service.
     * Currently, only realtime mode is supported.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.LbVirtualServerStatisticsListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param serviceId (required)
     * @param source Data source type. (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void list(java.lang.String serviceId, java.lang.String source, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.LbVirtualServerStatisticsListResult> asyncCallback);

    /**
     * Returns the statistics list of virtual servers in given load balancer service.
     * Currently, only realtime mode is supported.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.LbVirtualServerStatisticsListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param serviceId (required)
     * @param source Data source type. (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void list(java.lang.String serviceId, java.lang.String source, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.LbVirtualServerStatisticsListResult> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
