/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx.logical_router_ports.
 * Used by client-side stubs.
 */

package com.vmware.nsx.logical_router_ports;

public interface Statistics extends com.vmware.vapi.bindings.Service, com.vmware.nsx.logical_router_ports.StatisticsTypes {

    /**
     * Returns the statistics for the Logical Router Port. If query parameter
     * \"transport_node_id=<transport-node-id>\" is given, only the statistics from the
     * given node for the logical router port will be returned. Otherwise the
     * statistics from each node for the same logical router port will be returned. The
     * transport_node_id is mandatory if the router port is not uplink type. The query
     * parameter \"source=cached\" will be ignored and it will always return realtime
     * statistics of the logical router port. <br/> <br/> Please use below Policy API.
     * <br/> GET
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/interfaces/<interface-id>/statistics?enforcement_point_path=/infra/sites/default/enforcement-points/default
     * <br/> GET
     * /policy/api/v1/infra/tier-1s/<tier-1-id>/locale-services/<locale-service-id>/interfaces/<interface-id>/statistics?enforcement_point_path=/infra/sites/default/enforcement-points/default
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param logicalRouterPortId (required)
     * @param source Data source type. (optional)
     * @param transportNodeId TransportNode Id (optional)
     * @return com.vmware.nsx.model.LogicalRouterPortStatistics
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.LogicalRouterPortStatistics get(java.lang.String logicalRouterPortId, java.lang.String source, java.lang.String transportNodeId);

    /**
     * Returns the statistics for the Logical Router Port. If query parameter
     * \"transport_node_id=<transport-node-id>\" is given, only the statistics from the
     * given node for the logical router port will be returned. Otherwise the
     * statistics from each node for the same logical router port will be returned. The
     * transport_node_id is mandatory if the router port is not uplink type. The query
     * parameter \"source=cached\" will be ignored and it will always return realtime
     * statistics of the logical router port. <br/> <br/> Please use below Policy API.
     * <br/> GET
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/interfaces/<interface-id>/statistics?enforcement_point_path=/infra/sites/default/enforcement-points/default
     * <br/> GET
     * /policy/api/v1/infra/tier-1s/<tier-1-id>/locale-services/<locale-service-id>/interfaces/<interface-id>/statistics?enforcement_point_path=/infra/sites/default/enforcement-points/default
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param logicalRouterPortId (required)
     * @param source Data source type. (optional)
     * @param transportNodeId TransportNode Id (optional)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.LogicalRouterPortStatistics
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.LogicalRouterPortStatistics get(java.lang.String logicalRouterPortId, java.lang.String source, java.lang.String transportNodeId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Returns the statistics for the Logical Router Port. If query parameter
     * \"transport_node_id=<transport-node-id>\" is given, only the statistics from the
     * given node for the logical router port will be returned. Otherwise the
     * statistics from each node for the same logical router port will be returned. The
     * transport_node_id is mandatory if the router port is not uplink type. The query
     * parameter \"source=cached\" will be ignored and it will always return realtime
     * statistics of the logical router port. <br/> <br/> Please use below Policy API.
     * <br/> GET
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/interfaces/<interface-id>/statistics?enforcement_point_path=/infra/sites/default/enforcement-points/default
     * <br/> GET
     * /policy/api/v1/infra/tier-1s/<tier-1-id>/locale-services/<locale-service-id>/interfaces/<interface-id>/statistics?enforcement_point_path=/infra/sites/default/enforcement-points/default
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.LogicalRouterPortStatistics
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param logicalRouterPortId (required)
     * @param source Data source type. (optional)
     * @param transportNodeId TransportNode Id (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void get(java.lang.String logicalRouterPortId, java.lang.String source, java.lang.String transportNodeId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.LogicalRouterPortStatistics> asyncCallback);

    /**
     * Returns the statistics for the Logical Router Port. If query parameter
     * \"transport_node_id=<transport-node-id>\" is given, only the statistics from the
     * given node for the logical router port will be returned. Otherwise the
     * statistics from each node for the same logical router port will be returned. The
     * transport_node_id is mandatory if the router port is not uplink type. The query
     * parameter \"source=cached\" will be ignored and it will always return realtime
     * statistics of the logical router port. <br/> <br/> Please use below Policy API.
     * <br/> GET
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/interfaces/<interface-id>/statistics?enforcement_point_path=/infra/sites/default/enforcement-points/default
     * <br/> GET
     * /policy/api/v1/infra/tier-1s/<tier-1-id>/locale-services/<locale-service-id>/interfaces/<interface-id>/statistics?enforcement_point_path=/infra/sites/default/enforcement-points/default
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.LogicalRouterPortStatistics
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param logicalRouterPortId (required)
     * @param source Data source type. (optional)
     * @param transportNodeId TransportNode Id (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void get(java.lang.String logicalRouterPortId, java.lang.String source, java.lang.String transportNodeId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.LogicalRouterPortStatistics> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
