/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx.logical_routers.routing.
 * Used by client-side stubs.
 */

package com.vmware.nsx.logical_routers.routing;

public interface RoutingTable extends com.vmware.vapi.bindings.Service, com.vmware.nsx.logical_routers.routing.RoutingTableTypes {

    /**
     * Returns the route table(RIB) for the logical router on a node of the given
     * transport-node-id. Query parameter \"transport_node_id=<transport-node-id>\" is
     * required. To filter the result by network address, parameter
     * \"network_prefix=<a.b.c.d/mask>\" needs to be specified. To filter the result by
     * route source, parameter \"route_source=<source_type>\" needs to be specified
     * where source_type can be BGP, STATIC, CONNECTED, NSX_STATIC, TIER1_NAT or
     * TIER0_NAT. It is also possible to filter the RIB table using both network
     * address and route source filter together. Query parameter \"source=realtime\" is
     * the only supported source. <br/> <br/> Please use below Policy API. <br/> GET
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/routing-table <br/> GET
     * /policy/api/v1/infra/tier-1s/<tier-1-id>/routing-table
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param logicalRouterId (required)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param networkPrefix IPAddress or CIDR Block (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param routeSource Route source filter parameter (optional)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param source Data source type. (optional)
     * @param transportNodeId TransportNode Id (optional)
     * @param vrfTable VRF filter parameter (optional)
     * @return com.vmware.nsx.model.LogicalRouterRouteTable
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.LogicalRouterRouteTable list(java.lang.String logicalRouterId, java.lang.String cursor, java.lang.String includedFields, java.lang.String networkPrefix, java.lang.Long pageSize, java.lang.String routeSource, java.lang.Boolean sortAscending, java.lang.String sortBy, java.lang.String source, java.lang.String transportNodeId, java.lang.String vrfTable);

    /**
     * Returns the route table(RIB) for the logical router on a node of the given
     * transport-node-id. Query parameter \"transport_node_id=<transport-node-id>\" is
     * required. To filter the result by network address, parameter
     * \"network_prefix=<a.b.c.d/mask>\" needs to be specified. To filter the result by
     * route source, parameter \"route_source=<source_type>\" needs to be specified
     * where source_type can be BGP, STATIC, CONNECTED, NSX_STATIC, TIER1_NAT or
     * TIER0_NAT. It is also possible to filter the RIB table using both network
     * address and route source filter together. Query parameter \"source=realtime\" is
     * the only supported source. <br/> <br/> Please use below Policy API. <br/> GET
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/routing-table <br/> GET
     * /policy/api/v1/infra/tier-1s/<tier-1-id>/routing-table
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param logicalRouterId (required)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param networkPrefix IPAddress or CIDR Block (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param routeSource Route source filter parameter (optional)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param source Data source type. (optional)
     * @param transportNodeId TransportNode Id (optional)
     * @param vrfTable VRF filter parameter (optional)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.LogicalRouterRouteTable
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.LogicalRouterRouteTable list(java.lang.String logicalRouterId, java.lang.String cursor, java.lang.String includedFields, java.lang.String networkPrefix, java.lang.Long pageSize, java.lang.String routeSource, java.lang.Boolean sortAscending, java.lang.String sortBy, java.lang.String source, java.lang.String transportNodeId, java.lang.String vrfTable, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Returns the route table(RIB) for the logical router on a node of the given
     * transport-node-id. Query parameter \"transport_node_id=<transport-node-id>\" is
     * required. To filter the result by network address, parameter
     * \"network_prefix=<a.b.c.d/mask>\" needs to be specified. To filter the result by
     * route source, parameter \"route_source=<source_type>\" needs to be specified
     * where source_type can be BGP, STATIC, CONNECTED, NSX_STATIC, TIER1_NAT or
     * TIER0_NAT. It is also possible to filter the RIB table using both network
     * address and route source filter together. Query parameter \"source=realtime\" is
     * the only supported source. <br/> <br/> Please use below Policy API. <br/> GET
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/routing-table <br/> GET
     * /policy/api/v1/infra/tier-1s/<tier-1-id>/routing-table
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.LogicalRouterRouteTable
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param logicalRouterId (required)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param networkPrefix IPAddress or CIDR Block (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param routeSource Route source filter parameter (optional)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param source Data source type. (optional)
     * @param transportNodeId TransportNode Id (optional)
     * @param vrfTable VRF filter parameter (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void list(java.lang.String logicalRouterId, java.lang.String cursor, java.lang.String includedFields, java.lang.String networkPrefix, java.lang.Long pageSize, java.lang.String routeSource, java.lang.Boolean sortAscending, java.lang.String sortBy, java.lang.String source, java.lang.String transportNodeId, java.lang.String vrfTable, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.LogicalRouterRouteTable> asyncCallback);

    /**
     * Returns the route table(RIB) for the logical router on a node of the given
     * transport-node-id. Query parameter \"transport_node_id=<transport-node-id>\" is
     * required. To filter the result by network address, parameter
     * \"network_prefix=<a.b.c.d/mask>\" needs to be specified. To filter the result by
     * route source, parameter \"route_source=<source_type>\" needs to be specified
     * where source_type can be BGP, STATIC, CONNECTED, NSX_STATIC, TIER1_NAT or
     * TIER0_NAT. It is also possible to filter the RIB table using both network
     * address and route source filter together. Query parameter \"source=realtime\" is
     * the only supported source. <br/> <br/> Please use below Policy API. <br/> GET
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/routing-table <br/> GET
     * /policy/api/v1/infra/tier-1s/<tier-1-id>/routing-table
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.LogicalRouterRouteTable
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param logicalRouterId (required)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param networkPrefix IPAddress or CIDR Block (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param routeSource Route source filter parameter (optional)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param source Data source type. (optional)
     * @param transportNodeId TransportNode Id (optional)
     * @param vrfTable VRF filter parameter (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void list(java.lang.String logicalRouterId, java.lang.String cursor, java.lang.String includedFields, java.lang.String networkPrefix, java.lang.Long pageSize, java.lang.String routeSource, java.lang.Boolean sortAscending, java.lang.String sortBy, java.lang.String source, java.lang.String transportNodeId, java.lang.String vrfTable, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.LogicalRouterRouteTable> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
