/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx.logical_routers.routing.bgp.
 * Used by client-side stubs.
 */

package com.vmware.nsx.logical_routers.routing.bgp;

public interface CommunityLists extends com.vmware.vapi.bindings.Service, com.vmware.nsx.logical_routers.routing.bgp.CommunityListsTypes {

    /**
     * Add a new BGP Community List on a Logical Router <br/> <br/> Please use below
     * Policy APIs. <br/> POST
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/community-lists/<community-list-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param logicalRouterId (required)
     * @param bGPCommunityList (required)
     * @return com.vmware.nsx.model.BGPCommunityList
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.BGPCommunityList create(java.lang.String logicalRouterId, com.vmware.nsx.model.BGPCommunityList bGPCommunityList);

    /**
     * Add a new BGP Community List on a Logical Router <br/> <br/> Please use below
     * Policy APIs. <br/> POST
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/community-lists/<community-list-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param logicalRouterId (required)
     * @param bGPCommunityList (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.BGPCommunityList
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.BGPCommunityList create(java.lang.String logicalRouterId, com.vmware.nsx.model.BGPCommunityList bGPCommunityList, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Add a new BGP Community List on a Logical Router <br/> <br/> Please use below
     * Policy APIs. <br/> POST
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/community-lists/<community-list-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.BGPCommunityList
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param logicalRouterId (required)
     * @param bGPCommunityList (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void create(java.lang.String logicalRouterId, com.vmware.nsx.model.BGPCommunityList bGPCommunityList, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.BGPCommunityList> asyncCallback);

    /**
     * Add a new BGP Community List on a Logical Router <br/> <br/> Please use below
     * Policy APIs. <br/> POST
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/community-lists/<community-list-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.BGPCommunityList
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param logicalRouterId (required)
     * @param bGPCommunityList (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void create(java.lang.String logicalRouterId, com.vmware.nsx.model.BGPCommunityList bGPCommunityList, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.BGPCommunityList> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Delete a specific BGP community list from a Logical Router <br/> <br/> Please
     * use below Policy APIs. <br/> DELETE
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/community-lists/<community-list-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param logicalRouterId (required)
     * @param communityListId (required)
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public void delete(java.lang.String logicalRouterId, java.lang.String communityListId);

    /**
     * Delete a specific BGP community list from a Logical Router <br/> <br/> Please
     * use below Policy APIs. <br/> DELETE
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/community-lists/<community-list-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param logicalRouterId (required)
     * @param communityListId (required)
     * @param invocationConfig Configuration for the method invocation.
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public void delete(java.lang.String logicalRouterId, java.lang.String communityListId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Delete a specific BGP community list from a Logical Router <br/> <br/> Please
     * use below Policy APIs. <br/> DELETE
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/community-lists/<community-list-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param logicalRouterId (required)
     * @param communityListId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void delete(java.lang.String logicalRouterId, java.lang.String communityListId, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback);

    /**
     * Delete a specific BGP community list from a Logical Router <br/> <br/> Please
     * use below Policy APIs. <br/> DELETE
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/community-lists/<community-list-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param logicalRouterId (required)
     * @param communityListId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void delete(java.lang.String logicalRouterId, java.lang.String communityListId, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Read a specific BGP community list from a Logical Router <br/> <br/> Please use
     * below Policy APIs. <br/> GET
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/community-lists/<community-list-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param logicalRouterId (required)
     * @param communityListId (required)
     * @return com.vmware.nsx.model.BGPCommunityList
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.BGPCommunityList get(java.lang.String logicalRouterId, java.lang.String communityListId);

    /**
     * Read a specific BGP community list from a Logical Router <br/> <br/> Please use
     * below Policy APIs. <br/> GET
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/community-lists/<community-list-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param logicalRouterId (required)
     * @param communityListId (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.BGPCommunityList
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.BGPCommunityList get(java.lang.String logicalRouterId, java.lang.String communityListId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Read a specific BGP community list from a Logical Router <br/> <br/> Please use
     * below Policy APIs. <br/> GET
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/community-lists/<community-list-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.BGPCommunityList
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param logicalRouterId (required)
     * @param communityListId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void get(java.lang.String logicalRouterId, java.lang.String communityListId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.BGPCommunityList> asyncCallback);

    /**
     * Read a specific BGP community list from a Logical Router <br/> <br/> Please use
     * below Policy APIs. <br/> GET
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/community-lists/<community-list-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.BGPCommunityList
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param logicalRouterId (required)
     * @param communityListId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void get(java.lang.String logicalRouterId, java.lang.String communityListId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.BGPCommunityList> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Paginated list of BGP Community Lists on a Logical Router <br/> <br/> Please use
     * below Policy APIs. <br/> GET
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/community-lists
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param logicalRouterId (required)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @return com.vmware.nsx.model.BGPCommunityListListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.BGPCommunityListListResult list(java.lang.String logicalRouterId, java.lang.String cursor, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy);

    /**
     * Paginated list of BGP Community Lists on a Logical Router <br/> <br/> Please use
     * below Policy APIs. <br/> GET
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/community-lists
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param logicalRouterId (required)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.BGPCommunityListListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.BGPCommunityListListResult list(java.lang.String logicalRouterId, java.lang.String cursor, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Paginated list of BGP Community Lists on a Logical Router <br/> <br/> Please use
     * below Policy APIs. <br/> GET
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/community-lists
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.BGPCommunityListListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param logicalRouterId (required)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void list(java.lang.String logicalRouterId, java.lang.String cursor, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.BGPCommunityListListResult> asyncCallback);

    /**
     * Paginated list of BGP Community Lists on a Logical Router <br/> <br/> Please use
     * below Policy APIs. <br/> GET
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/community-lists
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.BGPCommunityListListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param logicalRouterId (required)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void list(java.lang.String logicalRouterId, java.lang.String cursor, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.BGPCommunityListListResult> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Update a specific BGP community list from a Logical Router <br/> <br/> Please
     * use below Policy APIs. <br/> PUT
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/community-lists/<community-list-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param logicalRouterId (required)
     * @param communityListId (required)
     * @param bGPCommunityList (required)
     * @return com.vmware.nsx.model.BGPCommunityList
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.BGPCommunityList update(java.lang.String logicalRouterId, java.lang.String communityListId, com.vmware.nsx.model.BGPCommunityList bGPCommunityList);

    /**
     * Update a specific BGP community list from a Logical Router <br/> <br/> Please
     * use below Policy APIs. <br/> PUT
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/community-lists/<community-list-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param logicalRouterId (required)
     * @param communityListId (required)
     * @param bGPCommunityList (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.BGPCommunityList
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.BGPCommunityList update(java.lang.String logicalRouterId, java.lang.String communityListId, com.vmware.nsx.model.BGPCommunityList bGPCommunityList, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Update a specific BGP community list from a Logical Router <br/> <br/> Please
     * use below Policy APIs. <br/> PUT
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/community-lists/<community-list-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.BGPCommunityList
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param logicalRouterId (required)
     * @param communityListId (required)
     * @param bGPCommunityList (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void update(java.lang.String logicalRouterId, java.lang.String communityListId, com.vmware.nsx.model.BGPCommunityList bGPCommunityList, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.BGPCommunityList> asyncCallback);

    /**
     * Update a specific BGP community list from a Logical Router <br/> <br/> Please
     * use below Policy APIs. <br/> PUT
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/community-lists/<community-list-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.BGPCommunityList
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param logicalRouterId (required)
     * @param communityListId (required)
     * @param bGPCommunityList (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void update(java.lang.String logicalRouterId, java.lang.String communityListId, com.vmware.nsx.model.BGPCommunityList bGPCommunityList, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.BGPCommunityList> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
