/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx.logical_routers.routing.bgp.neighbors.
 * Used by client-side stubs.
 */

package com.vmware.nsx.logical_routers.routing.bgp.neighbors;

public interface Status extends com.vmware.vapi.bindings.Service, com.vmware.nsx.logical_routers.routing.bgp.neighbors.StatusTypes {

    /**
     * Returns the status of all the BGP neighbors for the Logical Router of the given
     * id. To get BGP neighbors status for the logical router from particular node,
     * parameter \"transport_node_id=<transportnode_id>\" needs to be specified. Query
     * parameter \"source=realtime\" is the only supported source. <br/> <br/> Please
     * use below Policy API. <br/> GET
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/bgp/neighbors/status?enforcement_point_path=/infra/sites/default/enforcement-points/default
     * <br/> GET
     * /policy/api/v1/infra/tier-1s/<tier-1-id>/locale-services/<locale-service-id>/bgp/neighbors/status?enforcement_point_path=/infra/sites/default/enforcement-points/default
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param logicalRouterId (required)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param source Data source type. (optional)
     * @param transportNodeId Transport node id (optional)
     * @return com.vmware.nsx.model.BgpNeighborsStatusListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.BgpNeighborsStatusListResult list(java.lang.String logicalRouterId, java.lang.String cursor, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, java.lang.String source, java.lang.String transportNodeId);

    /**
     * Returns the status of all the BGP neighbors for the Logical Router of the given
     * id. To get BGP neighbors status for the logical router from particular node,
     * parameter \"transport_node_id=<transportnode_id>\" needs to be specified. Query
     * parameter \"source=realtime\" is the only supported source. <br/> <br/> Please
     * use below Policy API. <br/> GET
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/bgp/neighbors/status?enforcement_point_path=/infra/sites/default/enforcement-points/default
     * <br/> GET
     * /policy/api/v1/infra/tier-1s/<tier-1-id>/locale-services/<locale-service-id>/bgp/neighbors/status?enforcement_point_path=/infra/sites/default/enforcement-points/default
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param logicalRouterId (required)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param source Data source type. (optional)
     * @param transportNodeId Transport node id (optional)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.BgpNeighborsStatusListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.BgpNeighborsStatusListResult list(java.lang.String logicalRouterId, java.lang.String cursor, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, java.lang.String source, java.lang.String transportNodeId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Returns the status of all the BGP neighbors for the Logical Router of the given
     * id. To get BGP neighbors status for the logical router from particular node,
     * parameter \"transport_node_id=<transportnode_id>\" needs to be specified. Query
     * parameter \"source=realtime\" is the only supported source. <br/> <br/> Please
     * use below Policy API. <br/> GET
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/bgp/neighbors/status?enforcement_point_path=/infra/sites/default/enforcement-points/default
     * <br/> GET
     * /policy/api/v1/infra/tier-1s/<tier-1-id>/locale-services/<locale-service-id>/bgp/neighbors/status?enforcement_point_path=/infra/sites/default/enforcement-points/default
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.BgpNeighborsStatusListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param logicalRouterId (required)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param source Data source type. (optional)
     * @param transportNodeId Transport node id (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void list(java.lang.String logicalRouterId, java.lang.String cursor, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, java.lang.String source, java.lang.String transportNodeId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.BgpNeighborsStatusListResult> asyncCallback);

    /**
     * Returns the status of all the BGP neighbors for the Logical Router of the given
     * id. To get BGP neighbors status for the logical router from particular node,
     * parameter \"transport_node_id=<transportnode_id>\" needs to be specified. Query
     * parameter \"source=realtime\" is the only supported source. <br/> <br/> Please
     * use below Policy API. <br/> GET
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/bgp/neighbors/status?enforcement_point_path=/infra/sites/default/enforcement-points/default
     * <br/> GET
     * /policy/api/v1/infra/tier-1s/<tier-1-id>/locale-services/<locale-service-id>/bgp/neighbors/status?enforcement_point_path=/infra/sites/default/enforcement-points/default
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.BgpNeighborsStatusListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param logicalRouterId (required)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param source Data source type. (optional)
     * @param transportNodeId Transport node id (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void list(java.lang.String logicalRouterId, java.lang.String cursor, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, java.lang.String source, java.lang.String transportNodeId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.BgpNeighborsStatusListResult> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
