/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx.logical_switches.
 * Used by client-side stubs.
 */

package com.vmware.nsx.logical_switches;

public interface Status extends com.vmware.vapi.bindings.Service, com.vmware.nsx.logical_switches.StatusTypes {

    /**
     * Returns Operational status of all logical switches. The query parameter
     * \"source=realtime\" is not supported.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param diagnostic Flag to enable showing of transit logical switch. (optional, default to false)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param source Data source type. (optional)
     * @param switchType Logical Switch type (optional)
     * @param switchingProfileId Switching Profile identifier (optional)
     * @param transportType Mode of transport supported in the transport zone for this logical switch
     * (optional)
     * @param transportZoneId Transport zone identifier (optional)
     * @param uplinkTeamingPolicyName The logical switch's uplink teaming policy name (optional)
     * @param vlan Virtual Local Area Network Identifier (optional)
     * @param vni VNI of the OVERLAY LogicalSwitch(es) to return. (optional)
     * @return com.vmware.nsx.model.LogicalSwitchStatusSummary
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx.model.LogicalSwitchStatusSummary get(java.lang.String cursor, java.lang.Boolean diagnostic, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, java.lang.String source, java.lang.String switchType, java.lang.String switchingProfileId, java.lang.String transportType, java.lang.String transportZoneId, java.lang.String uplinkTeamingPolicyName, java.lang.Long vlan, java.lang.Long vni);

    /**
     * Returns Operational status of all logical switches. The query parameter
     * \"source=realtime\" is not supported.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param diagnostic Flag to enable showing of transit logical switch. (optional, default to false)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param source Data source type. (optional)
     * @param switchType Logical Switch type (optional)
     * @param switchingProfileId Switching Profile identifier (optional)
     * @param transportType Mode of transport supported in the transport zone for this logical switch
     * (optional)
     * @param transportZoneId Transport zone identifier (optional)
     * @param uplinkTeamingPolicyName The logical switch's uplink teaming policy name (optional)
     * @param vlan Virtual Local Area Network Identifier (optional)
     * @param vni VNI of the OVERLAY LogicalSwitch(es) to return. (optional)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.LogicalSwitchStatusSummary
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx.model.LogicalSwitchStatusSummary get(java.lang.String cursor, java.lang.Boolean diagnostic, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, java.lang.String source, java.lang.String switchType, java.lang.String switchingProfileId, java.lang.String transportType, java.lang.String transportZoneId, java.lang.String uplinkTeamingPolicyName, java.lang.Long vlan, java.lang.Long vni, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Returns Operational status of all logical switches. The query parameter
     * \"source=realtime\" is not supported.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.LogicalSwitchStatusSummary
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param diagnostic Flag to enable showing of transit logical switch. (optional, default to false)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param source Data source type. (optional)
     * @param switchType Logical Switch type (optional)
     * @param switchingProfileId Switching Profile identifier (optional)
     * @param transportType Mode of transport supported in the transport zone for this logical switch
     * (optional)
     * @param transportZoneId Transport zone identifier (optional)
     * @param uplinkTeamingPolicyName The logical switch's uplink teaming policy name (optional)
     * @param vlan Virtual Local Area Network Identifier (optional)
     * @param vni VNI of the OVERLAY LogicalSwitch(es) to return. (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void get(java.lang.String cursor, java.lang.Boolean diagnostic, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, java.lang.String source, java.lang.String switchType, java.lang.String switchingProfileId, java.lang.String transportType, java.lang.String transportZoneId, java.lang.String uplinkTeamingPolicyName, java.lang.Long vlan, java.lang.Long vni, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.LogicalSwitchStatusSummary> asyncCallback);

    /**
     * Returns Operational status of all logical switches. The query parameter
     * \"source=realtime\" is not supported.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.LogicalSwitchStatusSummary
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param diagnostic Flag to enable showing of transit logical switch. (optional, default to false)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param source Data source type. (optional)
     * @param switchType Logical Switch type (optional)
     * @param switchingProfileId Switching Profile identifier (optional)
     * @param transportType Mode of transport supported in the transport zone for this logical switch
     * (optional)
     * @param transportZoneId Transport zone identifier (optional)
     * @param uplinkTeamingPolicyName The logical switch's uplink teaming policy name (optional)
     * @param vlan Virtual Local Area Network Identifier (optional)
     * @param vni VNI of the OVERLAY LogicalSwitch(es) to return. (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void get(java.lang.String cursor, java.lang.Boolean diagnostic, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, java.lang.String source, java.lang.String switchType, java.lang.String switchingProfileId, java.lang.String transportType, java.lang.String transportZoneId, java.lang.String uplinkTeamingPolicyName, java.lang.Long vlan, java.lang.Long vni, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.LogicalSwitchStatusSummary> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
