/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx.migration.
 * Used by client-side stubs.
 */

package com.vmware.nsx.migration;

public interface FeedbackRequests extends com.vmware.vapi.bindings.Service, com.vmware.nsx.migration.FeedbackRequestsTypes {

    /**
     * Get feedback details of NSX-V to be migrated.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param category Category on which feedback request should be filtered (optional)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param federationSiteId Id of the site in NSX-T Federation (optional)
     * @param hash Hash based on which feedback request should be filtered (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param networkLayer Network layer for which feedback is generated (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param state Filter based on current state of the feedback request (optional, default to ALL)
     * @param subCategory Sub category based on which feedback request should be filtered (optional)
     * @return com.vmware.nsx.model.MigrationFeedbackRequestListResult
     * @throws com.vmware.vapi.std.errors.Unauthenticated  Unauthorized
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx.model.MigrationFeedbackRequestListResult list(java.lang.String category, java.lang.String cursor, java.lang.String federationSiteId, java.lang.String hash, java.lang.String includedFields, java.lang.String networkLayer, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, java.lang.String state, java.lang.String subCategory);

    /**
     * Get feedback details of NSX-V to be migrated.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param category Category on which feedback request should be filtered (optional)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param federationSiteId Id of the site in NSX-T Federation (optional)
     * @param hash Hash based on which feedback request should be filtered (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param networkLayer Network layer for which feedback is generated (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param state Filter based on current state of the feedback request (optional, default to ALL)
     * @param subCategory Sub category based on which feedback request should be filtered (optional)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.MigrationFeedbackRequestListResult
     * @throws com.vmware.vapi.std.errors.Unauthenticated  Unauthorized
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx.model.MigrationFeedbackRequestListResult list(java.lang.String category, java.lang.String cursor, java.lang.String federationSiteId, java.lang.String hash, java.lang.String includedFields, java.lang.String networkLayer, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, java.lang.String state, java.lang.String subCategory, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Get feedback details of NSX-V to be migrated.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.MigrationFeedbackRequestListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.Unauthenticated} -  Unauthorized<br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param category Category on which feedback request should be filtered (optional)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param federationSiteId Id of the site in NSX-T Federation (optional)
     * @param hash Hash based on which feedback request should be filtered (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param networkLayer Network layer for which feedback is generated (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param state Filter based on current state of the feedback request (optional, default to ALL)
     * @param subCategory Sub category based on which feedback request should be filtered (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void list(java.lang.String category, java.lang.String cursor, java.lang.String federationSiteId, java.lang.String hash, java.lang.String includedFields, java.lang.String networkLayer, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, java.lang.String state, java.lang.String subCategory, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.MigrationFeedbackRequestListResult> asyncCallback);

    /**
     * Get feedback details of NSX-V to be migrated.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.MigrationFeedbackRequestListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.Unauthenticated} -  Unauthorized<br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param category Category on which feedback request should be filtered (optional)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param federationSiteId Id of the site in NSX-T Federation (optional)
     * @param hash Hash based on which feedback request should be filtered (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param networkLayer Network layer for which feedback is generated (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param state Filter based on current state of the feedback request (optional, default to ALL)
     * @param subCategory Sub category based on which feedback request should be filtered (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void list(java.lang.String category, java.lang.String cursor, java.lang.String federationSiteId, java.lang.String hash, java.lang.String includedFields, java.lang.String networkLayer, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, java.lang.String state, java.lang.String subCategory, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.MigrationFeedbackRequestListResult> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
