
/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 */


package com.vmware.nsx.migration;

/**
 * {@link MigrationFactory} is responsible for creating instances of services
 * contained inside the com.vmware.nsx.migration package and also has the subpackages reference
 * to access respective subpackage services.
 * <p>
*/
public class MigrationFactory {

    private com.vmware.vapi.bindings.StubFactory stubFactory;
    private com.vmware.vapi.bindings.StubConfiguration stubConfig;

    // restricting developers to create instance of this class directly
    private MigrationFactory() {

    }

    /**
     * Creates the new instance of this class with provided configuration
     * @param stubFactory {@link StubFactory} instance is responsible for creating stubs
     * @param stubConfig {@link StubConfiguration} instance is required to authenticate the request
     * @return {@link MigrationFactory} factory instance
     */
    public static MigrationFactory getFactory(com.vmware.vapi.bindings.StubFactory stubFactory, com.vmware.vapi.bindings.StubConfiguration stubConfig) {
        MigrationFactory instance = new MigrationFactory();
        instance.stubFactory = stubFactory;
        instance.stubConfig = stubConfig;
        return instance;
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.migration.Data}
     */
    public com.vmware.nsx.migration.Data dataService() {
        return this.stubFactory.createStub(Data.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.migration.DiscoveredSwitches}
     */
    public com.vmware.nsx.migration.DiscoveredSwitches discoveredSwitchesService() {
        return this.stubFactory.createStub(DiscoveredSwitches.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.migration.FeedbackRequests}
     */
    public com.vmware.nsx.migration.FeedbackRequests feedbackRequestsService() {
        return this.stubFactory.createStub(FeedbackRequests.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.migration.FeedbackResponse}
     */
    public com.vmware.nsx.migration.FeedbackResponse feedbackResponseService() {
        return this.stubFactory.createStub(FeedbackResponse.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.migration.FeedbackSummary}
     */
    public com.vmware.nsx.migration.FeedbackSummary feedbackSummaryService() {
        return this.stubFactory.createStub(FeedbackSummary.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.migration.GroupedFeedbackRequests}
     */
    public com.vmware.nsx.migration.GroupedFeedbackRequests groupedFeedbackRequestsService() {
        return this.stubFactory.createStub(GroupedFeedbackRequests.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.migration.MigratedResources}
     */
    public com.vmware.nsx.migration.MigratedResources migratedResourcesService() {
        return this.stubFactory.createStub(MigratedResources.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.migration.MigratedSwitches}
     */
    public com.vmware.nsx.migration.MigratedSwitches migratedSwitchesService() {
        return this.stubFactory.createStub(MigratedSwitches.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.migration.MigrationUnitGroups}
     */
    public com.vmware.nsx.migration.MigrationUnitGroups migrationUnitGroupsService() {
        return this.stubFactory.createStub(MigrationUnitGroups.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.migration.MigrationUnitGroupsStatus}
     */
    public com.vmware.nsx.migration.MigrationUnitGroupsStatus migrationUnitGroupsStatusService() {
        return this.stubFactory.createStub(MigrationUnitGroupsStatus.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.migration.MigrationUnits}
     */
    public com.vmware.nsx.migration.MigrationUnits migrationUnitsService() {
        return this.stubFactory.createStub(MigrationUnits.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.migration.MigrationUnitsStats}
     */
    public com.vmware.nsx.migration.MigrationUnitsStats migrationUnitsStatsService() {
        return this.stubFactory.createStub(MigrationUnitsStats.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.migration.MpToPolicy}
     */
    public com.vmware.nsx.migration.MpToPolicy mpToPolicyService() {
        return this.stubFactory.createStub(MpToPolicy.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.migration.Nodes}
     */
    public com.vmware.nsx.migration.Nodes nodesService() {
        return this.stubFactory.createStub(Nodes.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.migration.NodesSummary}
     */
    public com.vmware.nsx.migration.NodesSummary nodesSummaryService() {
        return this.stubFactory.createStub(NodesSummary.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.migration.Plan}
     */
    public com.vmware.nsx.migration.Plan planService() {
        return this.stubFactory.createStub(Plan.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.migration.Setup}
     */
    public com.vmware.nsx.migration.Setup setupService() {
        return this.stubFactory.createStub(Setup.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.migration.StatusSummary}
     */
    public com.vmware.nsx.migration.StatusSummary statusSummaryService() {
        return this.stubFactory.createStub(StatusSummary.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.migration.Summary}
     */
    public com.vmware.nsx.migration.Summary summaryService() {
        return this.stubFactory.createStub(Summary.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.migration.Switch}
     */
    public com.vmware.nsx.migration.Switch switch_Service() {
        return this.stubFactory.createStub(Switch.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.migration.Vmgroup}
     */
    public com.vmware.nsx.migration.Vmgroup vmgroupService() {
        return this.stubFactory.createStub(Vmgroup.class, this.stubConfig);
    }

    public com.vmware.nsx.migration.logical_constructs.LogicalConstructsFactory logicalConstructs() {
        return com.vmware.nsx.migration.logical_constructs.LogicalConstructsFactory.getFactory(this.stubFactory, this.stubConfig);
    }

    public com.vmware.nsx.migration.migration_unit_groups.MigrationUnitGroupsFactory migrationUnitGroups() {
        return com.vmware.nsx.migration.migration_unit_groups.MigrationUnitGroupsFactory.getFactory(this.stubFactory, this.stubConfig);
    }

    public com.vmware.nsx.migration.migration_units.MigrationUnitsFactory migrationUnits() {
        return com.vmware.nsx.migration.migration_units.MigrationUnitsFactory.getFactory(this.stubFactory, this.stubConfig);
    }

    public com.vmware.nsx.migration.mp_policy_promotion.MpPolicyPromotionFactory mpPolicyPromotion() {
        return com.vmware.nsx.migration.mp_policy_promotion.MpPolicyPromotionFactory.getFactory(this.stubFactory, this.stubConfig);
    }

    public com.vmware.nsx.migration.mp_to_policy.MpToPolicyFactory mpToPolicy() {
        return com.vmware.nsx.migration.mp_to_policy.MpToPolicyFactory.getFactory(this.stubFactory, this.stubConfig);
    }

    public com.vmware.nsx.migration.plan.PlanFactory plan() {
        return com.vmware.nsx.migration.plan.PlanFactory.getFactory(this.stubFactory, this.stubConfig);
    }

    public void updateStubConfiguration(com.vmware.vapi.bindings.StubFactory stubFactory, com.vmware.vapi.bindings.StubConfiguration stubConfig) {
        if (this.stubFactory == stubFactory && this.stubConfig == stubConfig)
            return;

        this.stubFactory = stubFactory;
        this.stubConfig = stubConfig;
    }

}
