/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx.model;

/**
 * HPM client data collection configuration
 */
public final class ClientTypeCollectionConfiguration implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    public static final java.lang.String CLIENT_TYPE_HYPERVISOR = "HYPERVISOR";

    public static final java.lang.String CLIENT_TYPE_EDGE = "EDGE";

    public static final java.lang.String CLIENT_TYPE_CONTROL_PLANE = "CONTROL_PLANE";

    public static final java.lang.String CLIENT_TYPE_CONTROL_PLANE_PLATFORM = "CONTROL_PLANE_PLATFORM";

    public static final java.lang.String CLIENT_TYPE_MANAGEMENT_PLANE = "MANAGEMENT_PLANE";

    public static final java.lang.String CLIENT_TYPE_MANAGEMENT_PLANE_PLATFORM = "MANAGEMENT_PLANE_PLATFORM";

    private java.lang.String clientType;

    private java.util.List<com.vmware.nsx.model.DataTypeCollectionConfiguration> dataTypeConfigurations;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public ClientTypeCollectionConfiguration() {
    }

    protected ClientTypeCollectionConfiguration(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.ClientTypeCollectionConfiguration#CLIENT_TYPE_HYPERVISOR}</li>
     * <li> {@link
     * com.vmware.nsx.model.ClientTypeCollectionConfiguration#CLIENT_TYPE_EDGE}</li>
     * <li> {@link
     * com.vmware.nsx.model.ClientTypeCollectionConfiguration#CLIENT_TYPE_CONTROL_PLANE}</li>
     * <li> {@link
     * com.vmware.nsx.model.ClientTypeCollectionConfiguration#CLIENT_TYPE_CONTROL_PLANE_PLATFORM}</li>
     * <li> {@link
     * com.vmware.nsx.model.ClientTypeCollectionConfiguration#CLIENT_TYPE_MANAGEMENT_PLANE}</li>
     * <li> {@link
     * com.vmware.nsx.model.ClientTypeCollectionConfiguration#CLIENT_TYPE_MANAGEMENT_PLANE_PLATFORM}</li>
     * </ul> The client type for which this data collection frequency setting applies
     *
     * @return The current value of the property.
     */
    public java.lang.String getClientType() {
        return this.clientType;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.ClientTypeCollectionConfiguration#CLIENT_TYPE_HYPERVISOR}</li>
     * <li> {@link
     * com.vmware.nsx.model.ClientTypeCollectionConfiguration#CLIENT_TYPE_EDGE}</li>
     * <li> {@link
     * com.vmware.nsx.model.ClientTypeCollectionConfiguration#CLIENT_TYPE_CONTROL_PLANE}</li>
     * <li> {@link
     * com.vmware.nsx.model.ClientTypeCollectionConfiguration#CLIENT_TYPE_CONTROL_PLANE_PLATFORM}</li>
     * <li> {@link
     * com.vmware.nsx.model.ClientTypeCollectionConfiguration#CLIENT_TYPE_MANAGEMENT_PLANE}</li>
     * <li> {@link
     * com.vmware.nsx.model.ClientTypeCollectionConfiguration#CLIENT_TYPE_MANAGEMENT_PLANE_PLATFORM}</li>
     * </ul> The client type for which this data collection frequency setting applies
     *
     * @param clientType New value for the property.
     */
    public void setClientType(java.lang.String clientType) {
        this.clientType = clientType;
    }

    /**
     * The set of data collection type configurations, one for each data collection
     * type
     *
     * @return The current value of the property.
     */
    public java.util.List<com.vmware.nsx.model.DataTypeCollectionConfiguration> getDataTypeConfigurations() {
        return this.dataTypeConfigurations;
    }

    /**
     * The set of data collection type configurations, one for each data collection
     * type
     *
     * @param dataTypeConfigurations New value for the property.
     */
    public void setDataTypeConfigurations(java.util.List<com.vmware.nsx.model.DataTypeCollectionConfiguration> dataTypeConfigurations) {
        this.dataTypeConfigurations = dataTypeConfigurations;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx.model.StructDefinitions.clientTypeCollectionConfiguration;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("client_type",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.clientType, this._getType().getField("client_type")));
        structValue.setField("data_type_configurations",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.dataTypeConfigurations, this._getType().getField("data_type_configurations")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx.model.StructDefinitions.clientTypeCollectionConfiguration;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx.model.StructDefinitions.clientTypeCollectionConfiguration.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static ClientTypeCollectionConfiguration _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new ClientTypeCollectionConfiguration(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static ClientTypeCollectionConfiguration _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new ClientTypeCollectionConfiguration(structValue);
    }

    /**
     * Builder class for {@link ClientTypeCollectionConfiguration}.
     */
    public static final class Builder {
        private java.lang.String clientType;
        private java.util.List<com.vmware.nsx.model.DataTypeCollectionConfiguration> dataTypeConfigurations;

        /**
         * Constructor with parameters for the required properties of
         * {@link ClientTypeCollectionConfiguration}.
         */
        public Builder() {
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx.model.ClientTypeCollectionConfiguration#CLIENT_TYPE_HYPERVISOR}</li>
         * <li> {@link
         * com.vmware.nsx.model.ClientTypeCollectionConfiguration#CLIENT_TYPE_EDGE}</li>
         * <li> {@link
         * com.vmware.nsx.model.ClientTypeCollectionConfiguration#CLIENT_TYPE_CONTROL_PLANE}</li>
         * <li> {@link
         * com.vmware.nsx.model.ClientTypeCollectionConfiguration#CLIENT_TYPE_CONTROL_PLANE_PLATFORM}</li>
         * <li> {@link
         * com.vmware.nsx.model.ClientTypeCollectionConfiguration#CLIENT_TYPE_MANAGEMENT_PLANE}</li>
         * <li> {@link
         * com.vmware.nsx.model.ClientTypeCollectionConfiguration#CLIENT_TYPE_MANAGEMENT_PLANE_PLATFORM}</li>
         * </ul> The client type for which this data collection frequency setting applies
         *
         * @param clientType New value for the property.
         */
        public Builder setClientType(java.lang.String clientType) {
            this.clientType = clientType;
            return this;
        }

        /**
         * The set of data collection type configurations, one for each data collection
         * type
         *
         * @param dataTypeConfigurations New value for the property.
         */
        public Builder setDataTypeConfigurations(java.util.List<com.vmware.nsx.model.DataTypeCollectionConfiguration> dataTypeConfigurations) {
            this.dataTypeConfigurations = dataTypeConfigurations;
            return this;
        }

        public ClientTypeCollectionConfiguration build() {
            ClientTypeCollectionConfiguration result = new ClientTypeCollectionConfiguration();
            result.setClientType(this.clientType);
            result.setDataTypeConfigurations(this.dataTypeConfigurations);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("client_type", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("client_type",
                                                                                "clientType",
                                                                                "getClientType",
                                                                                "setClientType");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("data_type_configurations", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx.model.StructDefinitions.dataTypeCollectionConfiguration; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("data_type_configurations",
                                                                                "dataTypeConfigurations",
                                                                                "getDataTypeConfigurations",
                                                                                "setDataTypeConfigurations");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx.model.client_type_collection_configuration",
                                                            fields,
                                                            com.vmware.nsx.model.ClientTypeCollectionConfiguration.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

