/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx.model;

/**
 * NSX Cluster is made up of multiple cluster nodes. Each node can perform multiple
 * functions, commonly referred to as roles. Cluster node entities are processes
 * running in a cluster node that assist in the performance of a role. Cluster Boot
 * Manager is a daemon that securely bootstraps and configures the entities. This
 * type contains attributes of a cluster node entity that are relevant to the
 * Cluster Boot Manager.
 */
public final class ClusterNodeEntity implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    public static final java.lang.String ENTITY_TYPE_MANAGER = "MANAGER";

    public static final java.lang.String ENTITY_TYPE_CONTROLLER = "CONTROLLER";

    public static final java.lang.String ENTITY_TYPE_POLICY = "POLICY";

    public static final java.lang.String ENTITY_TYPE_HTTPS = "HTTPS";

    public static final java.lang.String ENTITY_TYPE_CLUSTER_BOOT_MANAGER = "CLUSTER_BOOT_MANAGER";

    public static final java.lang.String ENTITY_TYPE_DATASTORE = "DATASTORE";

    public static final java.lang.String ENTITY_TYPE_GLOBAL_MANAGER = "GLOBAL_MANAGER";

    public static final java.lang.String ENTITY_TYPE_ASYNC_REPLICATOR = "ASYNC_REPLICATOR";

    public static final java.lang.String ENTITY_TYPE_MONITORING = "MONITORING";

    public static final java.lang.String ENTITY_TYPE_IDPS_REPORTING = "IDPS_REPORTING";

    public static final java.lang.String ENTITY_TYPE_CORFU_NONCONFIG = "CORFU_NONCONFIG";

    public static final java.lang.String ENTITY_TYPE_UPGRADE_COORDINATOR = "UPGRADE_COORDINATOR";

    public static final java.lang.String ENTITY_TYPE_CM_INVENTORY = "CM-INVENTORY";

    public static final java.lang.String ENTITY_TYPE_MESSAGING_MANAGER = "MESSAGING-MANAGER";

    private java.lang.String certificate;

    private java.lang.String entityType;

    private java.lang.String entityUuid;

    private java.lang.String fqdn;

    private java.lang.String ipAddress;

    private java.lang.String ipv6Address;

    private java.lang.Long ipv6SubnetPrefixLength;

    private java.lang.Long port;

    private java.lang.Long subnetPrefixLength;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public ClusterNodeEntity() {
    }

    protected ClusterNodeEntity(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * Public certificate of the entity in PEM format
     *
     * @return The current value of the property.
     */
    public java.lang.String getCertificate() {
        return this.certificate;
    }

    /**
     * Public certificate of the entity in PEM format
     *
     * @param certificate New value for the property.
     */
    public void setCertificate(java.lang.String certificate) {
        this.certificate = certificate;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.ClusterNodeEntity#ENTITY_TYPE_MANAGER}</li> <li> {@link
     * com.vmware.nsx.model.ClusterNodeEntity#ENTITY_TYPE_CONTROLLER}</li> <li> {@link
     * com.vmware.nsx.model.ClusterNodeEntity#ENTITY_TYPE_POLICY}</li> <li> {@link
     * com.vmware.nsx.model.ClusterNodeEntity#ENTITY_TYPE_HTTPS}</li> <li> {@link
     * com.vmware.nsx.model.ClusterNodeEntity#ENTITY_TYPE_CLUSTER_BOOT_MANAGER}</li>
     * <li> {@link com.vmware.nsx.model.ClusterNodeEntity#ENTITY_TYPE_DATASTORE}</li>
     * <li> {@link
     * com.vmware.nsx.model.ClusterNodeEntity#ENTITY_TYPE_GLOBAL_MANAGER}</li> <li>
     * {@link com.vmware.nsx.model.ClusterNodeEntity#ENTITY_TYPE_ASYNC_REPLICATOR}</li>
     * <li> {@link com.vmware.nsx.model.ClusterNodeEntity#ENTITY_TYPE_MONITORING}</li>
     * <li> {@link
     * com.vmware.nsx.model.ClusterNodeEntity#ENTITY_TYPE_IDPS_REPORTING}</li> <li>
     * {@link com.vmware.nsx.model.ClusterNodeEntity#ENTITY_TYPE_CORFU_NONCONFIG}</li>
     * <li> {@link
     * com.vmware.nsx.model.ClusterNodeEntity#ENTITY_TYPE_UPGRADE_COORDINATOR}</li>
     * <li> {@link
     * com.vmware.nsx.model.ClusterNodeEntity#ENTITY_TYPE_CM_INVENTORY}</li> <li>
     * {@link
     * com.vmware.nsx.model.ClusterNodeEntity#ENTITY_TYPE_MESSAGING_MANAGER}</li> </ul>
     * Type of the entity
     *
     * @return The current value of the property.
     */
    public java.lang.String getEntityType() {
        return this.entityType;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.ClusterNodeEntity#ENTITY_TYPE_MANAGER}</li> <li> {@link
     * com.vmware.nsx.model.ClusterNodeEntity#ENTITY_TYPE_CONTROLLER}</li> <li> {@link
     * com.vmware.nsx.model.ClusterNodeEntity#ENTITY_TYPE_POLICY}</li> <li> {@link
     * com.vmware.nsx.model.ClusterNodeEntity#ENTITY_TYPE_HTTPS}</li> <li> {@link
     * com.vmware.nsx.model.ClusterNodeEntity#ENTITY_TYPE_CLUSTER_BOOT_MANAGER}</li>
     * <li> {@link com.vmware.nsx.model.ClusterNodeEntity#ENTITY_TYPE_DATASTORE}</li>
     * <li> {@link
     * com.vmware.nsx.model.ClusterNodeEntity#ENTITY_TYPE_GLOBAL_MANAGER}</li> <li>
     * {@link com.vmware.nsx.model.ClusterNodeEntity#ENTITY_TYPE_ASYNC_REPLICATOR}</li>
     * <li> {@link com.vmware.nsx.model.ClusterNodeEntity#ENTITY_TYPE_MONITORING}</li>
     * <li> {@link
     * com.vmware.nsx.model.ClusterNodeEntity#ENTITY_TYPE_IDPS_REPORTING}</li> <li>
     * {@link com.vmware.nsx.model.ClusterNodeEntity#ENTITY_TYPE_CORFU_NONCONFIG}</li>
     * <li> {@link
     * com.vmware.nsx.model.ClusterNodeEntity#ENTITY_TYPE_UPGRADE_COORDINATOR}</li>
     * <li> {@link
     * com.vmware.nsx.model.ClusterNodeEntity#ENTITY_TYPE_CM_INVENTORY}</li> <li>
     * {@link
     * com.vmware.nsx.model.ClusterNodeEntity#ENTITY_TYPE_MESSAGING_MANAGER}</li> </ul>
     * Type of the entity
     *
     * @param entityType New value for the property.
     */
    public void setEntityType(java.lang.String entityType) {
        this.entityType = entityType;
    }

    /**
     * UUID of the entity
     *
     * @return The current value of the property.
     */
    public java.lang.String getEntityUuid() {
        return this.entityUuid;
    }

    /**
     * UUID of the entity
     *
     * @param entityUuid New value for the property.
     */
    public void setEntityUuid(java.lang.String entityUuid) {
        this.entityUuid = entityUuid;
    }

    /**
     * Domain name the entity binds to format: hostname
     *
     * @return The current value of the property.
     */
    public java.lang.String getFqdn() {
        return this.fqdn;
    }

    /**
     * Domain name the entity binds to format: hostname
     *
     * @param fqdn New value for the property.
     */
    public void setFqdn(java.lang.String fqdn) {
        this.fqdn = fqdn;
    }

    /**
     * IP address the entity binds to
     *
     * @return The current value of the property.
     */
    public java.lang.String getIpAddress() {
        return this.ipAddress;
    }

    /**
     * IP address the entity binds to
     *
     * @param ipAddress New value for the property.
     */
    public void setIpAddress(java.lang.String ipAddress) {
        this.ipAddress = ipAddress;
    }

    /**
     * IPv6 address the entity binds to
     *
     * @return The current value of the property.
     */
    public java.lang.String getIpv6Address() {
        return this.ipv6Address;
    }

    /**
     * IPv6 address the entity binds to
     *
     * @param ipv6Address New value for the property.
     */
    public void setIpv6Address(java.lang.String ipv6Address) {
        this.ipv6Address = ipv6Address;
    }

    /**
     * IPv6 subnet mask prefix length of the entity binds to format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getIpv6SubnetPrefixLength() {
        return this.ipv6SubnetPrefixLength;
    }

    /**
     * IPv6 subnet mask prefix length of the entity binds to format: int64
     *
     * @param ipv6SubnetPrefixLength New value for the property.
     */
    public void setIpv6SubnetPrefixLength(java.lang.Long ipv6SubnetPrefixLength) {
        this.ipv6SubnetPrefixLength = ipv6SubnetPrefixLength;
    }

    /**
     * Port the entity binds to format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getPort() {
        return this.port;
    }

    /**
     * Port the entity binds to format: int64
     *
     * @param port New value for the property.
     */
    public void setPort(java.lang.Long port) {
        this.port = port;
    }

    /**
     * Subnet mask prefix length of the entity binds to format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getSubnetPrefixLength() {
        return this.subnetPrefixLength;
    }

    /**
     * Subnet mask prefix length of the entity binds to format: int64
     *
     * @param subnetPrefixLength New value for the property.
     */
    public void setSubnetPrefixLength(java.lang.Long subnetPrefixLength) {
        this.subnetPrefixLength = subnetPrefixLength;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx.model.StructDefinitions.clusterNodeEntity;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("certificate",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.certificate, this._getType().getField("certificate")));
        structValue.setField("entity_type",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.entityType, this._getType().getField("entity_type")));
        structValue.setField("entity_uuid",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.entityUuid, this._getType().getField("entity_uuid")));
        structValue.setField("fqdn",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.fqdn, this._getType().getField("fqdn")));
        structValue.setField("ip_address",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.ipAddress, this._getType().getField("ip_address")));
        structValue.setField("ipv6_address",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.ipv6Address, this._getType().getField("ipv6_address")));
        structValue.setField("ipv6_subnet_prefix_length",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.ipv6SubnetPrefixLength, this._getType().getField("ipv6_subnet_prefix_length")));
        structValue.setField("port",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.port, this._getType().getField("port")));
        structValue.setField("subnet_prefix_length",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.subnetPrefixLength, this._getType().getField("subnet_prefix_length")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx.model.StructDefinitions.clusterNodeEntity;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx.model.StructDefinitions.clusterNodeEntity.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static ClusterNodeEntity _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new ClusterNodeEntity(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static ClusterNodeEntity _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new ClusterNodeEntity(structValue);
    }

    /**
     * Builder class for {@link ClusterNodeEntity}.
     */
    public static final class Builder {
        private java.lang.String certificate;
        private java.lang.String entityType;
        private java.lang.String entityUuid;
        private java.lang.String fqdn;
        private java.lang.String ipAddress;
        private java.lang.String ipv6Address;
        private java.lang.Long ipv6SubnetPrefixLength;
        private java.lang.Long port;
        private java.lang.Long subnetPrefixLength;

        /**
         * Constructor with parameters for the required properties of
         * {@link ClusterNodeEntity}.
         */
        public Builder() {
        }

        /**
         * Public certificate of the entity in PEM format
         *
         * @param certificate New value for the property.
         */
        public Builder setCertificate(java.lang.String certificate) {
            this.certificate = certificate;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx.model.ClusterNodeEntity#ENTITY_TYPE_MANAGER}</li> <li> {@link
         * com.vmware.nsx.model.ClusterNodeEntity#ENTITY_TYPE_CONTROLLER}</li> <li> {@link
         * com.vmware.nsx.model.ClusterNodeEntity#ENTITY_TYPE_POLICY}</li> <li> {@link
         * com.vmware.nsx.model.ClusterNodeEntity#ENTITY_TYPE_HTTPS}</li> <li> {@link
         * com.vmware.nsx.model.ClusterNodeEntity#ENTITY_TYPE_CLUSTER_BOOT_MANAGER}</li>
         * <li> {@link com.vmware.nsx.model.ClusterNodeEntity#ENTITY_TYPE_DATASTORE}</li>
         * <li> {@link
         * com.vmware.nsx.model.ClusterNodeEntity#ENTITY_TYPE_GLOBAL_MANAGER}</li> <li>
         * {@link com.vmware.nsx.model.ClusterNodeEntity#ENTITY_TYPE_ASYNC_REPLICATOR}</li>
         * <li> {@link com.vmware.nsx.model.ClusterNodeEntity#ENTITY_TYPE_MONITORING}</li>
         * <li> {@link
         * com.vmware.nsx.model.ClusterNodeEntity#ENTITY_TYPE_IDPS_REPORTING}</li> <li>
         * {@link com.vmware.nsx.model.ClusterNodeEntity#ENTITY_TYPE_CORFU_NONCONFIG}</li>
         * <li> {@link
         * com.vmware.nsx.model.ClusterNodeEntity#ENTITY_TYPE_UPGRADE_COORDINATOR}</li>
         * <li> {@link
         * com.vmware.nsx.model.ClusterNodeEntity#ENTITY_TYPE_CM_INVENTORY}</li> <li>
         * {@link
         * com.vmware.nsx.model.ClusterNodeEntity#ENTITY_TYPE_MESSAGING_MANAGER}</li> </ul>
         * Type of the entity
         *
         * @param entityType New value for the property.
         */
        public Builder setEntityType(java.lang.String entityType) {
            this.entityType = entityType;
            return this;
        }

        /**
         * UUID of the entity
         *
         * @param entityUuid New value for the property.
         */
        public Builder setEntityUuid(java.lang.String entityUuid) {
            this.entityUuid = entityUuid;
            return this;
        }

        /**
         * Domain name the entity binds to format: hostname
         *
         * @param fqdn New value for the property.
         */
        public Builder setFqdn(java.lang.String fqdn) {
            this.fqdn = fqdn;
            return this;
        }

        /**
         * IP address the entity binds to
         *
         * @param ipAddress New value for the property.
         */
        public Builder setIpAddress(java.lang.String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        /**
         * IPv6 address the entity binds to
         *
         * @param ipv6Address New value for the property.
         */
        public Builder setIpv6Address(java.lang.String ipv6Address) {
            this.ipv6Address = ipv6Address;
            return this;
        }

        /**
         * IPv6 subnet mask prefix length of the entity binds to format: int64
         *
         * @param ipv6SubnetPrefixLength New value for the property.
         */
        public Builder setIpv6SubnetPrefixLength(java.lang.Long ipv6SubnetPrefixLength) {
            this.ipv6SubnetPrefixLength = ipv6SubnetPrefixLength;
            return this;
        }

        /**
         * Port the entity binds to format: int64
         *
         * @param port New value for the property.
         */
        public Builder setPort(java.lang.Long port) {
            this.port = port;
            return this;
        }

        /**
         * Subnet mask prefix length of the entity binds to format: int64
         *
         * @param subnetPrefixLength New value for the property.
         */
        public Builder setSubnetPrefixLength(java.lang.Long subnetPrefixLength) {
            this.subnetPrefixLength = subnetPrefixLength;
            return this;
        }

        public ClusterNodeEntity build() {
            ClusterNodeEntity result = new ClusterNodeEntity();
            result.setCertificate(this.certificate);
            result.setEntityType(this.entityType);
            result.setEntityUuid(this.entityUuid);
            result.setFqdn(this.fqdn);
            result.setIpAddress(this.ipAddress);
            result.setIpv6Address(this.ipv6Address);
            result.setIpv6SubnetPrefixLength(this.ipv6SubnetPrefixLength);
            result.setPort(this.port);
            result.setSubnetPrefixLength(this.subnetPrefixLength);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("certificate", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("certificate",
                                                                                "certificate",
                                                                                "getCertificate",
                                                                                "setCertificate");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("entity_type", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("entity_type",
                                                                                "entityType",
                                                                                "getEntityType",
                                                                                "setEntityType");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("entity_uuid", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("entity_uuid",
                                                                                "entityUuid",
                                                                                "getEntityUuid",
                                                                                "setEntityUuid");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("fqdn", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("fqdn",
                                                                                "fqdn",
                                                                                "getFqdn",
                                                                                "setFqdn");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("ip_address", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("ip_address",
                                                                                "ipAddress",
                                                                                "getIpAddress",
                                                                                "setIpAddress");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("ipv6_address", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("ipv6_address",
                                                                                "ipv6Address",
                                                                                "getIpv6Address",
                                                                                "setIpv6Address");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("ipv6_subnet_prefix_length", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("ipv6_subnet_prefix_length",
                                                                                "ipv6SubnetPrefixLength",
                                                                                "getIpv6SubnetPrefixLength",
                                                                                "setIpv6SubnetPrefixLength");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("port", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("port",
                                                                                "port",
                                                                                "getPort",
                                                                                "setPort");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("subnet_prefix_length", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("subnet_prefix_length",
                                                                                "subnetPrefixLength",
                                                                                "getSubnetPrefixLength",
                                                                                "setSubnetPrefixLength");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx.model.cluster_node_entity",
                                                            fields,
                                                            com.vmware.nsx.model.ClusterNodeEntity.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

