/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx.model;

/**
 * Community match operation
 */
public final class CommunityMatchOperation implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    public static final java.lang.String MATCH_OPERATOR_ANY = "MATCH_ANY";

    public static final java.lang.String MATCH_OPERATOR_ALL = "MATCH_ALL";

    public static final java.lang.String MATCH_OPERATOR_EXACT = "MATCH_EXACT";

    public static final java.lang.String MATCH_OPERATOR_NONE = "MATCH_NONE";

    public static final java.lang.String MATCH_OPERATOR_REGEX = "MATCH_REGEX";

    public static final java.lang.String MATCH_OPERATOR_LARGE_COMMUNITY_REGEX = "MATCH_LARGE_COMMUNITY_REGEX";

    private java.lang.String communityListId;

    private java.lang.String matchOperator;

    private java.lang.String regularExpression;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public CommunityMatchOperation() {
    }

    protected CommunityMatchOperation(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * ID of BGP community list. This value is not required when match_operator is
     * MATCH_REGEX otherwise required.
     *
     * @return The current value of the property.
     */
    public java.lang.String getCommunityListId() {
        return this.communityListId;
    }

    /**
     * ID of BGP community list. This value is not required when match_operator is
     * MATCH_REGEX otherwise required.
     *
     * @param communityListId New value for the property.
     */
    public void setCommunityListId(java.lang.String communityListId) {
        this.communityListId = communityListId;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.CommunityMatchOperation#MATCH_OPERATOR_ANY}</li> <li>
     * {@link com.vmware.nsx.model.CommunityMatchOperation#MATCH_OPERATOR_ALL}</li>
     * <li> {@link
     * com.vmware.nsx.model.CommunityMatchOperation#MATCH_OPERATOR_EXACT}</li> <li>
     * {@link com.vmware.nsx.model.CommunityMatchOperation#MATCH_OPERATOR_NONE}</li>
     * <li> {@link
     * com.vmware.nsx.model.CommunityMatchOperation#MATCH_OPERATOR_REGEX}</li> <li>
     * {@link
     * com.vmware.nsx.model.CommunityMatchOperation#MATCH_OPERATOR_LARGE_COMMUNITY_REGEX}</li>
     * </ul> Match operator for communities from provided community list id. MATCH_ANY
     * will match any community MATCH_ALL will match all communities MATCH_EXACT will
     * do exact match on community MATCH_NONE [operator not supported] will not match
     * any community MATCH_REGEX will match normal communities by evaluating regular
     * expression MATCH_LARGE_COMMUNITY_REGEX will match large communities by
     * evaluating regular expression
     *
     * @return The current value of the property.
     */
    public java.lang.String getMatchOperator() {
        return this.matchOperator;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.CommunityMatchOperation#MATCH_OPERATOR_ANY}</li> <li>
     * {@link com.vmware.nsx.model.CommunityMatchOperation#MATCH_OPERATOR_ALL}</li>
     * <li> {@link
     * com.vmware.nsx.model.CommunityMatchOperation#MATCH_OPERATOR_EXACT}</li> <li>
     * {@link com.vmware.nsx.model.CommunityMatchOperation#MATCH_OPERATOR_NONE}</li>
     * <li> {@link
     * com.vmware.nsx.model.CommunityMatchOperation#MATCH_OPERATOR_REGEX}</li> <li>
     * {@link
     * com.vmware.nsx.model.CommunityMatchOperation#MATCH_OPERATOR_LARGE_COMMUNITY_REGEX}</li>
     * </ul> Match operator for communities from provided community list id. MATCH_ANY
     * will match any community MATCH_ALL will match all communities MATCH_EXACT will
     * do exact match on community MATCH_NONE [operator not supported] will not match
     * any community MATCH_REGEX will match normal communities by evaluating regular
     * expression MATCH_LARGE_COMMUNITY_REGEX will match large communities by
     * evaluating regular expression
     *
     * @param matchOperator New value for the property.
     */
    public void setMatchOperator(java.lang.String matchOperator) {
        this.matchOperator = matchOperator;
    }

    /**
     * Regular expression to match BGP communities. If match_operator is MATCH_REGEX
     * then this value must be specified.
     *
     * @return The current value of the property.
     */
    public java.lang.String getRegularExpression() {
        return this.regularExpression;
    }

    /**
     * Regular expression to match BGP communities. If match_operator is MATCH_REGEX
     * then this value must be specified.
     *
     * @param regularExpression New value for the property.
     */
    public void setRegularExpression(java.lang.String regularExpression) {
        this.regularExpression = regularExpression;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx.model.StructDefinitions.communityMatchOperation;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("community_list_id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.communityListId, this._getType().getField("community_list_id")));
        structValue.setField("match_operator",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.matchOperator, this._getType().getField("match_operator")));
        structValue.setField("regular_expression",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.regularExpression, this._getType().getField("regular_expression")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx.model.StructDefinitions.communityMatchOperation;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx.model.StructDefinitions.communityMatchOperation.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static CommunityMatchOperation _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new CommunityMatchOperation(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static CommunityMatchOperation _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new CommunityMatchOperation(structValue);
    }

    /**
     * Builder class for {@link CommunityMatchOperation}.
     */
    public static final class Builder {
        private java.lang.String communityListId;
        private java.lang.String matchOperator;
        private java.lang.String regularExpression;

        /**
         * Constructor with parameters for the required properties of
         * {@link CommunityMatchOperation}.
         */
        public Builder() {
        }

        /**
         * ID of BGP community list. This value is not required when match_operator is
         * MATCH_REGEX otherwise required.
         *
         * @param communityListId New value for the property.
         */
        public Builder setCommunityListId(java.lang.String communityListId) {
            this.communityListId = communityListId;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx.model.CommunityMatchOperation#MATCH_OPERATOR_ANY}</li> <li>
         * {@link com.vmware.nsx.model.CommunityMatchOperation#MATCH_OPERATOR_ALL}</li>
         * <li> {@link
         * com.vmware.nsx.model.CommunityMatchOperation#MATCH_OPERATOR_EXACT}</li> <li>
         * {@link com.vmware.nsx.model.CommunityMatchOperation#MATCH_OPERATOR_NONE}</li>
         * <li> {@link
         * com.vmware.nsx.model.CommunityMatchOperation#MATCH_OPERATOR_REGEX}</li> <li>
         * {@link
         * com.vmware.nsx.model.CommunityMatchOperation#MATCH_OPERATOR_LARGE_COMMUNITY_REGEX}</li>
         * </ul> Match operator for communities from provided community list id. MATCH_ANY
         * will match any community MATCH_ALL will match all communities MATCH_EXACT will
         * do exact match on community MATCH_NONE [operator not supported] will not match
         * any community MATCH_REGEX will match normal communities by evaluating regular
         * expression MATCH_LARGE_COMMUNITY_REGEX will match large communities by
         * evaluating regular expression
         *
         * @param matchOperator New value for the property.
         */
        public Builder setMatchOperator(java.lang.String matchOperator) {
            this.matchOperator = matchOperator;
            return this;
        }

        /**
         * Regular expression to match BGP communities. If match_operator is MATCH_REGEX
         * then this value must be specified.
         *
         * @param regularExpression New value for the property.
         */
        public Builder setRegularExpression(java.lang.String regularExpression) {
            this.regularExpression = regularExpression;
            return this;
        }

        public CommunityMatchOperation build() {
            CommunityMatchOperation result = new CommunityMatchOperation();
            result.setCommunityListId(this.communityListId);
            result.setMatchOperator(this.matchOperator);
            result.setRegularExpression(this.regularExpression);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("community_list_id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("community_list_id",
                                                                                "communityListId",
                                                                                "getCommunityListId",
                                                                                "setCommunityListId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("match_operator", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("match_operator",
                                                                                "matchOperator",
                                                                                "getMatchOperator",
                                                                                "setMatchOperator");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("regular_expression", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("regular_expression",
                                                                                "regularExpression",
                                                                                "getRegularExpression",
                                                                                "setRegularExpression");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx.model.community_match_operation",
                                                            fields,
                                                            com.vmware.nsx.model.CommunityMatchOperation.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

