/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx.model;

/**
 * Non Uniform Memory Access (NUMA) nodes and Logical cpu cores (Lcores) per NUMA
 * node configuration for Enhanced Networking Stack enabled HostSwitch.
 */
public final class CpuCoreConfigForEnhancedNetworkingStackSwitch implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    private java.lang.Long numLcores;

    private java.lang.Long numaNodeIndex;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public CpuCoreConfigForEnhancedNetworkingStackSwitch() {
    }

    protected CpuCoreConfigForEnhancedNetworkingStackSwitch(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * Number of Logical cpu cores (Lcores) to be placed on a specified NUMA node
     * format: int32
     *
     * @return The current value of the property.
     */
    public java.lang.Long getNumLcores() {
        return this.numLcores;
    }

    /**
     * Number of Logical cpu cores (Lcores) to be placed on a specified NUMA node
     * format: int32
     *
     * @param numLcores New value for the property.
     */
    public void setNumLcores(java.lang.Long numLcores) {
        this.numLcores = numLcores;
    }

    /**
     * Unique index of the Non Uniform Memory Access (NUMA) node format: int32
     *
     * @return The current value of the property.
     */
    public java.lang.Long getNumaNodeIndex() {
        return this.numaNodeIndex;
    }

    /**
     * Unique index of the Non Uniform Memory Access (NUMA) node format: int32
     *
     * @param numaNodeIndex New value for the property.
     */
    public void setNumaNodeIndex(java.lang.Long numaNodeIndex) {
        this.numaNodeIndex = numaNodeIndex;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx.model.StructDefinitions.cpuCoreConfigForEnhancedNetworkingStackSwitch;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("num_lcores",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.numLcores, this._getType().getField("num_lcores")));
        structValue.setField("numa_node_index",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.numaNodeIndex, this._getType().getField("numa_node_index")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx.model.StructDefinitions.cpuCoreConfigForEnhancedNetworkingStackSwitch;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx.model.StructDefinitions.cpuCoreConfigForEnhancedNetworkingStackSwitch.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static CpuCoreConfigForEnhancedNetworkingStackSwitch _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new CpuCoreConfigForEnhancedNetworkingStackSwitch(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static CpuCoreConfigForEnhancedNetworkingStackSwitch _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new CpuCoreConfigForEnhancedNetworkingStackSwitch(structValue);
    }

    /**
     * Builder class for {@link CpuCoreConfigForEnhancedNetworkingStackSwitch}.
     */
    public static final class Builder {
        private java.lang.Long numLcores;
        private java.lang.Long numaNodeIndex;

        /**
         * Constructor with parameters for the required properties of
         * {@link CpuCoreConfigForEnhancedNetworkingStackSwitch}.
         */
        public Builder() {
        }

        /**
         * Number of Logical cpu cores (Lcores) to be placed on a specified NUMA node
         * format: int32
         *
         * @param numLcores New value for the property.
         */
        public Builder setNumLcores(java.lang.Long numLcores) {
            this.numLcores = numLcores;
            return this;
        }

        /**
         * Unique index of the Non Uniform Memory Access (NUMA) node format: int32
         *
         * @param numaNodeIndex New value for the property.
         */
        public Builder setNumaNodeIndex(java.lang.Long numaNodeIndex) {
            this.numaNodeIndex = numaNodeIndex;
            return this;
        }

        public CpuCoreConfigForEnhancedNetworkingStackSwitch build() {
            CpuCoreConfigForEnhancedNetworkingStackSwitch result = new CpuCoreConfigForEnhancedNetworkingStackSwitch();
            result.setNumLcores(this.numLcores);
            result.setNumaNodeIndex(this.numaNodeIndex);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("num_lcores", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("num_lcores",
                                                                                "numLcores",
                                                                                "getNumLcores",
                                                                                "setNumLcores");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("numa_node_index", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("numa_node_index",
                                                                                "numaNodeIndex",
                                                                                "getNumaNodeIndex",
                                                                                "setNumaNodeIndex");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx.model.cpu_core_config_for_enhanced_networking_stack_switch",
                                                            fields,
                                                            com.vmware.nsx.model.CpuCoreConfigForEnhancedNetworkingStackSwitch.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

