/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx.model;

/**
 * Domain synchronization settings
 */
public final class DirectoryDomainSyncSettings implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    private java.lang.Long deltaSyncInterval;

    private java.lang.String fullSyncCronExpr;

    private java.lang.Long syncDelayInSec;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public DirectoryDomainSyncSettings() {
    }

    protected DirectoryDomainSyncSettings(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * Directory domain delta synchronization interval time between two delta sync in
     * minutes. format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getDeltaSyncInterval() {
        return this.deltaSyncInterval;
    }

    /**
     * Directory domain delta synchronization interval time between two delta sync in
     * minutes. format: int64
     *
     * @param deltaSyncInterval New value for the property.
     */
    public void setDeltaSyncInterval(java.lang.Long deltaSyncInterval) {
        this.deltaSyncInterval = deltaSyncInterval;
    }

    /**
     * Directory domain full synchronization schedule using cron expression. For
     * example, cron expression \"0 0 12 ? * SUN *\" means full sync is scheduled every
     * Sunday midnight. If this object is null, it means there is no background cron
     * job running for full sync.
     *
     * @return The current value of the property.
     */
    public java.lang.String getFullSyncCronExpr() {
        return this.fullSyncCronExpr;
    }

    /**
     * Directory domain full synchronization schedule using cron expression. For
     * example, cron expression \"0 0 12 ? * SUN *\" means full sync is scheduled every
     * Sunday midnight. If this object is null, it means there is no background cron
     * job running for full sync.
     *
     * @param fullSyncCronExpr New value for the property.
     */
    public void setFullSyncCronExpr(java.lang.String fullSyncCronExpr) {
        this.fullSyncCronExpr = fullSyncCronExpr;
    }

    /**
     * Sync delay after Directory domain has been successfully created. if delay is -1,
     * initial full sync will not be triggered. format: int32
     *
     * @return The current value of the property.
     */
    public java.lang.Long getSyncDelayInSec() {
        return this.syncDelayInSec;
    }

    /**
     * Sync delay after Directory domain has been successfully created. if delay is -1,
     * initial full sync will not be triggered. format: int32
     *
     * @param syncDelayInSec New value for the property.
     */
    public void setSyncDelayInSec(java.lang.Long syncDelayInSec) {
        this.syncDelayInSec = syncDelayInSec;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx.model.StructDefinitions.directoryDomainSyncSettings;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("delta_sync_interval",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.deltaSyncInterval, this._getType().getField("delta_sync_interval")));
        structValue.setField("full_sync_cron_expr",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.fullSyncCronExpr, this._getType().getField("full_sync_cron_expr")));
        structValue.setField("sync_delay_in_sec",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.syncDelayInSec, this._getType().getField("sync_delay_in_sec")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx.model.StructDefinitions.directoryDomainSyncSettings;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx.model.StructDefinitions.directoryDomainSyncSettings.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static DirectoryDomainSyncSettings _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new DirectoryDomainSyncSettings(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static DirectoryDomainSyncSettings _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new DirectoryDomainSyncSettings(structValue);
    }

    /**
     * Builder class for {@link DirectoryDomainSyncSettings}.
     */
    public static final class Builder {
        private java.lang.Long deltaSyncInterval;
        private java.lang.String fullSyncCronExpr;
        private java.lang.Long syncDelayInSec;

        /**
         * Constructor with parameters for the required properties of
         * {@link DirectoryDomainSyncSettings}.
         */
        public Builder() {
        }

        /**
         * Directory domain delta synchronization interval time between two delta sync in
         * minutes. format: int64
         *
         * @param deltaSyncInterval New value for the property.
         */
        public Builder setDeltaSyncInterval(java.lang.Long deltaSyncInterval) {
            this.deltaSyncInterval = deltaSyncInterval;
            return this;
        }

        /**
         * Directory domain full synchronization schedule using cron expression. For
         * example, cron expression \"0 0 12 ? * SUN *\" means full sync is scheduled every
         * Sunday midnight. If this object is null, it means there is no background cron
         * job running for full sync.
         *
         * @param fullSyncCronExpr New value for the property.
         */
        public Builder setFullSyncCronExpr(java.lang.String fullSyncCronExpr) {
            this.fullSyncCronExpr = fullSyncCronExpr;
            return this;
        }

        /**
         * Sync delay after Directory domain has been successfully created. if delay is -1,
         * initial full sync will not be triggered. format: int32
         *
         * @param syncDelayInSec New value for the property.
         */
        public Builder setSyncDelayInSec(java.lang.Long syncDelayInSec) {
            this.syncDelayInSec = syncDelayInSec;
            return this;
        }

        public DirectoryDomainSyncSettings build() {
            DirectoryDomainSyncSettings result = new DirectoryDomainSyncSettings();
            result.setDeltaSyncInterval(this.deltaSyncInterval);
            result.setFullSyncCronExpr(this.fullSyncCronExpr);
            result.setSyncDelayInSec(this.syncDelayInSec);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("delta_sync_interval", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("delta_sync_interval",
                                                                                "deltaSyncInterval",
                                                                                "getDeltaSyncInterval",
                                                                                "setDeltaSyncInterval");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("full_sync_cron_expr", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("full_sync_cron_expr",
                                                                                "fullSyncCronExpr",
                                                                                "getFullSyncCronExpr",
                                                                                "setFullSyncCronExpr");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("sync_delay_in_sec", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("sync_delay_in_sec",
                                                                                "syncDelayInSec",
                                                                                "getSyncDelayInSec",
                                                                                "setSyncDelayInSec");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx.model.directory_domain_sync_settings",
                                                            fields,
                                                            com.vmware.nsx.model.DirectoryDomainSyncSettings.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

