/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx.model;

/**
 * The response for DNS nslookup.
 */
public final class DnsAnswer implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    private java.util.List<com.vmware.nsx.model.DnsQueryAnswer> answers;

    private java.util.List<com.vmware.nsx.model.DnsQueryAnswer> authoritativeAnswers;

    private java.lang.String dnsServer;

    private java.lang.String edgeNodeId;

    private java.util.List<com.vmware.nsx.model.DnsQueryAnswer> nonAuthoritativeAnswers;

    private java.lang.String rawAnswer;

    private java.lang.String sourceIp;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public DnsAnswer() {
    }

    protected DnsAnswer(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * The answers of the query.
     *
     * @return The current value of the property.
     */
    public java.util.List<com.vmware.nsx.model.DnsQueryAnswer> getAnswers() {
        return this.answers;
    }

    /**
     * The answers of the query.
     *
     * @param answers New value for the property.
     */
    public void setAnswers(java.util.List<com.vmware.nsx.model.DnsQueryAnswer> answers) {
        this.answers = answers;
    }

    /**
     * Authotitative answers of the query. This is a deprecated property, please use
     * 'answers' instead.
     *
     * @return The current value of the property.
     */
    @Deprecated
    public java.util.List<com.vmware.nsx.model.DnsQueryAnswer> getAuthoritativeAnswers() {
        return this.authoritativeAnswers;
    }

    /**
     * Authotitative answers of the query. This is a deprecated property, please use
     * 'answers' instead.
     *
     * @param authoritativeAnswers New value for the property.
     */
    @Deprecated
    public void setAuthoritativeAnswers(java.util.List<com.vmware.nsx.model.DnsQueryAnswer> authoritativeAnswers) {
        this.authoritativeAnswers = authoritativeAnswers;
    }

    /**
     * Dns server ip address and port, format is \"ip address#port\".
     *
     * @return The current value of the property.
     */
    public java.lang.String getDnsServer() {
        return this.dnsServer;
    }

    /**
     * Dns server ip address and port, format is \"ip address#port\".
     *
     * @param dnsServer New value for the property.
     */
    public void setDnsServer(java.lang.String dnsServer) {
        this.dnsServer = dnsServer;
    }

    /**
     * ID of the edge node that performed the query.
     *
     * @return The current value of the property.
     */
    public java.lang.String getEdgeNodeId() {
        return this.edgeNodeId;
    }

    /**
     * ID of the edge node that performed the query.
     *
     * @param edgeNodeId New value for the property.
     */
    public void setEdgeNodeId(java.lang.String edgeNodeId) {
        this.edgeNodeId = edgeNodeId;
    }

    /**
     * Non-authotitative answers of the query. This is a deprecated property, please
     * use 'answers' instead.
     *
     * @return The current value of the property.
     */
    @Deprecated
    public java.util.List<com.vmware.nsx.model.DnsQueryAnswer> getNonAuthoritativeAnswers() {
        return this.nonAuthoritativeAnswers;
    }

    /**
     * Non-authotitative answers of the query. This is a deprecated property, please
     * use 'answers' instead.
     *
     * @param nonAuthoritativeAnswers New value for the property.
     */
    @Deprecated
    public void setNonAuthoritativeAnswers(java.util.List<com.vmware.nsx.model.DnsQueryAnswer> nonAuthoritativeAnswers) {
        this.nonAuthoritativeAnswers = nonAuthoritativeAnswers;
    }

    /**
     * It can be NXDOMAIN or error message which is not consisted of
     * authoritative_answer or non_authoritative_answer.
     *
     * @return The current value of the property.
     */
    public java.lang.String getRawAnswer() {
        return this.rawAnswer;
    }

    /**
     * It can be NXDOMAIN or error message which is not consisted of
     * authoritative_answer or non_authoritative_answer.
     *
     * @param rawAnswer New value for the property.
     */
    public void setRawAnswer(java.lang.String rawAnswer) {
        this.rawAnswer = rawAnswer;
    }

    /**
     * The source ip used in this lookup. format: ipv4
     *
     * @return The current value of the property.
     */
    public java.lang.String getSourceIp() {
        return this.sourceIp;
    }

    /**
     * The source ip used in this lookup. format: ipv4
     *
     * @param sourceIp New value for the property.
     */
    public void setSourceIp(java.lang.String sourceIp) {
        this.sourceIp = sourceIp;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx.model.StructDefinitions.dnsAnswer;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("answers",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.answers, this._getType().getField("answers")));
        structValue.setField("authoritative_answers",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.authoritativeAnswers, this._getType().getField("authoritative_answers")));
        structValue.setField("dns_server",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.dnsServer, this._getType().getField("dns_server")));
        structValue.setField("edge_node_id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.edgeNodeId, this._getType().getField("edge_node_id")));
        structValue.setField("non_authoritative_answers",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.nonAuthoritativeAnswers, this._getType().getField("non_authoritative_answers")));
        structValue.setField("raw_answer",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.rawAnswer, this._getType().getField("raw_answer")));
        structValue.setField("source_ip",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.sourceIp, this._getType().getField("source_ip")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx.model.StructDefinitions.dnsAnswer;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx.model.StructDefinitions.dnsAnswer.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static DnsAnswer _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new DnsAnswer(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static DnsAnswer _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new DnsAnswer(structValue);
    }

    /**
     * Builder class for {@link DnsAnswer}.
     */
    public static final class Builder {
        private java.util.List<com.vmware.nsx.model.DnsQueryAnswer> answers;
        private java.util.List<com.vmware.nsx.model.DnsQueryAnswer> authoritativeAnswers;
        private java.lang.String dnsServer;
        private java.lang.String edgeNodeId;
        private java.util.List<com.vmware.nsx.model.DnsQueryAnswer> nonAuthoritativeAnswers;
        private java.lang.String rawAnswer;
        private java.lang.String sourceIp;

        /**
         * Constructor with parameters for the required properties of
         * {@link DnsAnswer}.
         */
        public Builder() {
        }

        /**
         * The answers of the query.
         *
         * @param answers New value for the property.
         */
        public Builder setAnswers(java.util.List<com.vmware.nsx.model.DnsQueryAnswer> answers) {
            this.answers = answers;
            return this;
        }

        /**
         * Authotitative answers of the query. This is a deprecated property, please use
         * 'answers' instead.
         *
         * @param authoritativeAnswers New value for the property.
         */
        public Builder setAuthoritativeAnswers(java.util.List<com.vmware.nsx.model.DnsQueryAnswer> authoritativeAnswers) {
            this.authoritativeAnswers = authoritativeAnswers;
            return this;
        }

        /**
         * Dns server ip address and port, format is \"ip address#port\".
         *
         * @param dnsServer New value for the property.
         */
        public Builder setDnsServer(java.lang.String dnsServer) {
            this.dnsServer = dnsServer;
            return this;
        }

        /**
         * ID of the edge node that performed the query.
         *
         * @param edgeNodeId New value for the property.
         */
        public Builder setEdgeNodeId(java.lang.String edgeNodeId) {
            this.edgeNodeId = edgeNodeId;
            return this;
        }

        /**
         * Non-authotitative answers of the query. This is a deprecated property, please
         * use 'answers' instead.
         *
         * @param nonAuthoritativeAnswers New value for the property.
         */
        public Builder setNonAuthoritativeAnswers(java.util.List<com.vmware.nsx.model.DnsQueryAnswer> nonAuthoritativeAnswers) {
            this.nonAuthoritativeAnswers = nonAuthoritativeAnswers;
            return this;
        }

        /**
         * It can be NXDOMAIN or error message which is not consisted of
         * authoritative_answer or non_authoritative_answer.
         *
         * @param rawAnswer New value for the property.
         */
        public Builder setRawAnswer(java.lang.String rawAnswer) {
            this.rawAnswer = rawAnswer;
            return this;
        }

        /**
         * The source ip used in this lookup. format: ipv4
         *
         * @param sourceIp New value for the property.
         */
        public Builder setSourceIp(java.lang.String sourceIp) {
            this.sourceIp = sourceIp;
            return this;
        }

        public DnsAnswer build() {
            DnsAnswer result = new DnsAnswer();
            result.setAnswers(this.answers);
            result.setAuthoritativeAnswers(this.authoritativeAnswers);
            result.setDnsServer(this.dnsServer);
            result.setEdgeNodeId(this.edgeNodeId);
            result.setNonAuthoritativeAnswers(this.nonAuthoritativeAnswers);
            result.setRawAnswer(this.rawAnswer);
            result.setSourceIp(this.sourceIp);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("answers", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx.model.StructDefinitions.dnsQueryAnswer; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("answers",
                                                                                "answers",
                                                                                "getAnswers",
                                                                                "setAnswers");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("authoritative_answers", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx.model.StructDefinitions.dnsQueryAnswer; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("authoritative_answers",
                                                                                "authoritativeAnswers",
                                                                                "getAuthoritativeAnswers",
                                                                                "setAuthoritativeAnswers");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("dns_server", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("dns_server",
                                                                                "dnsServer",
                                                                                "getDnsServer",
                                                                                "setDnsServer");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("edge_node_id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("edge_node_id",
                                                                                "edgeNodeId",
                                                                                "getEdgeNodeId",
                                                                                "setEdgeNodeId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("non_authoritative_answers", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx.model.StructDefinitions.dnsQueryAnswer; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("non_authoritative_answers",
                                                                                "nonAuthoritativeAnswers",
                                                                                "getNonAuthoritativeAnswers",
                                                                                "setNonAuthoritativeAnswers");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("raw_answer", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("raw_answer",
                                                                                "rawAnswer",
                                                                                "getRawAnswer",
                                                                                "setRawAnswer");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("source_ip", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("source_ip",
                                                                                "sourceIp",
                                                                                "getSourceIp",
                                                                                "setSourceIp");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx.model.dns_answer",
                                                            fields,
                                                            com.vmware.nsx.model.DnsAnswer.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

