/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx.model;

/**
 * The summary of the failed DNS query. The query result represents a full query
 * chain from client VM to dns forwarder, and upstream server if no forwarder cache
 * was hit.
 */
public final class DnsFailedQuery implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    private java.lang.String address;

    private java.lang.String clientIp;

    private java.lang.String errorMessage;

    private java.lang.String errorType;

    private java.lang.String forwarderIp;

    private java.lang.String recordType;

    private java.lang.String sourceIp;

    private java.lang.Long timeSpent;

    private java.lang.String timestamp;

    private java.lang.String upstreamServerIp;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public DnsFailedQuery() {
    }

    protected DnsFailedQuery(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * The address be queried, can be a FQDN or an ip address.
     *
     * @return The current value of the property.
     */
    public java.lang.String getAddress() {
        return this.address;
    }

    /**
     * The address be queried, can be a FQDN or an ip address.
     *
     * @param address New value for the property.
     */
    public void setAddress(java.lang.String address) {
        this.address = address;
    }

    /**
     * The client host ip address from which the query was issued.
     *
     * @return The current value of the property.
     */
    public java.lang.String getClientIp() {
        return this.clientIp;
    }

    /**
     * The client host ip address from which the query was issued.
     *
     * @param clientIp New value for the property.
     */
    public void setClientIp(java.lang.String clientIp) {
        this.clientIp = clientIp;
    }

    /**
     * The detailed error message of the failed query, if any.
     *
     * @return The current value of the property.
     */
    public java.lang.String getErrorMessage() {
        return this.errorMessage;
    }

    /**
     * The detailed error message of the failed query, if any.
     *
     * @param errorMessage New value for the property.
     */
    public void setErrorMessage(java.lang.String errorMessage) {
        this.errorMessage = errorMessage;
    }

    /**
     * The type of the query failure, e.g. NXDOMAIN, etc.
     *
     * @return The current value of the property.
     */
    public java.lang.String getErrorType() {
        return this.errorType;
    }

    /**
     * The type of the query failure, e.g. NXDOMAIN, etc.
     *
     * @param errorType New value for the property.
     */
    public void setErrorType(java.lang.String errorType) {
        this.errorType = errorType;
    }

    /**
     * The DNS forwarder ip address to which the query was first received.
     *
     * @return The current value of the property.
     */
    public java.lang.String getForwarderIp() {
        return this.forwarderIp;
    }

    /**
     * The DNS forwarder ip address to which the query was first received.
     *
     * @param forwarderIp New value for the property.
     */
    public void setForwarderIp(java.lang.String forwarderIp) {
        this.forwarderIp = forwarderIp;
    }

    /**
     * The record type be queried, e.g. A, CNAME, SOA, etc.
     *
     * @return The current value of the property.
     */
    public java.lang.String getRecordType() {
        return this.recordType;
    }

    /**
     * The record type be queried, e.g. A, CNAME, SOA, etc.
     *
     * @param recordType New value for the property.
     */
    public void setRecordType(java.lang.String recordType) {
        this.recordType = recordType;
    }

    /**
     * The source ip address that is used to forward a query to an upstream server.
     *
     * @return The current value of the property.
     */
    public java.lang.String getSourceIp() {
        return this.sourceIp;
    }

    /**
     * The source ip address that is used to forward a query to an upstream server.
     *
     * @param sourceIp New value for the property.
     */
    public void setSourceIp(java.lang.String sourceIp) {
        this.sourceIp = sourceIp;
    }

    /**
     * The time the query took before it got a failed answer, in ms. format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getTimeSpent() {
        return this.timeSpent;
    }

    /**
     * The time the query took before it got a failed answer, in ms. format: int64
     *
     * @param timeSpent New value for the property.
     */
    public void setTimeSpent(java.lang.Long timeSpent) {
        this.timeSpent = timeSpent;
    }

    /**
     * Timestamp of the request, in YYYY-MM-DD HH:MM:SS.zzz format.
     *
     * @return The current value of the property.
     */
    public java.lang.String getTimestamp() {
        return this.timestamp;
    }

    /**
     * Timestamp of the request, in YYYY-MM-DD HH:MM:SS.zzz format.
     *
     * @param timestamp New value for the property.
     */
    public void setTimestamp(java.lang.String timestamp) {
        this.timestamp = timestamp;
    }

    /**
     * The upstream server ip address to which the query was forwarded. If the query
     * could not be serviced from the DNS forwarder cache, this property will contain
     * the IP address of the DNS server that serviced the request. If the request was
     * serviced from the cache, this property will be absent.
     *
     * @return The current value of the property.
     */
    public java.lang.String getUpstreamServerIp() {
        return this.upstreamServerIp;
    }

    /**
     * The upstream server ip address to which the query was forwarded. If the query
     * could not be serviced from the DNS forwarder cache, this property will contain
     * the IP address of the DNS server that serviced the request. If the request was
     * serviced from the cache, this property will be absent.
     *
     * @param upstreamServerIp New value for the property.
     */
    public void setUpstreamServerIp(java.lang.String upstreamServerIp) {
        this.upstreamServerIp = upstreamServerIp;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx.model.StructDefinitions.dnsFailedQuery;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("address",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.address, this._getType().getField("address")));
        structValue.setField("client_ip",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.clientIp, this._getType().getField("client_ip")));
        structValue.setField("error_message",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.errorMessage, this._getType().getField("error_message")));
        structValue.setField("error_type",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.errorType, this._getType().getField("error_type")));
        structValue.setField("forwarder_ip",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.forwarderIp, this._getType().getField("forwarder_ip")));
        structValue.setField("record_type",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.recordType, this._getType().getField("record_type")));
        structValue.setField("source_ip",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.sourceIp, this._getType().getField("source_ip")));
        structValue.setField("time_spent",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.timeSpent, this._getType().getField("time_spent")));
        structValue.setField("timestamp",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.timestamp, this._getType().getField("timestamp")));
        structValue.setField("upstream_server_ip",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.upstreamServerIp, this._getType().getField("upstream_server_ip")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx.model.StructDefinitions.dnsFailedQuery;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx.model.StructDefinitions.dnsFailedQuery.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static DnsFailedQuery _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new DnsFailedQuery(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static DnsFailedQuery _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new DnsFailedQuery(structValue);
    }

    /**
     * Builder class for {@link DnsFailedQuery}.
     */
    public static final class Builder {
        private java.lang.String address;
        private java.lang.String clientIp;
        private java.lang.String errorMessage;
        private java.lang.String errorType;
        private java.lang.String forwarderIp;
        private java.lang.String recordType;
        private java.lang.String sourceIp;
        private java.lang.Long timeSpent;
        private java.lang.String timestamp;
        private java.lang.String upstreamServerIp;

        /**
         * Constructor with parameters for the required properties of
         * {@link DnsFailedQuery}.
         */
        public Builder() {
        }

        /**
         * The address be queried, can be a FQDN or an ip address.
         *
         * @param address New value for the property.
         */
        public Builder setAddress(java.lang.String address) {
            this.address = address;
            return this;
        }

        /**
         * The client host ip address from which the query was issued.
         *
         * @param clientIp New value for the property.
         */
        public Builder setClientIp(java.lang.String clientIp) {
            this.clientIp = clientIp;
            return this;
        }

        /**
         * The detailed error message of the failed query, if any.
         *
         * @param errorMessage New value for the property.
         */
        public Builder setErrorMessage(java.lang.String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        /**
         * The type of the query failure, e.g. NXDOMAIN, etc.
         *
         * @param errorType New value for the property.
         */
        public Builder setErrorType(java.lang.String errorType) {
            this.errorType = errorType;
            return this;
        }

        /**
         * The DNS forwarder ip address to which the query was first received.
         *
         * @param forwarderIp New value for the property.
         */
        public Builder setForwarderIp(java.lang.String forwarderIp) {
            this.forwarderIp = forwarderIp;
            return this;
        }

        /**
         * The record type be queried, e.g. A, CNAME, SOA, etc.
         *
         * @param recordType New value for the property.
         */
        public Builder setRecordType(java.lang.String recordType) {
            this.recordType = recordType;
            return this;
        }

        /**
         * The source ip address that is used to forward a query to an upstream server.
         *
         * @param sourceIp New value for the property.
         */
        public Builder setSourceIp(java.lang.String sourceIp) {
            this.sourceIp = sourceIp;
            return this;
        }

        /**
         * The time the query took before it got a failed answer, in ms. format: int64
         *
         * @param timeSpent New value for the property.
         */
        public Builder setTimeSpent(java.lang.Long timeSpent) {
            this.timeSpent = timeSpent;
            return this;
        }

        /**
         * Timestamp of the request, in YYYY-MM-DD HH:MM:SS.zzz format.
         *
         * @param timestamp New value for the property.
         */
        public Builder setTimestamp(java.lang.String timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        /**
         * The upstream server ip address to which the query was forwarded. If the query
         * could not be serviced from the DNS forwarder cache, this property will contain
         * the IP address of the DNS server that serviced the request. If the request was
         * serviced from the cache, this property will be absent.
         *
         * @param upstreamServerIp New value for the property.
         */
        public Builder setUpstreamServerIp(java.lang.String upstreamServerIp) {
            this.upstreamServerIp = upstreamServerIp;
            return this;
        }

        public DnsFailedQuery build() {
            DnsFailedQuery result = new DnsFailedQuery();
            result.setAddress(this.address);
            result.setClientIp(this.clientIp);
            result.setErrorMessage(this.errorMessage);
            result.setErrorType(this.errorType);
            result.setForwarderIp(this.forwarderIp);
            result.setRecordType(this.recordType);
            result.setSourceIp(this.sourceIp);
            result.setTimeSpent(this.timeSpent);
            result.setTimestamp(this.timestamp);
            result.setUpstreamServerIp(this.upstreamServerIp);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("address", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("address",
                                                                                "address",
                                                                                "getAddress",
                                                                                "setAddress");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("client_ip", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("client_ip",
                                                                                "clientIp",
                                                                                "getClientIp",
                                                                                "setClientIp");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("error_message", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("error_message",
                                                                                "errorMessage",
                                                                                "getErrorMessage",
                                                                                "setErrorMessage");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("error_type", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("error_type",
                                                                                "errorType",
                                                                                "getErrorType",
                                                                                "setErrorType");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("forwarder_ip", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("forwarder_ip",
                                                                                "forwarderIp",
                                                                                "getForwarderIp",
                                                                                "setForwarderIp");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("record_type", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("record_type",
                                                                                "recordType",
                                                                                "getRecordType",
                                                                                "setRecordType");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("source_ip", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("source_ip",
                                                                                "sourceIp",
                                                                                "getSourceIp",
                                                                                "setSourceIp");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("time_spent", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("time_spent",
                                                                                "timeSpent",
                                                                                "getTimeSpent",
                                                                                "setTimeSpent");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("timestamp", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("timestamp",
                                                                                "timestamp",
                                                                                "getTimestamp",
                                                                                "setTimestamp");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("upstream_server_ip", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("upstream_server_ip",
                                                                                "upstreamServerIp",
                                                                                "getUpstreamServerIp",
                                                                                "setUpstreamServerIp");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx.model.dns_failed_query",
                                                            fields,
                                                            com.vmware.nsx.model.DnsFailedQuery.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

