/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx.model;

/**
 * Data processing unit status properties
 */
public final class DpuStatusProperties implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    private java.lang.Long cpuCores;

    private java.lang.String dpuId;

    private java.util.List<java.lang.Double> loadAverage;

    private java.lang.Long memCache;

    private java.lang.Long memTotal;

    private java.lang.Long memUsed;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public DpuStatusProperties() {
    }

    protected DpuStatusProperties(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * The number of CPU cores on the system. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getCpuCores() {
        return this.cpuCores;
    }

    /**
     * The number of CPU cores on the system. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param cpuCores New value for the property.
     */
    public void setCpuCores(java.lang.Long cpuCores) {
        this.cpuCores = cpuCores;
    }

    /**
     * Data processing unit ID
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getDpuId() {
        return this.dpuId;
    }

    /**
     * Data processing unit ID
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param dpuId New value for the property.
     */
    public void setDpuId(java.lang.String dpuId) {
        this.dpuId = dpuId;
    }

    /**
     * One, five, and fifteen minute load averages for the system.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.util.List<java.lang.Double> getLoadAverage() {
        return this.loadAverage;
    }

    /**
     * One, five, and fifteen minute load averages for the system.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param loadAverage New value for the property.
     */
    public void setLoadAverage(java.util.List<java.lang.Double> loadAverage) {
        this.loadAverage = loadAverage;
    }

    /**
     * Amount of RAM on the system that can be flushed out to disk, in kilobytes.
     * format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getMemCache() {
        return this.memCache;
    }

    /**
     * Amount of RAM on the system that can be flushed out to disk, in kilobytes.
     * format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param memCache New value for the property.
     */
    public void setMemCache(java.lang.Long memCache) {
        this.memCache = memCache;
    }

    /**
     * System Amount of RAM allocated to the system, in kilobytes. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getMemTotal() {
        return this.memTotal;
    }

    /**
     * System Amount of RAM allocated to the system, in kilobytes. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param memTotal New value for the property.
     */
    public void setMemTotal(java.lang.Long memTotal) {
        this.memTotal = memTotal;
    }

    /**
     * Amount of RAM in use on the system, in kilobytes. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getMemUsed() {
        return this.memUsed;
    }

    /**
     * Amount of RAM in use on the system, in kilobytes. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param memUsed New value for the property.
     */
    public void setMemUsed(java.lang.Long memUsed) {
        this.memUsed = memUsed;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx.model.StructDefinitions.dpuStatusProperties;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("cpu_cores",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.cpuCores, this._getType().getField("cpu_cores")));
        structValue.setField("dpu_id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.dpuId, this._getType().getField("dpu_id")));
        structValue.setField("load_average",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.loadAverage, this._getType().getField("load_average")));
        structValue.setField("mem_cache",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.memCache, this._getType().getField("mem_cache")));
        structValue.setField("mem_total",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.memTotal, this._getType().getField("mem_total")));
        structValue.setField("mem_used",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.memUsed, this._getType().getField("mem_used")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx.model.StructDefinitions.dpuStatusProperties;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx.model.StructDefinitions.dpuStatusProperties.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static DpuStatusProperties _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new DpuStatusProperties(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static DpuStatusProperties _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new DpuStatusProperties(structValue);
    }

    /**
     * Builder class for {@link DpuStatusProperties}.
     */
    public static final class Builder {
        private java.lang.Long cpuCores;
        private java.lang.String dpuId;
        private java.util.List<java.lang.Double> loadAverage;
        private java.lang.Long memCache;
        private java.lang.Long memTotal;
        private java.lang.Long memUsed;

        /**
         * Constructor with parameters for the required properties of
         * {@link DpuStatusProperties}.
         */
        public Builder() {
        }

        /**
         * The number of CPU cores on the system. format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param cpuCores New value for the property.
         */
        public Builder setCpuCores(java.lang.Long cpuCores) {
            this.cpuCores = cpuCores;
            return this;
        }

        /**
         * Data processing unit ID
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param dpuId New value for the property.
         */
        public Builder setDpuId(java.lang.String dpuId) {
            this.dpuId = dpuId;
            return this;
        }

        /**
         * One, five, and fifteen minute load averages for the system.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param loadAverage New value for the property.
         */
        public Builder setLoadAverage(java.util.List<java.lang.Double> loadAverage) {
            this.loadAverage = loadAverage;
            return this;
        }

        /**
         * Amount of RAM on the system that can be flushed out to disk, in kilobytes.
         * format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param memCache New value for the property.
         */
        public Builder setMemCache(java.lang.Long memCache) {
            this.memCache = memCache;
            return this;
        }

        /**
         * System Amount of RAM allocated to the system, in kilobytes. format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param memTotal New value for the property.
         */
        public Builder setMemTotal(java.lang.Long memTotal) {
            this.memTotal = memTotal;
            return this;
        }

        /**
         * Amount of RAM in use on the system, in kilobytes. format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param memUsed New value for the property.
         */
        public Builder setMemUsed(java.lang.Long memUsed) {
            this.memUsed = memUsed;
            return this;
        }

        public DpuStatusProperties build() {
            DpuStatusProperties result = new DpuStatusProperties();
            result.setCpuCores(this.cpuCores);
            result.setDpuId(this.dpuId);
            result.setLoadAverage(this.loadAverage);
            result.setMemCache(this.memCache);
            result.setMemTotal(this.memTotal);
            result.setMemUsed(this.memUsed);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("cpu_cores", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("cpu_cores",
                                                                                "cpuCores",
                                                                                "getCpuCores",
                                                                                "setCpuCores");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("dpu_id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("dpu_id",
                                                                                "dpuId",
                                                                                "getDpuId",
                                                                                "setDpuId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("load_average", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.DoubleType())));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("load_average",
                                                                                "loadAverage",
                                                                                "getLoadAverage",
                                                                                "setLoadAverage");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("mem_cache", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("mem_cache",
                                                                                "memCache",
                                                                                "getMemCache",
                                                                                "setMemCache");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("mem_total", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("mem_total",
                                                                                "memTotal",
                                                                                "getMemTotal",
                                                                                "setMemTotal");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("mem_used", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("mem_used",
                                                                                "memUsed",
                                                                                "getMemUsed",
                                                                                "setMemUsed");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx.model.dpu_status_properties",
                                                            fields,
                                                            com.vmware.nsx.model.DpuStatusProperties.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

