/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx.model;

/**
 * Host Switch configuration option specification
 */
public final class HostSwitchConfigOption implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    private java.lang.String hostSwitchId;

    private java.util.List<com.vmware.nsx.model.HostSwitchProfileTypeIdEntry> hostSwitchProfileIds;

    private com.vmware.vapi.bindings.Structure ipAssignmentSpec;

    private com.vmware.vapi.bindings.Structure ipv6AssignmentSpec;

    private java.util.List<com.vmware.nsx.model.VdsUplink> uplinks;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public HostSwitchConfigOption() {
    }

    protected HostSwitchConfigOption(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * This field is writable only in case of VDS type HostSwitch and system generated
     * for NVDS type. For VDS type host switch, This field is used to lookup a VDS from
     * corresponding Compute Manager and then can be configured for logical networking.
     * For NVDS type host switch, This field is system generated and if provided will
     * be overwritten.
     *
     * @return The current value of the property.
     */
    public java.lang.String getHostSwitchId() {
        return this.hostSwitchId;
    }

    /**
     * This field is writable only in case of VDS type HostSwitch and system generated
     * for NVDS type. For VDS type host switch, This field is used to lookup a VDS from
     * corresponding Compute Manager and then can be configured for logical networking.
     * For NVDS type host switch, This field is system generated and if provided will
     * be overwritten.
     *
     * @param hostSwitchId New value for the property.
     */
    public void setHostSwitchId(java.lang.String hostSwitchId) {
        this.hostSwitchId = hostSwitchId;
    }

    /**
     * Host switch profiles bound to this host switch. If a profile ID is not provided
     * for any HostSwitchProfileType that is supported by the transport node, the
     * corresponding default profile will be bound to the host switch. If transport
     * node is created using Policy APIs, use policyPaths instead of UUIDs.
     *
     * @return The current value of the property.
     */
    public java.util.List<com.vmware.nsx.model.HostSwitchProfileTypeIdEntry> getHostSwitchProfileIds() {
        return this.hostSwitchProfileIds;
    }

    /**
     * Host switch profiles bound to this host switch. If a profile ID is not provided
     * for any HostSwitchProfileType that is supported by the transport node, the
     * corresponding default profile will be bound to the host switch. If transport
     * node is created using Policy APIs, use policyPaths instead of UUIDs.
     *
     * @param hostSwitchProfileIds New value for the property.
     */
    public void setHostSwitchProfileIds(java.util.List<com.vmware.nsx.model.HostSwitchProfileTypeIdEntry> hostSwitchProfileIds) {
        this.hostSwitchProfileIds = hostSwitchProfileIds;
    }

    /**
     *
     *
     * @return The current value of the property.
     * When clients pass a value of this class as a parameter, the property must
     * contain all the properties defined in {@link
     * com.vmware.nsx.model.IpAssignmentSpec}. When methods return a value of this
     * class as a return value, the property will contain all the properties defined in
     * {@link com.vmware.nsx.model.IpAssignmentSpec}.
     */
    public com.vmware.vapi.bindings.Structure getIpAssignmentSpec() {
        return this.ipAssignmentSpec;
    }

    /**
     *
     *
     * @param ipAssignmentSpec New value for the property.
     * When clients pass a value of this class as a parameter, the property must
     * contain all the properties defined in {@link
     * com.vmware.nsx.model.IpAssignmentSpec}. When methods return a value of this
     * class as a return value, the property will contain all the properties defined in
     * {@link com.vmware.nsx.model.IpAssignmentSpec}.
     */
    public void setIpAssignmentSpec(com.vmware.vapi.bindings.Structure ipAssignmentSpec) {
        this.ipAssignmentSpec = ipAssignmentSpec;
    }

    /**
     *
     *
     * @return The current value of the property.
     * When clients pass a value of this class as a parameter, the property must
     * contain all the properties defined in {@link
     * com.vmware.nsx.model.Ipv6AssignmentSpec}. When methods return a value of this
     * class as a return value, the property will contain all the properties defined in
     * {@link com.vmware.nsx.model.Ipv6AssignmentSpec}.
     */
    public com.vmware.vapi.bindings.Structure getIpv6AssignmentSpec() {
        return this.ipv6AssignmentSpec;
    }

    /**
     *
     *
     * @param ipv6AssignmentSpec New value for the property.
     * When clients pass a value of this class as a parameter, the property must
     * contain all the properties defined in {@link
     * com.vmware.nsx.model.Ipv6AssignmentSpec}. When methods return a value of this
     * class as a return value, the property will contain all the properties defined in
     * {@link com.vmware.nsx.model.Ipv6AssignmentSpec}.
     */
    public void setIpv6AssignmentSpec(com.vmware.vapi.bindings.Structure ipv6AssignmentSpec) {
        this.ipv6AssignmentSpec = ipv6AssignmentSpec;
    }

    /**
     * If VDS is used as a HostSwitch this attribute must be specified. You can
     * associate uplinks from UplinkHostSwitchProfile to either VDS uplink or LAG. VDS
     * uplink or LAG will inherit the global VDS level teaming policy from vSphere. NSX
     * managed uplink or LAG will have NSX teaming policy configured through
     * UplinkHostSwitchProfile.
     *
     * @return The current value of the property.
     */
    public java.util.List<com.vmware.nsx.model.VdsUplink> getUplinks() {
        return this.uplinks;
    }

    /**
     * If VDS is used as a HostSwitch this attribute must be specified. You can
     * associate uplinks from UplinkHostSwitchProfile to either VDS uplink or LAG. VDS
     * uplink or LAG will inherit the global VDS level teaming policy from vSphere. NSX
     * managed uplink or LAG will have NSX teaming policy configured through
     * UplinkHostSwitchProfile.
     *
     * @param uplinks New value for the property.
     */
    public void setUplinks(java.util.List<com.vmware.nsx.model.VdsUplink> uplinks) {
        this.uplinks = uplinks;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx.model.StructDefinitions.hostSwitchConfigOption;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("host_switch_id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.hostSwitchId, this._getType().getField("host_switch_id")));
        structValue.setField("host_switch_profile_ids",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.hostSwitchProfileIds, this._getType().getField("host_switch_profile_ids")));
        structValue.setField("ip_assignment_spec",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.ipAssignmentSpec, this._getType().getField("ip_assignment_spec")));
        structValue.setField("ipv6_assignment_spec",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.ipv6AssignmentSpec, this._getType().getField("ipv6_assignment_spec")));
        structValue.setField("uplinks",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.uplinks, this._getType().getField("uplinks")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx.model.StructDefinitions.hostSwitchConfigOption;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx.model.StructDefinitions.hostSwitchConfigOption.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static HostSwitchConfigOption _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new HostSwitchConfigOption(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static HostSwitchConfigOption _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new HostSwitchConfigOption(structValue);
    }

    /**
     * Builder class for {@link HostSwitchConfigOption}.
     */
    public static final class Builder {
        private java.lang.String hostSwitchId;
        private java.util.List<com.vmware.nsx.model.HostSwitchProfileTypeIdEntry> hostSwitchProfileIds;
        private com.vmware.vapi.bindings.Structure ipAssignmentSpec;
        private com.vmware.vapi.bindings.Structure ipv6AssignmentSpec;
        private java.util.List<com.vmware.nsx.model.VdsUplink> uplinks;

        /**
         * Constructor with parameters for the required properties of
         * {@link HostSwitchConfigOption}.
         */
        public Builder() {
        }

        /**
         * This field is writable only in case of VDS type HostSwitch and system generated
         * for NVDS type. For VDS type host switch, This field is used to lookup a VDS from
         * corresponding Compute Manager and then can be configured for logical networking.
         * For NVDS type host switch, This field is system generated and if provided will
         * be overwritten.
         *
         * @param hostSwitchId New value for the property.
         */
        public Builder setHostSwitchId(java.lang.String hostSwitchId) {
            this.hostSwitchId = hostSwitchId;
            return this;
        }

        /**
         * Host switch profiles bound to this host switch. If a profile ID is not provided
         * for any HostSwitchProfileType that is supported by the transport node, the
         * corresponding default profile will be bound to the host switch. If transport
         * node is created using Policy APIs, use policyPaths instead of UUIDs.
         *
         * @param hostSwitchProfileIds New value for the property.
         */
        public Builder setHostSwitchProfileIds(java.util.List<com.vmware.nsx.model.HostSwitchProfileTypeIdEntry> hostSwitchProfileIds) {
            this.hostSwitchProfileIds = hostSwitchProfileIds;
            return this;
        }

        /**
         *
         *
         * @param ipAssignmentSpec New value for the property.
         * When clients pass a value of this class as a parameter, the property must
         * contain all the properties defined in {@link
         * com.vmware.nsx.model.IpAssignmentSpec}. When methods return a value of this
         * class as a return value, the property will contain all the properties defined in
         * {@link com.vmware.nsx.model.IpAssignmentSpec}.
         */
        public Builder setIpAssignmentSpec(com.vmware.vapi.bindings.Structure ipAssignmentSpec) {
            this.ipAssignmentSpec = ipAssignmentSpec;
            return this;
        }

        /**
         *
         *
         * @param ipv6AssignmentSpec New value for the property.
         * When clients pass a value of this class as a parameter, the property must
         * contain all the properties defined in {@link
         * com.vmware.nsx.model.Ipv6AssignmentSpec}. When methods return a value of this
         * class as a return value, the property will contain all the properties defined in
         * {@link com.vmware.nsx.model.Ipv6AssignmentSpec}.
         */
        public Builder setIpv6AssignmentSpec(com.vmware.vapi.bindings.Structure ipv6AssignmentSpec) {
            this.ipv6AssignmentSpec = ipv6AssignmentSpec;
            return this;
        }

        /**
         * If VDS is used as a HostSwitch this attribute must be specified. You can
         * associate uplinks from UplinkHostSwitchProfile to either VDS uplink or LAG. VDS
         * uplink or LAG will inherit the global VDS level teaming policy from vSphere. NSX
         * managed uplink or LAG will have NSX teaming policy configured through
         * UplinkHostSwitchProfile.
         *
         * @param uplinks New value for the property.
         */
        public Builder setUplinks(java.util.List<com.vmware.nsx.model.VdsUplink> uplinks) {
            this.uplinks = uplinks;
            return this;
        }

        public HostSwitchConfigOption build() {
            HostSwitchConfigOption result = new HostSwitchConfigOption();
            result.setHostSwitchId(this.hostSwitchId);
            result.setHostSwitchProfileIds(this.hostSwitchProfileIds);
            result.setIpAssignmentSpec(this.ipAssignmentSpec);
            result.setIpv6AssignmentSpec(this.ipv6AssignmentSpec);
            result.setUplinks(this.uplinks);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("host_switch_id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("host_switch_id",
                                                                                "hostSwitchId",
                                                                                "getHostSwitchId",
                                                                                "setHostSwitchId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("host_switch_profile_ids", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx.model.StructDefinitions.hostSwitchProfileTypeIdEntry; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("host_switch_profile_ids",
                                                                                "hostSwitchProfileIds",
                                                                                "getHostSwitchProfileIds",
                                                                                "setHostSwitchProfileIds");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("ip_assignment_spec", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.DynamicStructType(java.util.Arrays.<com.vmware.vapi.internal.data.ConstraintValidator>asList(new com.vmware.vapi.internal.bindings.HasFieldsOfValidator(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx.model.StructDefinitions.ipAssignmentSpec; } })))));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("ip_assignment_spec",
                                                                                "ipAssignmentSpec",
                                                                                "getIpAssignmentSpec",
                                                                                "setIpAssignmentSpec");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("ipv6_assignment_spec", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.DynamicStructType(java.util.Arrays.<com.vmware.vapi.internal.data.ConstraintValidator>asList(new com.vmware.vapi.internal.bindings.HasFieldsOfValidator(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx.model.StructDefinitions.ipv6AssignmentSpec; } })))));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("ipv6_assignment_spec",
                                                                                "ipv6AssignmentSpec",
                                                                                "getIpv6AssignmentSpec",
                                                                                "setIpv6AssignmentSpec");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("uplinks", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx.model.StructDefinitions.vdsUplink; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("uplinks",
                                                                                "uplinks",
                                                                                "getUplinks",
                                                                                "setUplinks");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx.model.host_switch_config_option",
                                                            fields,
                                                            com.vmware.nsx.model.HostSwitchConfigOption.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

