/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx.model;

/**
 * List summary of L2VPN sessions.
 */
public final class L2VPNSessionSummary implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    private java.lang.Long establishedL2vpnSessions;

    private java.lang.Long failedL2vpnSessions;

    private java.lang.Long totalL2vpnSessions;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public L2VPNSessionSummary() {
    }

    protected L2VPNSessionSummary(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * Number of established L2VPN sessions. L2VPN session is established when all the
     * tunnels are up. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getEstablishedL2vpnSessions() {
        return this.establishedL2vpnSessions;
    }

    /**
     * Number of established L2VPN sessions. L2VPN session is established when all the
     * tunnels are up. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param establishedL2vpnSessions New value for the property.
     */
    public void setEstablishedL2vpnSessions(java.lang.Long establishedL2vpnSessions) {
        this.establishedL2vpnSessions = establishedL2vpnSessions;
    }

    /**
     * Number of failed L2VPN sessions. L2VPN session is failed when all the tunnels
     * are down. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getFailedL2vpnSessions() {
        return this.failedL2vpnSessions;
    }

    /**
     * Number of failed L2VPN sessions. L2VPN session is failed when all the tunnels
     * are down. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param failedL2vpnSessions New value for the property.
     */
    public void setFailedL2vpnSessions(java.lang.Long failedL2vpnSessions) {
        this.failedL2vpnSessions = failedL2vpnSessions;
    }

    /**
     * Total L2VPN sessions configured. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getTotalL2vpnSessions() {
        return this.totalL2vpnSessions;
    }

    /**
     * Total L2VPN sessions configured. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param totalL2vpnSessions New value for the property.
     */
    public void setTotalL2vpnSessions(java.lang.Long totalL2vpnSessions) {
        this.totalL2vpnSessions = totalL2vpnSessions;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx.model.StructDefinitions.l2VPNSessionSummary;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("established_l2vpn_sessions",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.establishedL2vpnSessions, this._getType().getField("established_l2vpn_sessions")));
        structValue.setField("failed_l2vpn_sessions",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.failedL2vpnSessions, this._getType().getField("failed_l2vpn_sessions")));
        structValue.setField("total_l2vpn_sessions",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.totalL2vpnSessions, this._getType().getField("total_l2vpn_sessions")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx.model.StructDefinitions.l2VPNSessionSummary;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx.model.StructDefinitions.l2VPNSessionSummary.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static L2VPNSessionSummary _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new L2VPNSessionSummary(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static L2VPNSessionSummary _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new L2VPNSessionSummary(structValue);
    }

    /**
     * Builder class for {@link L2VPNSessionSummary}.
     */
    public static final class Builder {
        private java.lang.Long establishedL2vpnSessions;
        private java.lang.Long failedL2vpnSessions;
        private java.lang.Long totalL2vpnSessions;

        /**
         * Constructor with parameters for the required properties of
         * {@link L2VPNSessionSummary}.
         */
        public Builder() {
        }

        /**
         * Number of established L2VPN sessions. L2VPN session is established when all the
         * tunnels are up. format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param establishedL2vpnSessions New value for the property.
         */
        public Builder setEstablishedL2vpnSessions(java.lang.Long establishedL2vpnSessions) {
            this.establishedL2vpnSessions = establishedL2vpnSessions;
            return this;
        }

        /**
         * Number of failed L2VPN sessions. L2VPN session is failed when all the tunnels
         * are down. format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param failedL2vpnSessions New value for the property.
         */
        public Builder setFailedL2vpnSessions(java.lang.Long failedL2vpnSessions) {
            this.failedL2vpnSessions = failedL2vpnSessions;
            return this;
        }

        /**
         * Total L2VPN sessions configured. format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param totalL2vpnSessions New value for the property.
         */
        public Builder setTotalL2vpnSessions(java.lang.Long totalL2vpnSessions) {
            this.totalL2vpnSessions = totalL2vpnSessions;
            return this;
        }

        public L2VPNSessionSummary build() {
            L2VPNSessionSummary result = new L2VPNSessionSummary();
            result.setEstablishedL2vpnSessions(this.establishedL2vpnSessions);
            result.setFailedL2vpnSessions(this.failedL2vpnSessions);
            result.setTotalL2vpnSessions(this.totalL2vpnSessions);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("established_l2vpn_sessions", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("established_l2vpn_sessions",
                                                                                "establishedL2vpnSessions",
                                                                                "getEstablishedL2vpnSessions",
                                                                                "setEstablishedL2vpnSessions");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("failed_l2vpn_sessions", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("failed_l2vpn_sessions",
                                                                                "failedL2vpnSessions",
                                                                                "getFailedL2vpnSessions",
                                                                                "setFailedL2vpnSessions");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("total_l2vpn_sessions", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("total_l2vpn_sessions",
                                                                                "totalL2vpnSessions",
                                                                                "getTotalL2vpnSessions",
                                                                                "setTotalL2vpnSessions");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx.model.l2_VPN_session_summary",
                                                            fields,
                                                            com.vmware.nsx.model.L2VPNSessionSummary.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

