/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx.model;

/**
 * The capacity contains basic information and load balancer entity usages and
 * capacity for the given edge node.
 */
public final class LbEdgeNodeUsage implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    /**
     * Identifier denoting this class, when it is used in polymorphic context. 
     * <p>This
     * value should be assigned to the property which is used to discriminate the
     * actual type used in the polymorphic context.</p>
     */
    public static final java.lang.String _TYPE_IDENTIFIER = "LbEdgeNodeUsage";

    public static final java.lang.String FORM_FACTOR_SMALL_VIRTUAL_MACHINE = "SMALL_VIRTUAL_MACHINE";

    public static final java.lang.String FORM_FACTOR_MEDIUM_VIRTUAL_MACHINE = "MEDIUM_VIRTUAL_MACHINE";

    public static final java.lang.String FORM_FACTOR_LARGE_VIRTUAL_MACHINE = "LARGE_VIRTUAL_MACHINE";

    public static final java.lang.String FORM_FACTOR_XLARGE_VIRTUAL_MACHINE = "XLARGE_VIRTUAL_MACHINE";

    public static final java.lang.String FORM_FACTOR_PHYSICAL_MACHINE = "PHYSICAL_MACHINE";

    public static final java.lang.String SEVERITY_GREEN = "GREEN";

    public static final java.lang.String SEVERITY_ORANGE = "ORANGE";

    public static final java.lang.String SEVERITY_RED = "RED";

    private java.lang.Long currentCreditNumber;

    private java.lang.Long currentLargeLoadBalancerServices;

    private java.lang.Long currentMediumLoadBalancerServices;

    private java.lang.Long currentPoolMembers;

    private java.lang.Long currentPools;

    private java.lang.Long currentSmallLoadBalancerServices;

    private java.lang.Long currentVirtualServers;

    private java.lang.Long currentXlargeLoadBalancerServices;

    private java.lang.String edgeClusterId;

    private java.lang.String formFactor;

    private java.lang.Long remainingCreditNumber;

    private java.lang.Long remainingLargeLoadBalancerServices;

    private java.lang.Long remainingMediumLoadBalancerServices;

    private java.lang.Long remainingPoolMembers;

    private java.lang.Long remainingSmallLoadBalancerServices;

    private java.lang.Long remainingXlargeLoadBalancerServices;

    private java.lang.String severity;

    private java.lang.Double usagePercentage;

    private java.lang.String nodeId;

    private final java.lang.String type = "LbEdgeNodeUsage";

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public LbEdgeNodeUsage() {
    }

    protected LbEdgeNodeUsage(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * The current credit number reflects the current usage on the node. For example,
     * configuring a medium load balancer on a node consumes 10 credits. If there are 2
     * medium instances configured on a node, the current credit number is 2 * 10 = 20.
     * format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getCurrentCreditNumber() {
        return this.currentCreditNumber;
    }

    /**
     * The current credit number reflects the current usage on the node. For example,
     * configuring a medium load balancer on a node consumes 10 credits. If there are 2
     * medium instances configured on a node, the current credit number is 2 * 10 = 20.
     * format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param currentCreditNumber New value for the property.
     */
    public void setCurrentCreditNumber(java.lang.Long currentCreditNumber) {
        this.currentCreditNumber = currentCreditNumber;
    }

    /**
     * The number of large load balancer services configured on the node. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getCurrentLargeLoadBalancerServices() {
        return this.currentLargeLoadBalancerServices;
    }

    /**
     * The number of large load balancer services configured on the node. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param currentLargeLoadBalancerServices New value for the property.
     */
    public void setCurrentLargeLoadBalancerServices(java.lang.Long currentLargeLoadBalancerServices) {
        this.currentLargeLoadBalancerServices = currentLargeLoadBalancerServices;
    }

    /**
     * The number of medium load balancer services configured on the node. format:
     * int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getCurrentMediumLoadBalancerServices() {
        return this.currentMediumLoadBalancerServices;
    }

    /**
     * The number of medium load balancer services configured on the node. format:
     * int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param currentMediumLoadBalancerServices New value for the property.
     */
    public void setCurrentMediumLoadBalancerServices(java.lang.Long currentMediumLoadBalancerServices) {
        this.currentMediumLoadBalancerServices = currentMediumLoadBalancerServices;
    }

    /**
     * The number of pool members configured on the node. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getCurrentPoolMembers() {
        return this.currentPoolMembers;
    }

    /**
     * The number of pool members configured on the node. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param currentPoolMembers New value for the property.
     */
    public void setCurrentPoolMembers(java.lang.Long currentPoolMembers) {
        this.currentPoolMembers = currentPoolMembers;
    }

    /**
     * The number of pools configured on the node. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getCurrentPools() {
        return this.currentPools;
    }

    /**
     * The number of pools configured on the node. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param currentPools New value for the property.
     */
    public void setCurrentPools(java.lang.Long currentPools) {
        this.currentPools = currentPools;
    }

    /**
     * The number of small load balancer services configured on the node. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getCurrentSmallLoadBalancerServices() {
        return this.currentSmallLoadBalancerServices;
    }

    /**
     * The number of small load balancer services configured on the node. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param currentSmallLoadBalancerServices New value for the property.
     */
    public void setCurrentSmallLoadBalancerServices(java.lang.Long currentSmallLoadBalancerServices) {
        this.currentSmallLoadBalancerServices = currentSmallLoadBalancerServices;
    }

    /**
     * The number of virtual servers configured on the node. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getCurrentVirtualServers() {
        return this.currentVirtualServers;
    }

    /**
     * The number of virtual servers configured on the node. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param currentVirtualServers New value for the property.
     */
    public void setCurrentVirtualServers(java.lang.Long currentVirtualServers) {
        this.currentVirtualServers = currentVirtualServers;
    }

    /**
     * The number of xlarge load balancer services configured on the node. format:
     * int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getCurrentXlargeLoadBalancerServices() {
        return this.currentXlargeLoadBalancerServices;
    }

    /**
     * The number of xlarge load balancer services configured on the node. format:
     * int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param currentXlargeLoadBalancerServices New value for the property.
     */
    public void setCurrentXlargeLoadBalancerServices(java.lang.Long currentXlargeLoadBalancerServices) {
        this.currentXlargeLoadBalancerServices = currentXlargeLoadBalancerServices;
    }

    /**
     * The ID of edge cluster which contains the edge node.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getEdgeClusterId() {
        return this.edgeClusterId;
    }

    /**
     * The ID of edge cluster which contains the edge node.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param edgeClusterId New value for the property.
     */
    public void setEdgeClusterId(java.lang.String edgeClusterId) {
        this.edgeClusterId = edgeClusterId;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.LbEdgeNodeUsage#FORM_FACTOR_SMALL_VIRTUAL_MACHINE}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbEdgeNodeUsage#FORM_FACTOR_MEDIUM_VIRTUAL_MACHINE}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbEdgeNodeUsage#FORM_FACTOR_LARGE_VIRTUAL_MACHINE}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbEdgeNodeUsage#FORM_FACTOR_XLARGE_VIRTUAL_MACHINE}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbEdgeNodeUsage#FORM_FACTOR_PHYSICAL_MACHINE}</li> </ul>
     * The form factor of the given edge node.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getFormFactor() {
        return this.formFactor;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.LbEdgeNodeUsage#FORM_FACTOR_SMALL_VIRTUAL_MACHINE}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbEdgeNodeUsage#FORM_FACTOR_MEDIUM_VIRTUAL_MACHINE}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbEdgeNodeUsage#FORM_FACTOR_LARGE_VIRTUAL_MACHINE}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbEdgeNodeUsage#FORM_FACTOR_XLARGE_VIRTUAL_MACHINE}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbEdgeNodeUsage#FORM_FACTOR_PHYSICAL_MACHINE}</li> </ul>
     * The form factor of the given edge node.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param formFactor New value for the property.
     */
    public void setFormFactor(java.lang.String formFactor) {
        this.formFactor = formFactor;
    }

    /**
     * The remaining credit number is the remaining credits that can be used for load
     * balancer service configuration. For example, an edge node with form factor
     * LARGE_VIRTUAL_MACHINE has 40 credits, and a medium load balancer instance costs
     * 10 credits. If there are currently 3 medium instances configured, the remaining
     * credit number is 40 - (3 * 10) = 10. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getRemainingCreditNumber() {
        return this.remainingCreditNumber;
    }

    /**
     * The remaining credit number is the remaining credits that can be used for load
     * balancer service configuration. For example, an edge node with form factor
     * LARGE_VIRTUAL_MACHINE has 40 credits, and a medium load balancer instance costs
     * 10 credits. If there are currently 3 medium instances configured, the remaining
     * credit number is 40 - (3 * 10) = 10. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param remainingCreditNumber New value for the property.
     */
    public void setRemainingCreditNumber(java.lang.Long remainingCreditNumber) {
        this.remainingCreditNumber = remainingCreditNumber;
    }

    /**
     * The remaining number of large load balancer services which could be configured
     * on the given edge node. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getRemainingLargeLoadBalancerServices() {
        return this.remainingLargeLoadBalancerServices;
    }

    /**
     * The remaining number of large load balancer services which could be configured
     * on the given edge node. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param remainingLargeLoadBalancerServices New value for the property.
     */
    public void setRemainingLargeLoadBalancerServices(java.lang.Long remainingLargeLoadBalancerServices) {
        this.remainingLargeLoadBalancerServices = remainingLargeLoadBalancerServices;
    }

    /**
     * The remaining number of medium load balancer services which could be configured
     * on the given edge node. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getRemainingMediumLoadBalancerServices() {
        return this.remainingMediumLoadBalancerServices;
    }

    /**
     * The remaining number of medium load balancer services which could be configured
     * on the given edge node. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param remainingMediumLoadBalancerServices New value for the property.
     */
    public void setRemainingMediumLoadBalancerServices(java.lang.Long remainingMediumLoadBalancerServices) {
        this.remainingMediumLoadBalancerServices = remainingMediumLoadBalancerServices;
    }

    /**
     * The remaining number of pool members which could be configured on the given edge
     * node. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getRemainingPoolMembers() {
        return this.remainingPoolMembers;
    }

    /**
     * The remaining number of pool members which could be configured on the given edge
     * node. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param remainingPoolMembers New value for the property.
     */
    public void setRemainingPoolMembers(java.lang.Long remainingPoolMembers) {
        this.remainingPoolMembers = remainingPoolMembers;
    }

    /**
     * The remaining number of small load balancer services which could be configured
     * on the given edge node. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getRemainingSmallLoadBalancerServices() {
        return this.remainingSmallLoadBalancerServices;
    }

    /**
     * The remaining number of small load balancer services which could be configured
     * on the given edge node. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param remainingSmallLoadBalancerServices New value for the property.
     */
    public void setRemainingSmallLoadBalancerServices(java.lang.Long remainingSmallLoadBalancerServices) {
        this.remainingSmallLoadBalancerServices = remainingSmallLoadBalancerServices;
    }

    /**
     * The remaining number of xlarge load balancer services which could be configured
     * on the given edge node. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getRemainingXlargeLoadBalancerServices() {
        return this.remainingXlargeLoadBalancerServices;
    }

    /**
     * The remaining number of xlarge load balancer services which could be configured
     * on the given edge node. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param remainingXlargeLoadBalancerServices New value for the property.
     */
    public void setRemainingXlargeLoadBalancerServices(java.lang.Long remainingXlargeLoadBalancerServices) {
        this.remainingXlargeLoadBalancerServices = remainingXlargeLoadBalancerServices;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.LbEdgeNodeUsage#SEVERITY_GREEN}</li> <li> {@link
     * com.vmware.nsx.model.LbEdgeNodeUsage#SEVERITY_ORANGE}</li> <li> {@link
     * com.vmware.nsx.model.LbEdgeNodeUsage#SEVERITY_RED}</li> </ul> The severity
     * calculation is based on current credit usage percentage of load balancer for one
     * node.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getSeverity() {
        return this.severity;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.LbEdgeNodeUsage#SEVERITY_GREEN}</li> <li> {@link
     * com.vmware.nsx.model.LbEdgeNodeUsage#SEVERITY_ORANGE}</li> <li> {@link
     * com.vmware.nsx.model.LbEdgeNodeUsage#SEVERITY_RED}</li> </ul> The severity
     * calculation is based on current credit usage percentage of load balancer for one
     * node.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param severity New value for the property.
     */
    public void setSeverity(java.lang.String severity) {
        this.severity = severity;
    }

    /**
     * The usage percentage of the edge node for load balancer. The value is the larger
     * value between load balancer credit usage percentage and pool member usage
     * percentage for the edge node.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Double getUsagePercentage() {
        return this.usagePercentage;
    }

    /**
     * The usage percentage of the edge node for load balancer. The value is the larger
     * value between load balancer credit usage percentage and pool member usage
     * percentage for the edge node.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param usagePercentage New value for the property.
     */
    public void setUsagePercentage(java.lang.Double usagePercentage) {
        this.usagePercentage = usagePercentage;
    }

    /**
     * The property identifies the node UUID for load balancer node usage.
     *
     * @return The current value of the property.
     */
    public java.lang.String getNodeId() {
        return this.nodeId;
    }

    /**
     * The property identifies the node UUID for load balancer node usage.
     *
     * @param nodeId New value for the property.
     */
    public void setNodeId(java.lang.String nodeId) {
        this.nodeId = nodeId;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.LbNodeUsage#TYPE_LBEDGENODEUSAGE}</li> </ul> The property
     * identifies the load balancer node usage type.
     * The value of this property is automatically populated to {@code "LbEdgeNodeUsage"}.
     *
     * @return The current value of the property.
     */
    public java.lang.String getType() {
        return this.type;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx.model.StructDefinitions.lbEdgeNodeUsage;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("current_credit_number",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.currentCreditNumber, this._getType().getField("current_credit_number")));
        structValue.setField("current_large_load_balancer_services",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.currentLargeLoadBalancerServices, this._getType().getField("current_large_load_balancer_services")));
        structValue.setField("current_medium_load_balancer_services",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.currentMediumLoadBalancerServices, this._getType().getField("current_medium_load_balancer_services")));
        structValue.setField("current_pool_members",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.currentPoolMembers, this._getType().getField("current_pool_members")));
        structValue.setField("current_pools",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.currentPools, this._getType().getField("current_pools")));
        structValue.setField("current_small_load_balancer_services",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.currentSmallLoadBalancerServices, this._getType().getField("current_small_load_balancer_services")));
        structValue.setField("current_virtual_servers",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.currentVirtualServers, this._getType().getField("current_virtual_servers")));
        structValue.setField("current_xlarge_load_balancer_services",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.currentXlargeLoadBalancerServices, this._getType().getField("current_xlarge_load_balancer_services")));
        structValue.setField("edge_cluster_id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.edgeClusterId, this._getType().getField("edge_cluster_id")));
        structValue.setField("form_factor",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.formFactor, this._getType().getField("form_factor")));
        structValue.setField("remaining_credit_number",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.remainingCreditNumber, this._getType().getField("remaining_credit_number")));
        structValue.setField("remaining_large_load_balancer_services",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.remainingLargeLoadBalancerServices, this._getType().getField("remaining_large_load_balancer_services")));
        structValue.setField("remaining_medium_load_balancer_services",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.remainingMediumLoadBalancerServices, this._getType().getField("remaining_medium_load_balancer_services")));
        structValue.setField("remaining_pool_members",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.remainingPoolMembers, this._getType().getField("remaining_pool_members")));
        structValue.setField("remaining_small_load_balancer_services",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.remainingSmallLoadBalancerServices, this._getType().getField("remaining_small_load_balancer_services")));
        structValue.setField("remaining_xlarge_load_balancer_services",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.remainingXlargeLoadBalancerServices, this._getType().getField("remaining_xlarge_load_balancer_services")));
        structValue.setField("severity",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.severity, this._getType().getField("severity")));
        structValue.setField("usage_percentage",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.usagePercentage, this._getType().getField("usage_percentage")));
        structValue.setField("node_id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.nodeId, this._getType().getField("node_id")));
        structValue.setField("type",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.type, this._getType().getField("type")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx.model.StructDefinitions.lbEdgeNodeUsage;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx.model.StructDefinitions.lbEdgeNodeUsage.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static LbEdgeNodeUsage _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new LbEdgeNodeUsage(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static LbEdgeNodeUsage _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new LbEdgeNodeUsage(structValue);
    }

    /**
     * Builder class for {@link LbEdgeNodeUsage}.
     */
    public static final class Builder {
        private java.lang.Long currentCreditNumber;
        private java.lang.Long currentLargeLoadBalancerServices;
        private java.lang.Long currentMediumLoadBalancerServices;
        private java.lang.Long currentPoolMembers;
        private java.lang.Long currentPools;
        private java.lang.Long currentSmallLoadBalancerServices;
        private java.lang.Long currentVirtualServers;
        private java.lang.Long currentXlargeLoadBalancerServices;
        private java.lang.String edgeClusterId;
        private java.lang.String formFactor;
        private java.lang.Long remainingCreditNumber;
        private java.lang.Long remainingLargeLoadBalancerServices;
        private java.lang.Long remainingMediumLoadBalancerServices;
        private java.lang.Long remainingPoolMembers;
        private java.lang.Long remainingSmallLoadBalancerServices;
        private java.lang.Long remainingXlargeLoadBalancerServices;
        private java.lang.String severity;
        private java.lang.Double usagePercentage;
        private java.lang.String nodeId;

        /**
         * Constructor with parameters for the required properties of
         * {@link LbEdgeNodeUsage}.
         */
        public Builder() {
        }

        /**
         * The current credit number reflects the current usage on the node. For example,
         * configuring a medium load balancer on a node consumes 10 credits. If there are 2
         * medium instances configured on a node, the current credit number is 2 * 10 = 20.
         * format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param currentCreditNumber New value for the property.
         */
        public Builder setCurrentCreditNumber(java.lang.Long currentCreditNumber) {
            this.currentCreditNumber = currentCreditNumber;
            return this;
        }

        /**
         * The number of large load balancer services configured on the node. format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param currentLargeLoadBalancerServices New value for the property.
         */
        public Builder setCurrentLargeLoadBalancerServices(java.lang.Long currentLargeLoadBalancerServices) {
            this.currentLargeLoadBalancerServices = currentLargeLoadBalancerServices;
            return this;
        }

        /**
         * The number of medium load balancer services configured on the node. format:
         * int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param currentMediumLoadBalancerServices New value for the property.
         */
        public Builder setCurrentMediumLoadBalancerServices(java.lang.Long currentMediumLoadBalancerServices) {
            this.currentMediumLoadBalancerServices = currentMediumLoadBalancerServices;
            return this;
        }

        /**
         * The number of pool members configured on the node. format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param currentPoolMembers New value for the property.
         */
        public Builder setCurrentPoolMembers(java.lang.Long currentPoolMembers) {
            this.currentPoolMembers = currentPoolMembers;
            return this;
        }

        /**
         * The number of pools configured on the node. format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param currentPools New value for the property.
         */
        public Builder setCurrentPools(java.lang.Long currentPools) {
            this.currentPools = currentPools;
            return this;
        }

        /**
         * The number of small load balancer services configured on the node. format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param currentSmallLoadBalancerServices New value for the property.
         */
        public Builder setCurrentSmallLoadBalancerServices(java.lang.Long currentSmallLoadBalancerServices) {
            this.currentSmallLoadBalancerServices = currentSmallLoadBalancerServices;
            return this;
        }

        /**
         * The number of virtual servers configured on the node. format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param currentVirtualServers New value for the property.
         */
        public Builder setCurrentVirtualServers(java.lang.Long currentVirtualServers) {
            this.currentVirtualServers = currentVirtualServers;
            return this;
        }

        /**
         * The number of xlarge load balancer services configured on the node. format:
         * int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param currentXlargeLoadBalancerServices New value for the property.
         */
        public Builder setCurrentXlargeLoadBalancerServices(java.lang.Long currentXlargeLoadBalancerServices) {
            this.currentXlargeLoadBalancerServices = currentXlargeLoadBalancerServices;
            return this;
        }

        /**
         * The ID of edge cluster which contains the edge node.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param edgeClusterId New value for the property.
         */
        public Builder setEdgeClusterId(java.lang.String edgeClusterId) {
            this.edgeClusterId = edgeClusterId;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx.model.LbEdgeNodeUsage#FORM_FACTOR_SMALL_VIRTUAL_MACHINE}</li>
         * <li> {@link
         * com.vmware.nsx.model.LbEdgeNodeUsage#FORM_FACTOR_MEDIUM_VIRTUAL_MACHINE}</li>
         * <li> {@link
         * com.vmware.nsx.model.LbEdgeNodeUsage#FORM_FACTOR_LARGE_VIRTUAL_MACHINE}</li>
         * <li> {@link
         * com.vmware.nsx.model.LbEdgeNodeUsage#FORM_FACTOR_XLARGE_VIRTUAL_MACHINE}</li>
         * <li> {@link
         * com.vmware.nsx.model.LbEdgeNodeUsage#FORM_FACTOR_PHYSICAL_MACHINE}</li> </ul>
         * The form factor of the given edge node.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param formFactor New value for the property.
         */
        public Builder setFormFactor(java.lang.String formFactor) {
            this.formFactor = formFactor;
            return this;
        }

        /**
         * The remaining credit number is the remaining credits that can be used for load
         * balancer service configuration. For example, an edge node with form factor
         * LARGE_VIRTUAL_MACHINE has 40 credits, and a medium load balancer instance costs
         * 10 credits. If there are currently 3 medium instances configured, the remaining
         * credit number is 40 - (3 * 10) = 10. format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param remainingCreditNumber New value for the property.
         */
        public Builder setRemainingCreditNumber(java.lang.Long remainingCreditNumber) {
            this.remainingCreditNumber = remainingCreditNumber;
            return this;
        }

        /**
         * The remaining number of large load balancer services which could be configured
         * on the given edge node. format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param remainingLargeLoadBalancerServices New value for the property.
         */
        public Builder setRemainingLargeLoadBalancerServices(java.lang.Long remainingLargeLoadBalancerServices) {
            this.remainingLargeLoadBalancerServices = remainingLargeLoadBalancerServices;
            return this;
        }

        /**
         * The remaining number of medium load balancer services which could be configured
         * on the given edge node. format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param remainingMediumLoadBalancerServices New value for the property.
         */
        public Builder setRemainingMediumLoadBalancerServices(java.lang.Long remainingMediumLoadBalancerServices) {
            this.remainingMediumLoadBalancerServices = remainingMediumLoadBalancerServices;
            return this;
        }

        /**
         * The remaining number of pool members which could be configured on the given edge
         * node. format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param remainingPoolMembers New value for the property.
         */
        public Builder setRemainingPoolMembers(java.lang.Long remainingPoolMembers) {
            this.remainingPoolMembers = remainingPoolMembers;
            return this;
        }

        /**
         * The remaining number of small load balancer services which could be configured
         * on the given edge node. format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param remainingSmallLoadBalancerServices New value for the property.
         */
        public Builder setRemainingSmallLoadBalancerServices(java.lang.Long remainingSmallLoadBalancerServices) {
            this.remainingSmallLoadBalancerServices = remainingSmallLoadBalancerServices;
            return this;
        }

        /**
         * The remaining number of xlarge load balancer services which could be configured
         * on the given edge node. format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param remainingXlargeLoadBalancerServices New value for the property.
         */
        public Builder setRemainingXlargeLoadBalancerServices(java.lang.Long remainingXlargeLoadBalancerServices) {
            this.remainingXlargeLoadBalancerServices = remainingXlargeLoadBalancerServices;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx.model.LbEdgeNodeUsage#SEVERITY_GREEN}</li> <li> {@link
         * com.vmware.nsx.model.LbEdgeNodeUsage#SEVERITY_ORANGE}</li> <li> {@link
         * com.vmware.nsx.model.LbEdgeNodeUsage#SEVERITY_RED}</li> </ul> The severity
         * calculation is based on current credit usage percentage of load balancer for one
         * node.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param severity New value for the property.
         */
        public Builder setSeverity(java.lang.String severity) {
            this.severity = severity;
            return this;
        }

        /**
         * The usage percentage of the edge node for load balancer. The value is the larger
         * value between load balancer credit usage percentage and pool member usage
         * percentage for the edge node.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param usagePercentage New value for the property.
         */
        public Builder setUsagePercentage(java.lang.Double usagePercentage) {
            this.usagePercentage = usagePercentage;
            return this;
        }

        /**
         * The property identifies the node UUID for load balancer node usage.
         *
         * @param nodeId New value for the property.
         */
        public Builder setNodeId(java.lang.String nodeId) {
            this.nodeId = nodeId;
            return this;
        }

        public LbEdgeNodeUsage build() {
            LbEdgeNodeUsage result = new LbEdgeNodeUsage();
            result.setCurrentCreditNumber(this.currentCreditNumber);
            result.setCurrentLargeLoadBalancerServices(this.currentLargeLoadBalancerServices);
            result.setCurrentMediumLoadBalancerServices(this.currentMediumLoadBalancerServices);
            result.setCurrentPoolMembers(this.currentPoolMembers);
            result.setCurrentPools(this.currentPools);
            result.setCurrentSmallLoadBalancerServices(this.currentSmallLoadBalancerServices);
            result.setCurrentVirtualServers(this.currentVirtualServers);
            result.setCurrentXlargeLoadBalancerServices(this.currentXlargeLoadBalancerServices);
            result.setEdgeClusterId(this.edgeClusterId);
            result.setFormFactor(this.formFactor);
            result.setRemainingCreditNumber(this.remainingCreditNumber);
            result.setRemainingLargeLoadBalancerServices(this.remainingLargeLoadBalancerServices);
            result.setRemainingMediumLoadBalancerServices(this.remainingMediumLoadBalancerServices);
            result.setRemainingPoolMembers(this.remainingPoolMembers);
            result.setRemainingSmallLoadBalancerServices(this.remainingSmallLoadBalancerServices);
            result.setRemainingXlargeLoadBalancerServices(this.remainingXlargeLoadBalancerServices);
            result.setSeverity(this.severity);
            result.setUsagePercentage(this.usagePercentage);
            result.setNodeId(this.nodeId);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("current_credit_number", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("current_credit_number",
                                                                                "currentCreditNumber",
                                                                                "getCurrentCreditNumber",
                                                                                "setCurrentCreditNumber");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("current_large_load_balancer_services", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("current_large_load_balancer_services",
                                                                                "currentLargeLoadBalancerServices",
                                                                                "getCurrentLargeLoadBalancerServices",
                                                                                "setCurrentLargeLoadBalancerServices");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("current_medium_load_balancer_services", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("current_medium_load_balancer_services",
                                                                                "currentMediumLoadBalancerServices",
                                                                                "getCurrentMediumLoadBalancerServices",
                                                                                "setCurrentMediumLoadBalancerServices");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("current_pool_members", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("current_pool_members",
                                                                                "currentPoolMembers",
                                                                                "getCurrentPoolMembers",
                                                                                "setCurrentPoolMembers");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("current_pools", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("current_pools",
                                                                                "currentPools",
                                                                                "getCurrentPools",
                                                                                "setCurrentPools");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("current_small_load_balancer_services", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("current_small_load_balancer_services",
                                                                                "currentSmallLoadBalancerServices",
                                                                                "getCurrentSmallLoadBalancerServices",
                                                                                "setCurrentSmallLoadBalancerServices");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("current_virtual_servers", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("current_virtual_servers",
                                                                                "currentVirtualServers",
                                                                                "getCurrentVirtualServers",
                                                                                "setCurrentVirtualServers");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("current_xlarge_load_balancer_services", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("current_xlarge_load_balancer_services",
                                                                                "currentXlargeLoadBalancerServices",
                                                                                "getCurrentXlargeLoadBalancerServices",
                                                                                "setCurrentXlargeLoadBalancerServices");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("edge_cluster_id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("edge_cluster_id",
                                                                                "edgeClusterId",
                                                                                "getEdgeClusterId",
                                                                                "setEdgeClusterId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("form_factor", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("form_factor",
                                                                                "formFactor",
                                                                                "getFormFactor",
                                                                                "setFormFactor");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("remaining_credit_number", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("remaining_credit_number",
                                                                                "remainingCreditNumber",
                                                                                "getRemainingCreditNumber",
                                                                                "setRemainingCreditNumber");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("remaining_large_load_balancer_services", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("remaining_large_load_balancer_services",
                                                                                "remainingLargeLoadBalancerServices",
                                                                                "getRemainingLargeLoadBalancerServices",
                                                                                "setRemainingLargeLoadBalancerServices");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("remaining_medium_load_balancer_services", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("remaining_medium_load_balancer_services",
                                                                                "remainingMediumLoadBalancerServices",
                                                                                "getRemainingMediumLoadBalancerServices",
                                                                                "setRemainingMediumLoadBalancerServices");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("remaining_pool_members", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("remaining_pool_members",
                                                                                "remainingPoolMembers",
                                                                                "getRemainingPoolMembers",
                                                                                "setRemainingPoolMembers");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("remaining_small_load_balancer_services", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("remaining_small_load_balancer_services",
                                                                                "remainingSmallLoadBalancerServices",
                                                                                "getRemainingSmallLoadBalancerServices",
                                                                                "setRemainingSmallLoadBalancerServices");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("remaining_xlarge_load_balancer_services", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("remaining_xlarge_load_balancer_services",
                                                                                "remainingXlargeLoadBalancerServices",
                                                                                "getRemainingXlargeLoadBalancerServices",
                                                                                "setRemainingXlargeLoadBalancerServices");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("severity", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("severity",
                                                                                "severity",
                                                                                "getSeverity",
                                                                                "setSeverity");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("usage_percentage", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.DoubleType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("usage_percentage",
                                                                                "usagePercentage",
                                                                                "getUsagePercentage",
                                                                                "setUsagePercentage");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("node_id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("node_id",
                                                                                "nodeId",
                                                                                "getNodeId",
                                                                                "setNodeId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("type", new com.vmware.vapi.bindings.type.StringType());
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("type",
                                                                                "type",
                                                                                "getType",
                                                                                null);
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx.model.lb_edge_node_usage",
                                                            fields,
                                                            com.vmware.nsx.model.LbEdgeNodeUsage.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            "type",
                                                            "LbEdgeNodeUsage");
    }
}

