/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx.model;

/**
 * This condition is used to match SSL handshake and SSL connection at all
 * phases.If multiple properties are configured, the rule is considered a match
 * when all the configured properties are matched.
 */
public final class LbHttpSslCondition implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    /**
     * Identifier denoting this class, when it is used in polymorphic context. 
     * <p>This
     * value should be assigned to the property which is used to discriminate the
     * actual type used in the polymorphic context.</p>
     */
    public static final java.lang.String _TYPE_IDENTIFIER = "LbHttpSslCondition";

    public static final java.lang.String CLIENT_SUPPORTED_SSL_CIPHERS_ECDHE_RSA_WITH_AES_128_GCM_SHA256 = "TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256";

    public static final java.lang.String CLIENT_SUPPORTED_SSL_CIPHERS_ECDHE_RSA_WITH_AES_256_GCM_SHA384 = "TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384";

    public static final java.lang.String CLIENT_SUPPORTED_SSL_CIPHERS_ECDHE_RSA_WITH_AES_256_CBC_SHA = "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA";

    public static final java.lang.String CLIENT_SUPPORTED_SSL_CIPHERS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA = "TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA";

    public static final java.lang.String CLIENT_SUPPORTED_SSL_CIPHERS_ECDH_ECDSA_WITH_AES_256_CBC_SHA = "TLS_ECDH_ECDSA_WITH_AES_256_CBC_SHA";

    public static final java.lang.String CLIENT_SUPPORTED_SSL_CIPHERS_ECDH_RSA_WITH_AES_256_CBC_SHA = "TLS_ECDH_RSA_WITH_AES_256_CBC_SHA";

    public static final java.lang.String CLIENT_SUPPORTED_SSL_CIPHERS_RSA_WITH_AES_256_CBC_SHA = "TLS_RSA_WITH_AES_256_CBC_SHA";

    public static final java.lang.String CLIENT_SUPPORTED_SSL_CIPHERS_RSA_WITH_AES_128_CBC_SHA = "TLS_RSA_WITH_AES_128_CBC_SHA";

    public static final java.lang.String CLIENT_SUPPORTED_SSL_CIPHERS_RSA_WITH_3DES_EDE_CBC_SHA = "TLS_RSA_WITH_3DES_EDE_CBC_SHA";

    public static final java.lang.String CLIENT_SUPPORTED_SSL_CIPHERS_ECDHE_RSA_WITH_AES_128_CBC_SHA = "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA";

    public static final java.lang.String CLIENT_SUPPORTED_SSL_CIPHERS_ECDHE_RSA_WITH_AES_128_CBC_SHA256 = "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256";

    public static final java.lang.String CLIENT_SUPPORTED_SSL_CIPHERS_ECDHE_RSA_WITH_AES_256_CBC_SHA384 = "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384";

    public static final java.lang.String CLIENT_SUPPORTED_SSL_CIPHERS_RSA_WITH_AES_128_CBC_SHA256 = "TLS_RSA_WITH_AES_128_CBC_SHA256";

    public static final java.lang.String CLIENT_SUPPORTED_SSL_CIPHERS_RSA_WITH_AES_128_GCM_SHA256 = "TLS_RSA_WITH_AES_128_GCM_SHA256";

    public static final java.lang.String CLIENT_SUPPORTED_SSL_CIPHERS_RSA_WITH_AES_256_CBC_SHA256 = "TLS_RSA_WITH_AES_256_CBC_SHA256";

    public static final java.lang.String CLIENT_SUPPORTED_SSL_CIPHERS_RSA_WITH_AES_256_GCM_SHA384 = "TLS_RSA_WITH_AES_256_GCM_SHA384";

    public static final java.lang.String CLIENT_SUPPORTED_SSL_CIPHERS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA = "TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA";

    public static final java.lang.String CLIENT_SUPPORTED_SSL_CIPHERS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256 = "TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256";

    public static final java.lang.String CLIENT_SUPPORTED_SSL_CIPHERS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256 = "TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256";

    public static final java.lang.String CLIENT_SUPPORTED_SSL_CIPHERS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384 = "TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384";

    public static final java.lang.String CLIENT_SUPPORTED_SSL_CIPHERS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384 = "TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384";

    public static final java.lang.String CLIENT_SUPPORTED_SSL_CIPHERS_ECDH_ECDSA_WITH_AES_128_CBC_SHA = "TLS_ECDH_ECDSA_WITH_AES_128_CBC_SHA";

    public static final java.lang.String CLIENT_SUPPORTED_SSL_CIPHERS_ECDH_ECDSA_WITH_AES_128_CBC_SHA256 = "TLS_ECDH_ECDSA_WITH_AES_128_CBC_SHA256";

    public static final java.lang.String CLIENT_SUPPORTED_SSL_CIPHERS_ECDH_ECDSA_WITH_AES_128_GCM_SHA256 = "TLS_ECDH_ECDSA_WITH_AES_128_GCM_SHA256";

    public static final java.lang.String CLIENT_SUPPORTED_SSL_CIPHERS_ECDH_ECDSA_WITH_AES_256_CBC_SHA384 = "TLS_ECDH_ECDSA_WITH_AES_256_CBC_SHA384";

    public static final java.lang.String CLIENT_SUPPORTED_SSL_CIPHERS_ECDH_ECDSA_WITH_AES_256_GCM_SHA384 = "TLS_ECDH_ECDSA_WITH_AES_256_GCM_SHA384";

    public static final java.lang.String CLIENT_SUPPORTED_SSL_CIPHERS_ECDH_RSA_WITH_AES_128_CBC_SHA = "TLS_ECDH_RSA_WITH_AES_128_CBC_SHA";

    public static final java.lang.String CLIENT_SUPPORTED_SSL_CIPHERS_ECDH_RSA_WITH_AES_128_CBC_SHA256 = "TLS_ECDH_RSA_WITH_AES_128_CBC_SHA256";

    public static final java.lang.String CLIENT_SUPPORTED_SSL_CIPHERS_ECDH_RSA_WITH_AES_128_GCM_SHA256 = "TLS_ECDH_RSA_WITH_AES_128_GCM_SHA256";

    public static final java.lang.String CLIENT_SUPPORTED_SSL_CIPHERS_ECDH_RSA_WITH_AES_256_CBC_SHA384 = "TLS_ECDH_RSA_WITH_AES_256_CBC_SHA384";

    public static final java.lang.String CLIENT_SUPPORTED_SSL_CIPHERS_ECDH_RSA_WITH_AES_256_GCM_SHA384 = "TLS_ECDH_RSA_WITH_AES_256_GCM_SHA384";

    public static final java.lang.String SESSION_REUSED_IGNORE = "IGNORE";

    public static final java.lang.String SESSION_REUSED_REUSED = "REUSED";

    public static final java.lang.String SESSION_REUSED_NEW = "NEW";

    public static final java.lang.String USED_PROTOCOL_SSL_V2 = "SSL_V2";

    public static final java.lang.String USED_PROTOCOL_SSL_V3 = "SSL_V3";

    public static final java.lang.String USED_PROTOCOL_TLS_V1 = "TLS_V1";

    public static final java.lang.String USED_PROTOCOL_TLS_V1_1 = "TLS_V1_1";

    public static final java.lang.String USED_PROTOCOL_TLS_V1_2 = "TLS_V1_2";

    public static final java.lang.String USED_SSL_CIPHER_ECDHE_RSA_WITH_AES_128_GCM_SHA256 = "TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256";

    public static final java.lang.String USED_SSL_CIPHER_ECDHE_RSA_WITH_AES_256_GCM_SHA384 = "TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384";

    public static final java.lang.String USED_SSL_CIPHER_ECDHE_RSA_WITH_AES_256_CBC_SHA = "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA";

    public static final java.lang.String USED_SSL_CIPHER_ECDHE_ECDSA_WITH_AES_256_CBC_SHA = "TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA";

    public static final java.lang.String USED_SSL_CIPHER_ECDH_ECDSA_WITH_AES_256_CBC_SHA = "TLS_ECDH_ECDSA_WITH_AES_256_CBC_SHA";

    public static final java.lang.String USED_SSL_CIPHER_ECDH_RSA_WITH_AES_256_CBC_SHA = "TLS_ECDH_RSA_WITH_AES_256_CBC_SHA";

    public static final java.lang.String USED_SSL_CIPHER_RSA_WITH_AES_256_CBC_SHA = "TLS_RSA_WITH_AES_256_CBC_SHA";

    public static final java.lang.String USED_SSL_CIPHER_RSA_WITH_AES_128_CBC_SHA = "TLS_RSA_WITH_AES_128_CBC_SHA";

    public static final java.lang.String USED_SSL_CIPHER_RSA_WITH_3DES_EDE_CBC_SHA = "TLS_RSA_WITH_3DES_EDE_CBC_SHA";

    public static final java.lang.String USED_SSL_CIPHER_ECDHE_RSA_WITH_AES_128_CBC_SHA = "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA";

    public static final java.lang.String USED_SSL_CIPHER_ECDHE_RSA_WITH_AES_128_CBC_SHA256 = "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256";

    public static final java.lang.String USED_SSL_CIPHER_ECDHE_RSA_WITH_AES_256_CBC_SHA384 = "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384";

    public static final java.lang.String USED_SSL_CIPHER_RSA_WITH_AES_128_CBC_SHA256 = "TLS_RSA_WITH_AES_128_CBC_SHA256";

    public static final java.lang.String USED_SSL_CIPHER_RSA_WITH_AES_128_GCM_SHA256 = "TLS_RSA_WITH_AES_128_GCM_SHA256";

    public static final java.lang.String USED_SSL_CIPHER_RSA_WITH_AES_256_CBC_SHA256 = "TLS_RSA_WITH_AES_256_CBC_SHA256";

    public static final java.lang.String USED_SSL_CIPHER_RSA_WITH_AES_256_GCM_SHA384 = "TLS_RSA_WITH_AES_256_GCM_SHA384";

    public static final java.lang.String USED_SSL_CIPHER_ECDHE_ECDSA_WITH_AES_128_CBC_SHA = "TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA";

    public static final java.lang.String USED_SSL_CIPHER_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256 = "TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256";

    public static final java.lang.String USED_SSL_CIPHER_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256 = "TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256";

    public static final java.lang.String USED_SSL_CIPHER_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384 = "TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384";

    public static final java.lang.String USED_SSL_CIPHER_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384 = "TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384";

    public static final java.lang.String USED_SSL_CIPHER_ECDH_ECDSA_WITH_AES_128_CBC_SHA = "TLS_ECDH_ECDSA_WITH_AES_128_CBC_SHA";

    public static final java.lang.String USED_SSL_CIPHER_ECDH_ECDSA_WITH_AES_128_CBC_SHA256 = "TLS_ECDH_ECDSA_WITH_AES_128_CBC_SHA256";

    public static final java.lang.String USED_SSL_CIPHER_ECDH_ECDSA_WITH_AES_128_GCM_SHA256 = "TLS_ECDH_ECDSA_WITH_AES_128_GCM_SHA256";

    public static final java.lang.String USED_SSL_CIPHER_ECDH_ECDSA_WITH_AES_256_CBC_SHA384 = "TLS_ECDH_ECDSA_WITH_AES_256_CBC_SHA384";

    public static final java.lang.String USED_SSL_CIPHER_ECDH_ECDSA_WITH_AES_256_GCM_SHA384 = "TLS_ECDH_ECDSA_WITH_AES_256_GCM_SHA384";

    public static final java.lang.String USED_SSL_CIPHER_ECDH_RSA_WITH_AES_128_CBC_SHA = "TLS_ECDH_RSA_WITH_AES_128_CBC_SHA";

    public static final java.lang.String USED_SSL_CIPHER_ECDH_RSA_WITH_AES_128_CBC_SHA256 = "TLS_ECDH_RSA_WITH_AES_128_CBC_SHA256";

    public static final java.lang.String USED_SSL_CIPHER_ECDH_RSA_WITH_AES_128_GCM_SHA256 = "TLS_ECDH_RSA_WITH_AES_128_GCM_SHA256";

    public static final java.lang.String USED_SSL_CIPHER_ECDH_RSA_WITH_AES_256_CBC_SHA384 = "TLS_ECDH_RSA_WITH_AES_256_CBC_SHA384";

    public static final java.lang.String USED_SSL_CIPHER_ECDH_RSA_WITH_AES_256_GCM_SHA384 = "TLS_ECDH_RSA_WITH_AES_256_GCM_SHA384";

    private com.vmware.nsx.model.LbClientCertificateIssuerDnCondition clientCertificateIssuerDn;

    private com.vmware.nsx.model.LbClientCertificateSubjectDnCondition clientCertificateSubjectDn;

    private java.util.List<java.lang.String> clientSupportedSslCiphers;

    private java.lang.String sessionReused;

    private java.lang.String usedProtocol;

    private java.lang.String usedSslCipher;

    private java.lang.Boolean inverse;

    private final java.lang.String type = "LbHttpSslCondition";

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public LbHttpSslCondition() {
    }

    protected LbHttpSslCondition(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     *
     *
     * @return The current value of the property.
     */
    public com.vmware.nsx.model.LbClientCertificateIssuerDnCondition getClientCertificateIssuerDn() {
        return this.clientCertificateIssuerDn;
    }

    /**
     *
     *
     * @param clientCertificateIssuerDn New value for the property.
     */
    public void setClientCertificateIssuerDn(com.vmware.nsx.model.LbClientCertificateIssuerDnCondition clientCertificateIssuerDn) {
        this.clientCertificateIssuerDn = clientCertificateIssuerDn;
    }

    /**
     *
     *
     * @return The current value of the property.
     */
    public com.vmware.nsx.model.LbClientCertificateSubjectDnCondition getClientCertificateSubjectDn() {
        return this.clientCertificateSubjectDn;
    }

    /**
     *
     *
     * @param clientCertificateSubjectDn New value for the property.
     */
    public void setClientCertificateSubjectDn(com.vmware.nsx.model.LbClientCertificateSubjectDnCondition clientCertificateSubjectDn) {
        this.clientCertificateSubjectDn = clientCertificateSubjectDn;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.LbHttpSslCondition#CLIENT_SUPPORTED_SSL_CIPHERS_ECDHE_RSA_WITH_AES_128_GCM_SHA256}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpSslCondition#CLIENT_SUPPORTED_SSL_CIPHERS_ECDHE_RSA_WITH_AES_256_GCM_SHA384}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpSslCondition#CLIENT_SUPPORTED_SSL_CIPHERS_ECDHE_RSA_WITH_AES_256_CBC_SHA}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpSslCondition#CLIENT_SUPPORTED_SSL_CIPHERS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpSslCondition#CLIENT_SUPPORTED_SSL_CIPHERS_ECDH_ECDSA_WITH_AES_256_CBC_SHA}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpSslCondition#CLIENT_SUPPORTED_SSL_CIPHERS_ECDH_RSA_WITH_AES_256_CBC_SHA}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpSslCondition#CLIENT_SUPPORTED_SSL_CIPHERS_RSA_WITH_AES_256_CBC_SHA}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpSslCondition#CLIENT_SUPPORTED_SSL_CIPHERS_RSA_WITH_AES_128_CBC_SHA}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpSslCondition#CLIENT_SUPPORTED_SSL_CIPHERS_RSA_WITH_3DES_EDE_CBC_SHA}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpSslCondition#CLIENT_SUPPORTED_SSL_CIPHERS_ECDHE_RSA_WITH_AES_128_CBC_SHA}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpSslCondition#CLIENT_SUPPORTED_SSL_CIPHERS_ECDHE_RSA_WITH_AES_128_CBC_SHA256}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpSslCondition#CLIENT_SUPPORTED_SSL_CIPHERS_ECDHE_RSA_WITH_AES_256_CBC_SHA384}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpSslCondition#CLIENT_SUPPORTED_SSL_CIPHERS_RSA_WITH_AES_128_CBC_SHA256}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpSslCondition#CLIENT_SUPPORTED_SSL_CIPHERS_RSA_WITH_AES_128_GCM_SHA256}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpSslCondition#CLIENT_SUPPORTED_SSL_CIPHERS_RSA_WITH_AES_256_CBC_SHA256}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpSslCondition#CLIENT_SUPPORTED_SSL_CIPHERS_RSA_WITH_AES_256_GCM_SHA384}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpSslCondition#CLIENT_SUPPORTED_SSL_CIPHERS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpSslCondition#CLIENT_SUPPORTED_SSL_CIPHERS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpSslCondition#CLIENT_SUPPORTED_SSL_CIPHERS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpSslCondition#CLIENT_SUPPORTED_SSL_CIPHERS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpSslCondition#CLIENT_SUPPORTED_SSL_CIPHERS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpSslCondition#CLIENT_SUPPORTED_SSL_CIPHERS_ECDH_ECDSA_WITH_AES_128_CBC_SHA}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpSslCondition#CLIENT_SUPPORTED_SSL_CIPHERS_ECDH_ECDSA_WITH_AES_128_CBC_SHA256}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpSslCondition#CLIENT_SUPPORTED_SSL_CIPHERS_ECDH_ECDSA_WITH_AES_128_GCM_SHA256}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpSslCondition#CLIENT_SUPPORTED_SSL_CIPHERS_ECDH_ECDSA_WITH_AES_256_CBC_SHA384}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpSslCondition#CLIENT_SUPPORTED_SSL_CIPHERS_ECDH_ECDSA_WITH_AES_256_GCM_SHA384}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpSslCondition#CLIENT_SUPPORTED_SSL_CIPHERS_ECDH_RSA_WITH_AES_128_CBC_SHA}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpSslCondition#CLIENT_SUPPORTED_SSL_CIPHERS_ECDH_RSA_WITH_AES_128_CBC_SHA256}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpSslCondition#CLIENT_SUPPORTED_SSL_CIPHERS_ECDH_RSA_WITH_AES_128_GCM_SHA256}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpSslCondition#CLIENT_SUPPORTED_SSL_CIPHERS_ECDH_RSA_WITH_AES_256_CBC_SHA384}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpSslCondition#CLIENT_SUPPORTED_SSL_CIPHERS_ECDH_RSA_WITH_AES_256_GCM_SHA384}</li>
     * </ul> Cipher list which supported by client
     *
     * @return The current value of the property.
     */
    public java.util.List<java.lang.String> getClientSupportedSslCiphers() {
        return this.clientSupportedSslCiphers;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.LbHttpSslCondition#CLIENT_SUPPORTED_SSL_CIPHERS_ECDHE_RSA_WITH_AES_128_GCM_SHA256}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpSslCondition#CLIENT_SUPPORTED_SSL_CIPHERS_ECDHE_RSA_WITH_AES_256_GCM_SHA384}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpSslCondition#CLIENT_SUPPORTED_SSL_CIPHERS_ECDHE_RSA_WITH_AES_256_CBC_SHA}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpSslCondition#CLIENT_SUPPORTED_SSL_CIPHERS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpSslCondition#CLIENT_SUPPORTED_SSL_CIPHERS_ECDH_ECDSA_WITH_AES_256_CBC_SHA}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpSslCondition#CLIENT_SUPPORTED_SSL_CIPHERS_ECDH_RSA_WITH_AES_256_CBC_SHA}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpSslCondition#CLIENT_SUPPORTED_SSL_CIPHERS_RSA_WITH_AES_256_CBC_SHA}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpSslCondition#CLIENT_SUPPORTED_SSL_CIPHERS_RSA_WITH_AES_128_CBC_SHA}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpSslCondition#CLIENT_SUPPORTED_SSL_CIPHERS_RSA_WITH_3DES_EDE_CBC_SHA}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpSslCondition#CLIENT_SUPPORTED_SSL_CIPHERS_ECDHE_RSA_WITH_AES_128_CBC_SHA}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpSslCondition#CLIENT_SUPPORTED_SSL_CIPHERS_ECDHE_RSA_WITH_AES_128_CBC_SHA256}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpSslCondition#CLIENT_SUPPORTED_SSL_CIPHERS_ECDHE_RSA_WITH_AES_256_CBC_SHA384}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpSslCondition#CLIENT_SUPPORTED_SSL_CIPHERS_RSA_WITH_AES_128_CBC_SHA256}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpSslCondition#CLIENT_SUPPORTED_SSL_CIPHERS_RSA_WITH_AES_128_GCM_SHA256}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpSslCondition#CLIENT_SUPPORTED_SSL_CIPHERS_RSA_WITH_AES_256_CBC_SHA256}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpSslCondition#CLIENT_SUPPORTED_SSL_CIPHERS_RSA_WITH_AES_256_GCM_SHA384}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpSslCondition#CLIENT_SUPPORTED_SSL_CIPHERS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpSslCondition#CLIENT_SUPPORTED_SSL_CIPHERS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpSslCondition#CLIENT_SUPPORTED_SSL_CIPHERS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpSslCondition#CLIENT_SUPPORTED_SSL_CIPHERS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpSslCondition#CLIENT_SUPPORTED_SSL_CIPHERS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpSslCondition#CLIENT_SUPPORTED_SSL_CIPHERS_ECDH_ECDSA_WITH_AES_128_CBC_SHA}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpSslCondition#CLIENT_SUPPORTED_SSL_CIPHERS_ECDH_ECDSA_WITH_AES_128_CBC_SHA256}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpSslCondition#CLIENT_SUPPORTED_SSL_CIPHERS_ECDH_ECDSA_WITH_AES_128_GCM_SHA256}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpSslCondition#CLIENT_SUPPORTED_SSL_CIPHERS_ECDH_ECDSA_WITH_AES_256_CBC_SHA384}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpSslCondition#CLIENT_SUPPORTED_SSL_CIPHERS_ECDH_ECDSA_WITH_AES_256_GCM_SHA384}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpSslCondition#CLIENT_SUPPORTED_SSL_CIPHERS_ECDH_RSA_WITH_AES_128_CBC_SHA}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpSslCondition#CLIENT_SUPPORTED_SSL_CIPHERS_ECDH_RSA_WITH_AES_128_CBC_SHA256}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpSslCondition#CLIENT_SUPPORTED_SSL_CIPHERS_ECDH_RSA_WITH_AES_128_GCM_SHA256}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpSslCondition#CLIENT_SUPPORTED_SSL_CIPHERS_ECDH_RSA_WITH_AES_256_CBC_SHA384}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpSslCondition#CLIENT_SUPPORTED_SSL_CIPHERS_ECDH_RSA_WITH_AES_256_GCM_SHA384}</li>
     * </ul> Cipher list which supported by client
     *
     * @param clientSupportedSslCiphers New value for the property.
     */
    public void setClientSupportedSslCiphers(java.util.List<java.lang.String> clientSupportedSslCiphers) {
        this.clientSupportedSslCiphers = clientSupportedSslCiphers;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.LbHttpSslCondition#SESSION_REUSED_IGNORE}</li> <li> {@link
     * com.vmware.nsx.model.LbHttpSslCondition#SESSION_REUSED_REUSED}</li> <li> {@link
     * com.vmware.nsx.model.LbHttpSslCondition#SESSION_REUSED_NEW}</li> </ul> The type
     * of SSL session reused
     *
     * @return The current value of the property.
     */
    public java.lang.String getSessionReused() {
        return this.sessionReused;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.LbHttpSslCondition#SESSION_REUSED_IGNORE}</li> <li> {@link
     * com.vmware.nsx.model.LbHttpSslCondition#SESSION_REUSED_REUSED}</li> <li> {@link
     * com.vmware.nsx.model.LbHttpSslCondition#SESSION_REUSED_NEW}</li> </ul> The type
     * of SSL session reused
     *
     * @param sessionReused New value for the property.
     */
    public void setSessionReused(java.lang.String sessionReused) {
        this.sessionReused = sessionReused;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.LbHttpSslCondition#USED_PROTOCOL_SSL_V2}</li> <li> {@link
     * com.vmware.nsx.model.LbHttpSslCondition#USED_PROTOCOL_SSL_V3}</li> <li> {@link
     * com.vmware.nsx.model.LbHttpSslCondition#USED_PROTOCOL_TLS_V1}</li> <li> {@link
     * com.vmware.nsx.model.LbHttpSslCondition#USED_PROTOCOL_TLS_V1_1}</li> <li> {@link
     * com.vmware.nsx.model.LbHttpSslCondition#USED_PROTOCOL_TLS_V1_2}</li> </ul>
     * Protocol of an established SSL connection
     *
     * @return The current value of the property.
     */
    public java.lang.String getUsedProtocol() {
        return this.usedProtocol;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.LbHttpSslCondition#USED_PROTOCOL_SSL_V2}</li> <li> {@link
     * com.vmware.nsx.model.LbHttpSslCondition#USED_PROTOCOL_SSL_V3}</li> <li> {@link
     * com.vmware.nsx.model.LbHttpSslCondition#USED_PROTOCOL_TLS_V1}</li> <li> {@link
     * com.vmware.nsx.model.LbHttpSslCondition#USED_PROTOCOL_TLS_V1_1}</li> <li> {@link
     * com.vmware.nsx.model.LbHttpSslCondition#USED_PROTOCOL_TLS_V1_2}</li> </ul>
     * Protocol of an established SSL connection
     *
     * @param usedProtocol New value for the property.
     */
    public void setUsedProtocol(java.lang.String usedProtocol) {
        this.usedProtocol = usedProtocol;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.LbHttpSslCondition#USED_SSL_CIPHER_ECDHE_RSA_WITH_AES_128_GCM_SHA256}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpSslCondition#USED_SSL_CIPHER_ECDHE_RSA_WITH_AES_256_GCM_SHA384}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpSslCondition#USED_SSL_CIPHER_ECDHE_RSA_WITH_AES_256_CBC_SHA}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpSslCondition#USED_SSL_CIPHER_ECDHE_ECDSA_WITH_AES_256_CBC_SHA}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpSslCondition#USED_SSL_CIPHER_ECDH_ECDSA_WITH_AES_256_CBC_SHA}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpSslCondition#USED_SSL_CIPHER_ECDH_RSA_WITH_AES_256_CBC_SHA}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpSslCondition#USED_SSL_CIPHER_RSA_WITH_AES_256_CBC_SHA}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpSslCondition#USED_SSL_CIPHER_RSA_WITH_AES_128_CBC_SHA}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpSslCondition#USED_SSL_CIPHER_RSA_WITH_3DES_EDE_CBC_SHA}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpSslCondition#USED_SSL_CIPHER_ECDHE_RSA_WITH_AES_128_CBC_SHA}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpSslCondition#USED_SSL_CIPHER_ECDHE_RSA_WITH_AES_128_CBC_SHA256}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpSslCondition#USED_SSL_CIPHER_ECDHE_RSA_WITH_AES_256_CBC_SHA384}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpSslCondition#USED_SSL_CIPHER_RSA_WITH_AES_128_CBC_SHA256}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpSslCondition#USED_SSL_CIPHER_RSA_WITH_AES_128_GCM_SHA256}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpSslCondition#USED_SSL_CIPHER_RSA_WITH_AES_256_CBC_SHA256}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpSslCondition#USED_SSL_CIPHER_RSA_WITH_AES_256_GCM_SHA384}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpSslCondition#USED_SSL_CIPHER_ECDHE_ECDSA_WITH_AES_128_CBC_SHA}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpSslCondition#USED_SSL_CIPHER_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpSslCondition#USED_SSL_CIPHER_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpSslCondition#USED_SSL_CIPHER_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpSslCondition#USED_SSL_CIPHER_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpSslCondition#USED_SSL_CIPHER_ECDH_ECDSA_WITH_AES_128_CBC_SHA}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpSslCondition#USED_SSL_CIPHER_ECDH_ECDSA_WITH_AES_128_CBC_SHA256}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpSslCondition#USED_SSL_CIPHER_ECDH_ECDSA_WITH_AES_128_GCM_SHA256}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpSslCondition#USED_SSL_CIPHER_ECDH_ECDSA_WITH_AES_256_CBC_SHA384}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpSslCondition#USED_SSL_CIPHER_ECDH_ECDSA_WITH_AES_256_GCM_SHA384}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpSslCondition#USED_SSL_CIPHER_ECDH_RSA_WITH_AES_128_CBC_SHA}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpSslCondition#USED_SSL_CIPHER_ECDH_RSA_WITH_AES_128_CBC_SHA256}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpSslCondition#USED_SSL_CIPHER_ECDH_RSA_WITH_AES_128_GCM_SHA256}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpSslCondition#USED_SSL_CIPHER_ECDH_RSA_WITH_AES_256_CBC_SHA384}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpSslCondition#USED_SSL_CIPHER_ECDH_RSA_WITH_AES_256_GCM_SHA384}</li>
     * </ul> Cipher used for an established SSL connection
     *
     * @return The current value of the property.
     */
    public java.lang.String getUsedSslCipher() {
        return this.usedSslCipher;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.LbHttpSslCondition#USED_SSL_CIPHER_ECDHE_RSA_WITH_AES_128_GCM_SHA256}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpSslCondition#USED_SSL_CIPHER_ECDHE_RSA_WITH_AES_256_GCM_SHA384}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpSslCondition#USED_SSL_CIPHER_ECDHE_RSA_WITH_AES_256_CBC_SHA}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpSslCondition#USED_SSL_CIPHER_ECDHE_ECDSA_WITH_AES_256_CBC_SHA}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpSslCondition#USED_SSL_CIPHER_ECDH_ECDSA_WITH_AES_256_CBC_SHA}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpSslCondition#USED_SSL_CIPHER_ECDH_RSA_WITH_AES_256_CBC_SHA}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpSslCondition#USED_SSL_CIPHER_RSA_WITH_AES_256_CBC_SHA}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpSslCondition#USED_SSL_CIPHER_RSA_WITH_AES_128_CBC_SHA}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpSslCondition#USED_SSL_CIPHER_RSA_WITH_3DES_EDE_CBC_SHA}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpSslCondition#USED_SSL_CIPHER_ECDHE_RSA_WITH_AES_128_CBC_SHA}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpSslCondition#USED_SSL_CIPHER_ECDHE_RSA_WITH_AES_128_CBC_SHA256}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpSslCondition#USED_SSL_CIPHER_ECDHE_RSA_WITH_AES_256_CBC_SHA384}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpSslCondition#USED_SSL_CIPHER_RSA_WITH_AES_128_CBC_SHA256}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpSslCondition#USED_SSL_CIPHER_RSA_WITH_AES_128_GCM_SHA256}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpSslCondition#USED_SSL_CIPHER_RSA_WITH_AES_256_CBC_SHA256}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpSslCondition#USED_SSL_CIPHER_RSA_WITH_AES_256_GCM_SHA384}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpSslCondition#USED_SSL_CIPHER_ECDHE_ECDSA_WITH_AES_128_CBC_SHA}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpSslCondition#USED_SSL_CIPHER_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpSslCondition#USED_SSL_CIPHER_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpSslCondition#USED_SSL_CIPHER_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpSslCondition#USED_SSL_CIPHER_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpSslCondition#USED_SSL_CIPHER_ECDH_ECDSA_WITH_AES_128_CBC_SHA}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpSslCondition#USED_SSL_CIPHER_ECDH_ECDSA_WITH_AES_128_CBC_SHA256}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpSslCondition#USED_SSL_CIPHER_ECDH_ECDSA_WITH_AES_128_GCM_SHA256}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpSslCondition#USED_SSL_CIPHER_ECDH_ECDSA_WITH_AES_256_CBC_SHA384}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpSslCondition#USED_SSL_CIPHER_ECDH_ECDSA_WITH_AES_256_GCM_SHA384}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpSslCondition#USED_SSL_CIPHER_ECDH_RSA_WITH_AES_128_CBC_SHA}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpSslCondition#USED_SSL_CIPHER_ECDH_RSA_WITH_AES_128_CBC_SHA256}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpSslCondition#USED_SSL_CIPHER_ECDH_RSA_WITH_AES_128_GCM_SHA256}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpSslCondition#USED_SSL_CIPHER_ECDH_RSA_WITH_AES_256_CBC_SHA384}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpSslCondition#USED_SSL_CIPHER_ECDH_RSA_WITH_AES_256_GCM_SHA384}</li>
     * </ul> Cipher used for an established SSL connection
     *
     * @param usedSslCipher New value for the property.
     */
    public void setUsedSslCipher(java.lang.String usedSslCipher) {
        this.usedSslCipher = usedSslCipher;
    }

    /**
     * A flag to indicate whether reverse the match result of this condition
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getInverse() {
        return this.inverse;
    }

    /**
     * A flag to indicate whether reverse the match result of this condition
     *
     * @param inverse New value for the property.
     */
    public void setInverse(java.lang.Boolean inverse) {
        this.inverse = inverse;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.LbRuleCondition#TYPE_LBHTTPREQUESTMETHODCONDITION}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbRuleCondition#TYPE_LBHTTPREQUESTURICONDITION}</li> <li>
     * {@link
     * com.vmware.nsx.model.LbRuleCondition#TYPE_LBHTTPREQUESTURIARGUMENTSCONDITION}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbRuleCondition#TYPE_LBHTTPREQUESTVERSIONCONDITION}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbRuleCondition#TYPE_LBHTTPREQUESTHEADERCONDITION}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbRuleCondition#TYPE_LBHTTPREQUESTCOOKIECONDITION}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbRuleCondition#TYPE_LBHTTPREQUESTBODYCONDITION}</li> <li>
     * {@link
     * com.vmware.nsx.model.LbRuleCondition#TYPE_LBHTTPRESPONSEHEADERCONDITION}</li>
     * <li> {@link com.vmware.nsx.model.LbRuleCondition#TYPE_LBTCPHEADERCONDITION}</li>
     * <li> {@link com.vmware.nsx.model.LbRuleCondition#TYPE_LBIPHEADERCONDITION}</li>
     * <li> {@link com.vmware.nsx.model.LbRuleCondition#TYPE_LBVARIABLECONDITION}</li>
     * <li> {@link com.vmware.nsx.model.LbRuleCondition#TYPE_LBHTTPSSLCONDITION}</li>
     * <li> {@link com.vmware.nsx.model.LbRuleCondition#TYPE_LBSSLSNICONDITION}</li>
     * </ul> Type of load balancer rule condition
     * The value of this property is automatically populated to {@code "LbHttpSslCondition"}.
     *
     * @return The current value of the property.
     */
    public java.lang.String getType() {
        return this.type;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx.model.StructDefinitions.lbHttpSslCondition;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("client_certificate_issuer_dn",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.clientCertificateIssuerDn, this._getType().getField("client_certificate_issuer_dn")));
        structValue.setField("client_certificate_subject_dn",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.clientCertificateSubjectDn, this._getType().getField("client_certificate_subject_dn")));
        structValue.setField("client_supported_ssl_ciphers",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.clientSupportedSslCiphers, this._getType().getField("client_supported_ssl_ciphers")));
        structValue.setField("session_reused",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.sessionReused, this._getType().getField("session_reused")));
        structValue.setField("used_protocol",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.usedProtocol, this._getType().getField("used_protocol")));
        structValue.setField("used_ssl_cipher",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.usedSslCipher, this._getType().getField("used_ssl_cipher")));
        structValue.setField("inverse",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.inverse, this._getType().getField("inverse")));
        structValue.setField("type",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.type, this._getType().getField("type")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx.model.StructDefinitions.lbHttpSslCondition;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx.model.StructDefinitions.lbHttpSslCondition.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static LbHttpSslCondition _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new LbHttpSslCondition(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static LbHttpSslCondition _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new LbHttpSslCondition(structValue);
    }

    /**
     * Builder class for {@link LbHttpSslCondition}.
     */
    public static final class Builder {
        private com.vmware.nsx.model.LbClientCertificateIssuerDnCondition clientCertificateIssuerDn;
        private com.vmware.nsx.model.LbClientCertificateSubjectDnCondition clientCertificateSubjectDn;
        private java.util.List<java.lang.String> clientSupportedSslCiphers;
        private java.lang.String sessionReused;
        private java.lang.String usedProtocol;
        private java.lang.String usedSslCipher;
        private java.lang.Boolean inverse;

        /**
         * Constructor with parameters for the required properties of
         * {@link LbHttpSslCondition}.
         */
        public Builder() {
        }

        /**
         *
         *
         * @param clientCertificateIssuerDn New value for the property.
         */
        public Builder setClientCertificateIssuerDn(com.vmware.nsx.model.LbClientCertificateIssuerDnCondition clientCertificateIssuerDn) {
            this.clientCertificateIssuerDn = clientCertificateIssuerDn;
            return this;
        }

        /**
         *
         *
         * @param clientCertificateSubjectDn New value for the property.
         */
        public Builder setClientCertificateSubjectDn(com.vmware.nsx.model.LbClientCertificateSubjectDnCondition clientCertificateSubjectDn) {
            this.clientCertificateSubjectDn = clientCertificateSubjectDn;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx.model.LbHttpSslCondition#CLIENT_SUPPORTED_SSL_CIPHERS_ECDHE_RSA_WITH_AES_128_GCM_SHA256}</li>
         * <li> {@link
         * com.vmware.nsx.model.LbHttpSslCondition#CLIENT_SUPPORTED_SSL_CIPHERS_ECDHE_RSA_WITH_AES_256_GCM_SHA384}</li>
         * <li> {@link
         * com.vmware.nsx.model.LbHttpSslCondition#CLIENT_SUPPORTED_SSL_CIPHERS_ECDHE_RSA_WITH_AES_256_CBC_SHA}</li>
         * <li> {@link
         * com.vmware.nsx.model.LbHttpSslCondition#CLIENT_SUPPORTED_SSL_CIPHERS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA}</li>
         * <li> {@link
         * com.vmware.nsx.model.LbHttpSslCondition#CLIENT_SUPPORTED_SSL_CIPHERS_ECDH_ECDSA_WITH_AES_256_CBC_SHA}</li>
         * <li> {@link
         * com.vmware.nsx.model.LbHttpSslCondition#CLIENT_SUPPORTED_SSL_CIPHERS_ECDH_RSA_WITH_AES_256_CBC_SHA}</li>
         * <li> {@link
         * com.vmware.nsx.model.LbHttpSslCondition#CLIENT_SUPPORTED_SSL_CIPHERS_RSA_WITH_AES_256_CBC_SHA}</li>
         * <li> {@link
         * com.vmware.nsx.model.LbHttpSslCondition#CLIENT_SUPPORTED_SSL_CIPHERS_RSA_WITH_AES_128_CBC_SHA}</li>
         * <li> {@link
         * com.vmware.nsx.model.LbHttpSslCondition#CLIENT_SUPPORTED_SSL_CIPHERS_RSA_WITH_3DES_EDE_CBC_SHA}</li>
         * <li> {@link
         * com.vmware.nsx.model.LbHttpSslCondition#CLIENT_SUPPORTED_SSL_CIPHERS_ECDHE_RSA_WITH_AES_128_CBC_SHA}</li>
         * <li> {@link
         * com.vmware.nsx.model.LbHttpSslCondition#CLIENT_SUPPORTED_SSL_CIPHERS_ECDHE_RSA_WITH_AES_128_CBC_SHA256}</li>
         * <li> {@link
         * com.vmware.nsx.model.LbHttpSslCondition#CLIENT_SUPPORTED_SSL_CIPHERS_ECDHE_RSA_WITH_AES_256_CBC_SHA384}</li>
         * <li> {@link
         * com.vmware.nsx.model.LbHttpSslCondition#CLIENT_SUPPORTED_SSL_CIPHERS_RSA_WITH_AES_128_CBC_SHA256}</li>
         * <li> {@link
         * com.vmware.nsx.model.LbHttpSslCondition#CLIENT_SUPPORTED_SSL_CIPHERS_RSA_WITH_AES_128_GCM_SHA256}</li>
         * <li> {@link
         * com.vmware.nsx.model.LbHttpSslCondition#CLIENT_SUPPORTED_SSL_CIPHERS_RSA_WITH_AES_256_CBC_SHA256}</li>
         * <li> {@link
         * com.vmware.nsx.model.LbHttpSslCondition#CLIENT_SUPPORTED_SSL_CIPHERS_RSA_WITH_AES_256_GCM_SHA384}</li>
         * <li> {@link
         * com.vmware.nsx.model.LbHttpSslCondition#CLIENT_SUPPORTED_SSL_CIPHERS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA}</li>
         * <li> {@link
         * com.vmware.nsx.model.LbHttpSslCondition#CLIENT_SUPPORTED_SSL_CIPHERS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256}</li>
         * <li> {@link
         * com.vmware.nsx.model.LbHttpSslCondition#CLIENT_SUPPORTED_SSL_CIPHERS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256}</li>
         * <li> {@link
         * com.vmware.nsx.model.LbHttpSslCondition#CLIENT_SUPPORTED_SSL_CIPHERS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384}</li>
         * <li> {@link
         * com.vmware.nsx.model.LbHttpSslCondition#CLIENT_SUPPORTED_SSL_CIPHERS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384}</li>
         * <li> {@link
         * com.vmware.nsx.model.LbHttpSslCondition#CLIENT_SUPPORTED_SSL_CIPHERS_ECDH_ECDSA_WITH_AES_128_CBC_SHA}</li>
         * <li> {@link
         * com.vmware.nsx.model.LbHttpSslCondition#CLIENT_SUPPORTED_SSL_CIPHERS_ECDH_ECDSA_WITH_AES_128_CBC_SHA256}</li>
         * <li> {@link
         * com.vmware.nsx.model.LbHttpSslCondition#CLIENT_SUPPORTED_SSL_CIPHERS_ECDH_ECDSA_WITH_AES_128_GCM_SHA256}</li>
         * <li> {@link
         * com.vmware.nsx.model.LbHttpSslCondition#CLIENT_SUPPORTED_SSL_CIPHERS_ECDH_ECDSA_WITH_AES_256_CBC_SHA384}</li>
         * <li> {@link
         * com.vmware.nsx.model.LbHttpSslCondition#CLIENT_SUPPORTED_SSL_CIPHERS_ECDH_ECDSA_WITH_AES_256_GCM_SHA384}</li>
         * <li> {@link
         * com.vmware.nsx.model.LbHttpSslCondition#CLIENT_SUPPORTED_SSL_CIPHERS_ECDH_RSA_WITH_AES_128_CBC_SHA}</li>
         * <li> {@link
         * com.vmware.nsx.model.LbHttpSslCondition#CLIENT_SUPPORTED_SSL_CIPHERS_ECDH_RSA_WITH_AES_128_CBC_SHA256}</li>
         * <li> {@link
         * com.vmware.nsx.model.LbHttpSslCondition#CLIENT_SUPPORTED_SSL_CIPHERS_ECDH_RSA_WITH_AES_128_GCM_SHA256}</li>
         * <li> {@link
         * com.vmware.nsx.model.LbHttpSslCondition#CLIENT_SUPPORTED_SSL_CIPHERS_ECDH_RSA_WITH_AES_256_CBC_SHA384}</li>
         * <li> {@link
         * com.vmware.nsx.model.LbHttpSslCondition#CLIENT_SUPPORTED_SSL_CIPHERS_ECDH_RSA_WITH_AES_256_GCM_SHA384}</li>
         * </ul> Cipher list which supported by client
         *
         * @param clientSupportedSslCiphers New value for the property.
         */
        public Builder setClientSupportedSslCiphers(java.util.List<java.lang.String> clientSupportedSslCiphers) {
            this.clientSupportedSslCiphers = clientSupportedSslCiphers;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx.model.LbHttpSslCondition#SESSION_REUSED_IGNORE}</li> <li> {@link
         * com.vmware.nsx.model.LbHttpSslCondition#SESSION_REUSED_REUSED}</li> <li> {@link
         * com.vmware.nsx.model.LbHttpSslCondition#SESSION_REUSED_NEW}</li> </ul> The type
         * of SSL session reused
         *
         * @param sessionReused New value for the property.
         */
        public Builder setSessionReused(java.lang.String sessionReused) {
            this.sessionReused = sessionReused;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx.model.LbHttpSslCondition#USED_PROTOCOL_SSL_V2}</li> <li> {@link
         * com.vmware.nsx.model.LbHttpSslCondition#USED_PROTOCOL_SSL_V3}</li> <li> {@link
         * com.vmware.nsx.model.LbHttpSslCondition#USED_PROTOCOL_TLS_V1}</li> <li> {@link
         * com.vmware.nsx.model.LbHttpSslCondition#USED_PROTOCOL_TLS_V1_1}</li> <li> {@link
         * com.vmware.nsx.model.LbHttpSslCondition#USED_PROTOCOL_TLS_V1_2}</li> </ul>
         * Protocol of an established SSL connection
         *
         * @param usedProtocol New value for the property.
         */
        public Builder setUsedProtocol(java.lang.String usedProtocol) {
            this.usedProtocol = usedProtocol;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx.model.LbHttpSslCondition#USED_SSL_CIPHER_ECDHE_RSA_WITH_AES_128_GCM_SHA256}</li>
         * <li> {@link
         * com.vmware.nsx.model.LbHttpSslCondition#USED_SSL_CIPHER_ECDHE_RSA_WITH_AES_256_GCM_SHA384}</li>
         * <li> {@link
         * com.vmware.nsx.model.LbHttpSslCondition#USED_SSL_CIPHER_ECDHE_RSA_WITH_AES_256_CBC_SHA}</li>
         * <li> {@link
         * com.vmware.nsx.model.LbHttpSslCondition#USED_SSL_CIPHER_ECDHE_ECDSA_WITH_AES_256_CBC_SHA}</li>
         * <li> {@link
         * com.vmware.nsx.model.LbHttpSslCondition#USED_SSL_CIPHER_ECDH_ECDSA_WITH_AES_256_CBC_SHA}</li>
         * <li> {@link
         * com.vmware.nsx.model.LbHttpSslCondition#USED_SSL_CIPHER_ECDH_RSA_WITH_AES_256_CBC_SHA}</li>
         * <li> {@link
         * com.vmware.nsx.model.LbHttpSslCondition#USED_SSL_CIPHER_RSA_WITH_AES_256_CBC_SHA}</li>
         * <li> {@link
         * com.vmware.nsx.model.LbHttpSslCondition#USED_SSL_CIPHER_RSA_WITH_AES_128_CBC_SHA}</li>
         * <li> {@link
         * com.vmware.nsx.model.LbHttpSslCondition#USED_SSL_CIPHER_RSA_WITH_3DES_EDE_CBC_SHA}</li>
         * <li> {@link
         * com.vmware.nsx.model.LbHttpSslCondition#USED_SSL_CIPHER_ECDHE_RSA_WITH_AES_128_CBC_SHA}</li>
         * <li> {@link
         * com.vmware.nsx.model.LbHttpSslCondition#USED_SSL_CIPHER_ECDHE_RSA_WITH_AES_128_CBC_SHA256}</li>
         * <li> {@link
         * com.vmware.nsx.model.LbHttpSslCondition#USED_SSL_CIPHER_ECDHE_RSA_WITH_AES_256_CBC_SHA384}</li>
         * <li> {@link
         * com.vmware.nsx.model.LbHttpSslCondition#USED_SSL_CIPHER_RSA_WITH_AES_128_CBC_SHA256}</li>
         * <li> {@link
         * com.vmware.nsx.model.LbHttpSslCondition#USED_SSL_CIPHER_RSA_WITH_AES_128_GCM_SHA256}</li>
         * <li> {@link
         * com.vmware.nsx.model.LbHttpSslCondition#USED_SSL_CIPHER_RSA_WITH_AES_256_CBC_SHA256}</li>
         * <li> {@link
         * com.vmware.nsx.model.LbHttpSslCondition#USED_SSL_CIPHER_RSA_WITH_AES_256_GCM_SHA384}</li>
         * <li> {@link
         * com.vmware.nsx.model.LbHttpSslCondition#USED_SSL_CIPHER_ECDHE_ECDSA_WITH_AES_128_CBC_SHA}</li>
         * <li> {@link
         * com.vmware.nsx.model.LbHttpSslCondition#USED_SSL_CIPHER_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256}</li>
         * <li> {@link
         * com.vmware.nsx.model.LbHttpSslCondition#USED_SSL_CIPHER_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256}</li>
         * <li> {@link
         * com.vmware.nsx.model.LbHttpSslCondition#USED_SSL_CIPHER_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384}</li>
         * <li> {@link
         * com.vmware.nsx.model.LbHttpSslCondition#USED_SSL_CIPHER_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384}</li>
         * <li> {@link
         * com.vmware.nsx.model.LbHttpSslCondition#USED_SSL_CIPHER_ECDH_ECDSA_WITH_AES_128_CBC_SHA}</li>
         * <li> {@link
         * com.vmware.nsx.model.LbHttpSslCondition#USED_SSL_CIPHER_ECDH_ECDSA_WITH_AES_128_CBC_SHA256}</li>
         * <li> {@link
         * com.vmware.nsx.model.LbHttpSslCondition#USED_SSL_CIPHER_ECDH_ECDSA_WITH_AES_128_GCM_SHA256}</li>
         * <li> {@link
         * com.vmware.nsx.model.LbHttpSslCondition#USED_SSL_CIPHER_ECDH_ECDSA_WITH_AES_256_CBC_SHA384}</li>
         * <li> {@link
         * com.vmware.nsx.model.LbHttpSslCondition#USED_SSL_CIPHER_ECDH_ECDSA_WITH_AES_256_GCM_SHA384}</li>
         * <li> {@link
         * com.vmware.nsx.model.LbHttpSslCondition#USED_SSL_CIPHER_ECDH_RSA_WITH_AES_128_CBC_SHA}</li>
         * <li> {@link
         * com.vmware.nsx.model.LbHttpSslCondition#USED_SSL_CIPHER_ECDH_RSA_WITH_AES_128_CBC_SHA256}</li>
         * <li> {@link
         * com.vmware.nsx.model.LbHttpSslCondition#USED_SSL_CIPHER_ECDH_RSA_WITH_AES_128_GCM_SHA256}</li>
         * <li> {@link
         * com.vmware.nsx.model.LbHttpSslCondition#USED_SSL_CIPHER_ECDH_RSA_WITH_AES_256_CBC_SHA384}</li>
         * <li> {@link
         * com.vmware.nsx.model.LbHttpSslCondition#USED_SSL_CIPHER_ECDH_RSA_WITH_AES_256_GCM_SHA384}</li>
         * </ul> Cipher used for an established SSL connection
         *
         * @param usedSslCipher New value for the property.
         */
        public Builder setUsedSslCipher(java.lang.String usedSslCipher) {
            this.usedSslCipher = usedSslCipher;
            return this;
        }

        /**
         * A flag to indicate whether reverse the match result of this condition
         *
         * @param inverse New value for the property.
         */
        public Builder setInverse(java.lang.Boolean inverse) {
            this.inverse = inverse;
            return this;
        }

        public LbHttpSslCondition build() {
            LbHttpSslCondition result = new LbHttpSslCondition();
            result.setClientCertificateIssuerDn(this.clientCertificateIssuerDn);
            result.setClientCertificateSubjectDn(this.clientCertificateSubjectDn);
            result.setClientSupportedSslCiphers(this.clientSupportedSslCiphers);
            result.setSessionReused(this.sessionReused);
            result.setUsedProtocol(this.usedProtocol);
            result.setUsedSslCipher(this.usedSslCipher);
            result.setInverse(this.inverse);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("client_certificate_issuer_dn", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx.model.StructDefinitions.lbClientCertificateIssuerDnCondition; } }));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("client_certificate_issuer_dn",
                                                                                "clientCertificateIssuerDn",
                                                                                "getClientCertificateIssuerDn",
                                                                                "setClientCertificateIssuerDn");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("client_certificate_subject_dn", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx.model.StructDefinitions.lbClientCertificateSubjectDnCondition; } }));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("client_certificate_subject_dn",
                                                                                "clientCertificateSubjectDn",
                                                                                "getClientCertificateSubjectDn",
                                                                                "setClientCertificateSubjectDn");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("client_supported_ssl_ciphers", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.StringType())));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("client_supported_ssl_ciphers",
                                                                                "clientSupportedSslCiphers",
                                                                                "getClientSupportedSslCiphers",
                                                                                "setClientSupportedSslCiphers");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("session_reused", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("session_reused",
                                                                                "sessionReused",
                                                                                "getSessionReused",
                                                                                "setSessionReused");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("used_protocol", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("used_protocol",
                                                                                "usedProtocol",
                                                                                "getUsedProtocol",
                                                                                "setUsedProtocol");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("used_ssl_cipher", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("used_ssl_cipher",
                                                                                "usedSslCipher",
                                                                                "getUsedSslCipher",
                                                                                "setUsedSslCipher");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("inverse", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("inverse",
                                                                                "inverse",
                                                                                "getInverse",
                                                                                "setInverse");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("type", new com.vmware.vapi.bindings.type.StringType());
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("type",
                                                                                "type",
                                                                                "getType",
                                                                                null);
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx.model.lb_http_ssl_condition",
                                                            fields,
                                                            com.vmware.nsx.model.LbHttpSslCondition.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            "type",
                                                            "LbHttpSslCondition");
    }
}

