/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx.model;

/**
 * This action is performed in HTTP forwarding phase. It is used to inspect the
 * variable of HTTP request, and look up the persistence entry with its value and
 * pool uuid as key. If the persistence entry is found, the HTTP request is
 * forwarded to the recorded backend server according to the persistence entry. If
 * the persistence entry is not found, a new entry is created in the table after
 * backend server is selected.
 */
public final class LbVariablePersistenceOnAction implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    /**
     * Identifier denoting this class, when it is used in polymorphic context. 
     * <p>This
     * value should be assigned to the property which is used to discriminate the
     * actual type used in the polymorphic context.</p>
     */
    public static final java.lang.String _TYPE_IDENTIFIER = "LbVariablePersistenceOnAction";

    private java.lang.String persistenceProfileId;

    private java.lang.Boolean variableHashEnabled;

    private java.lang.String variableName;

    private final java.lang.String type = "LbVariablePersistenceOnAction";

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public LbVariablePersistenceOnAction() {
    }

    protected LbVariablePersistenceOnAction(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * If the persistence profile UUID is not specified, a default persistence table is
     * created per virtual server. Currently, only LbGenericPersistenceProfile is
     * supported.
     *
     * @return The current value of the property.
     */
    public java.lang.String getPersistenceProfileId() {
        return this.persistenceProfileId;
    }

    /**
     * If the persistence profile UUID is not specified, a default persistence table is
     * created per virtual server. Currently, only LbGenericPersistenceProfile is
     * supported.
     *
     * @param persistenceProfileId New value for the property.
     */
    public void setPersistenceProfileId(java.lang.String persistenceProfileId) {
        this.persistenceProfileId = persistenceProfileId;
    }

    /**
     * The property is used to enable a hash operation for variable value when
     * composing the persistence key.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getVariableHashEnabled() {
        return this.variableHashEnabled;
    }

    /**
     * The property is used to enable a hash operation for variable value when
     * composing the persistence key.
     *
     * @param variableHashEnabled New value for the property.
     */
    public void setVariableHashEnabled(java.lang.Boolean variableHashEnabled) {
        this.variableHashEnabled = variableHashEnabled;
    }

    /**
     * The property is the name of variable to be used. It specifies which variable's
     * value of a HTTP Request will be used in the key of persistence entry. The
     * variable can be a system embedded variable such as \"_cookie_JSESSIONID\", a
     * customized variable defined in LbVariableAssignmentAction or a captured variable
     * in regular expression such as \"article\".
     *
     * @return The current value of the property.
     */
    public java.lang.String getVariableName() {
        return this.variableName;
    }

    /**
     * The property is the name of variable to be used. It specifies which variable's
     * value of a HTTP Request will be used in the key of persistence entry. The
     * variable can be a system embedded variable such as \"_cookie_JSESSIONID\", a
     * customized variable defined in LbVariableAssignmentAction or a captured variable
     * in regular expression such as \"article\".
     *
     * @param variableName New value for the property.
     */
    public void setVariableName(java.lang.String variableName) {
        this.variableName = variableName;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.LbRuleAction#TYPE_LBHTTPREQUESTURIREWRITEACTION}</li> <li>
     * {@link
     * com.vmware.nsx.model.LbRuleAction#TYPE_LBHTTPREQUESTHEADERREWRITEACTION}</li>
     * <li> {@link com.vmware.nsx.model.LbRuleAction#TYPE_LBHTTPREJECTACTION}</li> <li>
     * {@link com.vmware.nsx.model.LbRuleAction#TYPE_LBHTTPREDIRECTACTION}</li> <li>
     * {@link com.vmware.nsx.model.LbRuleAction#TYPE_LBSELECTPOOLACTION}</li> <li>
     * {@link com.vmware.nsx.model.LbRuleAction#TYPE_LBSELECTSERVERACTION}</li> <li>
     * {@link
     * com.vmware.nsx.model.LbRuleAction#TYPE_LBHTTPRESPONSEHEADERREWRITEACTION}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbRuleAction#TYPE_LBHTTPREQUESTHEADERDELETEACTION}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbRuleAction#TYPE_LBHTTPRESPONSEHEADERDELETEACTION}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbRuleAction#TYPE_LBVARIABLEASSIGNMENTACTION}</li> <li>
     * {@link
     * com.vmware.nsx.model.LbRuleAction#TYPE_LBVARIABLEPERSISTENCEONACTION}</li> <li>
     * {@link
     * com.vmware.nsx.model.LbRuleAction#TYPE_LBVARIABLEPERSISTENCELEARNACTION}</li>
     * <li> {@link com.vmware.nsx.model.LbRuleAction#TYPE_LBJWTAUTHACTION}</li> <li>
     * {@link com.vmware.nsx.model.LbRuleAction#TYPE_LBSSLMODESELECTIONACTION}</li>
     * <li> {@link com.vmware.nsx.model.LbRuleAction#TYPE_LBCONNECTIONDROPACTION}</li>
     * </ul> The property identifies the load balancer rule action type.
     * The value of this property is automatically populated to {@code "LbVariablePersistenceOnAction"}.
     *
     * @return The current value of the property.
     */
    public java.lang.String getType() {
        return this.type;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx.model.StructDefinitions.lbVariablePersistenceOnAction;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("persistence_profile_id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.persistenceProfileId, this._getType().getField("persistence_profile_id")));
        structValue.setField("variable_hash_enabled",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.variableHashEnabled, this._getType().getField("variable_hash_enabled")));
        structValue.setField("variable_name",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.variableName, this._getType().getField("variable_name")));
        structValue.setField("type",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.type, this._getType().getField("type")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx.model.StructDefinitions.lbVariablePersistenceOnAction;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx.model.StructDefinitions.lbVariablePersistenceOnAction.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static LbVariablePersistenceOnAction _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new LbVariablePersistenceOnAction(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static LbVariablePersistenceOnAction _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new LbVariablePersistenceOnAction(structValue);
    }

    /**
     * Builder class for {@link LbVariablePersistenceOnAction}.
     */
    public static final class Builder {
        private java.lang.String persistenceProfileId;
        private java.lang.Boolean variableHashEnabled;
        private java.lang.String variableName;

        /**
         * Constructor with parameters for the required properties of
         * {@link LbVariablePersistenceOnAction}.
         */
        public Builder() {
        }

        /**
         * If the persistence profile UUID is not specified, a default persistence table is
         * created per virtual server. Currently, only LbGenericPersistenceProfile is
         * supported.
         *
         * @param persistenceProfileId New value for the property.
         */
        public Builder setPersistenceProfileId(java.lang.String persistenceProfileId) {
            this.persistenceProfileId = persistenceProfileId;
            return this;
        }

        /**
         * The property is used to enable a hash operation for variable value when
         * composing the persistence key.
         *
         * @param variableHashEnabled New value for the property.
         */
        public Builder setVariableHashEnabled(java.lang.Boolean variableHashEnabled) {
            this.variableHashEnabled = variableHashEnabled;
            return this;
        }

        /**
         * The property is the name of variable to be used. It specifies which variable's
         * value of a HTTP Request will be used in the key of persistence entry. The
         * variable can be a system embedded variable such as \"_cookie_JSESSIONID\", a
         * customized variable defined in LbVariableAssignmentAction or a captured variable
         * in regular expression such as \"article\".
         *
         * @param variableName New value for the property.
         */
        public Builder setVariableName(java.lang.String variableName) {
            this.variableName = variableName;
            return this;
        }

        public LbVariablePersistenceOnAction build() {
            LbVariablePersistenceOnAction result = new LbVariablePersistenceOnAction();
            result.setPersistenceProfileId(this.persistenceProfileId);
            result.setVariableHashEnabled(this.variableHashEnabled);
            result.setVariableName(this.variableName);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("persistence_profile_id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("persistence_profile_id",
                                                                                "persistenceProfileId",
                                                                                "getPersistenceProfileId",
                                                                                "setPersistenceProfileId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("variable_hash_enabled", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("variable_hash_enabled",
                                                                                "variableHashEnabled",
                                                                                "getVariableHashEnabled",
                                                                                "setVariableHashEnabled");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("variable_name", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("variable_name",
                                                                                "variableName",
                                                                                "getVariableName",
                                                                                "setVariableName");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("type", new com.vmware.vapi.bindings.type.StringType());
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("type",
                                                                                "type",
                                                                                "getType",
                                                                                null);
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx.model.lb_variable_persistence_on_action",
                                                            fields,
                                                            com.vmware.nsx.model.LbVariablePersistenceOnAction.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            "type",
                                                            "LbVariablePersistenceOnAction");
    }
}

