/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx.model;

public final class LoadBalancerAllocationPool implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    /**
     * Identifier denoting this class, when it is used in polymorphic context. 
     * <p>This
     * value should be assigned to the property which is used to discriminate the
     * actual type used in the polymorphic context.</p>
     */
    public static final java.lang.String _TYPE_IDENTIFIER = "LoadBalancerAllocationPool";

    public static final java.lang.String ALLOCATION_SIZE_SMALL = "SMALL";

    public static final java.lang.String ALLOCATION_SIZE_MEDIUM = "MEDIUM";

    public static final java.lang.String ALLOCATION_SIZE_LARGE = "LARGE";

    public static final java.lang.String ALLOCATION_SIZE_XLARGE = "XLARGE";

    private java.lang.String allocationSize;

    private final java.lang.String allocationPoolType = "LoadBalancerAllocationPool";

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public LoadBalancerAllocationPool() {
    }

    protected LoadBalancerAllocationPool(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.LoadBalancerAllocationPool#ALLOCATION_SIZE_SMALL}</li> <li>
     * {@link
     * com.vmware.nsx.model.LoadBalancerAllocationPool#ALLOCATION_SIZE_MEDIUM}</li>
     * <li> {@link
     * com.vmware.nsx.model.LoadBalancerAllocationPool#ALLOCATION_SIZE_LARGE}</li> <li>
     * {@link
     * com.vmware.nsx.model.LoadBalancerAllocationPool#ALLOCATION_SIZE_XLARGE}</li>
     * </ul> To address varied customer performance and scalability requirements,
     * different sizes for load balancer service are supported: SMALL, MEDIUM, LARGE
     * and XLARGE, each with its own set of resource and performance. Specify size of
     * load balancer service which you will bind to TIER1 router.
     *
     * @return The current value of the property.
     */
    public java.lang.String getAllocationSize() {
        return this.allocationSize;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.LoadBalancerAllocationPool#ALLOCATION_SIZE_SMALL}</li> <li>
     * {@link
     * com.vmware.nsx.model.LoadBalancerAllocationPool#ALLOCATION_SIZE_MEDIUM}</li>
     * <li> {@link
     * com.vmware.nsx.model.LoadBalancerAllocationPool#ALLOCATION_SIZE_LARGE}</li> <li>
     * {@link
     * com.vmware.nsx.model.LoadBalancerAllocationPool#ALLOCATION_SIZE_XLARGE}</li>
     * </ul> To address varied customer performance and scalability requirements,
     * different sizes for load balancer service are supported: SMALL, MEDIUM, LARGE
     * and XLARGE, each with its own set of resource and performance. Specify size of
     * load balancer service which you will bind to TIER1 router.
     *
     * @param allocationSize New value for the property.
     */
    public void setAllocationSize(java.lang.String allocationSize) {
        this.allocationSize = allocationSize;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.EdgeClusterMemberAllocationPool#ALLOCATION_POOL_TYPE_LOADBALANCERALLOCATIONPOOL}</li>
     * </ul> Types of logical router allocation pool based on services
     * The value of this property is automatically populated to {@code "LoadBalancerAllocationPool"}.
     *
     * @return The current value of the property.
     */
    public java.lang.String getAllocationPoolType() {
        return this.allocationPoolType;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx.model.StructDefinitions.loadBalancerAllocationPool;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("allocation_size",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.allocationSize, this._getType().getField("allocation_size")));
        structValue.setField("allocation_pool_type",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.allocationPoolType, this._getType().getField("allocation_pool_type")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx.model.StructDefinitions.loadBalancerAllocationPool;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx.model.StructDefinitions.loadBalancerAllocationPool.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static LoadBalancerAllocationPool _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new LoadBalancerAllocationPool(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static LoadBalancerAllocationPool _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new LoadBalancerAllocationPool(structValue);
    }

    /**
     * Builder class for {@link LoadBalancerAllocationPool}.
     */
    public static final class Builder {
        private java.lang.String allocationSize;

        /**
         * Constructor with parameters for the required properties of
         * {@link LoadBalancerAllocationPool}.
         */
        public Builder() {
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx.model.LoadBalancerAllocationPool#ALLOCATION_SIZE_SMALL}</li> <li>
         * {@link
         * com.vmware.nsx.model.LoadBalancerAllocationPool#ALLOCATION_SIZE_MEDIUM}</li>
         * <li> {@link
         * com.vmware.nsx.model.LoadBalancerAllocationPool#ALLOCATION_SIZE_LARGE}</li> <li>
         * {@link
         * com.vmware.nsx.model.LoadBalancerAllocationPool#ALLOCATION_SIZE_XLARGE}</li>
         * </ul> To address varied customer performance and scalability requirements,
         * different sizes for load balancer service are supported: SMALL, MEDIUM, LARGE
         * and XLARGE, each with its own set of resource and performance. Specify size of
         * load balancer service which you will bind to TIER1 router.
         *
         * @param allocationSize New value for the property.
         */
        public Builder setAllocationSize(java.lang.String allocationSize) {
            this.allocationSize = allocationSize;
            return this;
        }

        public LoadBalancerAllocationPool build() {
            LoadBalancerAllocationPool result = new LoadBalancerAllocationPool();
            result.setAllocationSize(this.allocationSize);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("allocation_size", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("allocation_size",
                                                                                "allocationSize",
                                                                                "getAllocationSize",
                                                                                "setAllocationSize");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("allocation_pool_type", new com.vmware.vapi.bindings.type.StringType());
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("allocation_pool_type",
                                                                                "allocationPoolType",
                                                                                "getAllocationPoolType",
                                                                                null);
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx.model.load_balancer_allocation_pool",
                                                            fields,
                                                            com.vmware.nsx.model.LoadBalancerAllocationPool.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            "allocation_pool_type",
                                                            "LoadBalancerAllocationPool");
    }
}

