/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx.model;

/**
 * SNMP Service properties
 */
public final class SnmpServiceProperties implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    public static final java.lang.String V3AUTH_PROTOCOL_SHA1 = "SHA1";

    public static final java.lang.String V3PRIV_PROTOCOL_AES128 = "AES128";

    private java.util.List<java.lang.String> communities;

    private java.lang.Boolean startOnBoot;

    private java.lang.Boolean v2Configured;

    private java.lang.String v3AuthProtocol;

    private java.lang.Boolean v3Configured;

    private java.lang.String v3PrivProtocol;

    private java.util.List<com.vmware.nsx.model.SnmpV3User> v3Users;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public SnmpServiceProperties() {
    }

    protected SnmpServiceProperties(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * SNMP v1, v2c community strings
     *
     * @return The current value of the property.
     */
    public java.util.List<java.lang.String> getCommunities() {
        return this.communities;
    }

    /**
     * SNMP v1, v2c community strings
     *
     * @param communities New value for the property.
     */
    public void setCommunities(java.util.List<java.lang.String> communities) {
        this.communities = communities;
    }

    /**
     * Start when system boots
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getStartOnBoot() {
        return this.startOnBoot;
    }

    /**
     * Start when system boots
     *
     * @param startOnBoot New value for the property.
     */
    public void setStartOnBoot(java.lang.Boolean startOnBoot) {
        this.startOnBoot = startOnBoot;
    }

    /**
     * SNMP v2 is configured or not
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getV2Configured() {
        return this.v2Configured;
    }

    /**
     * SNMP v2 is configured or not
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param v2Configured New value for the property.
     */
    public void setV2Configured(java.lang.Boolean v2Configured) {
        this.v2Configured = v2Configured;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.SnmpServiceProperties#V3AUTH_PROTOCOL_SHA1}</li> </ul> SNMP
     * v3 auth protocol
     *
     * @return The current value of the property.
     */
    public java.lang.String getV3AuthProtocol() {
        return this.v3AuthProtocol;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.SnmpServiceProperties#V3AUTH_PROTOCOL_SHA1}</li> </ul> SNMP
     * v3 auth protocol
     *
     * @param v3AuthProtocol New value for the property.
     */
    public void setV3AuthProtocol(java.lang.String v3AuthProtocol) {
        this.v3AuthProtocol = v3AuthProtocol;
    }

    /**
     * SNMP v3 is configured or not
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getV3Configured() {
        return this.v3Configured;
    }

    /**
     * SNMP v3 is configured or not
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param v3Configured New value for the property.
     */
    public void setV3Configured(java.lang.Boolean v3Configured) {
        this.v3Configured = v3Configured;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.SnmpServiceProperties#V3PRIV_PROTOCOL_AES128}</li> </ul>
     * SNMP v3 private protocol
     *
     * @return The current value of the property.
     */
    public java.lang.String getV3PrivProtocol() {
        return this.v3PrivProtocol;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.SnmpServiceProperties#V3PRIV_PROTOCOL_AES128}</li> </ul>
     * SNMP v3 private protocol
     *
     * @param v3PrivProtocol New value for the property.
     */
    public void setV3PrivProtocol(java.lang.String v3PrivProtocol) {
        this.v3PrivProtocol = v3PrivProtocol;
    }

    /**
     * SNMP v3 users information
     *
     * @return The current value of the property.
     */
    public java.util.List<com.vmware.nsx.model.SnmpV3User> getV3Users() {
        return this.v3Users;
    }

    /**
     * SNMP v3 users information
     *
     * @param v3Users New value for the property.
     */
    public void setV3Users(java.util.List<com.vmware.nsx.model.SnmpV3User> v3Users) {
        this.v3Users = v3Users;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx.model.StructDefinitions.snmpServiceProperties;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("communities",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.communities, this._getType().getField("communities")));
        structValue.setField("start_on_boot",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.startOnBoot, this._getType().getField("start_on_boot")));
        structValue.setField("v2_configured",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.v2Configured, this._getType().getField("v2_configured")));
        structValue.setField("v3_auth_protocol",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.v3AuthProtocol, this._getType().getField("v3_auth_protocol")));
        structValue.setField("v3_configured",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.v3Configured, this._getType().getField("v3_configured")));
        structValue.setField("v3_priv_protocol",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.v3PrivProtocol, this._getType().getField("v3_priv_protocol")));
        structValue.setField("v3_users",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.v3Users, this._getType().getField("v3_users")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx.model.StructDefinitions.snmpServiceProperties;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx.model.StructDefinitions.snmpServiceProperties.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static SnmpServiceProperties _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new SnmpServiceProperties(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static SnmpServiceProperties _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new SnmpServiceProperties(structValue);
    }

    /**
     * Builder class for {@link SnmpServiceProperties}.
     */
    public static final class Builder {
        private java.util.List<java.lang.String> communities;
        private java.lang.Boolean startOnBoot;
        private java.lang.Boolean v2Configured;
        private java.lang.String v3AuthProtocol;
        private java.lang.Boolean v3Configured;
        private java.lang.String v3PrivProtocol;
        private java.util.List<com.vmware.nsx.model.SnmpV3User> v3Users;

        /**
         * Constructor with parameters for the required properties of
         * {@link SnmpServiceProperties}.
         */
        public Builder() {
        }

        /**
         * SNMP v1, v2c community strings
         *
         * @param communities New value for the property.
         */
        public Builder setCommunities(java.util.List<java.lang.String> communities) {
            this.communities = communities;
            return this;
        }

        /**
         * Start when system boots
         *
         * @param startOnBoot New value for the property.
         */
        public Builder setStartOnBoot(java.lang.Boolean startOnBoot) {
            this.startOnBoot = startOnBoot;
            return this;
        }

        /**
         * SNMP v2 is configured or not
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param v2Configured New value for the property.
         */
        public Builder setV2Configured(java.lang.Boolean v2Configured) {
            this.v2Configured = v2Configured;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx.model.SnmpServiceProperties#V3AUTH_PROTOCOL_SHA1}</li> </ul> SNMP
         * v3 auth protocol
         *
         * @param v3AuthProtocol New value for the property.
         */
        public Builder setV3AuthProtocol(java.lang.String v3AuthProtocol) {
            this.v3AuthProtocol = v3AuthProtocol;
            return this;
        }

        /**
         * SNMP v3 is configured or not
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param v3Configured New value for the property.
         */
        public Builder setV3Configured(java.lang.Boolean v3Configured) {
            this.v3Configured = v3Configured;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx.model.SnmpServiceProperties#V3PRIV_PROTOCOL_AES128}</li> </ul>
         * SNMP v3 private protocol
         *
         * @param v3PrivProtocol New value for the property.
         */
        public Builder setV3PrivProtocol(java.lang.String v3PrivProtocol) {
            this.v3PrivProtocol = v3PrivProtocol;
            return this;
        }

        /**
         * SNMP v3 users information
         *
         * @param v3Users New value for the property.
         */
        public Builder setV3Users(java.util.List<com.vmware.nsx.model.SnmpV3User> v3Users) {
            this.v3Users = v3Users;
            return this;
        }

        public SnmpServiceProperties build() {
            SnmpServiceProperties result = new SnmpServiceProperties();
            result.setCommunities(this.communities);
            result.setStartOnBoot(this.startOnBoot);
            result.setV2Configured(this.v2Configured);
            result.setV3AuthProtocol(this.v3AuthProtocol);
            result.setV3Configured(this.v3Configured);
            result.setV3PrivProtocol(this.v3PrivProtocol);
            result.setV3Users(this.v3Users);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("communities", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.StringType())));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("communities",
                                                                                "communities",
                                                                                "getCommunities",
                                                                                "setCommunities");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("start_on_boot", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("start_on_boot",
                                                                                "startOnBoot",
                                                                                "getStartOnBoot",
                                                                                "setStartOnBoot");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("v2_configured", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("v2_configured",
                                                                                "v2Configured",
                                                                                "getV2Configured",
                                                                                "setV2Configured");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("v3_auth_protocol", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("v3_auth_protocol",
                                                                                "v3AuthProtocol",
                                                                                "getV3AuthProtocol",
                                                                                "setV3AuthProtocol");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("v3_configured", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("v3_configured",
                                                                                "v3Configured",
                                                                                "getV3Configured",
                                                                                "setV3Configured");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("v3_priv_protocol", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("v3_priv_protocol",
                                                                                "v3PrivProtocol",
                                                                                "getV3PrivProtocol",
                                                                                "setV3PrivProtocol");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("v3_users", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx.model.StructDefinitions.snmpV3User; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("v3_users",
                                                                                "v3Users",
                                                                                "getV3Users",
                                                                                "setV3Users");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx.model.snmp_service_properties",
                                                            fields,
                                                            com.vmware.nsx.model.SnmpServiceProperties.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

