/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx.model;

/**
 * Details about an existing NSX manager to be migrated
 */
public final class SourceNsxApiEndpoint implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    private java.lang.String authToken;

    private java.lang.String ip;

    private java.lang.String nsxPassword;

    private java.lang.String nsxSyncrole;

    private java.lang.String nsxUsername;

    private java.lang.String nsxVersion;

    private java.lang.String vcIp;

    private java.lang.String vcPassword;

    private java.lang.Long vcPort;

    private java.lang.String vcUsername;

    private java.lang.String vcVersion;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public SourceNsxApiEndpoint() {
    }

    protected SourceNsxApiEndpoint(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * Auth token used to make REST calls to the source NSX API endpoint. This field is
     * not applicable in case of vSphere network migration. Please generate the token
     * with a sufficiently large duration so that it does not expire in the middle of
     * the migration. If it does expire, then the token needs to be refreshed manually
     * by invoking this API again with a new token. Alternatively, you can provide the
     * username/password of the source NSX.
     *
     * @return The current value of the property.
     */
    public java.lang.String getAuthToken() {
        return this.authToken;
    }

    /**
     * Auth token used to make REST calls to the source NSX API endpoint. This field is
     * not applicable in case of vSphere network migration. Please generate the token
     * with a sufficiently large duration so that it does not expire in the middle of
     * the migration. If it does expire, then the token needs to be refreshed manually
     * by invoking this API again with a new token. Alternatively, you can provide the
     * username/password of the source NSX.
     *
     * @param authToken New value for the property.
     */
    public void setAuthToken(java.lang.String authToken) {
        this.authToken = authToken;
    }

    /**
     * IP address or hostname of a source NSX API endpoint. This field is not
     * applicable in case of vSphere network migration. format: hostname-or-ip
     *
     * @return The current value of the property.
     */
    public java.lang.String getIp() {
        return this.ip;
    }

    /**
     * IP address or hostname of a source NSX API endpoint. This field is not
     * applicable in case of vSphere network migration. format: hostname-or-ip
     *
     * @param ip New value for the property.
     */
    public void setIp(java.lang.String ip) {
        this.ip = ip;
    }

    /**
     * Password for connecting to NSX manager. This field is not applicable in case of
     * vSphere network migration.
     *
     * @return The current value of the property.
     */
    public java.lang.String getNsxPassword() {
        return this.nsxPassword;
    }

    /**
     * Password for connecting to NSX manager. This field is not applicable in case of
     * vSphere network migration.
     *
     * @param nsxPassword New value for the property.
     */
    public void setNsxPassword(java.lang.String nsxPassword) {
        this.nsxPassword = nsxPassword;
    }

    /**
     * Signifies Universal Sync role status (STANDALONE, PRIMARY, SECONDARY) of a
     * source NSX API endpoint.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getNsxSyncrole() {
        return this.nsxSyncrole;
    }

    /**
     * Signifies Universal Sync role status (STANDALONE, PRIMARY, SECONDARY) of a
     * source NSX API endpoint.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param nsxSyncrole New value for the property.
     */
    public void setNsxSyncrole(java.lang.String nsxSyncrole) {
        this.nsxSyncrole = nsxSyncrole;
    }

    /**
     * Username for connecting to NSX manager. This field is not applicable in case of
     * vSphere network migration.
     *
     * @return The current value of the property.
     */
    public java.lang.String getNsxUsername() {
        return this.nsxUsername;
    }

    /**
     * Username for connecting to NSX manager. This field is not applicable in case of
     * vSphere network migration.
     *
     * @param nsxUsername New value for the property.
     */
    public void setNsxUsername(java.lang.String nsxUsername) {
        this.nsxUsername = nsxUsername;
    }

    /**
     * Build version (major, minor, patch) of a source NSX API endpoint.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getNsxVersion() {
        return this.nsxVersion;
    }

    /**
     * Build version (major, minor, patch) of a source NSX API endpoint.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param nsxVersion New value for the property.
     */
    public void setNsxVersion(java.lang.String nsxVersion) {
        this.nsxVersion = nsxVersion;
    }

    /**
     * IP address or host name of VC. format: hostname-or-ip
     *
     * @return The current value of the property.
     */
    public java.lang.String getVcIp() {
        return this.vcIp;
    }

    /**
     * IP address or host name of VC. format: hostname-or-ip
     *
     * @param vcIp New value for the property.
     */
    public void setVcIp(java.lang.String vcIp) {
        this.vcIp = vcIp;
    }

    /**
     * Password for connecting to VC.
     *
     * @return The current value of the property.
     */
    public java.lang.String getVcPassword() {
        return this.vcPassword;
    }

    /**
     * Password for connecting to VC.
     *
     * @param vcPassword New value for the property.
     */
    public void setVcPassword(java.lang.String vcPassword) {
        this.vcPassword = vcPassword;
    }

    /**
     * VC port that will be used to fetch details. format: int32
     *
     * @return The current value of the property.
     */
    public java.lang.Long getVcPort() {
        return this.vcPort;
    }

    /**
     * VC port that will be used to fetch details. format: int32
     *
     * @param vcPort New value for the property.
     */
    public void setVcPort(java.lang.Long vcPort) {
        this.vcPort = vcPort;
    }

    /**
     * Username for connecting to VC.
     *
     * @return The current value of the property.
     */
    public java.lang.String getVcUsername() {
        return this.vcUsername;
    }

    /**
     * Username for connecting to VC.
     *
     * @param vcUsername New value for the property.
     */
    public void setVcUsername(java.lang.String vcUsername) {
        this.vcUsername = vcUsername;
    }

    /**
     * Build version of VC.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getVcVersion() {
        return this.vcVersion;
    }

    /**
     * Build version of VC.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param vcVersion New value for the property.
     */
    public void setVcVersion(java.lang.String vcVersion) {
        this.vcVersion = vcVersion;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx.model.StructDefinitions.sourceNsxApiEndpoint;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("auth_token",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.authToken, this._getType().getField("auth_token")));
        structValue.setField("ip",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.ip, this._getType().getField("ip")));
        structValue.setField("nsx_password",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.nsxPassword, this._getType().getField("nsx_password")));
        structValue.setField("nsx_syncrole",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.nsxSyncrole, this._getType().getField("nsx_syncrole")));
        structValue.setField("nsx_username",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.nsxUsername, this._getType().getField("nsx_username")));
        structValue.setField("nsx_version",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.nsxVersion, this._getType().getField("nsx_version")));
        structValue.setField("vc_ip",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.vcIp, this._getType().getField("vc_ip")));
        structValue.setField("vc_password",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.vcPassword, this._getType().getField("vc_password")));
        structValue.setField("vc_port",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.vcPort, this._getType().getField("vc_port")));
        structValue.setField("vc_username",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.vcUsername, this._getType().getField("vc_username")));
        structValue.setField("vc_version",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.vcVersion, this._getType().getField("vc_version")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx.model.StructDefinitions.sourceNsxApiEndpoint;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx.model.StructDefinitions.sourceNsxApiEndpoint.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static SourceNsxApiEndpoint _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new SourceNsxApiEndpoint(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static SourceNsxApiEndpoint _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new SourceNsxApiEndpoint(structValue);
    }

    /**
     * Builder class for {@link SourceNsxApiEndpoint}.
     */
    public static final class Builder {
        private java.lang.String authToken;
        private java.lang.String ip;
        private java.lang.String nsxPassword;
        private java.lang.String nsxSyncrole;
        private java.lang.String nsxUsername;
        private java.lang.String nsxVersion;
        private java.lang.String vcIp;
        private java.lang.String vcPassword;
        private java.lang.Long vcPort;
        private java.lang.String vcUsername;
        private java.lang.String vcVersion;

        /**
         * Constructor with parameters for the required properties of
         * {@link SourceNsxApiEndpoint}.
         */
        public Builder() {
        }

        /**
         * Auth token used to make REST calls to the source NSX API endpoint. This field is
         * not applicable in case of vSphere network migration. Please generate the token
         * with a sufficiently large duration so that it does not expire in the middle of
         * the migration. If it does expire, then the token needs to be refreshed manually
         * by invoking this API again with a new token. Alternatively, you can provide the
         * username/password of the source NSX.
         *
         * @param authToken New value for the property.
         */
        public Builder setAuthToken(java.lang.String authToken) {
            this.authToken = authToken;
            return this;
        }

        /**
         * IP address or hostname of a source NSX API endpoint. This field is not
         * applicable in case of vSphere network migration. format: hostname-or-ip
         *
         * @param ip New value for the property.
         */
        public Builder setIp(java.lang.String ip) {
            this.ip = ip;
            return this;
        }

        /**
         * Password for connecting to NSX manager. This field is not applicable in case of
         * vSphere network migration.
         *
         * @param nsxPassword New value for the property.
         */
        public Builder setNsxPassword(java.lang.String nsxPassword) {
            this.nsxPassword = nsxPassword;
            return this;
        }

        /**
         * Signifies Universal Sync role status (STANDALONE, PRIMARY, SECONDARY) of a
         * source NSX API endpoint.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param nsxSyncrole New value for the property.
         */
        public Builder setNsxSyncrole(java.lang.String nsxSyncrole) {
            this.nsxSyncrole = nsxSyncrole;
            return this;
        }

        /**
         * Username for connecting to NSX manager. This field is not applicable in case of
         * vSphere network migration.
         *
         * @param nsxUsername New value for the property.
         */
        public Builder setNsxUsername(java.lang.String nsxUsername) {
            this.nsxUsername = nsxUsername;
            return this;
        }

        /**
         * Build version (major, minor, patch) of a source NSX API endpoint.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param nsxVersion New value for the property.
         */
        public Builder setNsxVersion(java.lang.String nsxVersion) {
            this.nsxVersion = nsxVersion;
            return this;
        }

        /**
         * IP address or host name of VC. format: hostname-or-ip
         *
         * @param vcIp New value for the property.
         */
        public Builder setVcIp(java.lang.String vcIp) {
            this.vcIp = vcIp;
            return this;
        }

        /**
         * Password for connecting to VC.
         *
         * @param vcPassword New value for the property.
         */
        public Builder setVcPassword(java.lang.String vcPassword) {
            this.vcPassword = vcPassword;
            return this;
        }

        /**
         * VC port that will be used to fetch details. format: int32
         *
         * @param vcPort New value for the property.
         */
        public Builder setVcPort(java.lang.Long vcPort) {
            this.vcPort = vcPort;
            return this;
        }

        /**
         * Username for connecting to VC.
         *
         * @param vcUsername New value for the property.
         */
        public Builder setVcUsername(java.lang.String vcUsername) {
            this.vcUsername = vcUsername;
            return this;
        }

        /**
         * Build version of VC.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param vcVersion New value for the property.
         */
        public Builder setVcVersion(java.lang.String vcVersion) {
            this.vcVersion = vcVersion;
            return this;
        }

        public SourceNsxApiEndpoint build() {
            SourceNsxApiEndpoint result = new SourceNsxApiEndpoint();
            result.setAuthToken(this.authToken);
            result.setIp(this.ip);
            result.setNsxPassword(this.nsxPassword);
            result.setNsxSyncrole(this.nsxSyncrole);
            result.setNsxUsername(this.nsxUsername);
            result.setNsxVersion(this.nsxVersion);
            result.setVcIp(this.vcIp);
            result.setVcPassword(this.vcPassword);
            result.setVcPort(this.vcPort);
            result.setVcUsername(this.vcUsername);
            result.setVcVersion(this.vcVersion);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("auth_token", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("auth_token",
                                                                                "authToken",
                                                                                "getAuthToken",
                                                                                "setAuthToken");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("ip", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("ip",
                                                                                "ip",
                                                                                "getIp",
                                                                                "setIp");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("nsx_password", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("nsx_password",
                                                                                "nsxPassword",
                                                                                "getNsxPassword",
                                                                                "setNsxPassword");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("nsx_syncrole", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("nsx_syncrole",
                                                                                "nsxSyncrole",
                                                                                "getNsxSyncrole",
                                                                                "setNsxSyncrole");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("nsx_username", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("nsx_username",
                                                                                "nsxUsername",
                                                                                "getNsxUsername",
                                                                                "setNsxUsername");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("nsx_version", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("nsx_version",
                                                                                "nsxVersion",
                                                                                "getNsxVersion",
                                                                                "setNsxVersion");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("vc_ip", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("vc_ip",
                                                                                "vcIp",
                                                                                "getVcIp",
                                                                                "setVcIp");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("vc_password", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("vc_password",
                                                                                "vcPassword",
                                                                                "getVcPassword",
                                                                                "setVcPassword");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("vc_port", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("vc_port",
                                                                                "vcPort",
                                                                                "getVcPort",
                                                                                "setVcPort");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("vc_username", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("vc_username",
                                                                                "vcUsername",
                                                                                "getVcUsername",
                                                                                "setVcUsername");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("vc_version", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("vc_version",
                                                                                "vcVersion",
                                                                                "getVcVersion",
                                                                                "setVcVersion");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx.model.source_nsx_api_endpoint",
                                                            fields,
                                                            com.vmware.nsx.model.SourceNsxApiEndpoint.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

