/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx.model;

/**
 * Possible values of a mode in a \"/config/nsx_appliance_mode\" file
 */
public final class SwitchingToVmcModeParameters implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    public static final java.lang.String MODE_ID_ON_PREM = "ON_PREM";

    public static final java.lang.String MODE_ID_SERVICE = "SERVICE";

    public static final java.lang.String MODE_ID_VMC = "VMC";

    public static final java.lang.String MODE_ID_VMC_LOCAL = "VMC_LOCAL";

    public static final java.lang.String RESOURCE_TYPE_SWITCHINGTOVMCMODEPARAMETERS = "SwitchingToVmcModeParameters";

    private java.lang.String modeId;

    private com.vmware.nsx.model.Oauth2Credentials authCode;

    private java.lang.String baseUrl;

    private java.util.List<java.lang.String> basicAuthWhitelistIps;

    private java.lang.String cspAccessTokenUri;

    private com.vmware.nsx.model.Oauth2Credentials cspClientCredential;

    private java.util.List<java.lang.String> cspClientIncomingCredentials;

    private java.lang.String cspLogoutUri;

    private java.lang.String cspOrgUri;

    private java.lang.String cspPublicKeyUri;

    private java.lang.Long cspTimeDrift;

    private java.lang.String cspUserAuthorizationUri;

    private java.lang.String cspUserInfoUri;

    private java.lang.String defaultOrgId;

    private com.vmware.nsx.model.OrgInfo eaOrg;

    private com.vmware.nsx.model.OrgInfo gssOrg;

    private java.lang.Boolean modeChangeOnly;

    private java.lang.String proxyHost;

    private java.lang.Long proxyPort;

    private com.vmware.nsx.model.PublicClientInfo publicClientInfo;

    private java.lang.String resourceType;

    private java.lang.String sddcId;

    private java.lang.String serviceDefinitionId;

    private com.vmware.nsx.model.OrgInfo sreOrg;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public SwitchingToVmcModeParameters() {
    }

    protected SwitchingToVmcModeParameters(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.SwitchingToVmcModeParameters#MODE_ID_ON_PREM}</li> <li>
     * {@link com.vmware.nsx.model.SwitchingToVmcModeParameters#MODE_ID_SERVICE}</li>
     * <li> {@link com.vmware.nsx.model.SwitchingToVmcModeParameters#MODE_ID_VMC}</li>
     * <li> {@link
     * com.vmware.nsx.model.SwitchingToVmcModeParameters#MODE_ID_VMC_LOCAL}</li> </ul>
     * Possible enum values in a \"/config/nsx_appliance_mode\" file
     *
     * @return The current value of the property.
     */
    public java.lang.String getModeId() {
        return this.modeId;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.SwitchingToVmcModeParameters#MODE_ID_ON_PREM}</li> <li>
     * {@link com.vmware.nsx.model.SwitchingToVmcModeParameters#MODE_ID_SERVICE}</li>
     * <li> {@link com.vmware.nsx.model.SwitchingToVmcModeParameters#MODE_ID_VMC}</li>
     * <li> {@link
     * com.vmware.nsx.model.SwitchingToVmcModeParameters#MODE_ID_VMC_LOCAL}</li> </ul>
     * Possible enum values in a \"/config/nsx_appliance_mode\" file
     *
     * @param modeId New value for the property.
     */
    public void setModeId(java.lang.String modeId) {
        this.modeId = modeId;
    }

    /**
     *
     *
     * @return The current value of the property.
     */
    public com.vmware.nsx.model.Oauth2Credentials getAuthCode() {
        return this.authCode;
    }

    /**
     *
     *
     * @param authCode New value for the property.
     */
    public void setAuthCode(com.vmware.nsx.model.Oauth2Credentials authCode) {
        this.authCode = authCode;
    }

    /**
     * Protocol and domain name (or IP address) of a CSP server, like
     * \"https://console-stg.cloud.vmware.com\".
     *
     * @return The current value of the property.
     */
    public java.lang.String getBaseUrl() {
        return this.baseUrl;
    }

    /**
     * Protocol and domain name (or IP address) of a CSP server, like
     * \"https://console-stg.cloud.vmware.com\".
     *
     * @param baseUrl New value for the property.
     */
    public void setBaseUrl(java.lang.String baseUrl) {
        this.baseUrl = baseUrl;
    }

    /**
     * List of whitelist IPs for basic auth
     *
     * @return The current value of the property.
     */
    public java.util.List<java.lang.String> getBasicAuthWhitelistIps() {
        return this.basicAuthWhitelistIps;
    }

    /**
     * List of whitelist IPs for basic auth
     *
     * @param basicAuthWhitelistIps New value for the property.
     */
    public void setBasicAuthWhitelistIps(java.util.List<java.lang.String> basicAuthWhitelistIps) {
        this.basicAuthWhitelistIps = basicAuthWhitelistIps;
    }

    /**
     * This CSP end-point exchanges one of the following grants - authorization_code,
     * refresh_token, client_credentials or client_delegate for an access token.
     *
     * @return The current value of the property.
     */
    public java.lang.String getCspAccessTokenUri() {
        return this.cspAccessTokenUri;
    }

    /**
     * This CSP end-point exchanges one of the following grants - authorization_code,
     * refresh_token, client_credentials or client_delegate for an access token.
     *
     * @param cspAccessTokenUri New value for the property.
     */
    public void setCspAccessTokenUri(java.lang.String cspAccessTokenUri) {
        this.cspAccessTokenUri = cspAccessTokenUri;
    }

    /**
     *
     *
     * @return The current value of the property.
     */
    public com.vmware.nsx.model.Oauth2Credentials getCspClientCredential() {
        return this.cspClientCredential;
    }

    /**
     *
     *
     * @param cspClientCredential New value for the property.
     */
    public void setCspClientCredential(com.vmware.nsx.model.Oauth2Credentials cspClientCredential) {
        this.cspClientCredential = cspClientCredential;
    }

    /**
     * List of incoming client IDs
     *
     * @return The current value of the property.
     */
    public java.util.List<java.lang.String> getCspClientIncomingCredentials() {
        return this.cspClientIncomingCredentials;
    }

    /**
     * List of incoming client IDs
     *
     * @param cspClientIncomingCredentials New value for the property.
     */
    public void setCspClientIncomingCredentials(java.util.List<java.lang.String> cspClientIncomingCredentials) {
        this.cspClientIncomingCredentials = cspClientIncomingCredentials;
    }

    /**
     * This CSP end-point returns the identity provider's logout url. In order to
     * logout, an explicit redirect to this url is needed.
     *
     * @return The current value of the property.
     */
    public java.lang.String getCspLogoutUri() {
        return this.cspLogoutUri;
    }

    /**
     * This CSP end-point returns the identity provider's logout url. In order to
     * logout, an explicit redirect to this url is needed.
     *
     * @param cspLogoutUri New value for the property.
     */
    public void setCspLogoutUri(java.lang.String cspLogoutUri) {
        this.cspLogoutUri = cspLogoutUri;
    }

    /**
     * Relative path on CSP server to the Org location. Can be
     * \"/csp/gateway/am/api/orgs/\".
     *
     * @return The current value of the property.
     */
    public java.lang.String getCspOrgUri() {
        return this.cspOrgUri;
    }

    /**
     * Relative path on CSP server to the Org location. Can be
     * \"/csp/gateway/am/api/orgs/\".
     *
     * @param cspOrgUri New value for the property.
     */
    public void setCspOrgUri(java.lang.String cspOrgUri) {
        this.cspOrgUri = cspOrgUri;
    }

    /**
     * CSP endpoint that returns a list of public keys in jwks format. These keys are
     * used in an application to validate that the access-token is valid.
     *
     * @return The current value of the property.
     */
    public java.lang.String getCspPublicKeyUri() {
        return this.cspPublicKeyUri;
    }

    /**
     * CSP endpoint that returns a list of public keys in jwks format. These keys are
     * used in an application to validate that the access-token is valid.
     *
     * @param cspPublicKeyUri New value for the property.
     */
    public void setCspPublicKeyUri(java.lang.String cspPublicKeyUri) {
        this.cspPublicKeyUri = cspPublicKeyUri;
    }

    /**
     * CSP time drift in milliseconds format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getCspTimeDrift() {
        return this.cspTimeDrift;
    }

    /**
     * CSP time drift in milliseconds format: int64
     *
     * @param cspTimeDrift New value for the property.
     */
    public void setCspTimeDrift(java.lang.Long cspTimeDrift) {
        this.cspTimeDrift = cspTimeDrift;
    }

    /**
     * This endpoint is used with browser redirection only. It discovers the user's
     * Identity Provider (IdP) and sends the user to the IdP login page. It is the
     * starting point of the OAuth 2.0 flow to authenticate end users from an
     * application.
     *
     * @return The current value of the property.
     */
    public java.lang.String getCspUserAuthorizationUri() {
        return this.cspUserAuthorizationUri;
    }

    /**
     * This endpoint is used with browser redirection only. It discovers the user's
     * Identity Provider (IdP) and sends the user to the IdP login page. It is the
     * starting point of the OAuth 2.0 flow to authenticate end users from an
     * application.
     *
     * @param cspUserAuthorizationUri New value for the property.
     */
    public void setCspUserAuthorizationUri(java.lang.String cspUserAuthorizationUri) {
        this.cspUserAuthorizationUri = cspUserAuthorizationUri;
    }

    /**
     * This endpoint returns the content of the given access token if the token is
     * valid. It also includes the group_ids and group_names if the client is
     * registered with group_id, group_names scopes. It's usually /am/api/userinfo.
     *
     * @return The current value of the property.
     */
    public java.lang.String getCspUserInfoUri() {
        return this.cspUserInfoUri;
    }

    /**
     * This endpoint returns the content of the given access token if the token is
     * valid. It also includes the group_ids and group_names if the client is
     * registered with group_id, group_names scopes. It's usually /am/api/userinfo.
     *
     * @param cspUserInfoUri New value for the property.
     */
    public void setCspUserInfoUri(java.lang.String cspUserInfoUri) {
        this.cspUserInfoUri = cspUserInfoUri;
    }

    /**
     * Org ID of a Client - commonly UUID.
     *
     * @return The current value of the property.
     */
    public java.lang.String getDefaultOrgId() {
        return this.defaultOrgId;
    }

    /**
     * Org ID of a Client - commonly UUID.
     *
     * @param defaultOrgId New value for the property.
     */
    public void setDefaultOrgId(java.lang.String defaultOrgId) {
        this.defaultOrgId = defaultOrgId;
    }

    /**
     *
     *
     * @return The current value of the property.
     */
    public com.vmware.nsx.model.OrgInfo getEaOrg() {
        return this.eaOrg;
    }

    /**
     *
     *
     * @param eaOrg New value for the property.
     */
    public void setEaOrg(com.vmware.nsx.model.OrgInfo eaOrg) {
        this.eaOrg = eaOrg;
    }

    /**
     *
     *
     * @return The current value of the property.
     */
    public com.vmware.nsx.model.OrgInfo getGssOrg() {
        return this.gssOrg;
    }

    /**
     *
     *
     * @param gssOrg New value for the property.
     */
    public void setGssOrg(com.vmware.nsx.model.OrgInfo gssOrg) {
        this.gssOrg = gssOrg;
    }

    /**
     * When this parameter is set to true, only a change of the node mode happens
     * without any update to the auth properties. When this param is not set to true
     * i.e. set to false or not provided, mode change and update to the auth properties
     * will both happen.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getModeChangeOnly() {
        return this.modeChangeOnly;
    }

    /**
     * When this parameter is set to true, only a change of the node mode happens
     * without any update to the auth properties. When this param is not set to true
     * i.e. set to false or not provided, mode change and update to the auth properties
     * will both happen.
     *
     * @param modeChangeOnly New value for the property.
     */
    public void setModeChangeOnly(java.lang.Boolean modeChangeOnly) {
        this.modeChangeOnly = modeChangeOnly;
    }

    /**
     * IP/host of PoP (Point-of-Presence) HTTP proxy server format: hostname-or-ip
     *
     * @return The current value of the property.
     */
    public java.lang.String getProxyHost() {
        return this.proxyHost;
    }

    /**
     * IP/host of PoP (Point-of-Presence) HTTP proxy server format: hostname-or-ip
     *
     * @param proxyHost New value for the property.
     */
    public void setProxyHost(java.lang.String proxyHost) {
        this.proxyHost = proxyHost;
    }

    /**
     * Port of PoP (Point-of-Presence) Http proxy server format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getProxyPort() {
        return this.proxyPort;
    }

    /**
     * Port of PoP (Point-of-Presence) Http proxy server format: int64
     *
     * @param proxyPort New value for the property.
     */
    public void setProxyPort(java.lang.Long proxyPort) {
        this.proxyPort = proxyPort;
    }

    /**
     *
     *
     * @return The current value of the property.
     */
    public com.vmware.nsx.model.PublicClientInfo getPublicClientInfo() {
        return this.publicClientInfo;
    }

    /**
     *
     *
     * @param publicClientInfo New value for the property.
     */
    public void setPublicClientInfo(com.vmware.nsx.model.PublicClientInfo publicClientInfo) {
        this.publicClientInfo = publicClientInfo;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.SwitchingToVmcModeParameters#RESOURCE_TYPE_SWITCHINGTOVMCMODEPARAMETERS}</li>
     * </ul> Node Mode type
     *
     * @return The current value of the property.
     */
    public java.lang.String getResourceType() {
        return this.resourceType;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.SwitchingToVmcModeParameters#RESOURCE_TYPE_SWITCHINGTOVMCMODEPARAMETERS}</li>
     * </ul> Node Mode type
     *
     * @param resourceType New value for the property.
     */
    public void setResourceType(java.lang.String resourceType) {
        this.resourceType = resourceType;
    }

    /**
     * SDDC id
     *
     * @return The current value of the property.
     */
    public java.lang.String getSddcId() {
        return this.sddcId;
    }

    /**
     * SDDC id
     *
     * @param sddcId New value for the property.
     */
    public void setSddcId(java.lang.String sddcId) {
        this.sddcId = sddcId;
    }

    /**
     * Service definition id
     *
     * @return The current value of the property.
     */
    public java.lang.String getServiceDefinitionId() {
        return this.serviceDefinitionId;
    }

    /**
     * Service definition id
     *
     * @param serviceDefinitionId New value for the property.
     */
    public void setServiceDefinitionId(java.lang.String serviceDefinitionId) {
        this.serviceDefinitionId = serviceDefinitionId;
    }

    /**
     *
     *
     * @return The current value of the property.
     */
    public com.vmware.nsx.model.OrgInfo getSreOrg() {
        return this.sreOrg;
    }

    /**
     *
     *
     * @param sreOrg New value for the property.
     */
    public void setSreOrg(com.vmware.nsx.model.OrgInfo sreOrg) {
        this.sreOrg = sreOrg;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx.model.StructDefinitions.switchingToVmcModeParameters;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("mode_id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.modeId, this._getType().getField("mode_id")));
        structValue.setField("auth_code",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.authCode, this._getType().getField("auth_code")));
        structValue.setField("base_url",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.baseUrl, this._getType().getField("base_url")));
        structValue.setField("basic_auth_whitelist_ips",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.basicAuthWhitelistIps, this._getType().getField("basic_auth_whitelist_ips")));
        structValue.setField("csp_access_token_uri",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.cspAccessTokenUri, this._getType().getField("csp_access_token_uri")));
        structValue.setField("csp_client_credential",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.cspClientCredential, this._getType().getField("csp_client_credential")));
        structValue.setField("csp_client_incoming_credentials",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.cspClientIncomingCredentials, this._getType().getField("csp_client_incoming_credentials")));
        structValue.setField("csp_logout_uri",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.cspLogoutUri, this._getType().getField("csp_logout_uri")));
        structValue.setField("csp_org_uri",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.cspOrgUri, this._getType().getField("csp_org_uri")));
        structValue.setField("csp_public_key_uri",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.cspPublicKeyUri, this._getType().getField("csp_public_key_uri")));
        structValue.setField("csp_time_drift",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.cspTimeDrift, this._getType().getField("csp_time_drift")));
        structValue.setField("csp_user_authorization_uri",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.cspUserAuthorizationUri, this._getType().getField("csp_user_authorization_uri")));
        structValue.setField("csp_user_info_uri",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.cspUserInfoUri, this._getType().getField("csp_user_info_uri")));
        structValue.setField("default_org_id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.defaultOrgId, this._getType().getField("default_org_id")));
        structValue.setField("ea_org",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.eaOrg, this._getType().getField("ea_org")));
        structValue.setField("gss_org",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.gssOrg, this._getType().getField("gss_org")));
        structValue.setField("mode_change_only",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.modeChangeOnly, this._getType().getField("mode_change_only")));
        structValue.setField("proxy_host",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.proxyHost, this._getType().getField("proxy_host")));
        structValue.setField("proxy_port",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.proxyPort, this._getType().getField("proxy_port")));
        structValue.setField("public_client_info",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.publicClientInfo, this._getType().getField("public_client_info")));
        structValue.setField("resource_type",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.resourceType, this._getType().getField("resource_type")));
        structValue.setField("sddc_id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.sddcId, this._getType().getField("sddc_id")));
        structValue.setField("service_definition_id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.serviceDefinitionId, this._getType().getField("service_definition_id")));
        structValue.setField("sre_org",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.sreOrg, this._getType().getField("sre_org")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx.model.StructDefinitions.switchingToVmcModeParameters;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx.model.StructDefinitions.switchingToVmcModeParameters.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static SwitchingToVmcModeParameters _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new SwitchingToVmcModeParameters(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static SwitchingToVmcModeParameters _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new SwitchingToVmcModeParameters(structValue);
    }

    /**
     * Builder class for {@link SwitchingToVmcModeParameters}.
     */
    public static final class Builder {
        private java.lang.String modeId;
        private com.vmware.nsx.model.Oauth2Credentials authCode;
        private java.lang.String baseUrl;
        private java.util.List<java.lang.String> basicAuthWhitelistIps;
        private java.lang.String cspAccessTokenUri;
        private com.vmware.nsx.model.Oauth2Credentials cspClientCredential;
        private java.util.List<java.lang.String> cspClientIncomingCredentials;
        private java.lang.String cspLogoutUri;
        private java.lang.String cspOrgUri;
        private java.lang.String cspPublicKeyUri;
        private java.lang.Long cspTimeDrift;
        private java.lang.String cspUserAuthorizationUri;
        private java.lang.String cspUserInfoUri;
        private java.lang.String defaultOrgId;
        private com.vmware.nsx.model.OrgInfo eaOrg;
        private com.vmware.nsx.model.OrgInfo gssOrg;
        private java.lang.Boolean modeChangeOnly;
        private java.lang.String proxyHost;
        private java.lang.Long proxyPort;
        private com.vmware.nsx.model.PublicClientInfo publicClientInfo;
        private java.lang.String resourceType;
        private java.lang.String sddcId;
        private java.lang.String serviceDefinitionId;
        private com.vmware.nsx.model.OrgInfo sreOrg;

        /**
         * Constructor with parameters for the required properties of
         * {@link SwitchingToVmcModeParameters}.
         */
        public Builder() {
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx.model.SwitchingToVmcModeParameters#MODE_ID_ON_PREM}</li> <li>
         * {@link com.vmware.nsx.model.SwitchingToVmcModeParameters#MODE_ID_SERVICE}</li>
         * <li> {@link com.vmware.nsx.model.SwitchingToVmcModeParameters#MODE_ID_VMC}</li>
         * <li> {@link
         * com.vmware.nsx.model.SwitchingToVmcModeParameters#MODE_ID_VMC_LOCAL}</li> </ul>
         * Possible enum values in a \"/config/nsx_appliance_mode\" file
         *
         * @param modeId New value for the property.
         */
        public Builder setModeId(java.lang.String modeId) {
            this.modeId = modeId;
            return this;
        }

        /**
         *
         *
         * @param authCode New value for the property.
         */
        public Builder setAuthCode(com.vmware.nsx.model.Oauth2Credentials authCode) {
            this.authCode = authCode;
            return this;
        }

        /**
         * Protocol and domain name (or IP address) of a CSP server, like
         * \"https://console-stg.cloud.vmware.com\".
         *
         * @param baseUrl New value for the property.
         */
        public Builder setBaseUrl(java.lang.String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        /**
         * List of whitelist IPs for basic auth
         *
         * @param basicAuthWhitelistIps New value for the property.
         */
        public Builder setBasicAuthWhitelistIps(java.util.List<java.lang.String> basicAuthWhitelistIps) {
            this.basicAuthWhitelistIps = basicAuthWhitelistIps;
            return this;
        }

        /**
         * This CSP end-point exchanges one of the following grants - authorization_code,
         * refresh_token, client_credentials or client_delegate for an access token.
         *
         * @param cspAccessTokenUri New value for the property.
         */
        public Builder setCspAccessTokenUri(java.lang.String cspAccessTokenUri) {
            this.cspAccessTokenUri = cspAccessTokenUri;
            return this;
        }

        /**
         *
         *
         * @param cspClientCredential New value for the property.
         */
        public Builder setCspClientCredential(com.vmware.nsx.model.Oauth2Credentials cspClientCredential) {
            this.cspClientCredential = cspClientCredential;
            return this;
        }

        /**
         * List of incoming client IDs
         *
         * @param cspClientIncomingCredentials New value for the property.
         */
        public Builder setCspClientIncomingCredentials(java.util.List<java.lang.String> cspClientIncomingCredentials) {
            this.cspClientIncomingCredentials = cspClientIncomingCredentials;
            return this;
        }

        /**
         * This CSP end-point returns the identity provider's logout url. In order to
         * logout, an explicit redirect to this url is needed.
         *
         * @param cspLogoutUri New value for the property.
         */
        public Builder setCspLogoutUri(java.lang.String cspLogoutUri) {
            this.cspLogoutUri = cspLogoutUri;
            return this;
        }

        /**
         * Relative path on CSP server to the Org location. Can be
         * \"/csp/gateway/am/api/orgs/\".
         *
         * @param cspOrgUri New value for the property.
         */
        public Builder setCspOrgUri(java.lang.String cspOrgUri) {
            this.cspOrgUri = cspOrgUri;
            return this;
        }

        /**
         * CSP endpoint that returns a list of public keys in jwks format. These keys are
         * used in an application to validate that the access-token is valid.
         *
         * @param cspPublicKeyUri New value for the property.
         */
        public Builder setCspPublicKeyUri(java.lang.String cspPublicKeyUri) {
            this.cspPublicKeyUri = cspPublicKeyUri;
            return this;
        }

        /**
         * CSP time drift in milliseconds format: int64
         *
         * @param cspTimeDrift New value for the property.
         */
        public Builder setCspTimeDrift(java.lang.Long cspTimeDrift) {
            this.cspTimeDrift = cspTimeDrift;
            return this;
        }

        /**
         * This endpoint is used with browser redirection only. It discovers the user's
         * Identity Provider (IdP) and sends the user to the IdP login page. It is the
         * starting point of the OAuth 2.0 flow to authenticate end users from an
         * application.
         *
         * @param cspUserAuthorizationUri New value for the property.
         */
        public Builder setCspUserAuthorizationUri(java.lang.String cspUserAuthorizationUri) {
            this.cspUserAuthorizationUri = cspUserAuthorizationUri;
            return this;
        }

        /**
         * This endpoint returns the content of the given access token if the token is
         * valid. It also includes the group_ids and group_names if the client is
         * registered with group_id, group_names scopes. It's usually /am/api/userinfo.
         *
         * @param cspUserInfoUri New value for the property.
         */
        public Builder setCspUserInfoUri(java.lang.String cspUserInfoUri) {
            this.cspUserInfoUri = cspUserInfoUri;
            return this;
        }

        /**
         * Org ID of a Client - commonly UUID.
         *
         * @param defaultOrgId New value for the property.
         */
        public Builder setDefaultOrgId(java.lang.String defaultOrgId) {
            this.defaultOrgId = defaultOrgId;
            return this;
        }

        /**
         *
         *
         * @param eaOrg New value for the property.
         */
        public Builder setEaOrg(com.vmware.nsx.model.OrgInfo eaOrg) {
            this.eaOrg = eaOrg;
            return this;
        }

        /**
         *
         *
         * @param gssOrg New value for the property.
         */
        public Builder setGssOrg(com.vmware.nsx.model.OrgInfo gssOrg) {
            this.gssOrg = gssOrg;
            return this;
        }

        /**
         * When this parameter is set to true, only a change of the node mode happens
         * without any update to the auth properties. When this param is not set to true
         * i.e. set to false or not provided, mode change and update to the auth properties
         * will both happen.
         *
         * @param modeChangeOnly New value for the property.
         */
        public Builder setModeChangeOnly(java.lang.Boolean modeChangeOnly) {
            this.modeChangeOnly = modeChangeOnly;
            return this;
        }

        /**
         * IP/host of PoP (Point-of-Presence) HTTP proxy server format: hostname-or-ip
         *
         * @param proxyHost New value for the property.
         */
        public Builder setProxyHost(java.lang.String proxyHost) {
            this.proxyHost = proxyHost;
            return this;
        }

        /**
         * Port of PoP (Point-of-Presence) Http proxy server format: int64
         *
         * @param proxyPort New value for the property.
         */
        public Builder setProxyPort(java.lang.Long proxyPort) {
            this.proxyPort = proxyPort;
            return this;
        }

        /**
         *
         *
         * @param publicClientInfo New value for the property.
         */
        public Builder setPublicClientInfo(com.vmware.nsx.model.PublicClientInfo publicClientInfo) {
            this.publicClientInfo = publicClientInfo;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx.model.SwitchingToVmcModeParameters#RESOURCE_TYPE_SWITCHINGTOVMCMODEPARAMETERS}</li>
         * </ul> Node Mode type
         *
         * @param resourceType New value for the property.
         */
        public Builder setResourceType(java.lang.String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        /**
         * SDDC id
         *
         * @param sddcId New value for the property.
         */
        public Builder setSddcId(java.lang.String sddcId) {
            this.sddcId = sddcId;
            return this;
        }

        /**
         * Service definition id
         *
         * @param serviceDefinitionId New value for the property.
         */
        public Builder setServiceDefinitionId(java.lang.String serviceDefinitionId) {
            this.serviceDefinitionId = serviceDefinitionId;
            return this;
        }

        /**
         *
         *
         * @param sreOrg New value for the property.
         */
        public Builder setSreOrg(com.vmware.nsx.model.OrgInfo sreOrg) {
            this.sreOrg = sreOrg;
            return this;
        }

        public SwitchingToVmcModeParameters build() {
            SwitchingToVmcModeParameters result = new SwitchingToVmcModeParameters();
            result.setModeId(this.modeId);
            result.setAuthCode(this.authCode);
            result.setBaseUrl(this.baseUrl);
            result.setBasicAuthWhitelistIps(this.basicAuthWhitelistIps);
            result.setCspAccessTokenUri(this.cspAccessTokenUri);
            result.setCspClientCredential(this.cspClientCredential);
            result.setCspClientIncomingCredentials(this.cspClientIncomingCredentials);
            result.setCspLogoutUri(this.cspLogoutUri);
            result.setCspOrgUri(this.cspOrgUri);
            result.setCspPublicKeyUri(this.cspPublicKeyUri);
            result.setCspTimeDrift(this.cspTimeDrift);
            result.setCspUserAuthorizationUri(this.cspUserAuthorizationUri);
            result.setCspUserInfoUri(this.cspUserInfoUri);
            result.setDefaultOrgId(this.defaultOrgId);
            result.setEaOrg(this.eaOrg);
            result.setGssOrg(this.gssOrg);
            result.setModeChangeOnly(this.modeChangeOnly);
            result.setProxyHost(this.proxyHost);
            result.setProxyPort(this.proxyPort);
            result.setPublicClientInfo(this.publicClientInfo);
            result.setResourceType(this.resourceType);
            result.setSddcId(this.sddcId);
            result.setServiceDefinitionId(this.serviceDefinitionId);
            result.setSreOrg(this.sreOrg);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("mode_id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("mode_id",
                                                                                "modeId",
                                                                                "getModeId",
                                                                                "setModeId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("auth_code", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx.model.StructDefinitions.oauth2Credentials; } }));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("auth_code",
                                                                                "authCode",
                                                                                "getAuthCode",
                                                                                "setAuthCode");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("base_url", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("base_url",
                                                                                "baseUrl",
                                                                                "getBaseUrl",
                                                                                "setBaseUrl");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("basic_auth_whitelist_ips", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.StringType())));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("basic_auth_whitelist_ips",
                                                                                "basicAuthWhitelistIps",
                                                                                "getBasicAuthWhitelistIps",
                                                                                "setBasicAuthWhitelistIps");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("csp_access_token_uri", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("csp_access_token_uri",
                                                                                "cspAccessTokenUri",
                                                                                "getCspAccessTokenUri",
                                                                                "setCspAccessTokenUri");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("csp_client_credential", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx.model.StructDefinitions.oauth2Credentials; } }));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("csp_client_credential",
                                                                                "cspClientCredential",
                                                                                "getCspClientCredential",
                                                                                "setCspClientCredential");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("csp_client_incoming_credentials", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.StringType())));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("csp_client_incoming_credentials",
                                                                                "cspClientIncomingCredentials",
                                                                                "getCspClientIncomingCredentials",
                                                                                "setCspClientIncomingCredentials");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("csp_logout_uri", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("csp_logout_uri",
                                                                                "cspLogoutUri",
                                                                                "getCspLogoutUri",
                                                                                "setCspLogoutUri");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("csp_org_uri", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("csp_org_uri",
                                                                                "cspOrgUri",
                                                                                "getCspOrgUri",
                                                                                "setCspOrgUri");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("csp_public_key_uri", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("csp_public_key_uri",
                                                                                "cspPublicKeyUri",
                                                                                "getCspPublicKeyUri",
                                                                                "setCspPublicKeyUri");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("csp_time_drift", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("csp_time_drift",
                                                                                "cspTimeDrift",
                                                                                "getCspTimeDrift",
                                                                                "setCspTimeDrift");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("csp_user_authorization_uri", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("csp_user_authorization_uri",
                                                                                "cspUserAuthorizationUri",
                                                                                "getCspUserAuthorizationUri",
                                                                                "setCspUserAuthorizationUri");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("csp_user_info_uri", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("csp_user_info_uri",
                                                                                "cspUserInfoUri",
                                                                                "getCspUserInfoUri",
                                                                                "setCspUserInfoUri");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("default_org_id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("default_org_id",
                                                                                "defaultOrgId",
                                                                                "getDefaultOrgId",
                                                                                "setDefaultOrgId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("ea_org", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx.model.StructDefinitions.orgInfo; } }));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("ea_org",
                                                                                "eaOrg",
                                                                                "getEaOrg",
                                                                                "setEaOrg");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("gss_org", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx.model.StructDefinitions.orgInfo; } }));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("gss_org",
                                                                                "gssOrg",
                                                                                "getGssOrg",
                                                                                "setGssOrg");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("mode_change_only", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("mode_change_only",
                                                                                "modeChangeOnly",
                                                                                "getModeChangeOnly",
                                                                                "setModeChangeOnly");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("proxy_host", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("proxy_host",
                                                                                "proxyHost",
                                                                                "getProxyHost",
                                                                                "setProxyHost");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("proxy_port", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("proxy_port",
                                                                                "proxyPort",
                                                                                "getProxyPort",
                                                                                "setProxyPort");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("public_client_info", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx.model.StructDefinitions.publicClientInfo; } }));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("public_client_info",
                                                                                "publicClientInfo",
                                                                                "getPublicClientInfo",
                                                                                "setPublicClientInfo");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("resource_type", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("resource_type",
                                                                                "resourceType",
                                                                                "getResourceType",
                                                                                "setResourceType");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("sddc_id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("sddc_id",
                                                                                "sddcId",
                                                                                "getSddcId",
                                                                                "setSddcId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("service_definition_id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("service_definition_id",
                                                                                "serviceDefinitionId",
                                                                                "getServiceDefinitionId",
                                                                                "setServiceDefinitionId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("sre_org", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx.model.StructDefinitions.orgInfo; } }));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("sre_org",
                                                                                "sreOrg",
                                                                                "getSreOrg",
                                                                                "setSreOrg");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx.model.switching_to_vmc_mode_parameters",
                                                            fields,
                                                            com.vmware.nsx.model.SwitchingToVmcModeParameters.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

