/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx.model;

/**
 * Execution status of pre/post-upgrade checks
 */
public final class UpgradeChecksExecutionStatus implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    public static final java.lang.String STATUS_NOT_STARTED = "NOT_STARTED";

    public static final java.lang.String STATUS_IN_PROGRESS = "IN_PROGRESS";

    public static final java.lang.String STATUS_ABORTING = "ABORTING";

    public static final java.lang.String STATUS_ABORTED = "ABORTED";

    public static final java.lang.String STATUS_COMPLETED = "COMPLETED";

    private java.lang.String details;

    private java.lang.Long endTime;

    private java.lang.Long errorCount;

    private java.lang.Long failureCount;

    private java.lang.Long nodeWithIssuesCount;

    private java.lang.Long startTime;

    private java.lang.String status;

    private java.lang.Long warningCount;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public UpgradeChecksExecutionStatus() {
    }

    protected UpgradeChecksExecutionStatus(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * Details about current execution of pre/post-upgrade checks
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getDetails() {
        return this.details;
    }

    /**
     * Details about current execution of pre/post-upgrade checks
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param details New value for the property.
     */
    public void setDetails(java.lang.String details) {
        this.details = details;
    }

    /**
     * Time (in milliseconds since epoch) when the execution of pre/post-upgrade checks
     * completed format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getEndTime() {
        return this.endTime;
    }

    /**
     * Time (in milliseconds since epoch) when the execution of pre/post-upgrade checks
     * completed format: int64
     *
     * @param endTime New value for the property.
     */
    public void setEndTime(java.lang.Long endTime) {
        this.endTime = endTime;
    }

    /**
     * Total count of generated Failures in last execution of pre/post upgrade checks
     * format: int32
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getErrorCount() {
        return this.errorCount;
    }

    /**
     * Total count of generated Failures in last execution of pre/post upgrade checks
     * format: int32
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param errorCount New value for the property.
     */
    public void setErrorCount(java.lang.Long errorCount) {
        this.errorCount = errorCount;
    }

    /**
     * Total count of generated failures or warnings in last execution of
     * pre/post-upgrade checks format: int32
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getFailureCount() {
        return this.failureCount;
    }

    /**
     * Total count of generated failures or warnings in last execution of
     * pre/post-upgrade checks format: int32
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param failureCount New value for the property.
     */
    public void setFailureCount(java.lang.Long failureCount) {
        this.failureCount = failureCount;
    }

    /**
     * Number of nodes which generated failures or warnings in last execution of
     * pre/post-upgrade checks. This field has been deprecated. Please use
     * failure_count instead. format: int32
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    @Deprecated
    public java.lang.Long getNodeWithIssuesCount() {
        return this.nodeWithIssuesCount;
    }

    /**
     * Number of nodes which generated failures or warnings in last execution of
     * pre/post-upgrade checks. This field has been deprecated. Please use
     * failure_count instead. format: int32
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param nodeWithIssuesCount New value for the property.
     */
    @Deprecated
    public void setNodeWithIssuesCount(java.lang.Long nodeWithIssuesCount) {
        this.nodeWithIssuesCount = nodeWithIssuesCount;
    }

    /**
     * Time (in milliseconds since epoch) when the execution of pre/post-upgrade checks
     * started format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getStartTime() {
        return this.startTime;
    }

    /**
     * Time (in milliseconds since epoch) when the execution of pre/post-upgrade checks
     * started format: int64
     *
     * @param startTime New value for the property.
     */
    public void setStartTime(java.lang.Long startTime) {
        this.startTime = startTime;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.UpgradeChecksExecutionStatus#STATUS_NOT_STARTED}</li> <li>
     * {@link
     * com.vmware.nsx.model.UpgradeChecksExecutionStatus#STATUS_IN_PROGRESS}</li> <li>
     * {@link com.vmware.nsx.model.UpgradeChecksExecutionStatus#STATUS_ABORTING}</li>
     * <li> {@link
     * com.vmware.nsx.model.UpgradeChecksExecutionStatus#STATUS_ABORTED}</li> <li>
     * {@link com.vmware.nsx.model.UpgradeChecksExecutionStatus#STATUS_COMPLETED}</li>
     * </ul> Status of execution of pre/post-upgrade checks
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getStatus() {
        return this.status;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.UpgradeChecksExecutionStatus#STATUS_NOT_STARTED}</li> <li>
     * {@link
     * com.vmware.nsx.model.UpgradeChecksExecutionStatus#STATUS_IN_PROGRESS}</li> <li>
     * {@link com.vmware.nsx.model.UpgradeChecksExecutionStatus#STATUS_ABORTING}</li>
     * <li> {@link
     * com.vmware.nsx.model.UpgradeChecksExecutionStatus#STATUS_ABORTED}</li> <li>
     * {@link com.vmware.nsx.model.UpgradeChecksExecutionStatus#STATUS_COMPLETED}</li>
     * </ul> Status of execution of pre/post-upgrade checks
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param status New value for the property.
     */
    public void setStatus(java.lang.String status) {
        this.status = status;
    }

    /**
     * Total count of generated warnings in last execution of pre/post upgrade checks.
     * format: int32
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getWarningCount() {
        return this.warningCount;
    }

    /**
     * Total count of generated warnings in last execution of pre/post upgrade checks.
     * format: int32
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param warningCount New value for the property.
     */
    public void setWarningCount(java.lang.Long warningCount) {
        this.warningCount = warningCount;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx.model.StructDefinitions.upgradeChecksExecutionStatus;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("details",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.details, this._getType().getField("details")));
        structValue.setField("end_time",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.endTime, this._getType().getField("end_time")));
        structValue.setField("error_count",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.errorCount, this._getType().getField("error_count")));
        structValue.setField("failure_count",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.failureCount, this._getType().getField("failure_count")));
        structValue.setField("node_with_issues_count",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.nodeWithIssuesCount, this._getType().getField("node_with_issues_count")));
        structValue.setField("start_time",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.startTime, this._getType().getField("start_time")));
        structValue.setField("status",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.status, this._getType().getField("status")));
        structValue.setField("warning_count",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.warningCount, this._getType().getField("warning_count")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx.model.StructDefinitions.upgradeChecksExecutionStatus;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx.model.StructDefinitions.upgradeChecksExecutionStatus.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static UpgradeChecksExecutionStatus _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new UpgradeChecksExecutionStatus(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static UpgradeChecksExecutionStatus _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new UpgradeChecksExecutionStatus(structValue);
    }

    /**
     * Builder class for {@link UpgradeChecksExecutionStatus}.
     */
    public static final class Builder {
        private java.lang.String details;
        private java.lang.Long endTime;
        private java.lang.Long errorCount;
        private java.lang.Long failureCount;
        private java.lang.Long nodeWithIssuesCount;
        private java.lang.Long startTime;
        private java.lang.String status;
        private java.lang.Long warningCount;

        /**
         * Constructor with parameters for the required properties of
         * {@link UpgradeChecksExecutionStatus}.
         */
        public Builder() {
        }

        /**
         * Details about current execution of pre/post-upgrade checks
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param details New value for the property.
         */
        public Builder setDetails(java.lang.String details) {
            this.details = details;
            return this;
        }

        /**
         * Time (in milliseconds since epoch) when the execution of pre/post-upgrade checks
         * completed format: int64
         *
         * @param endTime New value for the property.
         */
        public Builder setEndTime(java.lang.Long endTime) {
            this.endTime = endTime;
            return this;
        }

        /**
         * Total count of generated Failures in last execution of pre/post upgrade checks
         * format: int32
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param errorCount New value for the property.
         */
        public Builder setErrorCount(java.lang.Long errorCount) {
            this.errorCount = errorCount;
            return this;
        }

        /**
         * Total count of generated failures or warnings in last execution of
         * pre/post-upgrade checks format: int32
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param failureCount New value for the property.
         */
        public Builder setFailureCount(java.lang.Long failureCount) {
            this.failureCount = failureCount;
            return this;
        }

        /**
         * Number of nodes which generated failures or warnings in last execution of
         * pre/post-upgrade checks. This field has been deprecated. Please use
         * failure_count instead. format: int32
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param nodeWithIssuesCount New value for the property.
         */
        public Builder setNodeWithIssuesCount(java.lang.Long nodeWithIssuesCount) {
            this.nodeWithIssuesCount = nodeWithIssuesCount;
            return this;
        }

        /**
         * Time (in milliseconds since epoch) when the execution of pre/post-upgrade checks
         * started format: int64
         *
         * @param startTime New value for the property.
         */
        public Builder setStartTime(java.lang.Long startTime) {
            this.startTime = startTime;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx.model.UpgradeChecksExecutionStatus#STATUS_NOT_STARTED}</li> <li>
         * {@link
         * com.vmware.nsx.model.UpgradeChecksExecutionStatus#STATUS_IN_PROGRESS}</li> <li>
         * {@link com.vmware.nsx.model.UpgradeChecksExecutionStatus#STATUS_ABORTING}</li>
         * <li> {@link
         * com.vmware.nsx.model.UpgradeChecksExecutionStatus#STATUS_ABORTED}</li> <li>
         * {@link com.vmware.nsx.model.UpgradeChecksExecutionStatus#STATUS_COMPLETED}</li>
         * </ul> Status of execution of pre/post-upgrade checks
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param status New value for the property.
         */
        public Builder setStatus(java.lang.String status) {
            this.status = status;
            return this;
        }

        /**
         * Total count of generated warnings in last execution of pre/post upgrade checks.
         * format: int32
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param warningCount New value for the property.
         */
        public Builder setWarningCount(java.lang.Long warningCount) {
            this.warningCount = warningCount;
            return this;
        }

        public UpgradeChecksExecutionStatus build() {
            UpgradeChecksExecutionStatus result = new UpgradeChecksExecutionStatus();
            result.setDetails(this.details);
            result.setEndTime(this.endTime);
            result.setErrorCount(this.errorCount);
            result.setFailureCount(this.failureCount);
            result.setNodeWithIssuesCount(this.nodeWithIssuesCount);
            result.setStartTime(this.startTime);
            result.setStatus(this.status);
            result.setWarningCount(this.warningCount);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("details", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("details",
                                                                                "details",
                                                                                "getDetails",
                                                                                "setDetails");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("end_time", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("end_time",
                                                                                "endTime",
                                                                                "getEndTime",
                                                                                "setEndTime");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("error_count", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("error_count",
                                                                                "errorCount",
                                                                                "getErrorCount",
                                                                                "setErrorCount");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("failure_count", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("failure_count",
                                                                                "failureCount",
                                                                                "getFailureCount",
                                                                                "setFailureCount");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("node_with_issues_count", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("node_with_issues_count",
                                                                                "nodeWithIssuesCount",
                                                                                "getNodeWithIssuesCount",
                                                                                "setNodeWithIssuesCount");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("start_time", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("start_time",
                                                                                "startTime",
                                                                                "getStartTime",
                                                                                "setStartTime");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("status", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("status",
                                                                                "status",
                                                                                "getStatus",
                                                                                "setStatus");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("warning_count", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("warning_count",
                                                                                "warningCount",
                                                                                "getWarningCount",
                                                                                "setWarningCount");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx.model.upgrade_checks_execution_status",
                                                            fields,
                                                            com.vmware.nsx.model.UpgradeChecksExecutionStatus.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

