/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx.node.aaa.
 * Used by client-side stubs.
 */

package com.vmware.nsx.node.aaa;

public interface AuthPolicy extends com.vmware.vapi.bindings.Service, com.vmware.nsx.node.aaa.AuthPolicyTypes {

    /**
     * Returns information about the currently configured authentication policies and
     * password complexity on the node.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @return com.vmware.nsx.model.AuthenticationPolicyProperties
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx.model.AuthenticationPolicyProperties get();

    /**
     * Returns information about the currently configured authentication policies and
     * password complexity on the node.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.AuthenticationPolicyProperties
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx.model.AuthenticationPolicyProperties get(com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Returns information about the currently configured authentication policies and
     * password complexity on the node.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.AuthenticationPolicyProperties
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void get(com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.AuthenticationPolicyProperties> asyncCallback);

    /**
     * Returns information about the currently configured authentication policies and
     * password complexity on the node.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.AuthenticationPolicyProperties
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void get(com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.AuthenticationPolicyProperties> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Resets to default, currently configured authentication policy and password
     * complexity on the node. Administrators need to enforce password change for
     * existing user accounts in order to match newly configured complexity
     * requirements in system. 
     * <p><b>reset-all</b>: resets configured Authentication
     * policy and Password complexity</p> 
     * <p><b>reset-auth-policies</b>: resets only
     * configured Authentication policy<br/> <i>includes -
     * {api_failed_auth_lockout_period, api_failed_auth_reset_period,
     * api_max_auth_failures, cli_failed_auth_lockout_period,
     * cli_max_auth_failures}</i></p> 
     * <p><b>reset-pwd-complexity</b>: resets only
     * configured Password complexity</p>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @return com.vmware.nsx.model.AuthenticationPolicyProperties
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx.model.AuthenticationPolicyProperties resetall();

    /**
     * Resets to default, currently configured authentication policy and password
     * complexity on the node. Administrators need to enforce password change for
     * existing user accounts in order to match newly configured complexity
     * requirements in system. 
     * <p><b>reset-all</b>: resets configured Authentication
     * policy and Password complexity</p> 
     * <p><b>reset-auth-policies</b>: resets only
     * configured Authentication policy<br/> <i>includes -
     * {api_failed_auth_lockout_period, api_failed_auth_reset_period,
     * api_max_auth_failures, cli_failed_auth_lockout_period,
     * cli_max_auth_failures}</i></p> 
     * <p><b>reset-pwd-complexity</b>: resets only
     * configured Password complexity</p>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.AuthenticationPolicyProperties
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx.model.AuthenticationPolicyProperties resetall(com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Resets to default, currently configured authentication policy and password
     * complexity on the node. Administrators need to enforce password change for
     * existing user accounts in order to match newly configured complexity
     * requirements in system. 
     * <p><b>reset-all</b>: resets configured Authentication
     * policy and Password complexity</p> 
     * <p><b>reset-auth-policies</b>: resets only
     * configured Authentication policy<br/> <i>includes -
     * {api_failed_auth_lockout_period, api_failed_auth_reset_period,
     * api_max_auth_failures, cli_failed_auth_lockout_period,
     * cli_max_auth_failures}</i></p> 
     * <p><b>reset-pwd-complexity</b>: resets only
     * configured Password complexity</p>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.AuthenticationPolicyProperties
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void resetall(com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.AuthenticationPolicyProperties> asyncCallback);

    /**
     * Resets to default, currently configured authentication policy and password
     * complexity on the node. Administrators need to enforce password change for
     * existing user accounts in order to match newly configured complexity
     * requirements in system. 
     * <p><b>reset-all</b>: resets configured Authentication
     * policy and Password complexity</p> 
     * <p><b>reset-auth-policies</b>: resets only
     * configured Authentication policy<br/> <i>includes -
     * {api_failed_auth_lockout_period, api_failed_auth_reset_period,
     * api_max_auth_failures, cli_failed_auth_lockout_period,
     * cli_max_auth_failures}</i></p> 
     * <p><b>reset-pwd-complexity</b>: resets only
     * configured Password complexity</p>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.AuthenticationPolicyProperties
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void resetall(com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.AuthenticationPolicyProperties> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Resets to default, currently configured authentication policy and password
     * complexity on the node. Administrators need to enforce password change for
     * existing user accounts in order to match newly configured complexity
     * requirements in system. 
     * <p><b>reset-all</b>: resets configured Authentication
     * policy and Password complexity</p> 
     * <p><b>reset-auth-policies</b>: resets only
     * configured Authentication policy<br/> <i>includes -
     * {api_failed_auth_lockout_period, api_failed_auth_reset_period,
     * api_max_auth_failures, cli_failed_auth_lockout_period,
     * cli_max_auth_failures}</i></p> 
     * <p><b>reset-pwd-complexity</b>: resets only
     * configured Password complexity</p>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @return com.vmware.nsx.model.AuthenticationPolicyProperties
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx.model.AuthenticationPolicyProperties resetauthpolicies();

    /**
     * Resets to default, currently configured authentication policy and password
     * complexity on the node. Administrators need to enforce password change for
     * existing user accounts in order to match newly configured complexity
     * requirements in system. 
     * <p><b>reset-all</b>: resets configured Authentication
     * policy and Password complexity</p> 
     * <p><b>reset-auth-policies</b>: resets only
     * configured Authentication policy<br/> <i>includes -
     * {api_failed_auth_lockout_period, api_failed_auth_reset_period,
     * api_max_auth_failures, cli_failed_auth_lockout_period,
     * cli_max_auth_failures}</i></p> 
     * <p><b>reset-pwd-complexity</b>: resets only
     * configured Password complexity</p>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.AuthenticationPolicyProperties
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx.model.AuthenticationPolicyProperties resetauthpolicies(com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Resets to default, currently configured authentication policy and password
     * complexity on the node. Administrators need to enforce password change for
     * existing user accounts in order to match newly configured complexity
     * requirements in system. 
     * <p><b>reset-all</b>: resets configured Authentication
     * policy and Password complexity</p> 
     * <p><b>reset-auth-policies</b>: resets only
     * configured Authentication policy<br/> <i>includes -
     * {api_failed_auth_lockout_period, api_failed_auth_reset_period,
     * api_max_auth_failures, cli_failed_auth_lockout_period,
     * cli_max_auth_failures}</i></p> 
     * <p><b>reset-pwd-complexity</b>: resets only
     * configured Password complexity</p>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.AuthenticationPolicyProperties
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void resetauthpolicies(com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.AuthenticationPolicyProperties> asyncCallback);

    /**
     * Resets to default, currently configured authentication policy and password
     * complexity on the node. Administrators need to enforce password change for
     * existing user accounts in order to match newly configured complexity
     * requirements in system. 
     * <p><b>reset-all</b>: resets configured Authentication
     * policy and Password complexity</p> 
     * <p><b>reset-auth-policies</b>: resets only
     * configured Authentication policy<br/> <i>includes -
     * {api_failed_auth_lockout_period, api_failed_auth_reset_period,
     * api_max_auth_failures, cli_failed_auth_lockout_period,
     * cli_max_auth_failures}</i></p> 
     * <p><b>reset-pwd-complexity</b>: resets only
     * configured Password complexity</p>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.AuthenticationPolicyProperties
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void resetauthpolicies(com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.AuthenticationPolicyProperties> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Resets to default, currently configured authentication policy and password
     * complexity on the node. Administrators need to enforce password change for
     * existing user accounts in order to match newly configured complexity
     * requirements in system. 
     * <p><b>reset-all</b>: resets configured Authentication
     * policy and Password complexity</p> 
     * <p><b>reset-auth-policies</b>: resets only
     * configured Authentication policy<br/> <i>includes -
     * {api_failed_auth_lockout_period, api_failed_auth_reset_period,
     * api_max_auth_failures, cli_failed_auth_lockout_period,
     * cli_max_auth_failures}</i></p> 
     * <p><b>reset-pwd-complexity</b>: resets only
     * configured Password complexity</p>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @return com.vmware.nsx.model.AuthenticationPolicyProperties
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx.model.AuthenticationPolicyProperties resetpwdcomplexity();

    /**
     * Resets to default, currently configured authentication policy and password
     * complexity on the node. Administrators need to enforce password change for
     * existing user accounts in order to match newly configured complexity
     * requirements in system. 
     * <p><b>reset-all</b>: resets configured Authentication
     * policy and Password complexity</p> 
     * <p><b>reset-auth-policies</b>: resets only
     * configured Authentication policy<br/> <i>includes -
     * {api_failed_auth_lockout_period, api_failed_auth_reset_period,
     * api_max_auth_failures, cli_failed_auth_lockout_period,
     * cli_max_auth_failures}</i></p> 
     * <p><b>reset-pwd-complexity</b>: resets only
     * configured Password complexity</p>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.AuthenticationPolicyProperties
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx.model.AuthenticationPolicyProperties resetpwdcomplexity(com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Resets to default, currently configured authentication policy and password
     * complexity on the node. Administrators need to enforce password change for
     * existing user accounts in order to match newly configured complexity
     * requirements in system. 
     * <p><b>reset-all</b>: resets configured Authentication
     * policy and Password complexity</p> 
     * <p><b>reset-auth-policies</b>: resets only
     * configured Authentication policy<br/> <i>includes -
     * {api_failed_auth_lockout_period, api_failed_auth_reset_period,
     * api_max_auth_failures, cli_failed_auth_lockout_period,
     * cli_max_auth_failures}</i></p> 
     * <p><b>reset-pwd-complexity</b>: resets only
     * configured Password complexity</p>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.AuthenticationPolicyProperties
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void resetpwdcomplexity(com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.AuthenticationPolicyProperties> asyncCallback);

    /**
     * Resets to default, currently configured authentication policy and password
     * complexity on the node. Administrators need to enforce password change for
     * existing user accounts in order to match newly configured complexity
     * requirements in system. 
     * <p><b>reset-all</b>: resets configured Authentication
     * policy and Password complexity</p> 
     * <p><b>reset-auth-policies</b>: resets only
     * configured Authentication policy<br/> <i>includes -
     * {api_failed_auth_lockout_period, api_failed_auth_reset_period,
     * api_max_auth_failures, cli_failed_auth_lockout_period,
     * cli_max_auth_failures}</i></p> 
     * <p><b>reset-pwd-complexity</b>: resets only
     * configured Password complexity</p>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.AuthenticationPolicyProperties
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void resetpwdcomplexity(com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.AuthenticationPolicyProperties> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Update the currently configured authentication policy and password complexity on
     * the node. If any of api_max_auth_failures, api_failed_auth_reset_period, or
     * api_failed_auth_lockout_period are modified, the http service is automatically
     * restarted. Whereas change in any password complexity will not be applicable on
     * already configured user passwords. Administrators need to enforce password
     * change for existing user accounts in order to match newly configured complexity
     * requirements enforced in system. All values from AuthenticationPolicyProperties
     * are in sync among the management cluster nodes.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param authenticationPolicyProperties (required)
     * @return com.vmware.nsx.model.AuthenticationPolicyProperties
     * @throws com.vmware.vapi.std.errors.ConcurrentChange  Conflict
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx.model.AuthenticationPolicyProperties update(com.vmware.nsx.model.AuthenticationPolicyProperties authenticationPolicyProperties);

    /**
     * Update the currently configured authentication policy and password complexity on
     * the node. If any of api_max_auth_failures, api_failed_auth_reset_period, or
     * api_failed_auth_lockout_period are modified, the http service is automatically
     * restarted. Whereas change in any password complexity will not be applicable on
     * already configured user passwords. Administrators need to enforce password
     * change for existing user accounts in order to match newly configured complexity
     * requirements enforced in system. All values from AuthenticationPolicyProperties
     * are in sync among the management cluster nodes.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param authenticationPolicyProperties (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.AuthenticationPolicyProperties
     * @throws com.vmware.vapi.std.errors.ConcurrentChange  Conflict
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx.model.AuthenticationPolicyProperties update(com.vmware.nsx.model.AuthenticationPolicyProperties authenticationPolicyProperties, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Update the currently configured authentication policy and password complexity on
     * the node. If any of api_max_auth_failures, api_failed_auth_reset_period, or
     * api_failed_auth_lockout_period are modified, the http service is automatically
     * restarted. Whereas change in any password complexity will not be applicable on
     * already configured user passwords. Administrators need to enforce password
     * change for existing user accounts in order to match newly configured complexity
     * requirements enforced in system. All values from AuthenticationPolicyProperties
     * are in sync among the management cluster nodes.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.AuthenticationPolicyProperties
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.ConcurrentChange} -  Conflict<br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param authenticationPolicyProperties (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void update(com.vmware.nsx.model.AuthenticationPolicyProperties authenticationPolicyProperties, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.AuthenticationPolicyProperties> asyncCallback);

    /**
     * Update the currently configured authentication policy and password complexity on
     * the node. If any of api_max_auth_failures, api_failed_auth_reset_period, or
     * api_failed_auth_lockout_period are modified, the http service is automatically
     * restarted. Whereas change in any password complexity will not be applicable on
     * already configured user passwords. Administrators need to enforce password
     * change for existing user accounts in order to match newly configured complexity
     * requirements enforced in system. All values from AuthenticationPolicyProperties
     * are in sync among the management cluster nodes.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.AuthenticationPolicyProperties
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.ConcurrentChange} -  Conflict<br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param authenticationPolicyProperties (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void update(com.vmware.nsx.model.AuthenticationPolicyProperties authenticationPolicyProperties, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.AuthenticationPolicyProperties> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
