/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx.node.network.
 * Used by client-side stubs.
 */

package com.vmware.nsx.node.network;

public interface Routes extends com.vmware.vapi.bindings.Service, com.vmware.nsx.node.network.RoutesTypes {

    /**
     * Add a route to the node routing table. For static routes, the route_type,
     * interface_id, netmask, and destination are required parameters. For default
     * routes, the route_type, gateway address, and interface_id are required. For
     * blackhole routes, the route_type and destination are required. All other
     * parameters are optional. When you add a static route, the scope and route_id are
     * created automatically. When you add a default or blackhole route, the route_id
     * is created automatically. The route_id is read-only, meaning that it cannot be
     * modified. All other properties can be modified by deleting and readding the
     * route.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param nodeRouteProperties (required)
     * @return com.vmware.nsx.model.NodeRouteProperties
     * @throws com.vmware.vapi.std.errors.ConcurrentChange  Conflict
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx.model.NodeRouteProperties create(com.vmware.nsx.model.NodeRouteProperties nodeRouteProperties);

    /**
     * Add a route to the node routing table. For static routes, the route_type,
     * interface_id, netmask, and destination are required parameters. For default
     * routes, the route_type, gateway address, and interface_id are required. For
     * blackhole routes, the route_type and destination are required. All other
     * parameters are optional. When you add a static route, the scope and route_id are
     * created automatically. When you add a default or blackhole route, the route_id
     * is created automatically. The route_id is read-only, meaning that it cannot be
     * modified. All other properties can be modified by deleting and readding the
     * route.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param nodeRouteProperties (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.NodeRouteProperties
     * @throws com.vmware.vapi.std.errors.ConcurrentChange  Conflict
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx.model.NodeRouteProperties create(com.vmware.nsx.model.NodeRouteProperties nodeRouteProperties, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Add a route to the node routing table. For static routes, the route_type,
     * interface_id, netmask, and destination are required parameters. For default
     * routes, the route_type, gateway address, and interface_id are required. For
     * blackhole routes, the route_type and destination are required. All other
     * parameters are optional. When you add a static route, the scope and route_id are
     * created automatically. When you add a default or blackhole route, the route_id
     * is created automatically. The route_id is read-only, meaning that it cannot be
     * modified. All other properties can be modified by deleting and readding the
     * route.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.NodeRouteProperties
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.ConcurrentChange} -  Conflict<br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param nodeRouteProperties (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void create(com.vmware.nsx.model.NodeRouteProperties nodeRouteProperties, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.NodeRouteProperties> asyncCallback);

    /**
     * Add a route to the node routing table. For static routes, the route_type,
     * interface_id, netmask, and destination are required parameters. For default
     * routes, the route_type, gateway address, and interface_id are required. For
     * blackhole routes, the route_type and destination are required. All other
     * parameters are optional. When you add a static route, the scope and route_id are
     * created automatically. When you add a default or blackhole route, the route_id
     * is created automatically. The route_id is read-only, meaning that it cannot be
     * modified. All other properties can be modified by deleting and readding the
     * route.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.NodeRouteProperties
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.ConcurrentChange} -  Conflict<br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param nodeRouteProperties (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void create(com.vmware.nsx.model.NodeRouteProperties nodeRouteProperties, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.NodeRouteProperties> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Delete a route from the node routing table. You can modify an existing route by
     * deleting it and then posting the modified version of the route. To verify,
     * remove the route ID from the URI, issue a GET request, and note the absense of
     * the deleted route.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param routeId ID of route to delete (required)
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public void delete(java.lang.String routeId);

    /**
     * Delete a route from the node routing table. You can modify an existing route by
     * deleting it and then posting the modified version of the route. To verify,
     * remove the route ID from the URI, issue a GET request, and note the absense of
     * the deleted route.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param routeId ID of route to delete (required)
     * @param invocationConfig Configuration for the method invocation.
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public void delete(java.lang.String routeId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Delete a route from the node routing table. You can modify an existing route by
     * deleting it and then posting the modified version of the route. To verify,
     * remove the route ID from the URI, issue a GET request, and note the absense of
     * the deleted route.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param routeId ID of route to delete (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void delete(java.lang.String routeId, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback);

    /**
     * Delete a route from the node routing table. You can modify an existing route by
     * deleting it and then posting the modified version of the route. To verify,
     * remove the route ID from the URI, issue a GET request, and note the absense of
     * the deleted route.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param routeId ID of route to delete (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void delete(java.lang.String routeId, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Returns detailed information about a specified route in the node routing table.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param routeId ID of route to read (required)
     * @return com.vmware.nsx.model.NodeRouteProperties
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx.model.NodeRouteProperties get(java.lang.String routeId);

    /**
     * Returns detailed information about a specified route in the node routing table.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param routeId ID of route to read (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.NodeRouteProperties
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx.model.NodeRouteProperties get(java.lang.String routeId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Returns detailed information about a specified route in the node routing table.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.NodeRouteProperties
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param routeId ID of route to read (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void get(java.lang.String routeId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.NodeRouteProperties> asyncCallback);

    /**
     * Returns detailed information about a specified route in the node routing table.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.NodeRouteProperties
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param routeId ID of route to read (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void get(java.lang.String routeId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.NodeRouteProperties> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Returns detailed information about each route in the node routing table. Routes
     * can be of any type i.e. IPv4 or IPv6 or both. Route information includes the
     * route ipv6 flag (True or False), route type (default, static, and so on), a
     * unique route identifier, the route metric, the protocol from which the route was
     * learned, the route source (which is the preferred egress interface), the route
     * destination, and the route scope. If ipv6 flag is True then route information is
     * for IPv6 route else for IPv4 route. The route scope refers to the distance to
     * the destination network: The \"host\" scope leads to a destination address on
     * the node, such as a loopback address; the \"link\" scope leads to a destination
     * on the local network; and the \"global\" scope leads to addresses that are more
     * than one hop away.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @return com.vmware.nsx.model.NodeRoutePropertiesListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx.model.NodeRoutePropertiesListResult list();

    /**
     * Returns detailed information about each route in the node routing table. Routes
     * can be of any type i.e. IPv4 or IPv6 or both. Route information includes the
     * route ipv6 flag (True or False), route type (default, static, and so on), a
     * unique route identifier, the route metric, the protocol from which the route was
     * learned, the route source (which is the preferred egress interface), the route
     * destination, and the route scope. If ipv6 flag is True then route information is
     * for IPv6 route else for IPv4 route. The route scope refers to the distance to
     * the destination network: The \"host\" scope leads to a destination address on
     * the node, such as a loopback address; the \"link\" scope leads to a destination
     * on the local network; and the \"global\" scope leads to addresses that are more
     * than one hop away.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.NodeRoutePropertiesListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx.model.NodeRoutePropertiesListResult list(com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Returns detailed information about each route in the node routing table. Routes
     * can be of any type i.e. IPv4 or IPv6 or both. Route information includes the
     * route ipv6 flag (True or False), route type (default, static, and so on), a
     * unique route identifier, the route metric, the protocol from which the route was
     * learned, the route source (which is the preferred egress interface), the route
     * destination, and the route scope. If ipv6 flag is True then route information is
     * for IPv6 route else for IPv4 route. The route scope refers to the distance to
     * the destination network: The \"host\" scope leads to a destination address on
     * the node, such as a loopback address; the \"link\" scope leads to a destination
     * on the local network; and the \"global\" scope leads to addresses that are more
     * than one hop away.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.NodeRoutePropertiesListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void list(com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.NodeRoutePropertiesListResult> asyncCallback);

    /**
     * Returns detailed information about each route in the node routing table. Routes
     * can be of any type i.e. IPv4 or IPv6 or both. Route information includes the
     * route ipv6 flag (True or False), route type (default, static, and so on), a
     * unique route identifier, the route metric, the protocol from which the route was
     * learned, the route source (which is the preferred egress interface), the route
     * destination, and the route scope. If ipv6 flag is True then route information is
     * for IPv6 route else for IPv4 route. The route scope refers to the distance to
     * the destination network: The \"host\" scope leads to a destination address on
     * the node, such as a loopback address; the \"link\" scope leads to a destination
     * on the local network; and the \"global\" scope leads to addresses that are more
     * than one hop away.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.NodeRoutePropertiesListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void list(com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.NodeRoutePropertiesListResult> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
