/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx.node.network.
 * Used by client-side stubs.
 */

package com.vmware.nsx.node.network;

public interface SearchDomains extends com.vmware.vapi.bindings.Service, com.vmware.nsx.node.network.SearchDomainsTypes {

    /**
     * Returns the domain list that the node uses to complete unqualified host names.
     * When a host name does not include a fully qualified domain name (FQDN), the NSX
     * Management node appends the first-listed domain name to the host name before the
     * host name is looked up. The NSX Management node continues this for each entry in
     * the domain list until it finds a match.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @return com.vmware.nsx.model.NodeSearchDomainsProperties
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx.model.NodeSearchDomainsProperties get();

    /**
     * Returns the domain list that the node uses to complete unqualified host names.
     * When a host name does not include a fully qualified domain name (FQDN), the NSX
     * Management node appends the first-listed domain name to the host name before the
     * host name is looked up. The NSX Management node continues this for each entry in
     * the domain list until it finds a match.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.NodeSearchDomainsProperties
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx.model.NodeSearchDomainsProperties get(com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Returns the domain list that the node uses to complete unqualified host names.
     * When a host name does not include a fully qualified domain name (FQDN), the NSX
     * Management node appends the first-listed domain name to the host name before the
     * host name is looked up. The NSX Management node continues this for each entry in
     * the domain list until it finds a match.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.NodeSearchDomainsProperties
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void get(com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.NodeSearchDomainsProperties> asyncCallback);

    /**
     * Returns the domain list that the node uses to complete unqualified host names.
     * When a host name does not include a fully qualified domain name (FQDN), the NSX
     * Management node appends the first-listed domain name to the host name before the
     * host name is looked up. The NSX Management node continues this for each entry in
     * the domain list until it finds a match.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.NodeSearchDomainsProperties
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void get(com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.NodeSearchDomainsProperties> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Modifies the list of domain names that the node uses to complete unqualified
     * host names. If DHCP is configured, this method returns a 409 CONFLICT error,
     * because DHCP manages the list of name servers.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param nodeSearchDomainsProperties (required)
     * @return com.vmware.nsx.model.NodeSearchDomainsProperties
     * @throws com.vmware.vapi.std.errors.ConcurrentChange  Conflict
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx.model.NodeSearchDomainsProperties update(com.vmware.nsx.model.NodeSearchDomainsProperties nodeSearchDomainsProperties);

    /**
     * Modifies the list of domain names that the node uses to complete unqualified
     * host names. If DHCP is configured, this method returns a 409 CONFLICT error,
     * because DHCP manages the list of name servers.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param nodeSearchDomainsProperties (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.NodeSearchDomainsProperties
     * @throws com.vmware.vapi.std.errors.ConcurrentChange  Conflict
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx.model.NodeSearchDomainsProperties update(com.vmware.nsx.model.NodeSearchDomainsProperties nodeSearchDomainsProperties, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Modifies the list of domain names that the node uses to complete unqualified
     * host names. If DHCP is configured, this method returns a 409 CONFLICT error,
     * because DHCP manages the list of name servers.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.NodeSearchDomainsProperties
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.ConcurrentChange} -  Conflict<br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param nodeSearchDomainsProperties (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void update(com.vmware.nsx.model.NodeSearchDomainsProperties nodeSearchDomainsProperties, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.NodeSearchDomainsProperties> asyncCallback);

    /**
     * Modifies the list of domain names that the node uses to complete unqualified
     * host names. If DHCP is configured, this method returns a 409 CONFLICT error,
     * because DHCP manages the list of name servers.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.NodeSearchDomainsProperties
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.ConcurrentChange} -  Conflict<br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param nodeSearchDomainsProperties (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void update(com.vmware.nsx.model.NodeSearchDomainsProperties nodeSearchDomainsProperties, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.NodeSearchDomainsProperties> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
