/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx.nvds_urt.
 * Used by client-side stubs.
 */

package com.vmware.nsx.nvds_urt;

public interface Precheck extends com.vmware.vapi.bindings.Service, com.vmware.nsx.nvds_urt.PrecheckTypes {

    /**
     * Precheck is peformed at a global level across all NVDSes present in the system.
     * It is expected to check the status once the precheck API is invoked via
     * GetNvdsUpgradeReadinessCheckSummary API. If NVDS configuration like
     * HostSwitchProfiles differs across TransportNodes, precheck will fail and status
     * will be FAILED and error will be reported via the status API. Once the reported
     * errors are fixed, precheck API is expected to be invoked again to rerun
     * precheck. Once NVDS configuration is consistent across all TransportNodes,
     * precheck will pass and a topology will be generated and status will be
     * PENDING_TOPOLOGY. Generated toplogy can be retrieved via
     * GetRecommendedVdsTopology API. User can apply the recommended topology via
     * SetTargetVdsTopology API.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param tolerateDifferentConfigurations tolerate differnet configurations (optional, default to true)
     * @return com.vmware.nsx.model.NvdsUpgradePrecheckId
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.NvdsUpgradePrecheckId create(java.lang.Boolean tolerateDifferentConfigurations);

    /**
     * Precheck is peformed at a global level across all NVDSes present in the system.
     * It is expected to check the status once the precheck API is invoked via
     * GetNvdsUpgradeReadinessCheckSummary API. If NVDS configuration like
     * HostSwitchProfiles differs across TransportNodes, precheck will fail and status
     * will be FAILED and error will be reported via the status API. Once the reported
     * errors are fixed, precheck API is expected to be invoked again to rerun
     * precheck. Once NVDS configuration is consistent across all TransportNodes,
     * precheck will pass and a topology will be generated and status will be
     * PENDING_TOPOLOGY. Generated toplogy can be retrieved via
     * GetRecommendedVdsTopology API. User can apply the recommended topology via
     * SetTargetVdsTopology API.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param tolerateDifferentConfigurations tolerate differnet configurations (optional, default to true)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.NvdsUpgradePrecheckId
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.NvdsUpgradePrecheckId create(java.lang.Boolean tolerateDifferentConfigurations, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Precheck is peformed at a global level across all NVDSes present in the system.
     * It is expected to check the status once the precheck API is invoked via
     * GetNvdsUpgradeReadinessCheckSummary API. If NVDS configuration like
     * HostSwitchProfiles differs across TransportNodes, precheck will fail and status
     * will be FAILED and error will be reported via the status API. Once the reported
     * errors are fixed, precheck API is expected to be invoked again to rerun
     * precheck. Once NVDS configuration is consistent across all TransportNodes,
     * precheck will pass and a topology will be generated and status will be
     * PENDING_TOPOLOGY. Generated toplogy can be retrieved via
     * GetRecommendedVdsTopology API. User can apply the recommended topology via
     * SetTargetVdsTopology API.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.NvdsUpgradePrecheckId
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param tolerateDifferentConfigurations tolerate differnet configurations (optional, default to true)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void create(java.lang.Boolean tolerateDifferentConfigurations, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.NvdsUpgradePrecheckId> asyncCallback);

    /**
     * Precheck is peformed at a global level across all NVDSes present in the system.
     * It is expected to check the status once the precheck API is invoked via
     * GetNvdsUpgradeReadinessCheckSummary API. If NVDS configuration like
     * HostSwitchProfiles differs across TransportNodes, precheck will fail and status
     * will be FAILED and error will be reported via the status API. Once the reported
     * errors are fixed, precheck API is expected to be invoked again to rerun
     * precheck. Once NVDS configuration is consistent across all TransportNodes,
     * precheck will pass and a topology will be generated and status will be
     * PENDING_TOPOLOGY. Generated toplogy can be retrieved via
     * GetRecommendedVdsTopology API. User can apply the recommended topology via
     * SetTargetVdsTopology API.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.NvdsUpgradePrecheckId
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param tolerateDifferentConfigurations tolerate differnet configurations (optional, default to true)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void create(java.lang.Boolean tolerateDifferentConfigurations, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.NvdsUpgradePrecheckId> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Retrieve latest precheck ID of the N-VDS to VDS migration
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @return com.vmware.nsx.model.NvdsUpgradePrecheckId
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.NvdsUpgradePrecheckId get();

    /**
     * Retrieve latest precheck ID of the N-VDS to VDS migration
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.NvdsUpgradePrecheckId
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.NvdsUpgradePrecheckId get(com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Retrieve latest precheck ID of the N-VDS to VDS migration
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.NvdsUpgradePrecheckId
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void get(com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.NvdsUpgradePrecheckId> asyncCallback);

    /**
     * Retrieve latest precheck ID of the N-VDS to VDS migration
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.NvdsUpgradePrecheckId
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void get(com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.NvdsUpgradePrecheckId> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
