/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx.serviceinsertion.
 * Used by client-side stubs.
 */

package com.vmware.nsx.serviceinsertion;

public interface ServiceAttachments extends com.vmware.vapi.bindings.Service, com.vmware.nsx.serviceinsertion.ServiceAttachmentsTypes {

    /**
     * Adds a new Service attachment. A service attachment represents a point on NSX
     * entity (Example: Logical Router) to which service instance can be connected
     * through an InstanceEndpoint. <br/> This API has been deprecated, please use
     * below Policy API <br/> For North-South service insertion <br/> PUT
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/service-interfaces/<interface-id>
     * PATCH
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/service-interfaces/<interface-id>
     * PUT
     * /policy/api/v1/infra/tier-1s/<tier-1-id>/locale-services/<locale-service-id>/service-interfaces/<interface-id>
     * PATCH
     * /policy/api/v1/infra/tier-1s/<tier-1-id>/locale-services/<locale-service-id>/service-interfaces/<interface-id>
     * For East-West service insertion <br/> PUT
     * /policy/api/v1/infra/segments/service-segments/<service-segment-id> PATCH
     * /policy/api/v1/infra/segments/service-segments/<service-segment-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param serviceAttachment (required)
     * @return com.vmware.nsx.model.ServiceAttachment
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.ServiceAttachment create(com.vmware.nsx.model.ServiceAttachment serviceAttachment);

    /**
     * Adds a new Service attachment. A service attachment represents a point on NSX
     * entity (Example: Logical Router) to which service instance can be connected
     * through an InstanceEndpoint. <br/> This API has been deprecated, please use
     * below Policy API <br/> For North-South service insertion <br/> PUT
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/service-interfaces/<interface-id>
     * PATCH
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/service-interfaces/<interface-id>
     * PUT
     * /policy/api/v1/infra/tier-1s/<tier-1-id>/locale-services/<locale-service-id>/service-interfaces/<interface-id>
     * PATCH
     * /policy/api/v1/infra/tier-1s/<tier-1-id>/locale-services/<locale-service-id>/service-interfaces/<interface-id>
     * For East-West service insertion <br/> PUT
     * /policy/api/v1/infra/segments/service-segments/<service-segment-id> PATCH
     * /policy/api/v1/infra/segments/service-segments/<service-segment-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param serviceAttachment (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.ServiceAttachment
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.ServiceAttachment create(com.vmware.nsx.model.ServiceAttachment serviceAttachment, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Adds a new Service attachment. A service attachment represents a point on NSX
     * entity (Example: Logical Router) to which service instance can be connected
     * through an InstanceEndpoint. <br/> This API has been deprecated, please use
     * below Policy API <br/> For North-South service insertion <br/> PUT
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/service-interfaces/<interface-id>
     * PATCH
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/service-interfaces/<interface-id>
     * PUT
     * /policy/api/v1/infra/tier-1s/<tier-1-id>/locale-services/<locale-service-id>/service-interfaces/<interface-id>
     * PATCH
     * /policy/api/v1/infra/tier-1s/<tier-1-id>/locale-services/<locale-service-id>/service-interfaces/<interface-id>
     * For East-West service insertion <br/> PUT
     * /policy/api/v1/infra/segments/service-segments/<service-segment-id> PATCH
     * /policy/api/v1/infra/segments/service-segments/<service-segment-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.ServiceAttachment
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param serviceAttachment (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void create(com.vmware.nsx.model.ServiceAttachment serviceAttachment, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.ServiceAttachment> asyncCallback);

    /**
     * Adds a new Service attachment. A service attachment represents a point on NSX
     * entity (Example: Logical Router) to which service instance can be connected
     * through an InstanceEndpoint. <br/> This API has been deprecated, please use
     * below Policy API <br/> For North-South service insertion <br/> PUT
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/service-interfaces/<interface-id>
     * PATCH
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/service-interfaces/<interface-id>
     * PUT
     * /policy/api/v1/infra/tier-1s/<tier-1-id>/locale-services/<locale-service-id>/service-interfaces/<interface-id>
     * PATCH
     * /policy/api/v1/infra/tier-1s/<tier-1-id>/locale-services/<locale-service-id>/service-interfaces/<interface-id>
     * For East-West service insertion <br/> PUT
     * /policy/api/v1/infra/segments/service-segments/<service-segment-id> PATCH
     * /policy/api/v1/infra/segments/service-segments/<service-segment-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.ServiceAttachment
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param serviceAttachment (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void create(com.vmware.nsx.model.ServiceAttachment serviceAttachment, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.ServiceAttachment> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Delete existing service attachment from system. Before deletion, please make
     * sure that, no instance endpoints are connected to this attachment. In turn no
     * appliance should be connected to this attachment. <br/> This API has been
     * deprecated, please use below Policy API <br/> For North-South service insertion
     * <br/> DELETE
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/service-interfaces/<interface-id>
     * DELETE
     * /policy/api/v1/infra/tier-1s/<tier-1-id>/locale-services/<locale-service-id>/service-interfaces/<interface-id>
     * For East-West service insertion <br/> DELETE
     * /policy/api/v1/infra/segments/service-segments/>service-segment-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param serviceAttachmentId (required)
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public void delete(java.lang.String serviceAttachmentId);

    /**
     * Delete existing service attachment from system. Before deletion, please make
     * sure that, no instance endpoints are connected to this attachment. In turn no
     * appliance should be connected to this attachment. <br/> This API has been
     * deprecated, please use below Policy API <br/> For North-South service insertion
     * <br/> DELETE
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/service-interfaces/<interface-id>
     * DELETE
     * /policy/api/v1/infra/tier-1s/<tier-1-id>/locale-services/<locale-service-id>/service-interfaces/<interface-id>
     * For East-West service insertion <br/> DELETE
     * /policy/api/v1/infra/segments/service-segments/>service-segment-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param serviceAttachmentId (required)
     * @param invocationConfig Configuration for the method invocation.
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public void delete(java.lang.String serviceAttachmentId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Delete existing service attachment from system. Before deletion, please make
     * sure that, no instance endpoints are connected to this attachment. In turn no
     * appliance should be connected to this attachment. <br/> This API has been
     * deprecated, please use below Policy API <br/> For North-South service insertion
     * <br/> DELETE
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/service-interfaces/<interface-id>
     * DELETE
     * /policy/api/v1/infra/tier-1s/<tier-1-id>/locale-services/<locale-service-id>/service-interfaces/<interface-id>
     * For East-West service insertion <br/> DELETE
     * /policy/api/v1/infra/segments/service-segments/>service-segment-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param serviceAttachmentId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void delete(java.lang.String serviceAttachmentId, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback);

    /**
     * Delete existing service attachment from system. Before deletion, please make
     * sure that, no instance endpoints are connected to this attachment. In turn no
     * appliance should be connected to this attachment. <br/> This API has been
     * deprecated, please use below Policy API <br/> For North-South service insertion
     * <br/> DELETE
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/service-interfaces/<interface-id>
     * DELETE
     * /policy/api/v1/infra/tier-1s/<tier-1-id>/locale-services/<locale-service-id>/service-interfaces/<interface-id>
     * For East-West service insertion <br/> DELETE
     * /policy/api/v1/infra/segments/service-segments/>service-segment-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param serviceAttachmentId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void delete(java.lang.String serviceAttachmentId, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Returns detailed Attachment information for a given service attachment. <br/>
     * This API has been deprecated, please use below Policy API <br/> For North-South
     * service insertion <br/> GET
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/service-interfaces/<interface-id>
     * GET
     * /policy/api/v1/infra/tier-1s/<tier-1-id>/locale-services/<locale-service-id>/service-interfaces/<interface-id>
     * For East-West service insertion <br/> GET
     * /policy/api/v1/infra/segments/service-segments/<service-segment-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param serviceAttachmentId (required)
     * @return com.vmware.nsx.model.ServiceAttachment
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.ServiceAttachment get(java.lang.String serviceAttachmentId);

    /**
     * Returns detailed Attachment information for a given service attachment. <br/>
     * This API has been deprecated, please use below Policy API <br/> For North-South
     * service insertion <br/> GET
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/service-interfaces/<interface-id>
     * GET
     * /policy/api/v1/infra/tier-1s/<tier-1-id>/locale-services/<locale-service-id>/service-interfaces/<interface-id>
     * For East-West service insertion <br/> GET
     * /policy/api/v1/infra/segments/service-segments/<service-segment-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param serviceAttachmentId (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.ServiceAttachment
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.ServiceAttachment get(java.lang.String serviceAttachmentId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Returns detailed Attachment information for a given service attachment. <br/>
     * This API has been deprecated, please use below Policy API <br/> For North-South
     * service insertion <br/> GET
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/service-interfaces/<interface-id>
     * GET
     * /policy/api/v1/infra/tier-1s/<tier-1-id>/locale-services/<locale-service-id>/service-interfaces/<interface-id>
     * For East-West service insertion <br/> GET
     * /policy/api/v1/infra/segments/service-segments/<service-segment-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.ServiceAttachment
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param serviceAttachmentId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void get(java.lang.String serviceAttachmentId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.ServiceAttachment> asyncCallback);

    /**
     * Returns detailed Attachment information for a given service attachment. <br/>
     * This API has been deprecated, please use below Policy API <br/> For North-South
     * service insertion <br/> GET
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/service-interfaces/<interface-id>
     * GET
     * /policy/api/v1/infra/tier-1s/<tier-1-id>/locale-services/<locale-service-id>/service-interfaces/<interface-id>
     * For East-West service insertion <br/> GET
     * /policy/api/v1/infra/segments/service-segments/<service-segment-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.ServiceAttachment
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param serviceAttachmentId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void get(java.lang.String serviceAttachmentId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.ServiceAttachment> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Returns all Service-Attachement(s) present in the system. <br/> This API has
     * been deprecated, please use below Policy API <br/> For North-South service
     * insertion <br/> GET
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/service-interfaces
     * GET
     * /policy/api/v1/infra/tier-1s/<tier-1-id>/locale-services/<locale-service-id>/service-interfaces
     * For East-West service insertion <br/> GET
     * /policy/api/v1/infra/segments/service-segments
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @return com.vmware.nsx.model.ServiceAttachmentListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.ServiceAttachmentListResult list();

    /**
     * Returns all Service-Attachement(s) present in the system. <br/> This API has
     * been deprecated, please use below Policy API <br/> For North-South service
     * insertion <br/> GET
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/service-interfaces
     * GET
     * /policy/api/v1/infra/tier-1s/<tier-1-id>/locale-services/<locale-service-id>/service-interfaces
     * For East-West service insertion <br/> GET
     * /policy/api/v1/infra/segments/service-segments
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.ServiceAttachmentListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.ServiceAttachmentListResult list(com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Returns all Service-Attachement(s) present in the system. <br/> This API has
     * been deprecated, please use below Policy API <br/> For North-South service
     * insertion <br/> GET
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/service-interfaces
     * GET
     * /policy/api/v1/infra/tier-1s/<tier-1-id>/locale-services/<locale-service-id>/service-interfaces
     * For East-West service insertion <br/> GET
     * /policy/api/v1/infra/segments/service-segments
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.ServiceAttachmentListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void list(com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.ServiceAttachmentListResult> asyncCallback);

    /**
     * Returns all Service-Attachement(s) present in the system. <br/> This API has
     * been deprecated, please use below Policy API <br/> For North-South service
     * insertion <br/> GET
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/service-interfaces
     * GET
     * /policy/api/v1/infra/tier-1s/<tier-1-id>/locale-services/<locale-service-id>/service-interfaces
     * For East-West service insertion <br/> GET
     * /policy/api/v1/infra/segments/service-segments
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.ServiceAttachmentListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void list(com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.ServiceAttachmentListResult> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Modifies an existing service attachment. Updates to name, description and
     * Logical Router list only supported. <br/> This API has been deprecated, please
     * use below Policy API <br/> For North-South service insertion <br/> PUT
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/service-interfaces/<interface-id>
     * PATCH
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/service-interfaces/<interface-id>
     * PUT
     * /policy/api/v1/infra/tier-1s/<tier-1-id>/locale-services/<locale-service-id>/service-interfaces/<interface-id>
     * PATCH
     * /policy/api/v1/infra/tier-1s/<tier-1-id>/locale-services/<locale-service-id>/service-interfaces/<interface-id>
     * For East-West service insertion <br/> PUT
     * /policy/api/v1/infra/segments/service-segments/<service-segment-id> PATCH
     * /policy/api/v1/infra/segments/service-segments/<service-segment-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param serviceAttachmentId (required)
     * @param serviceAttachment (required)
     * @return com.vmware.nsx.model.ServiceAttachment
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.ServiceAttachment update(java.lang.String serviceAttachmentId, com.vmware.nsx.model.ServiceAttachment serviceAttachment);

    /**
     * Modifies an existing service attachment. Updates to name, description and
     * Logical Router list only supported. <br/> This API has been deprecated, please
     * use below Policy API <br/> For North-South service insertion <br/> PUT
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/service-interfaces/<interface-id>
     * PATCH
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/service-interfaces/<interface-id>
     * PUT
     * /policy/api/v1/infra/tier-1s/<tier-1-id>/locale-services/<locale-service-id>/service-interfaces/<interface-id>
     * PATCH
     * /policy/api/v1/infra/tier-1s/<tier-1-id>/locale-services/<locale-service-id>/service-interfaces/<interface-id>
     * For East-West service insertion <br/> PUT
     * /policy/api/v1/infra/segments/service-segments/<service-segment-id> PATCH
     * /policy/api/v1/infra/segments/service-segments/<service-segment-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param serviceAttachmentId (required)
     * @param serviceAttachment (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.ServiceAttachment
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.ServiceAttachment update(java.lang.String serviceAttachmentId, com.vmware.nsx.model.ServiceAttachment serviceAttachment, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Modifies an existing service attachment. Updates to name, description and
     * Logical Router list only supported. <br/> This API has been deprecated, please
     * use below Policy API <br/> For North-South service insertion <br/> PUT
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/service-interfaces/<interface-id>
     * PATCH
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/service-interfaces/<interface-id>
     * PUT
     * /policy/api/v1/infra/tier-1s/<tier-1-id>/locale-services/<locale-service-id>/service-interfaces/<interface-id>
     * PATCH
     * /policy/api/v1/infra/tier-1s/<tier-1-id>/locale-services/<locale-service-id>/service-interfaces/<interface-id>
     * For East-West service insertion <br/> PUT
     * /policy/api/v1/infra/segments/service-segments/<service-segment-id> PATCH
     * /policy/api/v1/infra/segments/service-segments/<service-segment-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.ServiceAttachment
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param serviceAttachmentId (required)
     * @param serviceAttachment (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void update(java.lang.String serviceAttachmentId, com.vmware.nsx.model.ServiceAttachment serviceAttachment, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.ServiceAttachment> asyncCallback);

    /**
     * Modifies an existing service attachment. Updates to name, description and
     * Logical Router list only supported. <br/> This API has been deprecated, please
     * use below Policy API <br/> For North-South service insertion <br/> PUT
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/service-interfaces/<interface-id>
     * PATCH
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/service-interfaces/<interface-id>
     * PUT
     * /policy/api/v1/infra/tier-1s/<tier-1-id>/locale-services/<locale-service-id>/service-interfaces/<interface-id>
     * PATCH
     * /policy/api/v1/infra/tier-1s/<tier-1-id>/locale-services/<locale-service-id>/service-interfaces/<interface-id>
     * For East-West service insertion <br/> PUT
     * /policy/api/v1/infra/segments/service-segments/<service-segment-id> PATCH
     * /policy/api/v1/infra/segments/service-segments/<service-segment-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.ServiceAttachment
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param serviceAttachmentId (required)
     * @param serviceAttachment (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void update(java.lang.String serviceAttachmentId, com.vmware.nsx.model.ServiceAttachment serviceAttachment, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.ServiceAttachment> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
