/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx.transport_zones.
 * Used by client-side stubs.
 */

package com.vmware.nsx.transport_zones;

public interface TransportNodeStatusReportJson extends com.vmware.vapi.bindings.Service, com.vmware.nsx.transport_zones.TransportNodeStatusReportJsonTypes {

    /**
     * Creates a status json report of transport nodes of all the transport zones
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param source Data source type. (optional)
     * @param status Transport node (optional)
     * @return com.vmware.nsx.model.TransportNodeStatusReportListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx.model.TransportNodeStatusReportListResult getall(java.lang.String source, java.lang.String status);

    /**
     * Creates a status json report of transport nodes of all the transport zones
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param source Data source type. (optional)
     * @param status Transport node (optional)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.TransportNodeStatusReportListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx.model.TransportNodeStatusReportListResult getall(java.lang.String source, java.lang.String status, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Creates a status json report of transport nodes of all the transport zones
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.TransportNodeStatusReportListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param source Data source type. (optional)
     * @param status Transport node (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void getall(java.lang.String source, java.lang.String status, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.TransportNodeStatusReportListResult> asyncCallback);

    /**
     * Creates a status json report of transport nodes of all the transport zones
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.TransportNodeStatusReportListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param source Data source type. (optional)
     * @param status Transport node (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void getall(java.lang.String source, java.lang.String status, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.TransportNodeStatusReportListResult> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Creates a status json report of transport nodes in a transport zone
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param zoneId ID of transport zone (required)
     * @param source Data source type. (optional)
     * @param status Transport node (optional)
     * @return com.vmware.nsx.model.TransportNodeStatusReportListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx.model.TransportNodeStatusReportListResult list(java.lang.String zoneId, java.lang.String source, java.lang.String status);

    /**
     * Creates a status json report of transport nodes in a transport zone
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param zoneId ID of transport zone (required)
     * @param source Data source type. (optional)
     * @param status Transport node (optional)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.TransportNodeStatusReportListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx.model.TransportNodeStatusReportListResult list(java.lang.String zoneId, java.lang.String source, java.lang.String status, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Creates a status json report of transport nodes in a transport zone
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.TransportNodeStatusReportListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param zoneId ID of transport zone (required)
     * @param source Data source type. (optional)
     * @param status Transport node (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void list(java.lang.String zoneId, java.lang.String source, java.lang.String status, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.TransportNodeStatusReportListResult> asyncCallback);

    /**
     * Creates a status json report of transport nodes in a transport zone
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.TransportNodeStatusReportListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param zoneId ID of transport zone (required)
     * @param source Data source type. (optional)
     * @param status Transport node (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void list(java.lang.String zoneId, java.lang.String source, java.lang.String status, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.TransportNodeStatusReportListResult> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
