/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx.trust_management.
 * Used by client-side stubs.
 */

package com.vmware.nsx.trust_management;

public interface Certificates extends com.vmware.vapi.bindings.Service, com.vmware.nsx.trust_management.CertificatesTypes {

    /**
     * Look up the Certificate Profile matching the service-type and apply the
     * certificate. When the Certificate Profile has cluster_certificate=false, the
     * node_id parameter is required to designate the node where the certificate needs
     * to be applied.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param certId ID of certificate to apply (required)
     * @param serviceType Supported service types, that are using certificates. (required)
     * @param nodeId Node Id (optional)
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public void applycertificate(java.lang.String certId, java.lang.String serviceType, java.lang.String nodeId);

    /**
     * Look up the Certificate Profile matching the service-type and apply the
     * certificate. When the Certificate Profile has cluster_certificate=false, the
     * node_id parameter is required to designate the node where the certificate needs
     * to be applied.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param certId ID of certificate to apply (required)
     * @param serviceType Supported service types, that are using certificates. (required)
     * @param nodeId Node Id (optional)
     * @param invocationConfig Configuration for the method invocation.
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public void applycertificate(java.lang.String certId, java.lang.String serviceType, java.lang.String nodeId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Look up the Certificate Profile matching the service-type and apply the
     * certificate. When the Certificate Profile has cluster_certificate=false, the
     * node_id parameter is required to designate the node where the certificate needs
     * to be applied.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param certId ID of certificate to apply (required)
     * @param serviceType Supported service types, that are using certificates. (required)
     * @param nodeId Node Id (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void applycertificate(java.lang.String certId, java.lang.String serviceType, java.lang.String nodeId, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback);

    /**
     * Look up the Certificate Profile matching the service-type and apply the
     * certificate. When the Certificate Profile has cluster_certificate=false, the
     * node_id parameter is required to designate the node where the certificate needs
     * to be applied.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param certId ID of certificate to apply (required)
     * @param serviceType Supported service types, that are using certificates. (required)
     * @param nodeId Node Id (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void applycertificate(java.lang.String certId, java.lang.String serviceType, java.lang.String nodeId, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Removes the specified certificate. The private key associated with the
     * certificate is also deleted.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param certId ID of certificate to delete (required)
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public void delete(java.lang.String certId);

    /**
     * Removes the specified certificate. The private key associated with the
     * certificate is also deleted.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param certId ID of certificate to delete (required)
     * @param invocationConfig Configuration for the method invocation.
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public void delete(java.lang.String certId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Removes the specified certificate. The private key associated with the
     * certificate is also deleted.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param certId ID of certificate to delete (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void delete(java.lang.String certId, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback);

    /**
     * Removes the specified certificate. The private key associated with the
     * certificate is also deleted.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param certId ID of certificate to delete (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void delete(java.lang.String certId, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Attempt to connect to an TLS service endpoint and retrieve the server
     * certificate chain it presents.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param tlsServiceEndpoint (required)
     * @return com.vmware.nsx.model.PeerCertificateChain
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx.model.PeerCertificateChain fetchpeercertificatechain(com.vmware.nsx.model.TlsServiceEndpoint tlsServiceEndpoint);

    /**
     * Attempt to connect to an TLS service endpoint and retrieve the server
     * certificate chain it presents.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param tlsServiceEndpoint (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.PeerCertificateChain
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx.model.PeerCertificateChain fetchpeercertificatechain(com.vmware.nsx.model.TlsServiceEndpoint tlsServiceEndpoint, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Attempt to connect to an TLS service endpoint and retrieve the server
     * certificate chain it presents.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.PeerCertificateChain
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param tlsServiceEndpoint (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void fetchpeercertificatechain(com.vmware.nsx.model.TlsServiceEndpoint tlsServiceEndpoint, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.PeerCertificateChain> asyncCallback);

    /**
     * Attempt to connect to an TLS service endpoint and retrieve the server
     * certificate chain it presents.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.PeerCertificateChain
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param tlsServiceEndpoint (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void fetchpeercertificatechain(com.vmware.nsx.model.TlsServiceEndpoint tlsServiceEndpoint, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.PeerCertificateChain> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Returns information for the specified certificate ID, including the
     * certificate's UUID; resource_type (for example, certificate_self_signed,
     * certificate_ca, or certificate_signed); pem_encoded data; and history of the
     * certificate (who created or modified it and when). For additional information,
     * include the ?details=true modifier at the end of the request URI.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param certId ID of certificate to read (required)
     * @param details whether to expand the pem data and show all its details (optional, default to
     * false)
     * @return com.vmware.nsx.model.Certificate
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx.model.Certificate get(java.lang.String certId, java.lang.Boolean details);

    /**
     * Returns information for the specified certificate ID, including the
     * certificate's UUID; resource_type (for example, certificate_self_signed,
     * certificate_ca, or certificate_signed); pem_encoded data; and history of the
     * certificate (who created or modified it and when). For additional information,
     * include the ?details=true modifier at the end of the request URI.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param certId ID of certificate to read (required)
     * @param details whether to expand the pem data and show all its details (optional, default to
     * false)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.Certificate
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx.model.Certificate get(java.lang.String certId, java.lang.Boolean details, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Returns information for the specified certificate ID, including the
     * certificate's UUID; resource_type (for example, certificate_self_signed,
     * certificate_ca, or certificate_signed); pem_encoded data; and history of the
     * certificate (who created or modified it and when). For additional information,
     * include the ?details=true modifier at the end of the request URI.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.Certificate
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param certId ID of certificate to read (required)
     * @param details whether to expand the pem data and show all its details (optional, default to
     * false)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void get(java.lang.String certId, java.lang.Boolean details, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.Certificate> asyncCallback);

    /**
     * Returns information for the specified certificate ID, including the
     * certificate's UUID; resource_type (for example, certificate_self_signed,
     * certificate_ca, or certificate_signed); pem_encoded data; and history of the
     * certificate (who created or modified it and when). For additional information,
     * include the ?details=true modifier at the end of the request URI.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.Certificate
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param certId ID of certificate to read (required)
     * @param details whether to expand the pem data and show all its details (optional, default to
     * false)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void get(java.lang.String certId, java.lang.Boolean details, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.Certificate> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Adds a new private-public certificate or a chain of certificates (CAs) and,
     * optionally, a private key that can be applied to one of the user-facing
     * components (appliance management or edge). The certificate and the key should be
     * stored in PEM format. If no private key is provided, the certificate is used as
     * a client certificate in the trust store. A private key can be uploaded for a CA
     * certificate only if the \"purpose\" parameter is set to \"signing-ca\".
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param trustObjectData (required)
     * @return com.vmware.nsx.model.CertificateList
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx.model.CertificateList importcertificate(com.vmware.nsx.model.TrustObjectData trustObjectData);

    /**
     * Adds a new private-public certificate or a chain of certificates (CAs) and,
     * optionally, a private key that can be applied to one of the user-facing
     * components (appliance management or edge). The certificate and the key should be
     * stored in PEM format. If no private key is provided, the certificate is used as
     * a client certificate in the trust store. A private key can be uploaded for a CA
     * certificate only if the \"purpose\" parameter is set to \"signing-ca\".
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param trustObjectData (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.CertificateList
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx.model.CertificateList importcertificate(com.vmware.nsx.model.TrustObjectData trustObjectData, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Adds a new private-public certificate or a chain of certificates (CAs) and,
     * optionally, a private key that can be applied to one of the user-facing
     * components (appliance management or edge). The certificate and the key should be
     * stored in PEM format. If no private key is provided, the certificate is used as
     * a client certificate in the trust store. A private key can be uploaded for a CA
     * certificate only if the \"purpose\" parameter is set to \"signing-ca\".
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.CertificateList
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param trustObjectData (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void importcertificate(com.vmware.nsx.model.TrustObjectData trustObjectData, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.CertificateList> asyncCallback);

    /**
     * Adds a new private-public certificate or a chain of certificates (CAs) and,
     * optionally, a private key that can be applied to one of the user-facing
     * components (appliance management or edge). The certificate and the key should be
     * stored in PEM format. If no private key is provided, the certificate is used as
     * a client certificate in the trust store. A private key can be uploaded for a CA
     * certificate only if the \"purpose\" parameter is set to \"signing-ca\".
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.CertificateList
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param trustObjectData (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void importcertificate(com.vmware.nsx.model.TrustObjectData trustObjectData, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.CertificateList> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Add a CA certificate as a trust anchor
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param alias Alias under which to store the trusted CA in the trust-store (required)
     * @param trustObjectData (required)
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public void importtrustedca(java.lang.String alias, com.vmware.nsx.model.TrustObjectData trustObjectData);

    /**
     * Add a CA certificate as a trust anchor
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param alias Alias under which to store the trusted CA in the trust-store (required)
     * @param trustObjectData (required)
     * @param invocationConfig Configuration for the method invocation.
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public void importtrustedca(java.lang.String alias, com.vmware.nsx.model.TrustObjectData trustObjectData, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Add a CA certificate as a trust anchor
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param alias Alias under which to store the trusted CA in the trust-store (required)
     * @param trustObjectData (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void importtrustedca(java.lang.String alias, com.vmware.nsx.model.TrustObjectData trustObjectData, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback);

    /**
     * Add a CA certificate as a trust anchor
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param alias Alias under which to store the trusted CA in the trust-store (required)
     * @param trustObjectData (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void importtrustedca(java.lang.String alias, com.vmware.nsx.model.TrustObjectData trustObjectData, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Returns all certificate information viewable by the user, including each
     * certificate's UUID; resource_type (for example, certificate_self_signed,
     * certificate_ca, or certificate_signed); pem_encoded data; and history of the
     * certificate (who created or modified it and when). For additional information,
     * include the ?details=true modifier at the end of the request URI.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param details whether to expand the pem data and show all its details (optional, default to
     * false)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param nodeId Node ID of certificate to return (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param type Type of certificate to return (optional)
     * @return com.vmware.nsx.model.CertificateList
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx.model.CertificateList list(java.lang.String cursor, java.lang.Boolean details, java.lang.String includedFields, java.lang.String nodeId, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, java.lang.String type);

    /**
     * Returns all certificate information viewable by the user, including each
     * certificate's UUID; resource_type (for example, certificate_self_signed,
     * certificate_ca, or certificate_signed); pem_encoded data; and history of the
     * certificate (who created or modified it and when). For additional information,
     * include the ?details=true modifier at the end of the request URI.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param details whether to expand the pem data and show all its details (optional, default to
     * false)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param nodeId Node ID of certificate to return (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param type Type of certificate to return (optional)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.CertificateList
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx.model.CertificateList list(java.lang.String cursor, java.lang.Boolean details, java.lang.String includedFields, java.lang.String nodeId, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, java.lang.String type, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Returns all certificate information viewable by the user, including each
     * certificate's UUID; resource_type (for example, certificate_self_signed,
     * certificate_ca, or certificate_signed); pem_encoded data; and history of the
     * certificate (who created or modified it and when). For additional information,
     * include the ?details=true modifier at the end of the request URI.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.CertificateList
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param details whether to expand the pem data and show all its details (optional, default to
     * false)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param nodeId Node ID of certificate to return (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param type Type of certificate to return (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void list(java.lang.String cursor, java.lang.Boolean details, java.lang.String includedFields, java.lang.String nodeId, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, java.lang.String type, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.CertificateList> asyncCallback);

    /**
     * Returns all certificate information viewable by the user, including each
     * certificate's UUID; resource_type (for example, certificate_self_signed,
     * certificate_ca, or certificate_signed); pem_encoded data; and history of the
     * certificate (who created or modified it and when). For additional information,
     * include the ?details=true modifier at the end of the request URI.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.CertificateList
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param details whether to expand the pem data and show all its details (optional, default to
     * false)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param nodeId Node ID of certificate to return (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param type Type of certificate to return (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void list(java.lang.String cursor, java.lang.Boolean details, java.lang.String includedFields, java.lang.String nodeId, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, java.lang.String type, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.CertificateList> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Set a certificate that has been imported to be the Appliance Proxy certificate
     * used for communicating with Appliance Proxies on other sites. <br/> <br/> Please
     * use below APIs. <br/> POST
     * https://<nsx-mgr>/api/v1/trust-management/certificates/<cert-id>?action=apply_certificate&service_type=APH
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param setInterSiteAphCertificateRequest (required)
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public void setapplianceproxycertificateforintersitecommunication(com.vmware.nsx.model.SetInterSiteAphCertificateRequest setInterSiteAphCertificateRequest);

    /**
     * Set a certificate that has been imported to be the Appliance Proxy certificate
     * used for communicating with Appliance Proxies on other sites. <br/> <br/> Please
     * use below APIs. <br/> POST
     * https://<nsx-mgr>/api/v1/trust-management/certificates/<cert-id>?action=apply_certificate&service_type=APH
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param setInterSiteAphCertificateRequest (required)
     * @param invocationConfig Configuration for the method invocation.
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public void setapplianceproxycertificateforintersitecommunication(com.vmware.nsx.model.SetInterSiteAphCertificateRequest setInterSiteAphCertificateRequest, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Set a certificate that has been imported to be the Appliance Proxy certificate
     * used for communicating with Appliance Proxies on other sites. <br/> <br/> Please
     * use below APIs. <br/> POST
     * https://<nsx-mgr>/api/v1/trust-management/certificates/<cert-id>?action=apply_certificate&service_type=APH
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param setInterSiteAphCertificateRequest (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void setapplianceproxycertificateforintersitecommunication(com.vmware.nsx.model.SetInterSiteAphCertificateRequest setInterSiteAphCertificateRequest, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback);

    /**
     * Set a certificate that has been imported to be the Appliance Proxy certificate
     * used for communicating with Appliance Proxies on other sites. <br/> <br/> Please
     * use below APIs. <br/> POST
     * https://<nsx-mgr>/api/v1/trust-management/certificates/<cert-id>?action=apply_certificate&service_type=APH
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param setInterSiteAphCertificateRequest (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void setapplianceproxycertificateforintersitecommunication(com.vmware.nsx.model.SetInterSiteAphCertificateRequest setInterSiteAphCertificateRequest, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Set a certificate that has been imported to be either the principal identity
     * certificate for the local cluster with either GM or LM service type. Currently,
     * the service type specified must match the current service type of the local
     * cluster. <br/> <br/> Please use below APIs. <br/> POST
     * https://<nsx-mgr>/api/v1/trust-management/certificates/<cert-id>?action=apply_certificate&service_type=LOCAL_MANAGER
     * <br/> POST
     * https://<nsx-mgr>/api/v1/trust-management/certificates/<cert-id>?action=apply_certificate&service_type=GLOBAL_MANAGER
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param setPrincipalIdentityCertificateForFederationRequest (required)
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public void setpicertificateforfederation(com.vmware.nsx.model.SetPrincipalIdentityCertificateForFederationRequest setPrincipalIdentityCertificateForFederationRequest);

    /**
     * Set a certificate that has been imported to be either the principal identity
     * certificate for the local cluster with either GM or LM service type. Currently,
     * the service type specified must match the current service type of the local
     * cluster. <br/> <br/> Please use below APIs. <br/> POST
     * https://<nsx-mgr>/api/v1/trust-management/certificates/<cert-id>?action=apply_certificate&service_type=LOCAL_MANAGER
     * <br/> POST
     * https://<nsx-mgr>/api/v1/trust-management/certificates/<cert-id>?action=apply_certificate&service_type=GLOBAL_MANAGER
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param setPrincipalIdentityCertificateForFederationRequest (required)
     * @param invocationConfig Configuration for the method invocation.
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public void setpicertificateforfederation(com.vmware.nsx.model.SetPrincipalIdentityCertificateForFederationRequest setPrincipalIdentityCertificateForFederationRequest, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Set a certificate that has been imported to be either the principal identity
     * certificate for the local cluster with either GM or LM service type. Currently,
     * the service type specified must match the current service type of the local
     * cluster. <br/> <br/> Please use below APIs. <br/> POST
     * https://<nsx-mgr>/api/v1/trust-management/certificates/<cert-id>?action=apply_certificate&service_type=LOCAL_MANAGER
     * <br/> POST
     * https://<nsx-mgr>/api/v1/trust-management/certificates/<cert-id>?action=apply_certificate&service_type=GLOBAL_MANAGER
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param setPrincipalIdentityCertificateForFederationRequest (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void setpicertificateforfederation(com.vmware.nsx.model.SetPrincipalIdentityCertificateForFederationRequest setPrincipalIdentityCertificateForFederationRequest, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback);

    /**
     * Set a certificate that has been imported to be either the principal identity
     * certificate for the local cluster with either GM or LM service type. Currently,
     * the service type specified must match the current service type of the local
     * cluster. <br/> <br/> Please use below APIs. <br/> POST
     * https://<nsx-mgr>/api/v1/trust-management/certificates/<cert-id>?action=apply_certificate&service_type=LOCAL_MANAGER
     * <br/> POST
     * https://<nsx-mgr>/api/v1/trust-management/certificates/<cert-id>?action=apply_certificate&service_type=GLOBAL_MANAGER
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param setPrincipalIdentityCertificateForFederationRequest (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void setpicertificateforfederation(com.vmware.nsx.model.SetPrincipalIdentityCertificateForFederationRequest setPrincipalIdentityCertificateForFederationRequest, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Checks whether certificate is valid. When the certificate contains a chain, the
     * full chain is validated. The usage parameter can be SERVER (default) or CLIENT.
     * This indicates whether the certificate needs to be validated as a server-auth or
     * a client-auth certificate.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param certId ID of certificate to validate (required)
     * @param usage Usage Type of the Certificate, SERVER or CLIENT. Default is SERVER (optional)
     * @return com.vmware.nsx.model.CertificateCheckingStatus
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx.model.CertificateCheckingStatus validate(java.lang.String certId, java.lang.String usage);

    /**
     * Checks whether certificate is valid. When the certificate contains a chain, the
     * full chain is validated. The usage parameter can be SERVER (default) or CLIENT.
     * This indicates whether the certificate needs to be validated as a server-auth or
     * a client-auth certificate.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param certId ID of certificate to validate (required)
     * @param usage Usage Type of the Certificate, SERVER or CLIENT. Default is SERVER (optional)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.CertificateCheckingStatus
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx.model.CertificateCheckingStatus validate(java.lang.String certId, java.lang.String usage, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Checks whether certificate is valid. When the certificate contains a chain, the
     * full chain is validated. The usage parameter can be SERVER (default) or CLIENT.
     * This indicates whether the certificate needs to be validated as a server-auth or
     * a client-auth certificate.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.CertificateCheckingStatus
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param certId ID of certificate to validate (required)
     * @param usage Usage Type of the Certificate, SERVER or CLIENT. Default is SERVER (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void validate(java.lang.String certId, java.lang.String usage, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.CertificateCheckingStatus> asyncCallback);

    /**
     * Checks whether certificate is valid. When the certificate contains a chain, the
     * full chain is validated. The usage parameter can be SERVER (default) or CLIENT.
     * This indicates whether the certificate needs to be validated as a server-auth or
     * a client-auth certificate.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.CertificateCheckingStatus
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param certId ID of certificate to validate (required)
     * @param usage Usage Type of the Certificate, SERVER or CLIENT. Default is SERVER (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void validate(java.lang.String certId, java.lang.String usage, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.CertificateCheckingStatus> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
