/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx.trust_management.
 * Used by client-side stubs.
 */

package com.vmware.nsx.trust_management;

public interface CsrsExtended extends com.vmware.vapi.bindings.Service, com.vmware.nsx.trust_management.CsrsExtendedTypes {

    /**
     * Creates a new certificate signing request (CSR) with selected extensions. A CSR
     * is encrypted text that contains information about your organization
     * (organization name, country, and so on), additional attributes as extensions,
     * and your Web server's public key, which is a public certificate the is generated
     * on the server that can be used to forward this request to a certificate
     * authority (CA). A private key is also usually created at the same time as the
     * CSR.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param csrExt (required)
     * @return com.vmware.nsx.model.Csr
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx.model.Csr create(com.vmware.nsx.model.CsrExt csrExt);

    /**
     * Creates a new certificate signing request (CSR) with selected extensions. A CSR
     * is encrypted text that contains information about your organization
     * (organization name, country, and so on), additional attributes as extensions,
     * and your Web server's public key, which is a public certificate the is generated
     * on the server that can be used to forward this request to a certificate
     * authority (CA). A private key is also usually created at the same time as the
     * CSR.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param csrExt (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.Csr
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx.model.Csr create(com.vmware.nsx.model.CsrExt csrExt, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Creates a new certificate signing request (CSR) with selected extensions. A CSR
     * is encrypted text that contains information about your organization
     * (organization name, country, and so on), additional attributes as extensions,
     * and your Web server's public key, which is a public certificate the is generated
     * on the server that can be used to forward this request to a certificate
     * authority (CA). A private key is also usually created at the same time as the
     * CSR.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.Csr
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param csrExt (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void create(com.vmware.nsx.model.CsrExt csrExt, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.Csr> asyncCallback);

    /**
     * Creates a new certificate signing request (CSR) with selected extensions. A CSR
     * is encrypted text that contains information about your organization
     * (organization name, country, and so on), additional attributes as extensions,
     * and your Web server's public key, which is a public certificate the is generated
     * on the server that can be used to forward this request to a certificate
     * authority (CA). A private key is also usually created at the same time as the
     * CSR.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.Csr
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param csrExt (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void create(com.vmware.nsx.model.CsrExt csrExt, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.Csr> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
