/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx.upgrade.
 * Used by client-side stubs.
 */

package com.vmware.nsx.upgrade;

public interface Plan extends com.vmware.vapi.bindings.Service, com.vmware.nsx.upgrade.PlanTypes {

    /**
     * Continue the upgrade. Resumes the upgrade from the point where it was paused.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param componentType Component to upgrade. (optional)
     * @param skip Skip to upgrade of next component. (optional, default to false)
     * @throws com.vmware.vapi.std.errors.ConcurrentChange  Conflict
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public void continue_(java.lang.String componentType, java.lang.Boolean skip);

    /**
     * Continue the upgrade. Resumes the upgrade from the point where it was paused.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param componentType Component to upgrade. (optional)
     * @param skip Skip to upgrade of next component. (optional, default to false)
     * @param invocationConfig Configuration for the method invocation.
     * @throws com.vmware.vapi.std.errors.ConcurrentChange  Conflict
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public void continue_(java.lang.String componentType, java.lang.Boolean skip, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Continue the upgrade. Resumes the upgrade from the point where it was paused.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.ConcurrentChange} -  Conflict<br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param componentType Component to upgrade. (optional)
     * @param skip Skip to upgrade of next component. (optional, default to false)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void continue_(java.lang.String componentType, java.lang.Boolean skip, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback);

    /**
     * Continue the upgrade. Resumes the upgrade from the point where it was paused.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.ConcurrentChange} -  Conflict<br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param componentType Component to upgrade. (optional)
     * @param skip Skip to upgrade of next component. (optional, default to false)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void continue_(java.lang.String componentType, java.lang.Boolean skip, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Pause the upgrade. Upgrade will be paused after upgrade of all the nodes
     * currently in progress is completed either successfully or with failure. User can
     * make changes in the upgrade plan when the upgrade is paused.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @throws com.vmware.vapi.std.errors.ConcurrentChange  Conflict
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public void pause();

    /**
     * Pause the upgrade. Upgrade will be paused after upgrade of all the nodes
     * currently in progress is completed either successfully or with failure. User can
     * make changes in the upgrade plan when the upgrade is paused.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param invocationConfig Configuration for the method invocation.
     * @throws com.vmware.vapi.std.errors.ConcurrentChange  Conflict
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public void pause(com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Pause the upgrade. Upgrade will be paused after upgrade of all the nodes
     * currently in progress is completed either successfully or with failure. User can
     * make changes in the upgrade plan when the upgrade is paused.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.ConcurrentChange} -  Conflict<br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void pause(com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback);

    /**
     * Pause the upgrade. Upgrade will be paused after upgrade of all the nodes
     * currently in progress is completed either successfully or with failure. User can
     * make changes in the upgrade plan when the upgrade is paused.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.ConcurrentChange} -  Conflict<br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void pause(com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Reset the upgrade plan to default plan. User has an option to change the default
     * plan. But if after making changes, user wants to go back to the default plan,
     * this is the way to do so.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param componentType Component type (required)
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public void reset(java.lang.String componentType);

    /**
     * Reset the upgrade plan to default plan. User has an option to change the default
     * plan. But if after making changes, user wants to go back to the default plan,
     * this is the way to do so.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param componentType Component type (required)
     * @param invocationConfig Configuration for the method invocation.
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public void reset(java.lang.String componentType, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Reset the upgrade plan to default plan. User has an option to change the default
     * plan. But if after making changes, user wants to go back to the default plan,
     * this is the way to do so.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param componentType Component type (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void reset(java.lang.String componentType, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback);

    /**
     * Reset the upgrade plan to default plan. User has an option to change the default
     * plan. But if after making changes, user wants to go back to the default plan,
     * this is the way to do so.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param componentType Component type (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void reset(java.lang.String componentType, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * This will stage the upgrade bits so that upgrade can be driven from outside NSX
     * upgrade-coordinator. If component type is not provided as a request parameter
     * then upgrade staging will be performed on all the components.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param componentType Component type (optional)
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public void stageupgrade(java.lang.String componentType);

    /**
     * This will stage the upgrade bits so that upgrade can be driven from outside NSX
     * upgrade-coordinator. If component type is not provided as a request parameter
     * then upgrade staging will be performed on all the components.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param componentType Component type (optional)
     * @param invocationConfig Configuration for the method invocation.
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public void stageupgrade(java.lang.String componentType, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * This will stage the upgrade bits so that upgrade can be driven from outside NSX
     * upgrade-coordinator. If component type is not provided as a request parameter
     * then upgrade staging will be performed on all the components.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param componentType Component type (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void stageupgrade(java.lang.String componentType, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback);

    /**
     * This will stage the upgrade bits so that upgrade can be driven from outside NSX
     * upgrade-coordinator. If component type is not provided as a request parameter
     * then upgrade staging will be performed on all the components.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param componentType Component type (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void stageupgrade(java.lang.String componentType, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Start the upgrade. Upgrade will start as per the upgrade plan.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param componentType Type of the component (optional)
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public void start(java.lang.String componentType);

    /**
     * Start the upgrade. Upgrade will start as per the upgrade plan.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param componentType Type of the component (optional)
     * @param invocationConfig Configuration for the method invocation.
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public void start(java.lang.String componentType, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Start the upgrade. Upgrade will start as per the upgrade plan.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param componentType Type of the component (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void start(java.lang.String componentType, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback);

    /**
     * Start the upgrade. Upgrade will start as per the upgrade plan.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param componentType Type of the component (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void start(java.lang.String componentType, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Depending on current upgrade state, start or continue the upgrade.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param componentType Type of the component (optional)
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public void upgrade(java.lang.String componentType);

    /**
     * Depending on current upgrade state, start or continue the upgrade.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param componentType Type of the component (optional)
     * @param invocationConfig Configuration for the method invocation.
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public void upgrade(java.lang.String componentType, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Depending on current upgrade state, start or continue the upgrade.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param componentType Type of the component (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void upgrade(java.lang.String componentType, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback);

    /**
     * Depending on current upgrade state, start or continue the upgrade.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param componentType Type of the component (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void upgrade(java.lang.String componentType, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Upgrades, Resumes the upgrade of a selected set of units.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param upgradeUnitList (required)
     * @throws com.vmware.vapi.std.errors.ConcurrentChange  Conflict
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public void upgradeselectedunits(com.vmware.nsx.model.UpgradeUnitList upgradeUnitList);

    /**
     * Upgrades, Resumes the upgrade of a selected set of units.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param upgradeUnitList (required)
     * @param invocationConfig Configuration for the method invocation.
     * @throws com.vmware.vapi.std.errors.ConcurrentChange  Conflict
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public void upgradeselectedunits(com.vmware.nsx.model.UpgradeUnitList upgradeUnitList, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Upgrades, Resumes the upgrade of a selected set of units.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.ConcurrentChange} -  Conflict<br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param upgradeUnitList (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void upgradeselectedunits(com.vmware.nsx.model.UpgradeUnitList upgradeUnitList, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback);

    /**
     * Upgrades, Resumes the upgrade of a selected set of units.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.ConcurrentChange} -  Conflict<br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param upgradeUnitList (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void upgradeselectedunits(com.vmware.nsx.model.UpgradeUnitList upgradeUnitList, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
