
/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 */


package com.vmware.nsx.upgrade;

/**
 * {@link UpgradeFactory} is responsible for creating instances of services
 * contained inside the com.vmware.nsx.upgrade package and also has the subpackages reference
 * to access respective subpackage services.
 * <p>
*/
public class UpgradeFactory {

    private com.vmware.vapi.bindings.StubFactory stubFactory;
    private com.vmware.vapi.bindings.StubConfiguration stubConfig;

    // restricting developers to create instance of this class directly
    private UpgradeFactory() {

    }

    /**
     * Creates the new instance of this class with provided configuration
     * @param stubFactory {@link StubFactory} instance is responsible for creating stubs
     * @param stubConfig {@link StubConfiguration} instance is required to authenticate the request
     * @return {@link UpgradeFactory} factory instance
     */
    public static UpgradeFactory getFactory(com.vmware.vapi.bindings.StubFactory stubFactory, com.vmware.vapi.bindings.StubConfiguration stubConfig) {
        UpgradeFactory instance = new UpgradeFactory();
        instance.stubFactory = stubFactory;
        instance.stubConfig = stubConfig;
        return instance;
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.upgrade.AvailableReleases}
     */
    public com.vmware.nsx.upgrade.AvailableReleases availableReleasesService() {
        return this.stubFactory.createStub(AvailableReleases.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.upgrade.Bundles}
     */
    public com.vmware.nsx.upgrade.Bundles bundlesService() {
        return this.stubFactory.createStub(Bundles.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.upgrade.FilterGroups}
     */
    public com.vmware.nsx.upgrade.FilterGroups filterGroupsService() {
        return this.stubFactory.createStub(FilterGroups.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.upgrade.FilterUnits}
     */
    public com.vmware.nsx.upgrade.FilterUnits filterUnitsService() {
        return this.stubFactory.createStub(FilterUnits.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.upgrade.FunctionalState}
     */
    public com.vmware.nsx.upgrade.FunctionalState functionalStateService() {
        return this.stubFactory.createStub(FunctionalState.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.upgrade.History}
     */
    public com.vmware.nsx.upgrade.History historyService() {
        return this.stubFactory.createStub(History.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.upgrade.Nodes}
     */
    public com.vmware.nsx.upgrade.Nodes nodesService() {
        return this.stubFactory.createStub(Nodes.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.upgrade.NodesSummary}
     */
    public com.vmware.nsx.upgrade.NodesSummary nodesSummaryService() {
        return this.stubFactory.createStub(NodesSummary.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.upgrade.Plan}
     */
    public com.vmware.nsx.upgrade.Plan planService() {
        return this.stubFactory.createStub(Plan.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.upgrade.PreUpgradeChecks}
     */
    public com.vmware.nsx.upgrade.PreUpgradeChecks preUpgradeChecksService() {
        return this.stubFactory.createStub(PreUpgradeChecks.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.upgrade.StatusSummary}
     */
    public com.vmware.nsx.upgrade.StatusSummary statusSummaryService() {
        return this.stubFactory.createStub(StatusSummary.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.upgrade.Summary}
     */
    public com.vmware.nsx.upgrade.Summary summaryService() {
        return this.stubFactory.createStub(Summary.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.upgrade.UcBundleMetadata}
     */
    public com.vmware.nsx.upgrade.UcBundleMetadata ucBundleMetadataService() {
        return this.stubFactory.createStub(UcBundleMetadata.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.upgrade.UcUpgradeMetadata}
     */
    public com.vmware.nsx.upgrade.UcUpgradeMetadata ucUpgradeMetadataService() {
        return this.stubFactory.createStub(UcUpgradeMetadata.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.upgrade.UcUpgradeStatus}
     */
    public com.vmware.nsx.upgrade.UcUpgradeStatus ucUpgradeStatusService() {
        return this.stubFactory.createStub(UcUpgradeStatus.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.upgrade.UpgradeChecksInfo}
     */
    public com.vmware.nsx.upgrade.UpgradeChecksInfo upgradeChecksInfoService() {
        return this.stubFactory.createStub(UpgradeChecksInfo.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.upgrade.UpgradeUnitGroups}
     */
    public com.vmware.nsx.upgrade.UpgradeUnitGroups upgradeUnitGroupsService() {
        return this.stubFactory.createStub(UpgradeUnitGroups.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.upgrade.UpgradeUnitGroupsStatus}
     */
    public com.vmware.nsx.upgrade.UpgradeUnitGroupsStatus upgradeUnitGroupsStatusService() {
        return this.stubFactory.createStub(UpgradeUnitGroupsStatus.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.upgrade.UpgradeUnits}
     */
    public com.vmware.nsx.upgrade.UpgradeUnits upgradeUnitsService() {
        return this.stubFactory.createStub(UpgradeUnits.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.upgrade.UpgradeUnitsStats}
     */
    public com.vmware.nsx.upgrade.UpgradeUnitsStats upgradeUnitsStatsService() {
        return this.stubFactory.createStub(UpgradeUnitsStats.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.upgrade.VersionWhitelist}
     */
    public com.vmware.nsx.upgrade.VersionWhitelist versionWhitelistService() {
        return this.stubFactory.createStub(VersionWhitelist.class, this.stubConfig);
    }

    public com.vmware.nsx.upgrade.bundles.BundlesFactory bundles() {
        return com.vmware.nsx.upgrade.bundles.BundlesFactory.getFactory(this.stubFactory, this.stubConfig);
    }

    public com.vmware.nsx.upgrade.eula.EulaFactory eula() {
        return com.vmware.nsx.upgrade.eula.EulaFactory.getFactory(this.stubFactory, this.stubConfig);
    }

    public com.vmware.nsx.upgrade.filter.FilterFactory filter() {
        return com.vmware.nsx.upgrade.filter.FilterFactory.getFactory(this.stubFactory, this.stubConfig);
    }

    public com.vmware.nsx.upgrade.plan.PlanFactory plan() {
        return com.vmware.nsx.upgrade.plan.PlanFactory.getFactory(this.stubFactory, this.stubConfig);
    }

    public com.vmware.nsx.upgrade.pre_upgrade_checks.PreUpgradeChecksFactory preUpgradeChecks() {
        return com.vmware.nsx.upgrade.pre_upgrade_checks.PreUpgradeChecksFactory.getFactory(this.stubFactory, this.stubConfig);
    }

    public com.vmware.nsx.upgrade.ui.UiFactory ui() {
        return com.vmware.nsx.upgrade.ui.UiFactory.getFactory(this.stubFactory, this.stubConfig);
    }

    public com.vmware.nsx.upgrade.upgrade_unit_groups.UpgradeUnitGroupsFactory upgradeUnitGroups() {
        return com.vmware.nsx.upgrade.upgrade_unit_groups.UpgradeUnitGroupsFactory.getFactory(this.stubFactory, this.stubConfig);
    }

    public com.vmware.nsx.upgrade.upgrade_units.UpgradeUnitsFactory upgradeUnits() {
        return com.vmware.nsx.upgrade.upgrade_units.UpgradeUnitsFactory.getFactory(this.stubFactory, this.stubConfig);
    }

    public void updateStubConfiguration(com.vmware.vapi.bindings.StubFactory stubFactory, com.vmware.vapi.bindings.StubConfiguration stubConfig) {
        if (this.stubFactory == stubFactory && this.stubConfig == stubConfig)
            return;

        this.stubFactory = stubFactory;
        this.stubConfig = stubConfig;
    }

}
