/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx.upgrade.upgrade_unit_groups.
 * Used by client-side stubs.
 */

package com.vmware.nsx.upgrade.upgrade_unit_groups;

public interface AggregateInfo extends com.vmware.vapi.bindings.Service, com.vmware.nsx.upgrade.upgrade_unit_groups.AggregateInfoTypes {

    /**
     * Return information of all upgrade unit groups in the upgrade plan. If request
     * parameter summary is set to true, then only count of upgrade units will be
     * returned, upgrade units list will be empty. If request parameter component type
     * is specified, then all upgrade unit groups for that component will be returned.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param componentType Component type based on which upgrade unit groups to be filtered (optional)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param summary Flag indicating whether to return summary (optional, default to false)
     * @param sync Synchronize before returning upgrade unit groups (optional, default to false)
     * @return com.vmware.nsx.model.UpgradeUnitGroupAggregateInfoListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx.model.UpgradeUnitGroupAggregateInfoListResult list(java.lang.String componentType, java.lang.String cursor, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, java.lang.Boolean summary, java.lang.Boolean sync);

    /**
     * Return information of all upgrade unit groups in the upgrade plan. If request
     * parameter summary is set to true, then only count of upgrade units will be
     * returned, upgrade units list will be empty. If request parameter component type
     * is specified, then all upgrade unit groups for that component will be returned.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param componentType Component type based on which upgrade unit groups to be filtered (optional)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param summary Flag indicating whether to return summary (optional, default to false)
     * @param sync Synchronize before returning upgrade unit groups (optional, default to false)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.UpgradeUnitGroupAggregateInfoListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx.model.UpgradeUnitGroupAggregateInfoListResult list(java.lang.String componentType, java.lang.String cursor, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, java.lang.Boolean summary, java.lang.Boolean sync, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Return information of all upgrade unit groups in the upgrade plan. If request
     * parameter summary is set to true, then only count of upgrade units will be
     * returned, upgrade units list will be empty. If request parameter component type
     * is specified, then all upgrade unit groups for that component will be returned.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.UpgradeUnitGroupAggregateInfoListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param componentType Component type based on which upgrade unit groups to be filtered (optional)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param summary Flag indicating whether to return summary (optional, default to false)
     * @param sync Synchronize before returning upgrade unit groups (optional, default to false)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void list(java.lang.String componentType, java.lang.String cursor, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, java.lang.Boolean summary, java.lang.Boolean sync, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.UpgradeUnitGroupAggregateInfoListResult> asyncCallback);

    /**
     * Return information of all upgrade unit groups in the upgrade plan. If request
     * parameter summary is set to true, then only count of upgrade units will be
     * returned, upgrade units list will be empty. If request parameter component type
     * is specified, then all upgrade unit groups for that component will be returned.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.UpgradeUnitGroupAggregateInfoListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param componentType Component type based on which upgrade unit groups to be filtered (optional)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param summary Flag indicating whether to return summary (optional, default to false)
     * @param sync Synchronize before returning upgrade unit groups (optional, default to false)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void list(java.lang.String componentType, java.lang.String cursor, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, java.lang.Boolean summary, java.lang.Boolean sync, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.UpgradeUnitGroupAggregateInfoListResult> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
