/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx.vpn.ipsec.
 * Used by client-side stubs.
 */

package com.vmware.nsx.vpn.ipsec;

public interface IkeProfiles extends com.vmware.vapi.bindings.Service, com.vmware.nsx.vpn.ipsec.IkeProfilesTypes {

    /**
     * Create custom internet key exchange (IKE) Profile. IKE Profile is a reusable
     * profile that captures IKE and phase one negotiation parameters. System will be
     * pre provisioned with system owned non editable default IKE profile and suggested
     * set of profiles that can be used for peering with popular remote peers like AWS
     * VPN. User can create custom profiles as needed. Any change in profile affects
     * all sessions consuming this profile. <br/> <br/> Please use below Policy API.
     * <br/> PATCH /policy/api/v1/infra/ipsec-vpn-ike-profiles/<ike-profile-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param ipSecVPNIKEProfile (required)
     * @return com.vmware.nsx.model.IPSecVPNIKEProfile
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.IPSecVPNIKEProfile create(com.vmware.nsx.model.IPSecVPNIKEProfile ipSecVPNIKEProfile);

    /**
     * Create custom internet key exchange (IKE) Profile. IKE Profile is a reusable
     * profile that captures IKE and phase one negotiation parameters. System will be
     * pre provisioned with system owned non editable default IKE profile and suggested
     * set of profiles that can be used for peering with popular remote peers like AWS
     * VPN. User can create custom profiles as needed. Any change in profile affects
     * all sessions consuming this profile. <br/> <br/> Please use below Policy API.
     * <br/> PATCH /policy/api/v1/infra/ipsec-vpn-ike-profiles/<ike-profile-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param ipSecVPNIKEProfile (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.IPSecVPNIKEProfile
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.IPSecVPNIKEProfile create(com.vmware.nsx.model.IPSecVPNIKEProfile ipSecVPNIKEProfile, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Create custom internet key exchange (IKE) Profile. IKE Profile is a reusable
     * profile that captures IKE and phase one negotiation parameters. System will be
     * pre provisioned with system owned non editable default IKE profile and suggested
     * set of profiles that can be used for peering with popular remote peers like AWS
     * VPN. User can create custom profiles as needed. Any change in profile affects
     * all sessions consuming this profile. <br/> <br/> Please use below Policy API.
     * <br/> PATCH /policy/api/v1/infra/ipsec-vpn-ike-profiles/<ike-profile-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.IPSecVPNIKEProfile
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param ipSecVPNIKEProfile (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void create(com.vmware.nsx.model.IPSecVPNIKEProfile ipSecVPNIKEProfile, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.IPSecVPNIKEProfile> asyncCallback);

    /**
     * Create custom internet key exchange (IKE) Profile. IKE Profile is a reusable
     * profile that captures IKE and phase one negotiation parameters. System will be
     * pre provisioned with system owned non editable default IKE profile and suggested
     * set of profiles that can be used for peering with popular remote peers like AWS
     * VPN. User can create custom profiles as needed. Any change in profile affects
     * all sessions consuming this profile. <br/> <br/> Please use below Policy API.
     * <br/> PATCH /policy/api/v1/infra/ipsec-vpn-ike-profiles/<ike-profile-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.IPSecVPNIKEProfile
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param ipSecVPNIKEProfile (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void create(com.vmware.nsx.model.IPSecVPNIKEProfile ipSecVPNIKEProfile, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.IPSecVPNIKEProfile> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Delete custom IKE Profile. Profile can not be deleted if profile has references
     * to it. <br/> <br/> Please use below Policy API. <br/> DELETE
     * /policy/api/v1/infra/ipsec-vpn-ike-profiles/<ike-profile-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param ipsecVpnIkeProfileId (required)
     * @param force Force delete the resource even if it is being used somewhere (optional, default
     * to false)
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public void delete(java.lang.String ipsecVpnIkeProfileId, java.lang.Boolean force);

    /**
     * Delete custom IKE Profile. Profile can not be deleted if profile has references
     * to it. <br/> <br/> Please use below Policy API. <br/> DELETE
     * /policy/api/v1/infra/ipsec-vpn-ike-profiles/<ike-profile-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param ipsecVpnIkeProfileId (required)
     * @param force Force delete the resource even if it is being used somewhere (optional, default
     * to false)
     * @param invocationConfig Configuration for the method invocation.
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public void delete(java.lang.String ipsecVpnIkeProfileId, java.lang.Boolean force, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Delete custom IKE Profile. Profile can not be deleted if profile has references
     * to it. <br/> <br/> Please use below Policy API. <br/> DELETE
     * /policy/api/v1/infra/ipsec-vpn-ike-profiles/<ike-profile-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param ipsecVpnIkeProfileId (required)
     * @param force Force delete the resource even if it is being used somewhere (optional, default
     * to false)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void delete(java.lang.String ipsecVpnIkeProfileId, java.lang.Boolean force, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback);

    /**
     * Delete custom IKE Profile. Profile can not be deleted if profile has references
     * to it. <br/> <br/> Please use below Policy API. <br/> DELETE
     * /policy/api/v1/infra/ipsec-vpn-ike-profiles/<ike-profile-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param ipsecVpnIkeProfileId (required)
     * @param force Force delete the resource even if it is being used somewhere (optional, default
     * to false)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void delete(java.lang.String ipsecVpnIkeProfileId, java.lang.Boolean force, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Get custom IKE Profile, given the particular id. <br/> <br/> Please use below
     * Policy API. <br/> GET
     * /policy/api/v1/infra/ipsec-vpn-ike-profiles/<ike-profile-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param ipsecVpnIkeProfileId (required)
     * @return com.vmware.nsx.model.IPSecVPNIKEProfile
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.IPSecVPNIKEProfile get(java.lang.String ipsecVpnIkeProfileId);

    /**
     * Get custom IKE Profile, given the particular id. <br/> <br/> Please use below
     * Policy API. <br/> GET
     * /policy/api/v1/infra/ipsec-vpn-ike-profiles/<ike-profile-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param ipsecVpnIkeProfileId (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.IPSecVPNIKEProfile
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.IPSecVPNIKEProfile get(java.lang.String ipsecVpnIkeProfileId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Get custom IKE Profile, given the particular id. <br/> <br/> Please use below
     * Policy API. <br/> GET
     * /policy/api/v1/infra/ipsec-vpn-ike-profiles/<ike-profile-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.IPSecVPNIKEProfile
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param ipsecVpnIkeProfileId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void get(java.lang.String ipsecVpnIkeProfileId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.IPSecVPNIKEProfile> asyncCallback);

    /**
     * Get custom IKE Profile, given the particular id. <br/> <br/> Please use below
     * Policy API. <br/> GET
     * /policy/api/v1/infra/ipsec-vpn-ike-profiles/<ike-profile-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.IPSecVPNIKEProfile
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param ipsecVpnIkeProfileId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void get(java.lang.String ipsecVpnIkeProfileId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.IPSecVPNIKEProfile> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Get paginated list of all IKE Profiles. <br/> <br/> Please use below Policy API.
     * <br/> GET /policy/api/v1/infra/ipsec-vpn-ike-profiles
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @return com.vmware.nsx.model.IPSecVPNIKEProfileListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.IPSecVPNIKEProfileListResult list(java.lang.String cursor, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy);

    /**
     * Get paginated list of all IKE Profiles. <br/> <br/> Please use below Policy API.
     * <br/> GET /policy/api/v1/infra/ipsec-vpn-ike-profiles
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.IPSecVPNIKEProfileListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.IPSecVPNIKEProfileListResult list(java.lang.String cursor, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Get paginated list of all IKE Profiles. <br/> <br/> Please use below Policy API.
     * <br/> GET /policy/api/v1/infra/ipsec-vpn-ike-profiles
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.IPSecVPNIKEProfileListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void list(java.lang.String cursor, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.IPSecVPNIKEProfileListResult> asyncCallback);

    /**
     * Get paginated list of all IKE Profiles. <br/> <br/> Please use below Policy API.
     * <br/> GET /policy/api/v1/infra/ipsec-vpn-ike-profiles
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.IPSecVPNIKEProfileListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void list(java.lang.String cursor, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.IPSecVPNIKEProfileListResult> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Edit custom IKE Profile. System owned profiles are non editable. <br/> <br/>
     * Please use below Policy API. <br/> PUT
     * /policy/api/v1/infra/ipsec-vpn-ike-profiles/<ike-profile-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param ipsecVpnIkeProfileId (required)
     * @param ipSecVPNIKEProfile (required)
     * @return com.vmware.nsx.model.IPSecVPNIKEProfile
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.IPSecVPNIKEProfile update(java.lang.String ipsecVpnIkeProfileId, com.vmware.nsx.model.IPSecVPNIKEProfile ipSecVPNIKEProfile);

    /**
     * Edit custom IKE Profile. System owned profiles are non editable. <br/> <br/>
     * Please use below Policy API. <br/> PUT
     * /policy/api/v1/infra/ipsec-vpn-ike-profiles/<ike-profile-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param ipsecVpnIkeProfileId (required)
     * @param ipSecVPNIKEProfile (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.IPSecVPNIKEProfile
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.IPSecVPNIKEProfile update(java.lang.String ipsecVpnIkeProfileId, com.vmware.nsx.model.IPSecVPNIKEProfile ipSecVPNIKEProfile, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Edit custom IKE Profile. System owned profiles are non editable. <br/> <br/>
     * Please use below Policy API. <br/> PUT
     * /policy/api/v1/infra/ipsec-vpn-ike-profiles/<ike-profile-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.IPSecVPNIKEProfile
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param ipsecVpnIkeProfileId (required)
     * @param ipSecVPNIKEProfile (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void update(java.lang.String ipsecVpnIkeProfileId, com.vmware.nsx.model.IPSecVPNIKEProfile ipSecVPNIKEProfile, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.IPSecVPNIKEProfile> asyncCallback);

    /**
     * Edit custom IKE Profile. System owned profiles are non editable. <br/> <br/>
     * Please use below Policy API. <br/> PUT
     * /policy/api/v1/infra/ipsec-vpn-ike-profiles/<ike-profile-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.IPSecVPNIKEProfile
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param ipsecVpnIkeProfileId (required)
     * @param ipSecVPNIKEProfile (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void update(java.lang.String ipsecVpnIkeProfileId, com.vmware.nsx.model.IPSecVPNIKEProfile ipSecVPNIKEProfile, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.IPSecVPNIKEProfile> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
